/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm2.internal;

import android.text.TextUtils;
import io.agora.rtm2.JoinChannelOptions;
import io.agora.rtm2.JoinTopicOptions;
import io.agora.rtm2.StreamChannel;
import io.agora.rtm2.TopicOptions;
import io.agora.rtm2.UserList;
import io.agora.rtm2.internal.RtmClientImpl;
import java.util.ArrayList;

public class StreamChannelImpl
extends StreamChannel {
    private static final String TAG = StreamChannelImpl.class.getSimpleName();
    private long mChannelNative = 0L;
    private RtmClientImpl mRtmClient;

    StreamChannelImpl(long nativeHandle) {
        this.mChannelNative = nativeHandle;
    }

    synchronized void attach(RtmClientImpl rtmClient) {
        this.mRtmClient = rtmClient;
    }

    private synchronized void detach() {
        if (this.mRtmClient != null) {
            this.mRtmClient.removeChannel(this);
            this.mRtmClient = null;
        }
    }

    @Override
    public int release() {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        this.detach();
        int res = StreamChannelImpl.nativeDestroy(this.mChannelNative);
        this.mChannelNative = 0L;
        return res;
    }

    @Override
    public synchronized int join(JoinChannelOptions options) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (options == null || options.token == null || TextUtils.isEmpty((CharSequence)options.token)) {
            return -2;
        }
        return this.nativeJoin(this.mChannelNative, options);
    }

    @Override
    public synchronized int leave() {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        return this.nativeLeave(this.mChannelNative);
    }

    @Override
    public synchronized String getChannelName() {
        if (this.mChannelNative == 0L) {
            return "";
        }
        return this.nativeGetChannelName(this.mChannelNative);
    }

    @Override
    public synchronized int joinTopic(String topicName, JoinTopicOptions options) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        return this.nativeJoinTopic(this.mChannelNative, topicName, options);
    }

    @Override
    public synchronized int publishTopicMessage(String topicName, byte[] message) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        if (message == null) {
            return -2;
        }
        return this.nativePublishTopicMessage(this.mChannelNative, topicName, message);
    }

    @Override
    public synchronized int leaveTopic(String topicName) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        return this.nativeLeaveTopic(this.mChannelNative, topicName);
    }

    @Override
    public synchronized int subscribeTopic(String topicName, TopicOptions options) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        return this.nativeSubscribeTopic(this.mChannelNative, topicName, options.users);
    }

    @Override
    public synchronized int unsubscribeTopic(String topicName, TopicOptions options) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        return this.nativeUnsubscribeTopic(this.mChannelNative, topicName, options.users);
    }

    @Override
    public synchronized int getSubscribedUserList(String topicName, UserList users) {
        if (this.mChannelNative == 0L) {
            return -7;
        }
        if (topicName == null || TextUtils.isEmpty((CharSequence)topicName)) {
            return -10003;
        }
        if (users == null) {
            return -2;
        }
        return this.nativeGetSubscribedUserList(this.mChannelNative, topicName, users);
    }

    private static native int nativeDestroy(long var0);

    private native int nativeJoin(long var1, JoinChannelOptions var3);

    private native int nativeLeave(long var1);

    private native String nativeGetChannelName(long var1);

    private native int nativeJoinTopic(long var1, String var3, JoinTopicOptions var4);

    private native int nativePublishTopicMessage(long var1, String var3, byte[] var4);

    private native int nativeLeaveTopic(long var1, String var3);

    private native int nativeSubscribeTopic(long var1, String var3, ArrayList<String> var4);

    private native int nativeUnsubscribeTopic(long var1, String var3, ArrayList<String> var4);

    private native int nativeGetSubscribedUserList(long var1, String var3, UserList var4);
}

