/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.opengl.GLES20;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.video.GlShader;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import java.nio.Buffer;
import java.nio.FloatBuffer;

class GlGenericDrawer
implements RendererCommon.GlDrawer {
    private static float[] g_color601_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.344136f, 1.772f, 1.402f, -0.714136f, 0.0f};
    private static float[] g_color601_limit = new float[]{1.164384f, 1.164384f, 1.164384f, 0.0f, -0.391762f, 2.017232f, 1.596027f, -0.812968f, 0.0f};
    private static float[] g_color709_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.187324f, 1.8556f, 1.5748f, -0.468124f, 0.0f};
    private static float[] g_color709_limit = new float[]{1.164384f, 1.164384f, 1.164384f, 0.0f, -0.213249f, 2.112402f, 1.792741f, -0.532909f, 0.0f};
    private static float[] g_color2020_full = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.164553f, 1.8814f, 1.4746f, -0.571353f, 0.0f};
    private static float[] g_color2020_limit = new float[]{1.164384f, 1.164384f, 1.164384f, 0.0f, -0.187326f, 2.141772f, 1.678674f, -0.650424f, 0.0f};
    private static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    private static final String TEXTURE_MATRIX_NAME = "tex_mat";
    private static final String DEFAULT_VERTEX_SHADER_STRING = "varying vec2 tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    private static final String ALPHA_VERTEX_SHADER_STRING = "varying vec2 tc;\nvarying vec2 channelCoordinates[4];\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nuniform float texelWidthOffset;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n  vec2 singleStepOffset = vec2(texelWidthOffset, 0.0);\n  channelCoordinates[0] = tc - 1.5 * singleStepOffset;\n  channelCoordinates[1] = channelCoordinates[0] + singleStepOffset;\n  channelCoordinates[2] = channelCoordinates[1] + singleStepOffset;\n  channelCoordinates[3] = channelCoordinates[2] + singleStepOffset;\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final String genericFragmentSource;
    private String vertexShader;
    private final ShaderCallbacks shaderCallbacks;
    @Nullable
    private ShaderType currentShaderType;
    @Nullable
    private GlShader currentShader;
    private int inPosLocation;
    private int inTcLocation;
    private int texMatrixLocation;
    private FloatBuffer textureCropCoord;

    static String createFragmentShaderString(String genericFragmentSource, ShaderType shaderType, VideoFrame.ColorSpace colorSpace, boolean gammaCorrection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (shaderType == ShaderType.OES || shaderType == ShaderType.OESA) {
            stringBuilder.append("#extension GL_OES_EGL_image_external : require\n");
        }
        stringBuilder.append("precision mediump float;\n");
        stringBuilder.append("varying vec2 tc;\n");
        if (shaderType == ShaderType.YUV) {
            stringBuilder.append("uniform mat3 colorMatrix;\n");
            stringBuilder.append("uniform sampler2D y_tex;\n");
            stringBuilder.append("uniform sampler2D u_tex;\n");
            stringBuilder.append("uniform sampler2D v_tex;\n");
            stringBuilder.append("uniform sampler2D a_tex;\n");
            stringBuilder.append("highp vec3 yuv,rgb;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            if (colorSpace == null || colorSpace.getRange() != VideoFrame.ColorSpace.Range.Full) {
                stringBuilder.append("  yuv[0] = clamp(texture2D(y_tex, p).r, 0.0, 1.0) - 0.0627;\n");
            } else {
                stringBuilder.append("  yuv[0] = clamp(texture2D(y_tex, p).r, 0.0, 1.0);\n");
            }
            stringBuilder.append("  yuv[1] = clamp(texture2D(u_tex, p).r - 0.5, -0.5, 0.5);\n");
            stringBuilder.append("  yuv[2] = clamp(texture2D(v_tex, p).r - 0.5, -0.5, 0.5);\n");
            stringBuilder.append("  rgb = colorMatrix * yuv;\n");
            stringBuilder.append("  return vec4(rgb, clamp(texture2D(a_tex, p).a, 0.0, 1.0));\n");
            stringBuilder.append("}\n");
            stringBuilder.append(genericFragmentSource);
        } else if (shaderType == ShaderType.ALPHA) {
            stringBuilder.append("varying vec2 channelCoordinates[4];\n");
            stringBuilder.append("uniform sampler2D tex;\n");
            stringBuilder.append("highp vec4 outData;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            stringBuilder.append("  outData[0] = clamp(texture2D(tex, channelCoordinates[0]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[1] = clamp(texture2D(tex, channelCoordinates[1]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[2] = clamp(texture2D(tex, channelCoordinates[2]).a, 0.0, 1.0);\n");
            stringBuilder.append("  outData[3] = clamp(texture2D(tex, channelCoordinates[3]).a, 0.0, 1.0);\n");
            stringBuilder.append("  return outData;\n");
            stringBuilder.append("}\n");
            stringBuilder.append(genericFragmentSource);
        } else if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
            String samplerName = shaderType == ShaderType.OESA ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(samplerName).append(" tex;\n");
            stringBuilder.append("uniform sampler2D a_tex;\n");
            stringBuilder.append("highp vec4 outData;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            stringBuilder.append("  outData = texture2D(tex, p);\n");
            stringBuilder.append("  outData[3] = clamp(texture2D(a_tex, p).a, 0.0, 1.0);\n");
            stringBuilder.append("  return outData;\n");
            stringBuilder.append("}\n");
            stringBuilder.append(genericFragmentSource);
        } else {
            String samplerName = shaderType == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(samplerName).append(" tex;\n");
            if (gammaCorrection) {
                stringBuilder.append(genericFragmentSource.replace("gl_FragColor = sample(tc);", "float gamma = 2.2;\nvec4 fragColor = texture2D(tex, tc);\nfragColor.rgb = pow(fragColor.rgb, vec3(1.0/gamma));\ngl_FragColor = fragColor;"));
            } else {
                stringBuilder.append(genericFragmentSource.replace("sample(", "texture2D(tex, "));
            }
        }
        return stringBuilder.toString();
    }

    public GlGenericDrawer(String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, genericFragmentSource, shaderCallbacks);
    }

    public GlGenericDrawer(String vertexShader, String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = vertexShader;
        this.genericFragmentSource = genericFragmentSource;
        this.shaderCallbacks = shaderCallbacks;
    }

    public GlGenericDrawer(String vertexShader, String genericFragmentSource, FloatBuffer textureCropCoord, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = vertexShader;
        this.genericFragmentSource = genericFragmentSource;
        this.textureCropCoord = textureCropCoord;
        this.shaderCallbacks = shaderCallbacks;
    }

    GlShader createShader(ShaderType shaderType, VideoFrame.ColorSpace colorSpace, boolean gammaCorrection) {
        return new GlShader(this.vertexShader, GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, shaderType, colorSpace, gammaCorrection));
    }

    @Override
    public void drawOes(int oesTextureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(alphaTexture > 0 ? ShaderType.OESA : ShaderType.OES, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, false);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void drawRgb(int textureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawRgb(textureId, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, false);
    }

    @Override
    public void drawRgb(int textureId, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, boolean gammaCorrection) {
        this.prepareShader(alphaTexture > 0 ? ShaderType.RGBA : ShaderType.RGB, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, gammaCorrection);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void drawAlpha(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(ShaderType.ALPHA, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, false);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] yuvTextures, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.drawYuv(yuvTextures, alphaTexture, texMatrix, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight, null);
    }

    @Override
    public void drawYuv(int[] yuvTextures, int alphaTexture, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight, VideoFrame.ColorSpace colorSpace) {
        int i;
        this.prepareShader(ShaderType.YUV, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, colorSpace, false);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)alphaTexture);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (alphaTexture > 0) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void setTextureCropCoord(FloatBuffer fb) {
        if (fb != null) {
            this.textureCropCoord = fb;
        }
    }

    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight, boolean gammaCorrection) {
        this.prepareShader(shaderType, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight, null, gammaCorrection);
    }

    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight, VideoFrame.ColorSpace colorSpace, boolean gammaCorrection) {
        GlShader shader;
        if (shaderType.equals((Object)this.currentShaderType)) {
            shader = this.currentShader;
        } else {
            this.currentShaderType = shaderType;
            if (this.currentShader != null) {
                this.currentShader.release();
            }
            this.vertexShader = shaderType == ShaderType.ALPHA ? ALPHA_VERTEX_SHADER_STRING : DEFAULT_VERTEX_SHADER_STRING;
            this.currentShader = shader = this.createShader(shaderType, colorSpace, gammaCorrection);
            shader.useProgram();
            if (shaderType == ShaderType.YUV) {
                FloatBuffer colorMat;
                GLES20.glUniform1i((int)shader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.getUniformLocation("v_tex"), (int)2);
                GLES20.glUniform1i((int)shader.getUniformLocation("a_tex"), (int)3);
                if (colorSpace == null) {
                    colorMat = FloatBuffer.wrap(g_color601_limit);
                } else {
                    VideoFrame.ColorSpace.Range range = colorSpace.getRange();
                    VideoFrame.ColorSpace.Matrix matrix = colorSpace.getMatrix();
                    switch (matrix) {
                        case SMPTE170M: 
                        case BT470BG: {
                            colorMat = range == VideoFrame.ColorSpace.Range.Full ? FloatBuffer.wrap(g_color601_full) : FloatBuffer.wrap(g_color601_limit);
                            break;
                        }
                        case BT709: {
                            colorMat = range == VideoFrame.ColorSpace.Range.Full ? FloatBuffer.wrap(g_color709_full) : FloatBuffer.wrap(g_color709_limit);
                            break;
                        }
                        case BT2020_NCL: 
                        case BT2020_CL: {
                            colorMat = range == VideoFrame.ColorSpace.Range.Full ? FloatBuffer.wrap(g_color2020_full) : FloatBuffer.wrap(g_color2020_limit);
                            break;
                        }
                        case Unspecified: {
                            colorMat = range == VideoFrame.ColorSpace.Range.Full ? FloatBuffer.wrap(g_color601_full) : FloatBuffer.wrap(g_color601_limit);
                            break;
                        }
                        default: {
                            colorMat = range == VideoFrame.ColorSpace.Range.Full ? FloatBuffer.wrap(g_color709_full) : FloatBuffer.wrap(g_color709_limit);
                        }
                    }
                }
                GLES20.glUniformMatrix3fv((int)shader.getUniformLocation("colorMatrix"), (int)1, (boolean)false, (FloatBuffer)colorMat);
            } else if (shaderType == ShaderType.ALPHA) {
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
                GLES20.glUniform1f((int)shader.getUniformLocation("texelWidthOffset"), (float)(1.0f / (float)frameWidth));
            } else if (shaderType == ShaderType.OESA || shaderType == ShaderType.RGBA) {
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
                GLES20.glUniform1i((int)shader.getUniformLocation("a_tex"), (int)3);
            } else {
                GLES20.glUniform1i((int)shader.getUniformLocation("tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Create shader");
            this.shaderCallbacks.onNewShader(shader);
            this.texMatrixLocation = shader.getUniformLocation(TEXTURE_MATRIX_NAME);
            this.inPosLocation = shader.getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            this.inTcLocation = shader.getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
        }
        shader.useProgram();
        GLES20.glEnableVertexAttribArray((int)this.inPosLocation);
        GLES20.glVertexAttribPointer((int)this.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GLES20.glEnableVertexAttribArray((int)this.inTcLocation);
        if (this.textureCropCoord != null) {
            GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.textureCropCoord);
        } else {
            GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEXTURE_BUFFER);
        }
        GLES20.glUniformMatrix4fv((int)this.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        this.shaderCallbacks.onPrepareShader(shader, texMatrix, frameWidth, frameHeight, viewportWidth, viewportHeight);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    @Override
    public void release() {
        if (this.currentShader != null) {
            this.currentShader.release();
            this.currentShader = null;
            this.currentShaderType = null;
        }
    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }

    public static enum ShaderType {
        OES,
        RGB,
        YUV,
        ALPHA,
        OESA,
        RGBA;

    }
}

