/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTrack;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.voiceengine.HardwareEarMonitorController;
import io.agora.base.internal.voiceengine.WebRtcAudioEffects;
import io.agora.base.internal.voiceengine.WebRtcAudioUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private final Object volumeListenerLock = new Object();
    private final Object recorderCallbackLock = new Object();
    @Nullable
    private AudioAttributes custAudioAttr = null;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private final long nativeAudioManager;
    private final AudioManager audioManager;
    private boolean initialized = false;
    private int nativeSampleRate;
    private int nativeChannels;
    private static AudioManager mockedAudioManager;
    private HardwareEarMonitorController mHardwareEarMonitorController;
    @Nullable
    @TargetApi(value=24)
    private static AudioRecordingCallbackImpl mRecordingCallback;
    @Nullable
    private VolumeChangeReceiver mVolumeChangeReceiver = null;
    private int playoutVolume = 0;

    @VisibleForTesting
    public static void setMockedAudioManager(AudioManager mockedAudioManager) {
        WebRtcAudioManager.mockedAudioManager = mockedAudioManager;
    }

    @CalledByNative
    WebRtcAudioManager(long nativeAudioManager, int bufferPeriodMs, boolean enableHwEarmonitor) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo() + ", this " + this);
        this.nativeAudioManager = nativeAudioManager;
        Logging.w(TAG, "bufferPeriodMs is: " + bufferPeriodMs);
        this.audioManager = mockedAudioManager != null ? mockedAudioManager : (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        Context context = ContextUtils.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 24 && context != null) {
            if (mRecordingCallback == null) {
                mRecordingCallback = new AudioRecordingCallbackImpl();
                this.audioManager.registerAudioRecordingCallback((AudioManager.AudioRecordingCallback)mRecordingCallback, null);
            }
            mRecordingCallback.registerRtcAudioManager(this);
        }
        this.mHardwareEarMonitorController = new HardwareEarMonitorController(enableHwEarmonitor);
        Logging.w(TAG, "ctor finish");
    }

    @CalledByNative
    private boolean init() {
        Logging.d(TAG, "init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        this.mHardwareEarMonitorController.initialize();
        this.initialized = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void dispose() {
        Logging.d(TAG, "dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
        this.mHardwareEarMonitorController.terminate();
        this.enableChatMode(false);
        if (Build.VERSION.SDK_INT >= 24 && mRecordingCallback != null) {
            mRecordingCallback.registerRtcAudioManager(null);
        }
        Object object = this.recorderCallbackLock;
        synchronized (object) {
            this.initialized = false;
        }
    }

    @CalledByNative
    public boolean isHardwareEarMonitorSupported() {
        return this.mHardwareEarMonitorController.isHardwareEarMonitorSupported();
    }

    @CalledByNative
    public int enableHardwareEarMonitor(boolean enable) {
        return this.mHardwareEarMonitorController.enableHardwareEarMonitor(enable);
    }

    @CalledByNative
    public int setHardwareEarMonitorVolume(int vol) {
        return this.mHardwareEarMonitorController.setHardwareEarMonitorVolume(vol);
    }

    @CalledByNative
    private boolean isCommunicationModeEnabled() {
        return this.getAudioMode() == 3;
    }

    @CalledByNative
    private boolean enableChatMode(boolean enable) {
        WebRtcAudioManager.assertTrue(this.audioManager != null);
        int audio_mode = enable ? 3 : 0;
        try {
            int curr_mode = this.audioManager.getMode();
            Logging.d(TAG, "set audio mode to: " + WebRtcAudioUtils.modeToString(audio_mode) + " curr: " + WebRtcAudioUtils.modeToString(curr_mode));
            this.audioManager.setMode(audio_mode);
        }
        catch (Exception e) {
            Logging.e(TAG, "audioManager.setMode failed: " + e.getMessage());
        }
        return true;
    }

    @CalledByNative
    private int getCallState() {
        if (mockedAudioManager != null) {
            Logging.d(TAG, "mock call state: " + mockedAudioManager.getRingerMode());
            return mockedAudioManager.getRingerMode();
        }
        return this.getAudioMode();
    }

    private int getAudioMode() {
        int audio_mode = 0;
        if (this.audioManager == null) {
            return audio_mode;
        }
        try {
            audio_mode = this.audioManager.getMode();
        }
        catch (Exception e) {
            Logging.e(TAG, "get audio mode failed ", e);
        }
        return audio_mode;
    }

    private int getBufferSizeByPeriod(int sampleRate, int bufferPeriodMs) {
        return sampleRate / 1000 * bufferPeriodMs;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return WebRtcAudioUtils.runningOnLollipopOrHigher() && this.isLowLatencyOutputSupported();
    }

    @TargetApi(value=23)
    private boolean isProAudioSupported() {
        return WebRtcAudioUtils.runningOnMarshmallowOrHigher() && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Logging.w(TAG, "AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int sampleRateHz = WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? this.getSampleRateOnJellyBeanMR10OrHigher() : WebRtcAudioUtils.getDefaultSampleRateHz();
        Logging.d(TAG, "Sample rate is set to " + sampleRateHz + " Hz");
        return sampleRateHz;
    }

    @TargetApi(value=17)
    private int getSampleRateOnJellyBeanMR10OrHigher() {
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(sampleRateString);
    }

    @TargetApi(value=17)
    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyOutputSupported());
        if (!WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher()) {
            return 256;
        }
        String framesPerBuffer = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 256 : Integer.parseInt(framesPerBuffer);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyInputSupported());
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    @CalledByNative
    private int setAudioAttrCtx(AudioAttributes attr) {
        if (attr == null) {
            return 0;
        }
        Logging.d(TAG, "audioAttr " + attr.toString());
        this.custAudioAttr = attr;
        return 0;
    }

    @Nullable
    public AudioAttributes getCustAudioAttrCtx() {
        return this.custAudioAttr;
    }

    @CalledByNative
    private int getCurrentPlayoutDevices() {
        int devices = 0;
        try {
            int streamType = this.getStreamType();
            Method method = AudioManager.class.getMethod("getDevicesForStream", Integer.TYPE);
            devices = (Integer)method.invoke((Object)this.audioManager, streamType);
            Logging.d(TAG, "get current playout devices: " + devices);
        }
        catch (Exception error) {
            Logging.e(TAG, "Error getDevicesForStream! ", error);
        }
        return devices;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeNotifyRecordingStateChanged(int var1, long var2);

    private int getStreamType() {
        int streamType = 0;
        int audioMode = this.getAudioMode();
        if (audioMode == 3) {
            streamType = 0;
        } else if (audioMode == 0) {
            streamType = 3;
        } else {
            Logging.w(TAG, "invalid audio mode");
        }
        return streamType;
    }

    @CalledByNative
    private boolean setStreamVolume(int volume) {
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        WebRtcAudioManager.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        int streamType = this.getStreamType();
        this.audioManager.setStreamVolume(streamType, volume, 0);
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean monitorPlayoutVolumeChange(boolean monitor) {
        Logging.d(TAG, "monitorPlayoutVolumeChange monitor: " + monitor);
        Context context = ContextUtils.getApplicationContext();
        if (context == null || mockedAudioManager != null) {
            return false;
        }
        if (monitor) {
            int streamType = this.getStreamType();
            int volume = this.audioManager.getStreamVolume(streamType);
            this.notifyPlayoutVolumeChange(volume, streamType);
            if (this.mVolumeChangeReceiver == null) {
                try {
                    this.mVolumeChangeReceiver = new VolumeChangeReceiver(this);
                    if (this.mVolumeChangeReceiver == null) {
                        return false;
                    }
                    IntentFilter iFilter = new IntentFilter();
                    iFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
                    context.registerReceiver((BroadcastReceiver)this.mVolumeChangeReceiver, iFilter);
                    Logging.d(TAG, "register volume change receiver " + (Object)((Object)this.mVolumeChangeReceiver));
                    return true;
                }
                catch (Exception e) {
                    Logging.e(TAG, "Unable to create VolumeChangeReceiver, ", e);
                    return false;
                }
            }
        } else {
            try {
                Object streamType = this.volumeListenerLock;
                synchronized (streamType) {
                    if (this.mVolumeChangeReceiver != null) {
                        new Thread(new DelayVolumeTask(this.mVolumeChangeReceiver)).start();
                        this.mVolumeChangeReceiver = null;
                    }
                }
                return true;
            }
            catch (Exception e) {
                Logging.e(TAG, "unregister VolumeChangeReceiver failed ", e);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlayoutVolumeChange(int volume, int streamType) {
        if (this.playoutVolume == volume) {
            return;
        }
        Object object = this.volumeListenerLock;
        synchronized (object) {
            if (this.mVolumeChangeReceiver == null) {
                return;
            }
            this.playoutVolume = volume;
            int playoutVolumeMax = 0;
            playoutVolumeMax = this.audioManager.getStreamMaxVolume(streamType);
            if (playoutVolumeMax != 0) {
                volume = (int)(255.0f * ((float)volume / (float)playoutVolumeMax));
            }
            this.nativeNotifyPlayoutVolumeChange(volume, this.nativeAudioManager);
            Logging.d(TAG, "notifyPlayoutVolumeChange: " + volume);
        }
    }

    @CalledByNative
    private boolean checkRecordingPermission() {
        String permission2 = "android.permission.RECORD_AUDIO";
        boolean hasPermission = true;
        Context context = ContextUtils.getApplicationContext();
        if (context != null && Build.VERSION.SDK_INT >= 23) {
            hasPermission = context.checkSelfPermission(permission2) == 0;
        }
        return hasPermission;
    }

    private native void nativeNotifyPlayoutVolumeChange(int var1, long var2);

    static {
        mRecordingCallback = null;
    }

    private static class VolumeChangeReceiver
    extends BroadcastReceiver {
        private WeakReference<WebRtcAudioManager> mWebRtcAudioManager;

        public VolumeChangeReceiver(WebRtcAudioManager ad) {
            this.mWebRtcAudioManager = new WeakReference<WebRtcAudioManager>(ad);
        }

        public void onReceive(Context context, Intent intent) {
            WebRtcAudioManager ad = (WebRtcAudioManager)this.mWebRtcAudioManager.get();
            if (ad == null) {
                return;
            }
            int streamType = ad.getStreamType();
            int volume = ad.audioManager.getStreamVolume(streamType);
            ad.notifyPlayoutVolumeChange(volume, streamType);
        }
    }

    private class DelayVolumeTask
    implements Runnable {
        private VolumeChangeReceiver volumeChangeReceiver;

        public DelayVolumeTask(VolumeChangeReceiver recevier) {
            this.volumeChangeReceiver = recevier;
        }

        @Override
        public void run() {
            try {
                Context context = ContextUtils.getApplicationContext();
                if (context == null || this.volumeChangeReceiver == null) {
                    return;
                }
                context.unregisterReceiver((BroadcastReceiver)this.volumeChangeReceiver);
                Logging.d(WebRtcAudioManager.TAG, "unregister volume change receiver " + (Object)((Object)this.volumeChangeReceiver));
            }
            catch (Exception e) {
                Logging.e(WebRtcAudioManager.TAG, "unregister VolumeChangeReceiver failed ", e);
            }
        }
    }

    @TargetApi(value=24)
    private class AudioRecordingCallbackImpl
    extends AudioManager.AudioRecordingCallback {
        private WeakReference<WebRtcAudioManager> mWebRtcAudioManager;

        AudioRecordingCallbackImpl() {
            Logging.d(WebRtcAudioManager.TAG, "AudioRecordingCallbackImpl ctor " + (Object)((Object)this));
        }

        int registerRtcAudioManager(WebRtcAudioManager manager) {
            this.mWebRtcAudioManager = new WeakReference<WebRtcAudioManager>(manager);
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
            WebRtcAudioManager manager = (WebRtcAudioManager)this.mWebRtcAudioManager.get();
            Logging.d(WebRtcAudioManager.TAG, "onRecordingConfigChanged " + configs.size());
            if (manager == null) {
                return;
            }
            Object object = manager.recorderCallbackLock;
            synchronized (object) {
                if (!manager.initialized) {
                    Logging.w(WebRtcAudioManager.TAG, "dont handle recording callback when destroy!");
                    return;
                }
                super.onRecordingConfigChanged(configs);
                for (AudioRecordingConfiguration config : configs) {
                    Logging.d(WebRtcAudioManager.TAG, " recording client session ID: " + config.getClientAudioSessionId());
                }
                manager.nativeNotifyRecordingStateChanged(configs.size(), manager.nativeAudioManager);
            }
        }
    }
}

