/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import io.agora.base.internal.CalledByNative;

public class CameraCapturerConfiguration {
    public CAMERA_DIRECTION cameraDirection = null;
    public String cameraId = null;
    public CAMERA_FOCAL_LENGTH_TYPE cameraFocalLengthType = null;
    public CaptureFormat captureFormat;
    public Boolean followEncodeDimensionRatio = null;

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection) {
        this.cameraDirection = cameraDirection;
        this.captureFormat = new CaptureFormat(0, 0, 0);
    }

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection, CAMERA_FOCAL_LENGTH_TYPE cameraFocalLengthType) {
        this.cameraDirection = cameraDirection;
        this.cameraFocalLengthType = cameraFocalLengthType;
        this.captureFormat = new CaptureFormat(0, 0, 0);
    }

    public CameraCapturerConfiguration(CaptureFormat captureFormat) {
        this.captureFormat = captureFormat;
    }

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection, CaptureFormat captureFormat) {
        this.cameraDirection = cameraDirection;
        this.captureFormat = captureFormat;
    }

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection, CAMERA_FOCAL_LENGTH_TYPE cameraFocalLengthType, CaptureFormat captureFormat) {
        this.cameraDirection = cameraDirection;
        this.cameraFocalLengthType = cameraFocalLengthType;
        this.captureFormat = captureFormat;
    }

    @CalledByNative
    public CAMERA_DIRECTION getCameraDirection() {
        return this.cameraDirection;
    }

    @CalledByNative
    public String getCameraId() {
        return this.cameraId;
    }

    @CalledByNative
    public CAMERA_FOCAL_LENGTH_TYPE getCameraFocalLengthType() {
        return this.cameraFocalLengthType;
    }

    @CalledByNative
    public CaptureFormat getCaptureFormat() {
        return this.captureFormat;
    }

    @CalledByNative
    public Boolean isFollowEncodeDimensionRatio() {
        return this.followEncodeDimensionRatio;
    }

    public String toString() {
        return "CameraCapturerConfiguration{cameraDirection=" + (Object)((Object)this.cameraDirection) + ", captureDimensions=" + this.captureFormat + ", cameraId=" + this.cameraId + ", followEncodeDimensionRatio=" + this.followEncodeDimensionRatio + ", cameraFocalLengthType=" + (Object)((Object)this.cameraFocalLengthType) + '}';
    }

    public static class CaptureFormat {
        public int width;
        public int height;
        public int fps;

        public CaptureFormat(int width, int height, int fps) {
            this.width = width;
            this.height = height;
            this.fps = fps;
        }

        public CaptureFormat() {
            this.width = 960;
            this.height = 540;
            this.fps = 15;
        }

        @CalledByNative(value="CaptureFormat")
        public int getHeight() {
            return this.height;
        }

        @CalledByNative(value="CaptureFormat")
        public int getWidth() {
            return this.width;
        }

        @CalledByNative(value="CaptureFormat")
        public int getFps() {
            return this.fps;
        }

        public String toString() {
            return "CaptureFormat{width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + '}';
        }
    }

    public static enum CAMERA_FOCAL_LENGTH_TYPE {
        CAMERA_FOCAL_LENGTH_DEFAULT(0),
        CAMERA_FOCAL_LENGTH_WIDE_ANGLE(1),
        CAMERA_FOCAL_LENGTH_ULTRA_WIDE(2),
        CAMERA_FOCAL_LENGTH_TELEPHOTO(3);

        private int value;

        private CAMERA_FOCAL_LENGTH_TYPE(int v) {
            this.value = v;
        }

        @CalledByNative(value="CAMERA_FOCAL_LENGTH_TYPE")
        public int getValue() {
            return this.value;
        }
    }

    public static enum CAMERA_DIRECTION {
        CAMERA_REAR(0),
        CAMERA_FRONT(1),
        CAMERA_EXTRA(2);

        private int value;

        private CAMERA_DIRECTION(int v) {
            this.value = v;
        }

        @CalledByNative(value="CAMERA_DIRECTION")
        public int getValue() {
            return this.value;
        }
    }
}

