/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.NonNull;

public class CoordinatesTransform {
    public static RectF normalizedFaceRect(Rect rect, int displayOrientation, boolean isMirror) {
        Matrix matrix = new Matrix();
        CoordinatesTransform.prepareMatrix(matrix, isMirror, displayOrientation);
        RectF rectF = new RectF(rect);
        matrix.mapRect(rectF);
        return rectF;
    }

    private static void prepareMatrix(Matrix matrix, boolean mirror, int displayOrientation) {
        matrix.setScale(mirror ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)displayOrientation);
        matrix.postScale(5.0E-4f, 5.0E-4f);
        matrix.postTranslate(0.5f, 0.5f);
    }

    public static Rect sensorToNormalizedPreview(Rect transformRect, int previewWidth, int previewHeight, Rect cropRegion) {
        double previewRatio = previewWidth > previewHeight ? (double)previewWidth / (double)previewHeight : (double)previewHeight / (double)previewWidth;
        double cropRatio = (double)cropRegion.width() / (double)cropRegion.height();
        int cropResizeWidth = cropRegion.width();
        int cropResizeHeight = cropRegion.height();
        if (previewRatio > cropRatio) {
            cropResizeHeight = (int)((double)cropResizeWidth / previewRatio);
        } else {
            cropResizeWidth = (int)((double)cropResizeHeight * previewRatio);
        }
        int deltaCropX = Math.abs(cropResizeWidth - cropRegion.width());
        int deltaCropY = Math.abs(cropResizeHeight - cropRegion.height());
        RectF rect = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postTranslate((float)(-cropRegion.left - deltaCropX / 2), (float)(-cropRegion.top - deltaCropY / 2));
        matrix.postTranslate((float)(-cropResizeWidth / 2), (float)(-cropResizeHeight / 2));
        matrix.postScale(2000.0f / (float)cropResizeWidth, 2000.0f / (float)cropResizeHeight);
        matrix.mapRect(rect);
        Rect resultRect = new Rect();
        rect.round(resultRect);
        return resultRect;
    }

    public static RectF viewToNormalized(@NonNull RectF transformRect, int viewWidth, int viewHeight, int captureWidth, int captureHeight, boolean mirror, int rotation, int renderMode) {
        if (transformRect == null) {
            return null;
        }
        if (viewWidth <= 0 || viewHeight <= 0) {
            return null;
        }
        if (transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.right > (float)viewWidth || transformRect.bottom > (float)viewHeight || rotation % 90 != 0) {
            return null;
        }
        rotation = rotation > 0 ? rotation % 360 : 360 + rotation % 360;
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotation);
        float tempW = rotation == 90 || rotation == 270 ? (float)viewHeight : (float)viewWidth;
        float tempH = rotation == 90 || rotation == 270 ? (float)viewWidth : (float)viewHeight;
        float ratioW = tempW / (float)captureWidth;
        float ratioH = tempH / (float)captureHeight;
        matrix.postScale(1.0f / tempW, 1.0f / tempH);
        switch (rotation) {
            case 90: {
                matrix.postTranslate(1.0f, 0.0f);
                break;
            }
            case 180: {
                matrix.postTranslate(1.0f, 1.0f);
                break;
            }
            case 270: {
                matrix.postTranslate(0.0f, 1.0f);
                break;
            }
        }
        switch (renderMode) {
            case 1: {
                if (ratioW > ratioH) {
                    matrix.postScale(1.0f, ratioH / ratioW, 0.0f, 0.5f);
                    matrix.mapRect(temp);
                    temp.top = CoordinatesTransform.clamp(temp.top, 0.0f, 1.0f);
                    temp.bottom = CoordinatesTransform.clamp(temp.bottom, 0.0f, 1.0f);
                    break;
                }
                matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                matrix.mapRect(temp);
                temp.right = CoordinatesTransform.clamp(temp.right, 0.0f, 1.0f);
                temp.left = CoordinatesTransform.clamp(temp.left, 0.0f, 1.0f);
                break;
            }
            case 2: {
                if (ratioW > ratioH) {
                    matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                    matrix.mapRect(temp);
                    temp.right = CoordinatesTransform.clamp(temp.right, 0.0f, 1.0f);
                    temp.left = CoordinatesTransform.clamp(temp.left, 0.0f, 1.0f);
                    break;
                }
                matrix.postScale(1.0f, ratioH / ratioW);
                matrix.mapRect(temp);
                temp.top = CoordinatesTransform.clamp(temp.top, 0.0f, 1.0f);
                temp.bottom = CoordinatesTransform.clamp(temp.bottom, 0.0f, 1.0f);
                break;
            }
        }
        if (mirror) {
            float tempLeft = temp.left;
            temp.left = 1.0f - temp.right;
            temp.right = 1.0f - tempLeft;
        }
        return temp;
    }

    public static RectF normalizedToCamera(@NonNull RectF transformRect) {
        if (transformRect == null) {
            return null;
        }
        if (transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.width() > 1.0f || transformRect.height() > 1.0f) {
            return null;
        }
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postScale(2000.0f, 2000.0f);
        matrix.postTranslate(-1000.0f, -1000.0f);
        matrix.mapRect(temp);
        return temp;
    }

    public static RectF cameraToNormalized(@NonNull RectF transformRect) {
        if (transformRect == null) {
            return null;
        }
        if (transformRect.left < -1000.0f || transformRect.top < -1000.0f || transformRect.right > 1000.0f || transformRect.bottom > 1000.0f) {
            return null;
        }
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postScale(5.0E-4f, 5.0E-4f);
        matrix.postTranslate(0.5f, 0.5f);
        matrix.mapRect(temp);
        return temp;
    }

    public static RectF normalizedToSensor(@NonNull RectF transformRect, int previewW, int previewH, int cropWidth, int cropHeight, int rotation, boolean needCameraCrop) {
        if (transformRect == null) {
            return null;
        }
        if (transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.width() > 1.0f || transformRect.height() > 1.0f) {
            return null;
        }
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        if (needCameraCrop) {
            float ratioW = (float)cropWidth / (float)previewW;
            float ratioH = (float)cropHeight / (float)previewH;
            if (ratioW / ratioH > 1.0f) {
                matrix.postTranslate((ratioW / ratioH - 1.0f) / 2.0f, 0.0f);
                cropWidth = (int)((float)cropWidth * ratioH / ratioW);
            } else if (ratioW / ratioH < 1.0f) {
                matrix.postTranslate(0.0f, (ratioH / ratioW - 1.0f) / 2.0f);
                cropHeight = (int)((float)cropHeight * ratioW / ratioH);
            }
            matrix.mapRect(temp);
        }
        matrix.setScale((float)cropWidth, (float)cropHeight);
        matrix.mapRect(temp);
        return temp;
    }

    public static RectF sensorToNormalized(@NonNull RectF transformRect, int cropWidth, int cropHeight, int previewW, int previewH, boolean needCameraCrop) {
        if (transformRect == null) {
            return null;
        }
        if (transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.width() > (float)cropWidth || transformRect.height() > (float)cropHeight) {
            return null;
        }
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        if (needCameraCrop) {
            float ratioW = (float)cropWidth / (float)previewW;
            float ratioH = (float)cropHeight / (float)previewH;
            if (ratioW / ratioH > 1.0f) {
                matrix.postTranslate((ratioH / ratioW - 1.0f) * (float)cropWidth / 2.0f, 0.0f);
                cropWidth = (int)((float)cropWidth * ratioH / ratioW);
            } else if (ratioW / ratioH < 1.0f) {
                matrix.postTranslate(0.0f, (ratioW / ratioH - 1.0f) * (float)cropHeight / 2.0f);
                cropHeight = (int)((float)cropHeight * ratioW / ratioH);
            }
            matrix.mapRect(temp);
        }
        matrix.setScale(1.0f / (float)cropWidth, 1.0f / (float)cropHeight);
        matrix.mapRect(temp);
        temp.left = CoordinatesTransform.clamp(temp.left, 0.0f, 1.0f);
        temp.right = CoordinatesTransform.clamp(temp.right, 0.0f, 1.0f);
        temp.top = CoordinatesTransform.clamp(temp.top, 0.0f, 1.0f);
        temp.bottom = CoordinatesTransform.clamp(temp.bottom, 0.0f, 1.0f);
        return temp;
    }

    public static RectF normalizedToView(@NonNull RectF transformRect, int viewWidth, int viewHeight, int captureWidth, int captureHeight, boolean mirror, int rotation, int renderMode) {
        if (transformRect == null) {
            return null;
        }
        if (transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.right > 1.0f || transformRect.bottom > 1.0f || rotation % 90 != 0) {
            return null;
        }
        rotation = rotation > 0 ? rotation % 360 : 360 + rotation % 360;
        RectF temp = new RectF(transformRect);
        Matrix matrix = new Matrix();
        if (mirror) {
            float tempLeft = temp.left;
            temp.left = 1.0f - temp.right;
            temp.right = 1.0f - tempLeft;
        }
        matrix.setRotate((float)(-rotation));
        switch (rotation) {
            case 90: {
                matrix.postTranslate(0.0f, 1.0f);
                break;
            }
            case 180: {
                matrix.postTranslate(1.0f, 1.0f);
                break;
            }
            case 270: {
                matrix.postTranslate(1.0f, 0.0f);
                break;
            }
        }
        matrix.postScale((float)viewWidth, (float)viewHeight);
        matrix.mapRect(temp);
        float tempW = rotation == 90 || rotation == 270 ? (float)captureHeight : (float)captureWidth;
        float tempH = rotation == 90 || rotation == 270 ? (float)captureWidth : (float)captureHeight;
        float ratioW = (float)viewWidth / tempW;
        float ratioH = (float)viewHeight / tempH;
        switch (renderMode) {
            case 1: {
                if (ratioW > ratioH) {
                    matrix.setScale(1.0f, ratioW / ratioH, (float)(viewWidth / 2), (float)(viewHeight / 2));
                    matrix.mapRect(temp);
                    temp.top = CoordinatesTransform.clamp(temp.top, 0.0f, (float)viewHeight);
                    temp.bottom = CoordinatesTransform.clamp(temp.bottom, 0.0f, (float)viewHeight);
                    break;
                }
                matrix.setScale(ratioH / ratioW, 1.0f, (float)(viewWidth / 2), (float)(viewHeight / 2));
                matrix.mapRect(temp);
                temp.right = CoordinatesTransform.clamp(temp.right, 0.0f, (float)viewWidth);
                temp.left = CoordinatesTransform.clamp(temp.left, 0.0f, (float)viewWidth);
                break;
            }
            case 2: {
                if (ratioW > ratioH) {
                    matrix.setScale(ratioH / ratioW, 1.0f, (float)(viewWidth / 2), (float)(viewHeight / 2));
                    matrix.mapRect(temp);
                    temp.right = CoordinatesTransform.clamp(temp.right, 0.0f, (float)viewWidth);
                    temp.left = CoordinatesTransform.clamp(temp.left, 0.0f, (float)viewWidth);
                    break;
                }
                matrix.setScale(1.0f, ratioW / ratioH, (float)(viewWidth / 2), (float)(viewHeight / 2));
                matrix.mapRect(temp);
                temp.top = CoordinatesTransform.clamp(temp.top, 0.0f, (float)viewHeight);
                temp.bottom = CoordinatesTransform.clamp(temp.bottom, 0.0f, (float)viewHeight);
                break;
            }
        }
        return temp;
    }

    static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static Rect calculateMeteringArea(float x, float y, int captureWidth, int captureHeight, float coefficient) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x * (float)captureWidth - (float)(captureWidth / 2));
        int centerY = (int)(y * (float)captureHeight - (float)(captureHeight / 2));
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)CoordinatesTransform.clamp(centerX - halfAreaSize, 0, captureWidth), (float)CoordinatesTransform.clamp(centerY - halfAreaSize, 0, captureHeight), (float)CoordinatesTransform.clamp(centerX + halfAreaSize, 0, captureWidth), (float)CoordinatesTransform.clamp(centerY + halfAreaSize, 0, captureHeight));
        Rect result = new Rect();
        rectF.round(result);
        if (result.width() == 0 || result.height() == 0) {
            result = new Rect(0, 0, 0, 0);
        }
        return result;
    }

    public static Rect calculateFocusArea(float x, float y, float coefficient) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x * 2000.0f - 1000.0f);
        int centerY = (int)(y * 2000.0f - 1000.0f);
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)CoordinatesTransform.clamp(centerX - halfAreaSize, -1000, 1000), (float)CoordinatesTransform.clamp(centerY - halfAreaSize, -1000, 1000), (float)CoordinatesTransform.clamp(centerX + halfAreaSize, -1000, 1000), (float)CoordinatesTransform.clamp(centerY + halfAreaSize, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }
}

