/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.IHandlerReplaceable;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.WrappedNativeColorSpace;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;

public class WrappedNativeTextureBuffer
implements VideoFrame.TextureBuffer,
IHandlerReplaceable {
    @NonNull
    private final EglBase.Context eglContext;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    @Nullable
    private final Handler toI420Handler;
    @Nullable
    private final YuvConverter yuvConverter;
    @Nullable
    private final VideoFrame.ColorSpace colorSpace;
    private final Object nativeRefLock = new Object();
    private long nativeRefCountedPointer;
    private long fenceObject;
    private boolean is10bitTexture = false;

    @CalledByNative
    public WrappedNativeTextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, boolean isOES, int id, float[] matrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, long nativeRefCountedPointer, long fenceObject, int primaryId, int transferId, int matrixId, int rangeId) {
        this(eglContext, width, height, isOES ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB, id, RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix), toI420Handler, yuvConverter, nativeRefCountedPointer, fenceObject, new WrappedNativeColorSpace(primaryId, transferId, matrixId, rangeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrappedNativeTextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, long nativeRefCountedPointer, long fenceObject, @Nullable VideoFrame.ColorSpace colorSpace) {
        this.eglContext = eglContext;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.colorSpace = colorSpace;
        this.fenceObject = fenceObject;
        Object object = this.nativeRefLock;
        synchronized (object) {
            this.nativeRefCountedPointer = nativeRefCountedPointer;
            this.retain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void applyNewRefCountedPointer(long nativeRefCountedPointer) {
        Object object = this.nativeRefLock;
        synchronized (object) {
            this.release();
            this.nativeRefCountedPointer = nativeRefCountedPointer;
            this.retain();
        }
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    @NonNull
    public EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    @Override
    @Nullable
    public Object getSourceTexturePool() {
        return null;
    }

    @Override
    public long getNativeEglContext() {
        return this.eglContext.getNativeEglContext();
    }

    @Override
    public int getEglContextType() {
        return EglBaseFactory.isEglBase14(this.eglContext) ? VideoFrame.TextureBuffer.ContextType.EGL_CONTEXT_14.ordinal() : VideoFrame.TextureBuffer.ContextType.EGL_CONTEXT_10.ordinal();
    }

    @Override
    public float[] getTransformMatrixArray() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public int getSequence() {
        return 0;
    }

    @Override
    public long getFenceObject() {
        return this.fenceObject;
    }

    @Override
    public boolean is10BitTexture() {
        return this.is10bitTexture;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Override
    @Nullable
    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoFrame.Buffer applyNewI420Handler(@NonNull Handler toI420Handler, @NonNull YuvConverter yuvConverter) {
        Object object = this.nativeRefLock;
        synchronized (object) {
            return new WrappedNativeTextureBuffer(this.eglContext, this.width, this.height, this.type, this.id, this.transformMatrix, toI420Handler, yuvConverter, this.nativeRefCountedPointer, this.fenceObject, this.colorSpace);
        }
    }

    @Override
    @Nullable
    public VideoFrame.I420Buffer toI420() {
        if (this.toI420Handler == null || this.yuvConverter == null) {
            throw new IllegalStateException("toI420Handler or yuvConverter is null");
        }
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<VideoFrame.I420Buffer>(){

                @Override
                public VideoFrame.I420Buffer call() throws Exception {
                    return WrappedNativeTextureBuffer.this.yuvConverter.convert(WrappedNativeTextureBuffer.this, WrappedNativeTextureBuffer.this.colorSpace);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeRefCountedPointer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeRefCountedPointer);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(cropAndScaleMatrix, scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer mirror(int frameRotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (frameRotation == 90 || frameRotation == 270) {
            transformMatrix.preScale(1.0f, -1.0f);
        } else {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, this.getWidth(), this.getHeight());
    }

    @Override
    public VideoFrame.Buffer rotate(int frameRotation) {
        Matrix transformMatrix = new Matrix();
        int width = frameRotation == 90 || frameRotation == 270 ? this.getHeight() : this.getWidth();
        int height = frameRotation == 90 || frameRotation == 270 ? this.getWidth() : this.getHeight();
        transformMatrix.preTranslate(0.5f, 0.5f);
        transformMatrix.preRotate((float)frameRotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, width, height);
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        Matrix transformMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        transformMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        transformMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        if (scaleWidth > 0 && scaleHeight > 0 && rotation == 0) {
            return this.applyTransformMatrix(transformMatrix, scaleWidth, scaleHeight);
        }
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (scaleWidth < 0) {
            transformMatrix.preScale(-1.0f, 1.0f);
            scaleWidth = -scaleWidth;
        }
        if (scaleHeight < 0) {
            transformMatrix.preScale(1.0f, -1.0f);
            scaleHeight = -scaleHeight;
        }
        if (rotation == 90 || rotation == 270) {
            int tmp = scaleWidth;
            scaleWidth = scaleHeight;
            scaleHeight = tmp;
        }
        if (rotation != 0) {
            transformMatrix.preRotate((float)rotation);
        }
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, scaleWidth, scaleHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrappedNativeTextureBuffer applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        Object object = this.nativeRefLock;
        synchronized (object) {
            return new WrappedNativeTextureBuffer(this.eglContext, newWidth, newHeight, this.type, this.id, newMatrix, this.toI420Handler, this.yuvConverter, this.nativeRefCountedPointer, this.fenceObject, this.colorSpace);
        }
    }

    @CalledByNative
    private static VideoFrame.TextureBuffer wrapNewTextureBuffer(TextureBuffer referencedBuffer, int width, int height, int type, int id, long fenceObject, float[] matrix) {
        return referencedBuffer.applyNewTextureInfo(type == 0 ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB, id, fenceObject, RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix), width, height);
    }
}

