/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import io.agora.rtc2.PublisherParameters;
import io.agora.utils2.internal.Logging;
import org.json.JSONException;
import org.json.JSONObject;

public class PublisherConfiguration {
    private JSONObject jsonObject;

    public boolean validate() {
        return this.jsonObject != null;
    }

    public String toJsonString() {
        if (this.validate()) {
            return this.jsonObject.toString();
        }
        return null;
    }

    private PublisherConfiguration(Builder builder) {
        try {
            this.jsonObject = new JSONObject().put("owner", ((Builder)builder).params.owner).put("lifecycle", ((Builder)builder).params.lifecycle).put("defaultLayout", ((Builder)builder).params.defaultLayout).put("width", ((Builder)builder).params.width).put("height", ((Builder)builder).params.height).put("framerate", ((Builder)builder).params.framerate).put("bitrate", ((Builder)builder).params.bitrate).put("mosaicStream", (Object)((Builder)builder).params.publishUrl).put("rawStream", (Object)((Builder)builder).params.rawStreamUrl).put("extraInfo", (Object)((Builder)builder).params.extraInfo);
            if (((Builder)builder).params.injectStreamUrl != null && ((Builder)builder).params.injectStreamWidth != 0 && ((Builder)builder).params.injectStreamHeight != 0) {
                this.jsonObject.put("injectInfo", (Object)new JSONObject().put("injectStream", (Object)((Builder)builder).params.injectStreamUrl).put("width", ((Builder)builder).params.injectStreamWidth).put("height", ((Builder)builder).params.injectStreamHeight));
            }
        }
        catch (JSONException e) {
            this.jsonObject = null;
            Logging.e("failed to create PublisherConfiguration");
        }
    }

    public static class Builder {
        private PublisherParameters params = new PublisherParameters();

        public Builder owner(boolean isRoomOwner) {
            this.params.owner = isRoomOwner;
            return this;
        }

        public Builder streamLifeCycle(int lifecycle) {
            this.params.lifecycle = lifecycle;
            return this;
        }

        public Builder size(int width, int height) {
            this.params.width = width;
            this.params.height = height;
            return this;
        }

        public Builder frameRate(int framerate) {
            this.params.framerate = framerate;
            return this;
        }

        public Builder bitRate(int bitrate) {
            this.params.bitrate = bitrate;
            return this;
        }

        public Builder defaultLayout(int layoutStyle) {
            this.params.defaultLayout = layoutStyle;
            return this;
        }

        public Builder publishUrl(String url) {
            this.params.publishUrl = url;
            return this;
        }

        public Builder rawStreamUrl(String url) {
            this.params.rawStreamUrl = url;
            return this;
        }

        public Builder injectStream(String url, int width, int height) {
            if (url != null && width != 0 && height != 0) {
                this.params.injectStreamUrl = url;
                this.params.injectStreamWidth = width;
                this.params.injectStreamHeight = height;
            }
            return this;
        }

        public Builder extraInfo(String optionalInfo) {
            this.params.extraInfo = optionalInfo;
            return this;
        }

        public PublisherConfiguration build() {
            return new PublisherConfiguration(this);
        }
    }
}

