/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import io.agora.base.internal.BuildConfig;
import io.agora.rte.Config;
import io.agora.rte.Error;
import io.agora.rte.InitialConfig;
import io.agora.rte.Observer;
import io.agora.rte.callback.RteInitCallback;
import io.agora.rte.callback.RteSetConfigsCallback;
import java.io.File;

public class Rte {
    public static final String TAG = "Rte";
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySurffix = ".so";
    static String nativeLibraryName = "agora-rtc-sdk";
    private static int sLibLoadCount = 0;
    private long mNativeHandle = 0L;
    private boolean mGetFromBridge = false;

    public static synchronized void Initialize() {
        Rte.initializeNativeLibs();
    }

    public static synchronized Rte GetFromBridge(Error error) {
        long handle = Rte.nativeGetFromBridge(error != null ? Long.valueOf(error.GetNativeHandle()) : null);
        return new Rte(handle);
    }

    public Rte(InitialConfig initialConfig, Error error) {
        Rte.initializeNativeLibs();
        this.mNativeHandle = this.nativeCreateRte(initialConfig != null ? Long.valueOf(initialConfig.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    private Rte(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mGetFromBridge = true;
    }

    public synchronized void Release() {
        if (this.mNativeHandle != 0L) {
            this.nativeReleaseRte(this.mNativeHandle);
            this.mNativeHandle = 0L;
            if (!this.mGetFromBridge) {
                Rte.deinitializeNativeLibs();
            }
        }
    }

    protected void finalize() {
        this.Release();
    }

    public long GetNativeHandle() {
        return this.mNativeHandle;
    }

    public boolean InitMediaEngine(RteInitCallback callBack, Object cbData, Error error) {
        return this.nativeInitMediaEngine(this.mNativeHandle, callBack, cbData, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void GetConfig(Config config, Error error) {
        this.nativeGetConfig(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void SetConfig(Config config, RteSetConfigsCallback callBack, Object cbData) {
        this.nativeSetConfig(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, callBack, cbData);
    }

    public boolean RegisterObserver(Observer observer, Error error) {
        return this.nativeRegisterObserver(this.mNativeHandle, observer != null ? Long.valueOf(observer.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public boolean UnregisterObserver(Observer observer, Error error) {
        return this.nativeUnregisterObserver(this.mNativeHandle, observer != null ? Long.valueOf(observer.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public static synchronized boolean initializeNativeLibs() {
        return Rte.initializeNativeLibs(null);
    }

    public static synchronized void deinitializeNativeLibs() {
        if (sLibLoadCount > 0 && --sLibLoadCount < 0) {
            sLibLoadCount = 0;
        }
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        boolean libLoaded = false;
        if (sLibLoadCount <= 0) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                libLoaded = Rte.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (libLoaded) continue;
                return libLoaded;
            }
            libLoaded = Rte.safeLoadLibrary(libPath, nativeLibraryName);
            ++sLibLoadCount;
        } else {
            ++sLibLoadCount;
            libLoaded = true;
        }
        return libLoaded;
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                System.loadLibrary(name);
            } else {
                System.load(Rte.getNativeLibFullPath(path, name));
            }
        }
        catch (SecurityException e) {
            loaded = false;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        catch (NullPointerException e) {
            loaded = false;
        }
        catch (Exception e) {
            loaded = false;
        }
        if (!loaded) {
            Log.i((String)TAG, (String)("failed to load library " + name + " from " + path));
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySurffix;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    private static native long nativeGetFromBridge(long var0);

    private native long nativeCreateRte(long var1, long var3);

    private native void nativeReleaseRte(long var1);

    private native boolean nativeInitMediaEngine(long var1, RteInitCallback var3, Object var4, long var5);

    private native void nativeGetConfig(long var1, long var3, long var5);

    private native void nativeSetConfig(long var1, long var3, RteSetConfigsCallback var5, Object var6);

    private native boolean nativeRegisterObserver(long var1, long var3, long var5);

    private native boolean nativeUnregisterObserver(long var1, long var3, long var5);
}

