/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase$$CC;
import io.agora.base.internal.video.EglRenderer$$Lambda$0;
import io.agora.base.internal.video.EglRenderer$$Lambda$1;
import io.agora.base.internal.video.EglRenderer$$Lambda$2;
import io.agora.base.internal.video.EglRenderer$$Lambda$3;
import io.agora.base.internal.video.EglRenderer$$Lambda$4;
import io.agora.base.internal.video.EglRenderer$$Lambda$5;
import io.agora.base.internal.video.EglRenderer$$Lambda$6;
import io.agora.base.internal.video.EglRenderer$$Lambda$7;
import io.agora.base.internal.video.EglRenderer$$Lambda$8;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.VideoSink;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    protected final String name;
    protected RendererCommon.RendererEvents rendererEvents;
    protected boolean isFirstFrameRendered;
    private final Object handlerLock = new Object();
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private boolean eglContextAttached = false;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    @Nullable
    private VideoFrame pendingFrame;
    @Nullable
    private VideoFrame lastFrame = null;
    private boolean isViewSizeChanged = false;
    private static boolean ENABLE_LAST_FRAME = false;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean layoutScaledFit;
    private boolean mirror;
    private Rect rect;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long framesDrawTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private int frameDrawn = 0;
    private volatile boolean isReleasing = false;
    private volatile boolean textureCoordUpdate = false;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String name) {
        this.name = name;
    }

    public int getFrameDrawn() {
        return this.frameDrawn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nullable EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = drawer;
            this.isReleasing = false;
            HandlerThread renderThread = new HandlerThread(this.name + TAG);
            renderThread.start();
            this.renderThreadHandler = new HandlerWithExceptionCallback(renderThread.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.handlerLock;
                    synchronized (object) {
                        EglRenderer.this.renderThreadHandler = null;
                    }
                }
            });
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new EglRenderer$$Lambda$0(this, sharedContext, configAttributes));
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long currentTimeNs = System.nanoTime();
            this.resetStatistics(currentTimeNs);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
        }
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object surface) {
        this.eglSurfaceCreationRunnable.setSurface(surface);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        this.isReleasing = true;
        CountDownLatch eglCleanupBarrier = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue((Runnable)new EglRenderer$$Lambda$1(this, eglCleanupBarrier));
            Looper renderLooper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post((Runnable)new EglRenderer$$Lambda$2(this, renderLooper));
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(eglCleanupBarrier);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
            if (ENABLE_LAST_FRAME && this.lastFrame != null) {
                this.lastFrame.release();
                this.lastFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long currentTimeNs) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = currentTimeNs;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.framesDrawTimeNs = 0L;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] renderStackTrace;
            Thread renderThread;
            Thread thread = renderThread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (renderThread != null && (renderStackTrace = renderThread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement traceElem : renderStackTrace) {
                    this.logD(traceElem.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean mirror) {
        this.logD("setMirror: " + mirror);
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.mirror != mirror) {
                this.mirror = mirror;
                this.textureCoordUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCropArea(Rect rect) {
        this.logD("updateCropArea: " + rect.toString());
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.rect == null && rect != null) {
                this.rect = rect;
                this.textureCoordUpdate = true;
            } else if (this.rect != null && rect != null && !this.rect.equals((Object)rect)) {
                this.rect = rect;
                this.textureCoordUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float layoutAspectRatio) {
        this.logD("setLayoutAspectRatio: " + layoutAspectRatio);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = layoutAspectRatio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutScaledFit(boolean layoutScaledFit) {
        this.logD("layoutScaledFit: " + layoutScaledFit);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutScaledFit = layoutScaledFit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        this.logD("setFpsReduction: " + fps);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long previousRenderPeriodNs = this.minRenderPeriodNs;
            this.minRenderPeriodNs = fps <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / fps);
            if (this.minRenderPeriodNs != previousRenderPeriodNs) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener listener, float scale) {
        this.addFrameListener(listener, scale, null, false);
    }

    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.addFrameListener(listener, scale, drawerParam, false);
    }

    public void addFrameListener(FrameListener listener, float scale, @Nullable RendererCommon.GlDrawer drawerParam, boolean applyFpsReduction) {
        this.postToRenderThread(new EglRenderer$$Lambda$3(this, drawerParam, listener, scale, applyFpsReduction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener listener) {
        CountDownLatch latch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(new EglRenderer$$Lambda$4(this, latch, listener));
        }
        ThreadUtils.awaitUninterruptibly(latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySurfaceSizeChanged() {
        if (!ENABLE_LAST_FRAME) {
            return;
        }
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("notifySurfaceSizeChanged ");
                return;
            }
            Object object2 = this.frameLock;
            synchronized (object2) {
                if (this.lastFrame != null) {
                    long frameDrawStartTimeNs = System.nanoTime();
                    this.isViewSizeChanged = true;
                    this.renderThreadHandler.post((Runnable)new EglRenderer$$Lambda$5(this, frameDrawStartTimeNs));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        boolean dropOldFrame;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        long frameDrawStartTimeNs = System.nanoTime();
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                if (ENABLE_LAST_FRAME && this.isViewSizeChanged) {
                    this.logD("Dropping onFrame for view is changing size");
                    return;
                }
                boolean bl = dropOldFrame = this.pendingFrame != null;
                if (dropOldFrame) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = frame;
                this.pendingFrame.retain();
                if (ENABLE_LAST_FRAME) {
                    if (this.lastFrame != null) {
                        this.lastFrame.release();
                    }
                    this.lastFrame = frame;
                    this.lastFrame.retain();
                }
                this.renderThreadHandler.post((Runnable)new EglRenderer$$Lambda$6(this, frameDrawStartTimeNs));
            }
        }
        if (dropOldFrame) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(Runnable completionCallback) {
        this.logD("releaseEglSurface");
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue((Runnable)new EglRenderer$$Lambda$7(this, completionCallback));
                return;
            }
        }
        completionCallback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float r, float g, float b, float a) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(float r, float g, float b, float a) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue((Runnable)new EglRenderer$$Lambda$8(this, r, g, b, a));
        }
    }

    private float[] convertRectFromAndroidGraphicsRect(Rect rect, VideoFrame frame) {
        float cropLeft = 0.0f;
        float cropRight = 1.0f;
        float cropTop = 1.0f;
        float cropBottom = 0.0f;
        switch (frame.getRotation() % 360) {
            case 0: {
                cropTop = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                cropBottom = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                if (this.mirror) {
                    cropLeft = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                    cropRight = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                    break;
                }
                cropLeft = (float)rect.left / (float)frame.getRotatedWidth();
                cropRight = (float)rect.right / (float)frame.getRotatedWidth();
                break;
            }
            case 90: {
                cropTop = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                cropBottom = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                if (this.mirror) {
                    cropLeft = (float)rect.top / (float)frame.getRotatedHeight();
                    cropRight = (float)rect.bottom / (float)frame.getRotatedHeight();
                    break;
                }
                cropLeft = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                cropRight = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                break;
            }
            case 180: {
                cropTop = (float)rect.bottom / (float)frame.getRotatedHeight();
                cropBottom = (float)rect.top / (float)frame.getRotatedHeight();
                if (this.mirror) {
                    cropLeft = (float)rect.left / (float)frame.getRotatedWidth();
                    cropRight = (float)rect.right / (float)frame.getRotatedWidth();
                    break;
                }
                cropLeft = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                cropRight = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                break;
            }
            case 270: {
                cropTop = (float)rect.right / (float)frame.getRotatedWidth();
                cropBottom = (float)rect.left / (float)frame.getRotatedWidth();
                if (this.mirror) {
                    cropLeft = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                    cropRight = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                    break;
                }
                cropLeft = (float)rect.top / (float)frame.getRotatedHeight();
                cropRight = (float)rect.bottom / (float)frame.getRotatedHeight();
                break;
            }
        }
        this.logD("rotation " + frame.getRotation() % 360 + " mirror " + this.mirror + " left " + cropLeft + " right " + cropRight + " top " + cropTop + " bottom " + cropBottom);
        float[] glTextureCoord = new float[]{cropLeft, cropBottom, cropRight, cropBottom, cropLeft, cropTop, cropRight, cropTop};
        return glTextureCoord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread(long frameDrawStartTimeNs, boolean useLastFrame) {
        int drawnLayoutOffsetY;
        int drawnLayoutOffsetX;
        float scaleY;
        float scaleX;
        boolean drawnLayoutScaledFit;
        float drawnAspectRatio;
        boolean shouldRenderFrame;
        VideoFrame frame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null && !useLastFrame) {
                return;
            }
            if (useLastFrame) {
                if (this.lastFrame == null && useLastFrame) {
                    return;
                }
                frame = this.lastFrame;
                this.isViewSizeChanged = false;
            } else {
                frame = this.pendingFrame;
                this.pendingFrame = null;
            }
        }
        if (this.eglBase == null || !this.eglBase.hasSurface() || this.isReleasing) {
            this.logD("Dropping frame - No surface");
            frame.release();
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                shouldRenderFrame = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                shouldRenderFrame = true;
            } else {
                long currentTimeNs = System.nanoTime();
                if (currentTimeNs < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    shouldRenderFrame = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, currentTimeNs);
                    shouldRenderFrame = true;
                }
            }
        }
        long startTimeNs = System.nanoTime();
        float sampleSapectRatio = 1.0f;
        float videoFrameSampleSapectRatio = frame.getSampleAspectRatio();
        if (videoFrameSampleSapectRatio != 1.0f && videoFrameSampleSapectRatio > 0.0f) {
            sampleSapectRatio = videoFrameSampleSapectRatio;
        }
        float frameAspectRatio = (float)frame.getRotatedWidth() / (float)frame.getRotatedHeight() * sampleSapectRatio;
        int rectWidth = 0;
        int rectHeight = 0;
        if (this.rect != null) {
            int rotation = frame.getRotation();
            if (rotation % 180 == 0) {
                rectWidth = this.rect.right - this.rect.left;
                rectHeight = this.rect.bottom - this.rect.top;
            } else {
                rectWidth = this.rect.bottom - this.rect.top;
                rectHeight = this.rect.right - this.rect.left;
            }
            if (rectWidth <= frame.getRotatedWidth() && rectHeight <= frame.getRotatedHeight()) {
                frameAspectRatio = (float)rectWidth / (float)rectHeight;
            }
        }
        Object object3 = this.layoutLock;
        synchronized (object3) {
            drawnAspectRatio = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : frameAspectRatio;
            drawnLayoutScaledFit = this.layoutScaledFit;
        }
        int surfaceWidth = this.eglBase.surfaceWidth();
        int surfaceHeight = this.eglBase.surfaceHeight();
        if (drawnLayoutScaledFit) {
            scaleX = 1.0f;
            scaleY = 1.0f;
            if (frameAspectRatio > drawnAspectRatio) {
                drawnLayoutOffsetX = 0;
                drawnLayoutOffsetY = (int)((1.0f - drawnAspectRatio / frameAspectRatio) * (float)surfaceHeight / 2.0f);
            } else {
                drawnLayoutOffsetX = (int)((1.0f - frameAspectRatio / drawnAspectRatio) * (float)surfaceWidth / 2.0f);
                drawnLayoutOffsetY = 0;
            }
        } else {
            if (frameAspectRatio > drawnAspectRatio) {
                scaleX = drawnAspectRatio / frameAspectRatio;
                scaleY = 1.0f;
            } else {
                scaleX = 1.0f;
                scaleY = frameAspectRatio / drawnAspectRatio;
            }
            drawnLayoutOffsetX = 0;
            drawnLayoutOffsetY = 0;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(scaleX, scaleY);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (this.rect != null && this.textureCoordUpdate) {
            this.textureCoordUpdate = false;
            float[] gltexturecoord = this.convertRectFromAndroidGraphicsRect(this.rect, frame);
            this.drawer.setTextureCropCoord(GlUtil.createFloatBuffer(gltexturecoord));
        }
        if (shouldRenderFrame) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, this.drawer, this.drawMatrix, drawnLayoutOffsetX, drawnLayoutOffsetY, surfaceWidth - drawnLayoutOffsetX * 2, surfaceHeight - drawnLayoutOffsetY * 2);
            long swapBuffersStartTimeNs = System.nanoTime();
            this.eglBase.swapBuffers();
            long currentTimeNs = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                this.framesDrawTimeNs += currentTimeNs - frameDrawStartTimeNs;
                this.renderTimeNs += currentTimeNs - startTimeNs;
                this.renderSwapBufferTimeNs += currentTimeNs - swapBuffersStartTimeNs;
                ++this.frameDrawn;
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null && frame.getBuffer() != null) {
                    this.rendererEvents.onFirstFrameRendered(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
            }
        }
        this.notifyCallbacks(frame, shouldRenderFrame);
        if (!useLastFrame) {
            frame.release();
        }
    }

    private void notifyCallbacks(VideoFrame frame, boolean wasRendered) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> it = this.frameListeners.iterator();
        while (it.hasNext()) {
            FrameListenerAndParams listenerAndParams = it.next();
            if (!wasRendered && listenerAndParams.applyFpsReduction) continue;
            it.remove();
            int scaledWidth = (int)(listenerAndParams.scale * (float)frame.getRotatedWidth());
            int scaledHeight = (int)(listenerAndParams.scale * (float)frame.getRotatedHeight());
            if (scaledWidth == 0 || scaledHeight == 0) {
                listenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(scaledWidth, scaledHeight);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, listenerAndParams.drawer, this.drawMatrix, 0, 0, scaledWidth, scaledHeight);
            ByteBuffer bitmapBuffer = ByteBuffer.allocateDirect(scaledWidth * scaledHeight * 4);
            GLES20.glViewport((int)0, (int)0, (int)scaledWidth, (int)scaledHeight);
            GLES20.glReadPixels((int)0, (int)0, (int)scaledWidth, (int)scaledHeight, (int)6408, (int)5121, (Buffer)bitmapBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)bitmapBuffer);
            listenerAndParams.listener.onFrame(bitmap);
        }
    }

    private String averageTimeAsString(long sumTimeNs, int count) {
        return count <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(sumTimeNs / (long)count) + " \u03bcs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        DecimalFormat fpsFormat = new DecimalFormat("#.0");
        long currentTimeNs = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long elapsedTimeNs = currentTimeNs - this.statisticsStartTimeNs;
            if (elapsedTimeNs <= 0L) {
                return;
            }
            float renderFps = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)elapsedTimeNs;
            this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(elapsedTimeNs) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + fpsFormat.format(renderFps) + ". Average frame draw time: " + this.averageTimeAsString(this.framesDrawTimeNs, this.framesRendered) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(currentTimeNs);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    final /* synthetic */ void lambda$clearImage$8$EglRenderer(float r, float g, float b, float a) {
        this.clearSurfaceOnRenderThread(r, g, b, a);
    }

    final /* synthetic */ void lambda$releaseEglSurface$7$EglRenderer(Runnable completionCallback) {
        this.logD("detach egl context and release egl surface");
        if (this.eglBase != null) {
            this.eglBase.detachCurrent();
            this.eglContextAttached = false;
            this.eglBase.releaseSurface();
        }
        completionCallback.run();
    }

    final /* synthetic */ void lambda$onFrame$6$EglRenderer(long frameDrawStartTimeNs) {
        this.renderFrameOnRenderThread(frameDrawStartTimeNs, false);
    }

    final /* synthetic */ void lambda$notifySurfaceSizeChanged$5$EglRenderer(long frameDrawStartTimeNs) {
        this.renderFrameOnRenderThread(frameDrawStartTimeNs, this.isViewSizeChanged);
    }

    final /* synthetic */ void lambda$removeFrameListener$4$EglRenderer(CountDownLatch latch, FrameListener listener) {
        latch.countDown();
        Iterator<FrameListenerAndParams> iter = this.frameListeners.iterator();
        while (iter.hasNext()) {
            if (iter.next().listener != listener) continue;
            iter.remove();
        }
    }

    final /* synthetic */ void lambda$addFrameListener$3$EglRenderer(RendererCommon.GlDrawer drawerParam, FrameListener listener, float scale, boolean applyFpsReduction) {
        RendererCommon.GlDrawer listenerDrawer = drawerParam == null ? this.drawer : drawerParam;
        this.frameListeners.add(new FrameListenerAndParams(listener, scale, listenerDrawer, applyFpsReduction));
    }

    final /* synthetic */ void lambda$release$2$EglRenderer(Looper renderLooper) {
        this.logD("Quitting render thread.");
        renderLooper.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$release$1$EglRenderer(CountDownLatch eglCleanupBarrier) {
        this.logD("release egl and gl resources on render thread");
        if (!this.eglContextAttached && this.eglBase != null && !this.eglBase.hasSurface()) {
            this.logD("egl context not attached, make current to release gl resource");
            try {
                this.eglBase.createDummyPbufferSurface();
                this.eglBase.makeCurrent();
                this.eglContextAttached = true;
            }
            catch (RuntimeException e) {
                this.logD("failed to make current: " + e);
            }
        }
        Object object = EglBase.lock;
        synchronized (object) {
            GLES20.glUseProgram((int)0);
        }
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        this.frameDrawer.release();
        this.bitmapTextureFramebuffer.release();
        if (this.eglBase != null) {
            this.logD("eglBase detach and release.");
            this.eglBase.detachCurrent();
            this.eglContextAttached = false;
            this.eglBase.release();
            this.eglBase = null;
        }
        this.frameListeners.clear();
        eglCleanupBarrier.countDown();
    }

    final /* synthetic */ void lambda$init$0$EglRenderer(EglBase.Context sharedContext, int[] configAttributes) {
        if (sharedContext == null) {
            this.logD("EglBase10.create context");
            this.eglBase = EglBase$$CC.createEgl10$$STATIC$$(configAttributes);
        } else {
            this.logD("EglBase.create shared context");
            this.eglBase = EglBase$$CC.create$$STATIC$$(sharedContext, configAttributes);
        }
    }

    private static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable exceptionCallback) {
            super(looper);
            this.exceptionCallback = exceptionCallback;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", e);
                this.exceptionCallback.run();
            }
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object surface) {
            this.surface = surface;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                EglRenderer.this.eglContextAttached = true;
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener listener, float scale, RendererCommon.GlDrawer drawer, boolean applyFpsReduction) {
            this.listener = listener;
            this.scale = scale;
            this.drawer = drawer;
            this.applyFpsReduction = applyFpsReduction;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

