/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.HardwareVideoDecoder;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapperFactoryImpl;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderFactory;
import io.agora.base.internal.video.VideoDecoderFactory$$CC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HardwareVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "HardwareVideoDecoderFactory";
    private static final List<String> H264_HWDEC_EXCEPTION_MODELS = Arrays.asList("ASUS_T00J");
    private final EglBase.Context sharedContext;

    @Deprecated
    public HardwareVideoDecoderFactory() {
        this(null);
    }

    public HardwareVideoDecoderFactory(EglBase.Context sharedContext) {
        this.sharedContext = sharedContext;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (!VideoCodecType.contains(codecType.getName())) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(codecType.getName());
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(type.mimeType());
        if (capabilities != null && capabilities.colorFormats != null) {
            for (int supportedColorFormat : capabilities.colorFormats) {
                Logging.d(TAG, "supportedColorFormat : " + supportedColorFormat);
            }
        }
        EglBase.Context eglContext = this.sharedContext;
        if (codecType.params != null && codecType.params.containsKey("av_dec_output_byte_frame")) {
            Logging.w(TAG, "force decode to byte frame");
            eglContext = null;
        }
        return new HardwareVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), type, codecType.params, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities), eglContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", e);
            }
            if (info == null || info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupported(info, type);
    }

    private boolean isHardwareSupported(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        switch (type) {
            case VP8: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Intel.") || name.startsWith("OMX.Exynos.") || name.startsWith("OMX.Nvidia.");
            }
            case VP9: {
                return name.startsWith("OMX.qcom.") || name.startsWith("OMX.Exynos.");
            }
            case H264: {
                if (H264_HWDEC_EXCEPTION_MODELS.contains(Build.MODEL)) {
                    return false;
                }
                if (!MediaCodecUtils.isCodecInPrepareList(info.getName())) {
                    Logging.w(TAG, "not included codec:" + info.getName());
                } else {
                    Logging.d(TAG, "found available codec: " + info.getName());
                }
                Logging.w(TAG, "not included codec:" + info.getName());
                return true;
            }
            case H265: {
                return Build.VERSION.SDK_INT >= 21;
            }
        }
        return false;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.");
    }

    @Override
    public VideoDecoder createDecoder(String string) {
        return VideoDecoderFactory$$CC.createDecoder((VideoDecoderFactory)this, string);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo, boolean bl) {
        return VideoDecoderFactory$$CC.createDecoder(this, videoCodecInfo, bl);
    }
}

