/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.video.H264Decoder;
import io.agora.base.internal.video.VP8Decoder;
import io.agora.base.internal.video.VP9Decoder;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderFactory;
import io.agora.base.internal.video.VideoDecoderFactory$$CC;
import java.util.ArrayList;
import java.util.HashMap;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    @Override
    @Deprecated
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        return this.createDecoder(new VideoCodecInfo(codecType, new HashMap<String, String>()));
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        if (codecType.getName().equalsIgnoreCase("VP8")) {
            return new VP8Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP9") && VP9Decoder.nativeIsSupported()) {
            return new VP9Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("H264") && H264Decoder.nativeIsSupported()) {
            return new H264Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (VP9Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (H264Decoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo, boolean bl) {
        return VideoDecoderFactory$$CC.createDecoder(this, videoCodecInfo, bl);
    }
}

