/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.video.H264Encoder;
import io.agora.base.internal.video.VP8Encoder;
import io.agora.base.internal.video.VP9Encoder;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderFactory;
import io.agora.base.internal.video.VideoEncoderFactory$$CC;
import java.util.ArrayList;
import java.util.HashMap;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info, boolean useTexture) {
        if (info.name.equalsIgnoreCase("VP8")) {
            return new VP8Encoder();
        }
        if (info.name.equalsIgnoreCase("VP9") && VP9Encoder.nativeIsSupported()) {
            return new VP9Encoder();
        }
        if (info.name.equalsIgnoreCase("H264") && H264Encoder.nativeIsSupported()) {
            return new H264Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs(boolean useTexture) {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (VP9Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (H264Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo, boolean bl, boolean bl2) {
        return VideoEncoderFactory$$CC.createEncoder(this, videoCodecInfo, bl, bl2);
    }
}

