/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase$$CC;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$0;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$1;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$2;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$3;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$4;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$5;
import io.agora.base.internal.video.TimerSurfaceTextureHelper$$Lambda$6;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;

public class TimerSurfaceTextureHelper
implements ISurfaceTextureHelper {
    private static final String TAG = "TSurfaceTextureHelper";
    private volatile int notifyIntervalInMS = 0;
    private final Handler handler;
    private final EglBase eglBase;
    @NonNull
    private final EglBase.Context sharedContext;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isOesTextureInUse = false;
    private boolean isQuitting = false;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.d(TimerSurfaceTextureHelper.TAG, "Setting listener to " + TimerSurfaceTextureHelper.this.pendingListener);
            TimerSurfaceTextureHelper.this.listener = TimerSurfaceTextureHelper.this.pendingListener;
            TimerSurfaceTextureHelper.this.pendingListener = null;
            if (TimerSurfaceTextureHelper.this.hasPendingTexture) {
                TimerSurfaceTextureHelper.this.updateTexImage();
                TimerSurfaceTextureHelper.this.hasPendingTexture = false;
            }
            TimerSurfaceTextureHelper.this.handler.postDelayed(TimerSurfaceTextureHelper.this.timerNotifyRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
        }
    };
    final Runnable timerNotifyRunnable = new Runnable(){

        @Override
        public void run() {
            if (TimerSurfaceTextureHelper.this.tryDeliverTextureFrame()) {
                TimerSurfaceTextureHelper.this.handler.postDelayed(TimerSurfaceTextureHelper.this.timerNotifyRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
            }
        }
    };
    private static final int ANDROID_API_TEXTURE_IN_USE = 10;

    public static TimerSurfaceTextureHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TimerSurfaceTextureHelper>(){

            @Override
            @Nullable
            public TimerSurfaceTextureHelper call() {
                try {
                    return new TimerSurfaceTextureHelper(sharedContext, handler);
                }
                catch (RuntimeException e) {
                    Logging.e(TimerSurfaceTextureHelper.TAG, threadName + " create failure", e);
                    return null;
                }
            }
        });
    }

    private TimerSurfaceTextureHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase$$CC.create$$STATIC$$(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        this.sharedContext = sharedContext != null ? sharedContext : this.eglBase.getEglBaseContext();
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        TimerSurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new TimerSurfaceTextureHelper$$Lambda$0(this), handler);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    public void setFrameRate(int frameRate) {
        if (frameRate <= 0) {
            throw new IllegalArgumentException("invalid frame rate");
        }
        this.notifyIntervalInMS = 1000 / frameRate;
    }

    @Override
    public void startListening(VideoSink listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        if (this.notifyIntervalInMS == 0) {
            throw new IllegalStateException("frame rate not set");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    @Override
    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new TimerSurfaceTextureHelper$$Lambda$1(this));
    }

    @Override
    public void setTextureSize(int textureWidth, int textureHeight) {
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + textureWidth);
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + textureHeight);
        }
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post((Runnable)new TimerSurfaceTextureHelper$$Lambda$2(this, textureWidth, textureHeight));
    }

    @Override
    public void setFrameRotation(int rotation) {
        this.handler.post((Runnable)new TimerSurfaceTextureHelper$$Lambda$3(this, rotation));
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post((Runnable)new TimerSurfaceTextureHelper$$Lambda$4(this));
    }

    @Override
    public boolean isOesTextureInUse() {
        return this.isOesTextureInUse;
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new TimerSurfaceTextureHelper$$Lambda$5(this));
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = EglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to updateTexImage. " + e.getMessage());
        }
    }

    private boolean tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || this.listener == null) {
            return false;
        }
        if (this.isOesTextureInUse) {
            if (this.listener instanceof IVideoCapture) {
                ((IVideoCapture)this.listener).onFrameDropped(10);
            }
            return true;
        }
        this.isOesTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = this.surfaceTexture.getTimestamp();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, (Runnable)new TimerSurfaceTextureHelper$$Lambda$6(this));
        VideoFrame frame = new VideoFrame(buffer, this.frameRotation, timestampNs);
        this.listener.onFrame(frame);
        frame.release();
        return true;
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isOesTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    final /* synthetic */ void lambda$dispose$5$TimerSurfaceTextureHelper() {
        this.isQuitting = true;
        if (!this.isOesTextureInUse) {
            this.release();
        }
    }

    final /* synthetic */ void lambda$returnTextureFrame$4$TimerSurfaceTextureHelper() {
        this.isOesTextureInUse = false;
        if (this.isQuitting) {
            this.release();
        }
    }

    final /* synthetic */ void lambda$setFrameRotation$3$TimerSurfaceTextureHelper(int rotation) {
        this.frameRotation = rotation;
    }

    final /* synthetic */ void lambda$setTextureSize$2$TimerSurfaceTextureHelper(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    final /* synthetic */ void lambda$stopListening$1$TimerSurfaceTextureHelper() {
        this.listener = null;
        this.pendingListener = null;
    }

    final /* synthetic */ void lambda$new$0$TimerSurfaceTextureHelper(SurfaceTexture st) {
        this.hasPendingTexture = true;
    }

    public static interface IVideoCapture
    extends VideoSink {
        public void onFrameDropped(int var1);
    }
}

