/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.opengl.GLES20;
import io.agora.base.JavaI420Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.GPUPBOUtil;
import io.agora.base.internal.video.GlGenericDrawer;
import io.agora.base.internal.video.GlShader;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.YuvConverter$$Lambda$0;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private final GPUPBOUtil gpupboUtil = new GPUPBOUtil();
    private static final boolean DEBUG = false;
    private static boolean enablePboOpt = true;
    private static boolean enableConvertPerLog = false;
    private long convertTimeInNS = 0L;
    private long convertTimeCounter = 0L;

    @CalledByNative
    public static void setEnablePboOpt(boolean enable) {
        enablePboOpt = enable;
    }

    @CalledByNative
    public static void setEnableConvertPerLog(boolean enable) {
        enableConvertPerLog = enable;
    }

    public YuvConverter() {
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer inputTextureBuffer) {
        boolean gpuAccSuccess;
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        int viewportWidth = stride / 4;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight);
        long timingPre = 0L;
        if (enableConvertPerLog) {
            timingPre = System.nanoTime();
        }
        boolean bl = gpuAccSuccess = enablePboOpt && this.gpupboUtil.readFrame(0, 0, this.i420TextureFrameBuffer.getWidth(), this.i420TextureFrameBuffer.getHeight(), 6408, 5121, i420ByteBuffer);
        if (!gpuAccSuccess) {
            GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)i420ByteBuffer);
        }
        if (enableConvertPerLog) {
            long timeSpent = System.nanoTime() - timingPre;
            this.convertTimeInNS = this.convertTimeInNS == 0L ? timeSpent : (long)((double)(this.convertTimeInNS + timeSpent) / 2.0);
            ++this.convertTimeCounter;
            if (this.convertTimeCounter % 100L == 0L) {
                this.convertTimeCounter = 0L;
                Logging.w("YuvConverter", "pbo " + (gpuAccSuccess ? "YES" : "NO") + ", avg timing for read pixel, " + this.convertTimeInNS + " ns");
            }
        }
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataU, stride, dataV, stride, new YuvConverter$$Lambda$0(i420ByteBuffer));
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.gpupboUtil.release();
        this.threadChecker.detachThread();
    }

    static final /* synthetic */ void lambda$convert$0$YuvConverter(ByteBuffer i420ByteBuffer) {
        JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.299f, 0.587f, 0.114f, 0.0f};
        private static final float[] uCoeffs = new float[]{-0.168736f, -0.331264f, 0.5f, 0.5f};
        private static final float[] vCoeffs = new float[]{0.5f, -0.418688f, -0.0813124f, 0.5f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader shader) {
            this.xUnitLoc = shader.getUniformLocation("xUnit");
            this.coeffsLoc = shader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader shader, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * texMatrix[0] / (float)frameWidth), (float)(this.stepSize * texMatrix[1] / (float)frameWidth));
        }
    }
}

