/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ThreadUtils;
import io.agora.rtc2.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private static final int ANDROID_SNOW_CONE = 31;
    private static final String PERMISSION_BLUETOOTH_CONNECT = "android.permission.BLUETOOTH_CONNECT";
    private static final int UNINIT = 0;
    private static final int START = 1;
    private static final int STOP = 2;
    private static final int ERROR = 4;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private final WeakReference<Context> mContext;
    private long mNativeHandle;
    @NonNull
    private final ThreadUtils.ThreadChecker mThreadChecker;
    private EventHandler mEventHandler;
    private ControllerState mState;
    private boolean mIsWiredHeadsetPlugged = false;
    private int mHeadsetType = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private int mCurrentRouting = -1;
    private int mDefaultRouting = -1;
    private int mForcedRouting = -1;
    private int mDefaultSystemRouting = -1;
    private int mChannelProfile = -1;
    private boolean mVideoDisabled = true;
    private boolean mMuteLocal = false;
    private boolean mMuteRemotes = false;
    private int mEngineRole = -1;
    private boolean mPhoneInCall = false;
    private int mSpeakerCommVolume = -1;
    private boolean mForceUseA2dp = true;
    private int mBtScoState = 3;
    private boolean mIsBTScoStarted = false;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 3000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 2;
    private int dynamic_timeout = 3000;
    private int mScoConnectionAttemps;
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    private ControllerStopState mStopState = null;
    private ControllerStartState mStartState = null;
    private ControllerErrorState mErrorState = null;
    private static AudioManager mockedAudioManager = null;
    private static MockedBroadcaseter mockedBroadcaster = null;
    private static boolean mockBlueToothEnable = false;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                AudioRoutingController.this.bluetoothTimeout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private HeadsetBroadcastReceiver mHeadsetReceiver;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private boolean mDisposed = false;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET = 2;
    private static final int EVT_BT_SCO = 3;
    public static final int CMD_SET_DEFAULT_ROUTING = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int CMD_START_BT_SCO = 15;
    public static final int CMD_FORCE_TO_A2DP = 16;
    public static final int EVT_CHANNEL_PROFILE = 20;
    public static final int EVT_ENGINE_ROLE_CHANGED = 21;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    private static final int EVT_BT_HEADSET_RECONNECT = 23;
    public static final int AUDIO_DEVICE_EVENT_FALLBACK_TO_A2DP = 4;

    @VisibleForTesting
    public static void setMockedAudioManager(AudioManager mockedAudioManager) {
        AudioRoutingController.mockedAudioManager = mockedAudioManager;
    }

    @VisibleForTesting
    public static void setMockedBroadcaster(MockedBroadcaseter mockedBroadcaster) {
        AudioRoutingController.mockedBroadcaster = mockedBroadcaster;
    }

    @VisibleForTesting
    public static void setMockBlueToothEnable(boolean mockBlueToothEnable) {
        AudioRoutingController.mockBlueToothEnable = mockBlueToothEnable;
    }

    private void startTimer() {
        this.dynamic_timeout += 3000 * this.mScoConnectionAttemps;
        Logging.w(TAG, "start bluetooth timer " + this.dynamic_timeout);
        this.mEventHandler.postDelayed(this.bluetoothTimeoutRunnable, 3000L);
    }

    private void cancelTimer() {
        this.mScoConnectionAttemps = 0;
        Logging.d(TAG, "cancel bluetooth timer");
        this.mEventHandler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private ControllerState changeState(int state) {
        if (state == 2) {
            if (this.mStopState == null) {
                this.mStopState = new ControllerStopState();
            } else {
                this.mStopState.reset();
            }
            return this.mStopState;
        }
        if (state == 1) {
            if (this.mStartState == null) {
                this.mStartState = new ControllerStartState();
            } else {
                this.mStartState.reset();
            }
            return this.mStartState;
        }
        if (this.mErrorState == null) {
            this.mErrorState = new ControllerErrorState();
        } else {
            this.mErrorState.reset();
        }
        return this.mErrorState;
    }

    @CalledByNative
    public AudioRoutingController(Context context, long handle) {
        this.mContext = new WeakReference<Context>(context);
        this.mNativeHandle = handle;
        this.mThreadChecker = new ThreadUtils.ThreadChecker();
    }

    @CalledByNative
    public long getNativeHandle() {
        this.mThreadChecker.checkIsOnValidThread();
        return this.mNativeHandle;
    }

    @CalledByNative
    public int initialize() {
        Logging.i(TAG, "initialize +");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            Logging.e(TAG, "context has been GCed");
            return -1;
        }
        AudioManager am = this.getAudioManager();
        if (am == null) {
            Logging.e(TAG, "invalid context: can't get AudioManager");
            return -1;
        }
        this.mEventHandler = new EventHandler(Looper.getMainLooper());
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        this.mIsWiredHeadsetPlugged = am.isWiredHeadsetOn();
        this.mState = this.changeState(2);
        Logging.i(TAG, "Headset setup: Plugged = " + this.mIsWiredHeadsetPlugged);
        if (!this.mHeadsetReceiver.getRegistered()) {
            IntentFilter hs = new IntentFilter("android.intent.action.HEADSET_PLUG");
            context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, hs);
            if (mockedBroadcaster != null) {
                mockedBroadcaster.registerReceiver(this.mHeadsetReceiver, hs);
            }
            this.mHeadsetReceiver.setRegistered(true);
        }
        if (Build.VERSION.SDK_INT >= 31 && !this.hasPermission(context, PERMISSION_BLUETOOTH_CONNECT) || Build.VERSION.SDK_INT < 31 && !this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return 0;
        }
        if (this.mBTHeadsetListener != null) {
            Logging.w(TAG, "Bluetooth service Listener already been initialized");
        } else {
            try {
                this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                    public void onServiceConnected(int profile, BluetoothProfile proxy) {
                        Logging.i(AudioRoutingController.TAG, "onServiceConnected " + profile + " =? headset(" + 1 + ")");
                        if (profile == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service connected: " + profile + " " + proxy);
                            AudioRoutingController.this.mBTHeadset = (BluetoothHeadset)proxy;
                        }
                    }

                    public void onServiceDisconnected(int profile) {
                        Logging.i(AudioRoutingController.TAG, "onServiceDisconnected " + profile + " =? headset(" + 1 + ")");
                        if (profile == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service disconnected: " + profile);
                            AudioRoutingController.this.cancelTimer();
                            AudioRoutingController.this.mBTHeadset = null;
                        }
                    }
                };
            }
            catch (Exception e) {
                Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + e.getMessage());
            }
        }
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return 0;
            }
            this.mBTAdapter.getProfileProxy(context, this.mBTHeadsetListener, 1);
            if (2 == this.mBTAdapter.getProfileConnectionState(1)) {
                this.mIsBTHeadsetPlugged = true;
            }
            Logging.i(TAG, "BT headset setup: BTHeadsetPlugged = " + this.mIsBTHeadsetPlugged + " " + this.mBTHeadset);
            IntentFilter bt = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            bt.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            bt.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            bt.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                Intent intent = context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, bt);
                if (mockedBroadcaster != null) {
                    mockedBroadcaster.registerReceiver(this.mBTHeadsetReceiver, bt);
                }
                this.mBTHeadsetReceiver.setRegistered(true);
                if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                    switch (state) {
                        case 1: {
                            Logging.i(TAG, "initial Bluetooth SCO device connected");
                            this.mBtScoState = 1;
                            break;
                        }
                        default: {
                            Logging.i(TAG, "initial Bluetooth SCO device unconnected");
                            this.mBtScoState = 3;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + e.getMessage());
        }
        Logging.i(TAG, "initialize -");
        return 0;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    @CalledByNative
    public void dispose() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        this.mNativeHandle = 0L;
        Logging.d(TAG, "dispose");
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    if (mockedBroadcaster != null) {
                        mockedBroadcaster.unRegisterReceiver(this.mHeadsetReceiver);
                    }
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    if (mockedBroadcaster != null) {
                        mockedBroadcaster.unRegisterReceiver(this.mBTHeadsetReceiver);
                    }
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception e) {
            Logging.e(TAG, "AudioRoutingController dispose fail: ", e);
        }
    }

    @CalledByNative
    public int startMonitoring() {
        Logging.d(TAG, "startMonitoring()");
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                AudioRoutingController.this.mState.setState(1);
            }
        });
        int targetRouting = this.mIsBTHeadsetPlugged ? 5 : (this.mIsWiredHeadsetPlugged ? this.mHeadsetType : this.mDefaultRouting);
        return targetRouting;
    }

    @CalledByNative
    public void stopMonitoring() {
        Logging.d(TAG, "stopMonitoring()");
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                AudioRoutingController.this.mState.setState(2);
            }
        });
    }

    @CalledByNative
    public void sendEvent(int event, int arg) {
        Logging.d(TAG, "sendEvent: [" + event + "], extra arg: " + arg + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(event, arg, 0);
            this.mEventHandler.sendMessage(m);
        }
    }

    private int getBtConnectedDevicesSize() {
        if (this.mBTHeadset == null) {
            return 0;
        }
        int size = 0;
        try {
            List devices = this.mBTHeadset.getConnectedDevices();
            for (BluetoothDevice device : devices) {
                Logging.i(TAG, "connected device name: " + device.getName());
            }
            size = devices.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        if (mockedAudioManager != null) {
            return mockedAudioManager;
        }
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int routing) {
        if (this.mDisposed) {
            return;
        }
        this.nativeAudioRoutingChanged(routing);
    }

    private int doSetAudioOutputRouting(int routing) {
        Logging.i(TAG, "set audio output routing from " + this.getAudioRouteDesc(this.mCurrentRouting) + " to " + this.getAudioRouteDesc(routing));
        try {
            AudioManager am = this.getAudioManager();
            am.setSpeakerphoneOn(routing == 3);
            if (this.queryCurrentAudioRouting() != routing) {
                int current = this.queryCurrentAudioRouting();
                Logging.i(TAG, "different audio routing from target " + routing + ", actual routing: " + current + "[" + this.getAudioRouteDesc(current) + "]");
            }
            this.updateBluetoothSco(routing);
            if (routing == this.mCurrentRouting) {
                Logging.i(TAG, "audio routing not changed, ignore");
                return 0;
            }
            this.mCurrentRouting = routing;
            this.notifyAudioRoutingChanged(routing);
            Logging.i(TAG, "audio routing changed to " + this.getAudioRouteDesc(this.mCurrentRouting));
        }
        catch (Exception e) {
            Logging.e(TAG, "set audio output routing failed:", e);
        }
        return 0;
    }

    private int updateBluetoothSco(int targetRouting) {
        Logging.d(TAG, "updateBluetoothSco sco started: " + this.mIsBTScoStarted + ", audio route target: " + targetRouting + "[" + this.getAudioRouteDesc(targetRouting) + "] current: " + this.mCurrentRouting + "[" + this.getAudioRouteDesc(this.mCurrentRouting) + "], engine role: " + this.mEngineRole);
        if (targetRouting == 5) {
            if (!this.mForceUseA2dp) {
                Logging.w(TAG, "enable hfp");
                this.mIsBTScoStarted = true;
                this.startTimer();
                this.startBtSco();
            } else if (this.mIsBTScoStarted) {
                Logging.w(TAG, "enable a2dp");
                this.mIsBTScoStarted = false;
                this.cancelTimer();
                this.stopBtSco();
            }
        } else if (this.mCurrentRouting == 5 && this.mIsBTScoStarted) {
            this.mIsBTScoStarted = false;
            this.cancelTimer();
            this.stopBtSco();
        }
        return 0;
    }

    private void startBtSco() {
        AudioManager am = this.getAudioManager();
        int mode = am.getMode();
        Logging.i(TAG, "try to opening bt sco " + this.mScoConnectionAttemps + " " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
        Logging.d(TAG, "Off call sco support = " + am.isBluetoothScoAvailableOffCall());
        this.mBtScoState = 0;
        this.doStartBTSco(am);
    }

    private String modeAsString(int mode) {
        String modeAsString;
        switch (mode) {
            case 0: {
                modeAsString = "MODE_NORMAL";
                break;
            }
            case 1: {
                modeAsString = "MODE_RINGTONE";
                break;
            }
            case 2: {
                modeAsString = "MODE_IN_CALL";
                break;
            }
            case 3: {
                modeAsString = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                modeAsString = "Unknown " + mode;
            }
        }
        return modeAsString;
    }

    private String btStateAsString(int state) {
        String btStateAsString;
        switch (state) {
            case 0: {
                btStateAsString = "SCO_CONNECTING";
                break;
            }
            case 1: {
                btStateAsString = "SCO_CONNECTED";
                break;
            }
            case 2: {
                btStateAsString = "SCO_DISCONNECTING";
                break;
            }
            case 3: {
                btStateAsString = "SCO_DISCONNECTED";
                break;
            }
            default: {
                btStateAsString = "Unknown " + state;
            }
        }
        return btStateAsString;
    }

    private String evtAsString(int evt) {
        String evtString;
        switch (evt) {
            case 1: {
                evtString = "EVT_HEADSET";
                break;
            }
            case 2: {
                evtString = "EVT_BT_HEADSET";
                break;
            }
            case 3: {
                evtString = "EVT_BT_SCO";
                break;
            }
            case 10: {
                evtString = "CMD_SET_DEFAULT_ROUTING";
                break;
            }
            case 11: {
                evtString = "CMD_FORCE_TO_SPEAKER";
                break;
            }
            case 16: {
                evtString = "CMD_FORCE_TO_A2DP";
                break;
            }
            case 14: {
                evtString = "CMD_MUTE_VIDEO_REMOTES";
                break;
            }
            case 20: {
                evtString = "EVT_CHANNEL_PROFILE";
                break;
            }
            case 22: {
                evtString = "EVT_PHONE_STATE_CHANGED";
                break;
            }
            default: {
                evtString = "evt " + evt;
            }
        }
        return evtString;
    }

    private void doStartBTSco(AudioManager am) {
        try {
            int mode = am.getMode();
            Logging.i(TAG, "doStartBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn() + " " + mode + "[" + this.modeAsString(mode) + "]");
            if (Build.VERSION.SDK_INT < 22) {
                am.setStreamMute(0, true);
            } else {
                am.setStreamVolume(0, 1, 0);
            }
            if (am.isBluetoothScoOn()) {
                am.stopBluetoothSco();
                Thread.sleep(600L);
                Logging.i(TAG, "doStartBTSco in sco already on, try stop old connect firstly!");
            }
            am.startBluetoothSco();
        }
        catch (Exception e) {
            Logging.e(TAG, "doStartBTSco fail ", e);
        }
        Logging.d(TAG, "doStartBTSco done sco on: " + am.isBluetoothScoOn() + " " + am.getMode() + "[" + this.modeAsString(am.getMode()) + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doStopBTSco(AudioManager am) {
        Logging.i(TAG, "doStopBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn());
        try {
            am.stopBluetoothSco();
            if (Build.VERSION.SDK_INT >= 22) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopBtSco() {
        AudioManager am = this.getAudioManager();
        int mode = am.getMode();
        Logging.i(TAG, "try to stopping bt sco " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
        this.mBtScoState = !am.isBluetoothScoOn() ? 3 : 2;
        this.doStopBTSco(am);
    }

    private void checkFallbackA2dpIfNeed() {
        AudioManager am = this.getAudioManager();
        if (am == null || !this.mIsBTHeadsetPlugged || !am.isBluetoothA2dpOn()) {
            Logging.i(TAG, "could not use a2dp also..");
            this.mIsBTHeadsetPlugged = false;
            this.resetAudioRouting();
            return;
        }
        this.nativeAudioRoutingCallbackEvent(4);
    }

    private void bluetoothTimeout() {
        AudioManager am = this.getAudioManager();
        boolean scoConnected = false;
        if (am != null) {
            scoConnected = am.isBluetoothScoOn();
        }
        if (this.mScoConnectionAttemps < 2) {
            Logging.w(TAG, "attemps trying, bt sco started: " + this.mIsBTScoStarted + " sco connected: " + scoConnected + " " + this.mScoConnectionAttemps + " times " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "]");
            if (!scoConnected) {
                this.startTimer();
                ++this.mScoConnectionAttemps;
                this.stopBtSco();
                am.stopBluetoothSco();
                this.doStartBTSco(am);
            } else {
                Logging.d(TAG, "soc connected");
                this.cancelTimer();
            }
        } else {
            Logging.e(TAG, "start bluetooth sco timeout, actual routing: " + this.queryCurrentAudioRouting());
            this.cancelTimer();
            this.nativeAudioRoutingError(1030);
            this.checkFallbackA2dpIfNeed();
        }
    }

    private int getCurrSystemRouting() {
        int devices = 0;
        int sdkdevices = 0;
        AudioManager am = this.getAudioManager();
        try {
            Method method = AudioManager.class.getMethod("getDevicesForStream", Integer.TYPE);
            devices = (Integer)method.invoke((Object)am, 3);
            Logging.i(TAG, "System playout device: " + devices);
        }
        catch (Exception error) {
            Logging.e(TAG, "Error while getDevicesForStream! ", error);
        }
        switch (devices) {
            case 128: 
            case 256: 
            case 512: {
                sdkdevices = 5;
                break;
            }
            case 4: {
                sdkdevices = 0;
                break;
            }
            case 8: {
                sdkdevices = 2;
                break;
            }
            default: {
                sdkdevices = 3;
            }
        }
        return sdkdevices;
    }

    private void resetAudioRouting() {
        int targetRouting = this.mIsBTHeadsetPlugged && this.mIsWiredHeadsetPlugged ? this.mDefaultSystemRouting : (this.mIsBTHeadsetPlugged ? 5 : (this.mIsWiredHeadsetPlugged ? this.mHeadsetType : (this.mForcedRouting != -1 ? this.mForcedRouting : this.mDefaultRouting)));
        Logging.i(TAG, "reset audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(targetRouting) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
        if (this.mCurrentRouting != targetRouting || this.queryCurrentAudioRouting() != this.mCurrentRouting) {
            this.doSetAudioOutputRouting(targetRouting);
        }
    }

    private String getAudioRouteDesc(int route) {
        switch (route) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "Default";
            }
        }
        return "Unknown";
    }

    @CalledByNative
    public int queryCurrentAudioRouting() {
        AudioManager am = this.getAudioManager();
        if (this.mBTAdapter == null) {
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        try {
            if (am.isSpeakerphoneOn()) {
                return 3;
            }
            if ((am.isBluetoothScoOn() || am.isBluetoothA2dpOn()) && (mockBlueToothEnable || this.mBTAdapter.isEnabled())) {
                return 5;
            }
            if (am.isWiredHeadsetOn()) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            Logging.e(TAG, "fatal error @queryCurrentAudioRouting", e);
            return -1;
        }
    }

    protected boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    private native void nativeAudioRoutingChanged(int var1);

    private native void nativeAudioRoutingError(int var1);

    private native void nativeAudioRoutingCallbackEvent(int var1);

    private class ControllerErrorState
    extends ControllerBaseState {
        private ControllerErrorState() {
        }

        @Override
        public int getState() {
            return 4;
        }
    }

    private class ControllerStartState
    extends ControllerBaseState {
        public ControllerStartState() {
            this.resetImpl();
            Logging.i(AudioRoutingController.TAG, "Monitor start: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        private void resetImpl() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 1) {
                    AudioRoutingController.this.mDefaultRouting = 3;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 1;
                }
            }
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mForcedRouting = -1;
            if (!mockBlueToothEnable && mockedBroadcaster == null) {
                AudioRoutingController.this.mDefaultSystemRouting = AudioRoutingController.this.getCurrSystemRouting();
            }
            AudioRoutingController.this.resetAudioRouting();
            if (AudioRoutingController.this.mCurrentRouting == 5) {
                AudioRoutingController.this.getBtConnectedDevicesSize();
            }
        }

        @Override
        public void reset() {
            this.resetImpl();
            Logging.i(AudioRoutingController.TAG, "Monitor reset: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public void onEvent(int event, int info) {
            Logging.d(AudioRoutingController.TAG, "StartState: onEvent: " + AudioRoutingController.this.evtAsString(event) + ", info: " + info);
            switch (event) {
                case 1: {
                    AudioRoutingController.this.mHeadsetType = info;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = info >= 0;
                    AudioRoutingController.this.mDefaultSystemRouting = AudioRoutingController.this.mIsWiredHeadsetPlugged ? info : AudioRoutingController.this.queryCurrentAudioRouting();
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged && AudioRoutingController.this.mCurrentRouting != info) {
                        AudioRoutingController.this.doSetAudioOutputRouting(info);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 11: {
                    if (AudioRoutingController.this.mCurrentRouting == 2 || AudioRoutingController.this.mCurrentRouting == 0 || AudioRoutingController.this.mCurrentRouting == 5) {
                        Logging.i(AudioRoutingController.TAG, "StartState: not proceed with force speaker event for BT/HS");
                        return;
                    }
                    AudioRoutingController.this.mForcedRouting = info == 1 ? 3 : 1;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    if (info == 1) {
                        AudioRoutingController.this.doSetAudioOutputRouting(3);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = info;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    AudioRoutingController.this.updateBluetoothSco(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 2: {
                    if (info == 0 && !AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        return;
                    }
                    AudioRoutingController.this.mIsBTHeadsetPlugged = info == 1;
                    AudioRoutingController.this.mDefaultSystemRouting = AudioRoutingController.this.mIsBTHeadsetPlugged ? 5 : AudioRoutingController.this.queryCurrentAudioRouting();
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(5);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 3: {
                    AudioRoutingController.this.mBtScoState = info == 1 ? 1 : 2;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    if (info == 1) {
                        AudioRoutingController.this.mScoConnectionAttemps = 0;
                        break;
                    }
                    if (info != 0 || AudioRoutingController.this.mCurrentRouting != 5) break;
                    Logging.w(AudioRoutingController.TAG, "StartState: sco is disconnect but current route still bt");
                    break;
                }
                case 10: {
                    AudioRoutingController.this.mDefaultRouting = info;
                    Logging.i(AudioRoutingController.TAG, "User set default routing to:" + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting));
                    break;
                }
                case 22: {
                    Logging.i(AudioRoutingController.TAG, "phone state changed: " + info);
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    if (info == 0) {
                        AudioRoutingController.this.resetAudioRouting();
                        break;
                    }
                    AudioRoutingController.this.mCurrentRouting = -1;
                    break;
                }
                case 23: {
                    Logging.i(AudioRoutingController.TAG, "try reconnect bt: ");
                    if (AudioRoutingController.this.mCurrentRouting != 5) break;
                    AudioRoutingController.this.doSetAudioOutputRouting(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                default: {
                    super.onEvent(event, info);
                }
            }
        }
    }

    private class ControllerStopState
    extends ControllerBaseState {
        public ControllerStopState() {
            Logging.i(AudioRoutingController.TAG, "Monitor stopped");
            this.resetImpl();
        }

        @Override
        public int getState() {
            return 2;
        }

        private void resetImpl() {
            AudioRoutingController.this.cancelTimer();
            if (AudioRoutingController.this.mIsBTScoStarted || AudioRoutingController.this.getAudioManager().isBluetoothScoOn()) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mCurrentRouting = -1;
        }

        @Override
        public void reset() {
            Logging.i(AudioRoutingController.TAG, "Monitor stop state, reset");
            this.resetImpl();
        }

        @Override
        public void onEvent(int evt, int info) {
            Logging.d(AudioRoutingController.TAG, "StopState: onEvent: " + AudioRoutingController.this.evtAsString(evt) + ", info: " + info);
            try {
                AudioManager am = AudioRoutingController.this.getAudioManager();
                switch (evt) {
                    case 11: {
                        am.setSpeakerphoneOn(info == 1);
                        AudioRoutingController.this.mCurrentRouting = info == 1 ? 3 : -1;
                        AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.queryCurrentAudioRouting());
                        break;
                    }
                    default: {
                        super.onEvent(evt, info);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logging.e(AudioRoutingController.TAG, "onEvent: Exception ", e);
            }
        }
    }

    private abstract class ControllerBaseState
    implements ControllerState {
        private ControllerBaseState() {
        }

        @Override
        public void setState(int state) {
            if (state == this.getState()) {
                Logging.i(AudioRoutingController.TAG, "setState: state not changed!");
                return;
            }
            AudioRoutingController.this.mState = AudioRoutingController.this.changeState(state);
        }

        @Override
        public void reset() {
            AudioRoutingController.this.resetAudioRouting();
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public void onEvent(int event, int info) {
            switch (event) {
                case 1: {
                    int route;
                    AudioRoutingController.this.mHeadsetType = info;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = info >= 0;
                    int n = route = AudioRoutingController.this.mIsWiredHeadsetPlugged ? info : AudioRoutingController.this.queryCurrentAudioRouting();
                    if (mockedBroadcaster != null) {
                        AudioRoutingController.this.mDefaultSystemRouting = route;
                    }
                    AudioRoutingController.this.notifyAudioRoutingChanged(route);
                    break;
                }
                case 20: {
                    AudioRoutingController.this.mChannelProfile = info;
                    break;
                }
                case 2: {
                    int route;
                    AudioRoutingController.this.mIsBTHeadsetPlugged = info == 1;
                    int n = route = AudioRoutingController.this.mIsBTHeadsetPlugged ? 5 : AudioRoutingController.this.queryCurrentAudioRouting();
                    if (mockBlueToothEnable) {
                        AudioRoutingController.this.mDefaultSystemRouting = route;
                    }
                    AudioRoutingController.this.notifyAudioRoutingChanged(route);
                    break;
                }
                case 16: {
                    AudioRoutingController.this.mForceUseA2dp = info == 1;
                    Logging.w(AudioRoutingController.TAG, "bluetooth protocol to: " + (AudioRoutingController.this.mForceUseA2dp ? "a2dp" : "hfp"));
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    AudioRoutingController.this.updateBluetoothSco(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 14: {
                    AudioRoutingController.this.mVideoDisabled = info > 0;
                    break;
                }
                case 12: {
                    AudioRoutingController.this.mMuteLocal = info > 0;
                    break;
                }
                case 13: {
                    AudioRoutingController.this.mMuteRemotes = info > 0;
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = info;
                    break;
                }
                case 10: {
                    AudioRoutingController.this.mDefaultRouting = info;
                    Logging.i(AudioRoutingController.TAG, "User set default routing to:" + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting));
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    break;
                }
            }
        }
    }

    private static interface ControllerState {
        public void setState(int var1);

        public int getState();

        public void onEvent(int var1, int var2);

        public void reset();
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            AudioRoutingController.this.mState.onEvent(msg.what, msg.arg1);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            block30: {
                String action = intent.getAction();
                try {
                    if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        String deviceName = device != null ? device.getName() : "bt headset has no name";
                        Logging.d(AudioRoutingController.TAG, "BT " + deviceName + " state : " + previousState + ", " + state);
                        switch (state) {
                            case 2: {
                                if (mockedBroadcaster != null || device != null && (device.getBluetoothClass().hasService(0x200000) || device.getBluetoothClass().hasService(0x400000))) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " connected");
                                    AudioRoutingController.this.sendEvent(2, 1);
                                    break;
                                }
                                break block30;
                            }
                            case 1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " connecting");
                                break;
                            }
                            case 3: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " disconnecting");
                                break;
                            }
                            case 0: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " disconnected");
                                if (AudioRoutingController.this.getBtConnectedDevicesSize() == 0) {
                                    AudioRoutingController.this.sendEvent(2, 0);
                                    break;
                                }
                                AudioRoutingController.this.sendEvent(23, 0);
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " unknown event, state=" + state);
                                break;
                            }
                        }
                        break block30;
                    }
                    if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        Logging.i(AudioRoutingController.TAG, "BT " + device.getName() + " audio state: " + previousState + "," + state);
                        switch (state) {
                            case 12: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " connected");
                                break;
                            }
                            case 11: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " connecting");
                                break;
                            }
                            case 10: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " disconnected");
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " event, state=" + state);
                                break;
                            }
                        }
                        break block30;
                    }
                    if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                        int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                        int previousState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                        Logging.i(AudioRoutingController.TAG, "BT ACTION_SCO_AUDIO_STATE_UPDATED prev " + previousState + "," + state);
                        switch (state) {
                            case 1: {
                                if (mockedBroadcaster != null || AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1) == 2) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connected");
                                    AudioRoutingController.this.sendEvent(3, 1);
                                    break;
                                }
                                break block30;
                            }
                            case 2: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connecting");
                                break;
                            }
                            case -1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device error");
                                break;
                            }
                            case 0: {
                                AudioManager am;
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device disconnected");
                                AudioRoutingController.this.sendEvent(3, 0);
                                if (mockBlueToothEnable && (am = AudioRoutingController.this.getAudioManager()) != null) {
                                    am.setBluetoothScoOn(false);
                                    break;
                                }
                                break block30;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device unknown event, state=" + state);
                                break;
                            }
                        }
                        break block30;
                    }
                    if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + previousState + ", " + state);
                        switch (state) {
                            case 10: {
                                if (AudioRoutingController.this.getBtConnectedDevicesSize() != 0) break;
                                AudioRoutingController.this.sendEvent(2, 0);
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logging.e(AudioRoutingController.TAG, "BT broadcast receiver onReceive fail ", e);
                }
            }
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && intent.hasExtra("state")) {
                int plugged = intent.getIntExtra("state", -1);
                if (plugged == 1) {
                    int microphone = intent.getIntExtra("microphone", -1);
                    if (microphone == 1) {
                        Logging.i(AudioRoutingController.TAG, "Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                    } else {
                        Logging.i(AudioRoutingController.TAG, "Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                    }
                } else if (plugged == 0) {
                    Logging.i(AudioRoutingController.TAG, "Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                } else {
                    Logging.i(AudioRoutingController.TAG, "Headset unknown event detected, state=" + plugged);
                }
            }
        }
    }

    public static interface MockedBroadcaseter {
        public void registerReceiver(BroadcastReceiver var1, IntentFilter var2);

        public void unRegisterReceiver(BroadcastReceiver var1);
    }
}

