/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.HardwareVideoDecoderFactory;
import io.agora.base.internal.video.SoftwareVideoDecoderFactory;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderFactory;
import io.agora.base.internal.video.VideoDecoderFallback;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "DefaultVideoDecoderFactory";
    private final VideoDecoderFactory hardwareVideoDecoderFactory;
    private final VideoDecoderFactory softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();

    public DefaultVideoDecoderFactory(EglBase.Context eglContext) {
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(eglContext);
    }

    DefaultVideoDecoderFactory(VideoDecoderFactory hardwareVideoDecoderFactory) {
        this.hardwareVideoDecoderFactory = hardwareVideoDecoderFactory;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoDecoder softwareDecoder = this.softwareVideoDecoderFactory.createDecoder(codecType);
        VideoDecoder hardwareDecoder = this.hardwareVideoDecoderFactory.createDecoder(codecType);
        if (hardwareDecoder != null && softwareDecoder != null) {
            return new VideoDecoderFallback(softwareDecoder, hardwareDecoder);
        }
        Logging.d(TAG, "using decoder:" + (hardwareDecoder != null ? "hardware" : "software"));
        return hardwareDecoder != null ? hardwareDecoder : softwareDecoder;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType, boolean preferHWDecoder) {
        if (!preferHWDecoder) {
            return this.softwareVideoDecoderFactory.createDecoder(codecType);
        }
        return this.createDecoder(codecType);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> supportedCodecInfos = new LinkedHashSet<VideoCodecInfo>();
        supportedCodecInfos.addAll(Arrays.asList(this.softwareVideoDecoderFactory.getSupportedCodecs()));
        supportedCodecInfos.addAll(Arrays.asList(this.hardwareVideoDecoderFactory.getSupportedCodecs()));
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }
}

