/*
 * Decompiled with CFR 0.152.
 */
package io.agora.metachat.internal;

import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.metachat.EnterSceneConfig;
import io.agora.metachat.ILocalUserAvatar;
import io.agora.metachat.IMetachatScene;
import io.agora.metachat.IMetachatSceneEventHandler;
import io.agora.metachat.internal.LocalUserAvatarImpl;
import io.agora.rtc2.video.AgoraVideoFrame;

public class MetachatSceneImpl
extends IMetachatScene {
    private static final String TAG = MetachatSceneImpl.class.getSimpleName();
    private long mNativeHandle = 0L;
    private final ILocalUserAvatar mLocalUserAvatar;

    @CalledByNative
    MetachatSceneImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mLocalUserAvatar = new LocalUserAvatarImpl(this.nativeGetLocalUserAvatar(this.mNativeHandle));
    }

    @Override
    public ILocalUserAvatar getLocalUserAvatar() {
        return this.mLocalUserAvatar;
    }

    @Override
    public int release() {
        if (this.mNativeHandle != 0L) {
            MetachatSceneImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        return 0;
    }

    @Override
    public int addEventHandler(IMetachatSceneEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAddEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int removeEventHandler(IMetachatSceneEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int enterScene(EnterSceneConfig config) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnterScene(this.mNativeHandle, config);
    }

    @Override
    public int leaveScene() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeLeaveScene(this.mNativeHandle);
    }

    @Override
    public int sendMessageToScene(byte[] message) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSendMessageToScene(this.mNativeHandle, message);
    }

    @Override
    public int setSceneParameters(String jsonParam) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeSetSceneParameters(this.mNativeHandle, jsonParam);
    }

    @Override
    public int enableUserPositionNotification(boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableUserPositionNotification(this.mNativeHandle, enable);
    }

    @Override
    public int enumerateVideoDisplays() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnumerateVideoDisplays(this.mNativeHandle);
    }

    @Override
    public int enableVideoDisplay(String displayId, boolean enable) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeEnableVideoDisplay(this.mNativeHandle, displayId, enable);
    }

    @Override
    public int pushVideoFrameToDisplay(String displayId, VideoFrame frame) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePushVideoFrameToDisplay(this.mNativeHandle, displayId, frame);
    }

    @Override
    public int pushVideoFrameToDisplay(String displayId, AgoraVideoFrame frame) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativePushAgoraVideoFrameToDisplay(this.mNativeHandle, displayId, frame.format, frame.buf, frame.stride, frame.height, frame.timeStamp);
    }

    private native long nativeGetLocalUserAvatar(long var1);

    private static native int nativeDestroy(long var0);

    private native int nativeAddEventHandler(long var1, Object var3);

    private native int nativeRemoveEventHandler(long var1, Object var3);

    private native int nativeEnterScene(long var1, EnterSceneConfig var3);

    private native int nativeLeaveScene(long var1);

    private native int nativeSendMessageToScene(long var1, byte[] var3);

    private native int nativeSetSceneParameters(long var1, String var3);

    private native int nativeEnableUserPositionNotification(long var1, boolean var3);

    private native int nativeEnumerateVideoDisplays(long var1);

    private native int nativeEnableVideoDisplay(long var1, String var3, boolean var4);

    private native int nativePushVideoFrameToDisplay(long var1, String var3, VideoFrame var4);

    private native int nativePushAgoraVideoFrameToDisplay(long var1, String var3, int var4, byte[] var5, int var6, int var7, long var8);
}

