/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.content.Context;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import androidx.annotation.RequiresApi;
import io.agora.rtc2.internal.AudioRoutingController;
import io.agora.rtc2.internal.Logging;
import java.util.HashMap;

@RequiresApi(api=23)
public class AudioDeviceInventoryMorHigher
implements AudioRoutingController.AudioDeviceInventory {
    private static final String TAG = "AudioRoute";
    private AudioManager mAm;
    private AudioRoutingController.AudioDeviceChangedCallback mAudioDeviceChangedCb = null;
    private AudioDeviceCallbackImpl mDevCb;
    private static final HashMap<Integer, Integer> DEVICE_TYPE_TO_ROUTE = new HashMap();

    public AudioDeviceInventoryMorHigher(Context ctx) {
        this.mAm = (AudioManager)ctx.getSystemService("audio");
    }

    @Override
    public void initialize() {
        this.mDevCb = new AudioDeviceCallbackImpl();
        this.mAm.registerAudioDeviceCallback((AudioDeviceCallback)this.mDevCb, null);
    }

    @Override
    public void dispose() {
        this.mAm.unregisterAudioDeviceCallback((AudioDeviceCallback)this.mDevCb);
    }

    @Override
    public boolean isDeviceAvaliable(int route) {
        AudioDeviceInfo[] devices;
        for (AudioDeviceInfo device : devices = this.mAm.getDevices(2)) {
            int type = device.getType();
            if (!DEVICE_TYPE_TO_ROUTE.containsKey(type) || DEVICE_TYPE_TO_ROUTE.get(type) != route) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAudioDeviceChangeCallback(AudioRoutingController.AudioDeviceChangedCallback cb) {
        this.mAudioDeviceChangedCb = cb;
    }

    private void onAudioDeviceChanged(int route, boolean connect) {
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceChanged(connect, route);
        }
    }

    private void processDevicesChanged(AudioDeviceInfo[] devices, boolean connect) {
        for (AudioDeviceInfo device : devices) {
            boolean isSource = device.isSource();
            int type = device.getType();
            if (type == 8) {
                Logging.i(TAG, "not process a2dp out yet!");
                continue;
            }
            if (isSource || !DEVICE_TYPE_TO_ROUTE.containsKey(device.getType())) {
                Logging.d(TAG, "not process device type: " + type + " connect: " + connect);
                continue;
            }
            int route = DEVICE_TYPE_TO_ROUTE.get(type);
            this.onAudioDeviceChanged(route, connect);
            Logging.i(TAG, "process device connect,route: " + route + " connect: " + connect);
        }
    }

    static {
        DEVICE_TYPE_TO_ROUTE.put(1, 1);
        DEVICE_TYPE_TO_ROUTE.put(2, 3);
        DEVICE_TYPE_TO_ROUTE.put(3, 0);
        DEVICE_TYPE_TO_ROUTE.put(4, 2);
        DEVICE_TYPE_TO_ROUTE.put(7, 5);
        DEVICE_TYPE_TO_ROUTE.put(8, 5);
        DEVICE_TYPE_TO_ROUTE.put(11, 0);
        DEVICE_TYPE_TO_ROUTE.put(22, 0);
        DEVICE_TYPE_TO_ROUTE.put(9, 7);
    }

    private class AudioDeviceCallbackImpl
    extends AudioDeviceCallback {
        public AudioDeviceCallbackImpl() {
            Logging.i(AudioDeviceInventoryMorHigher.TAG, "AudioDeviceCallbackImpl ctor!");
        }

        public void onAudioDevicesAdded(AudioDeviceInfo[] devices) {
            AudioDeviceInventoryMorHigher.this.processDevicesChanged(devices, true);
        }

        public void onAudioDevicesRemoved(AudioDeviceInfo[] devices) {
            AudioDeviceInventoryMorHigher.this.processDevicesChanged(devices, false);
        }
    }
}

