/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.wifi.WifiManager;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.view.TextureView;
import io.agora.rtc.AgoraMediaRecorder;
import io.agora.rtc.IAudioEffectManager;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ILogWriter;
import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.IRtcChannelEventHandler;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.IRtcEngineEventHandlerEx;
import io.agora.rtc.IVideoEncodedFrameObserver;
import io.agora.rtc.IVideoFrameObserver;
import io.agora.rtc.RtcChannel;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.RtcEngineConfig;
import io.agora.rtc.RtcEngineEx;
import io.agora.rtc.ScreenCaptureParameters;
import io.agora.rtc.audio.AgoraRhythmPlayerConfig;
import io.agora.rtc.audio.AudioParams;
import io.agora.rtc.audio.AudioRecordingConfiguration;
import io.agora.rtc.audio.SpatialAudioParams;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.internal.CommonUtility;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.EncryptionConfig;
import io.agora.rtc.internal.ExternalScreenSharingCallback;
import io.agora.rtc.internal.LastmileProbeConfig;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.RtcChannelImpl;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.AgoraDefaultRender;
import io.agora.rtc.mediaio.AgoraDefaultSource;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.models.ChannelMediaOptions;
import io.agora.rtc.models.ClientRoleOptions;
import io.agora.rtc.models.ContentInspectConfig;
import io.agora.rtc.models.DataStreamConfig;
import io.agora.rtc.models.EchoTestConfiguration;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.proxy.LocalAccessPointConfiguration;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.AgoraVideoFrame;
import io.agora.rtc.video.BeautyOptions;
import io.agora.rtc.video.CameraCapturerConfiguration;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import io.agora.rtc.video.ColorEnhanceOptions;
import io.agora.rtc.video.LowLightEnhanceOptions;
import io.agora.rtc.video.ViETextureViewWrapper;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoDenoiserOptions;
import io.agora.rtc.video.VideoEncoderConfiguration;
import io.agora.rtc.video.VirtualBackgroundSource;
import io.agora.rtc.video.WatermarkOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RtcEngineImpl
extends RtcEngineEx
implements IAudioEffectManager {
    private static final String TAG = "RtcEngine";
    public static final int VIDEO_SOURCE_TYPE_NULL = 0;
    public static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    public static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private int mVideoSourceType = 1;
    private boolean mLocalVideoEnabled = false;
    private boolean mUseLocalView = false;
    private int mExAudioSourceSampleRate = 0;
    private int mExAudioSourceChannels = 0;
    private int mExAudioSinkChannels = -1;
    private int mExAudioSinkSampleRate = -1;
    private long lastOrientationTs = 0L;
    private int mTotalRotation = 1000;
    private long mNativeHandle = 0L;
    private static boolean sLibLoaded = false;
    private final ConcurrentHashMap<IRtcEngineEventHandler, Integer> mRtcHandlers = new ConcurrentHashMap();
    private RtcChannelImpl mDefaultRtcChannel = null;
    private final LinkedList<RtcChannelImpl> mRtcChannels = new LinkedList();
    private IRtcEngineEventHandler.RtcStats mRtcStats = null;
    IRtcEngineEventHandler.AgoraFacePositionInfo[] faceRectArr;
    private WifiManager.WifiLock mWifiLock = null;
    private int mChannelProfile = 1;
    private int mClientRole = 2;
    private WeakReference<Context> mContext;
    private IntentFilter filter = new IntentFilter();
    private BroadcastReceiver mUsbStateChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(string) || "android.hardware.usb.action.USB_ACCESSORY_ATTACHED".equals(string)) {
                Logging.i(RtcEngineImpl.TAG, "device attached");
                RtcEngineImpl.this.refresh_device_list();
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string) || "android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(string)) {
                Logging.i(RtcEngineImpl.TAG, "device detached");
                RtcEngineImpl.this.refresh_device_list();
            }
        }
    };
    static float[] sMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    private void checkVoipPermissions(Context context, String string) throws SecurityException {
        if (context == null || context.checkPermission(string, Process.myPid(), Process.myUid()) != 0) {
            throw new SecurityException(string + " is not granted");
        }
    }

    private static void loadLibrary(String string) {
        if (externalLibPath != null) {
            String string2 = String.format(externalLibPath + File.separator + "lib%s.so", string);
            System.load(string2);
        } else {
            System.loadLibrary(string);
        }
    }

    public static synchronized void loadNativeLibrary() {
        RtcEngineImpl.loadLibrary("agora-core");
        RtcEngineImpl.loadLibrary("agora-soundtouch");
        RtcEngineImpl.loadLibrary("agora-rtc-sdk");
        try {
            RtcEngineImpl.loadLibrary("agora_mpg123");
            Logging.i(TAG, "agora mpg123 module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_ai_denoise_extension");
            Logging.i(TAG, "AgoraAI Denoise module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_spatial_audio_extension");
            Logging.i(TAG, "agora_spatial_audio_extension module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_fdkaac");
            Logging.i(TAG, "AgoraFdkaac module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_full_audio_format_extension");
            Logging.i(TAG, "agora_full_audio_format_extension module loaded");
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "agora_full_audio_format_extension module load failed.");
        }
        try {
            RtcEngineImpl.loadLibrary("agora_jnd_extension");
            Logging.i(TAG, "libagora_jnd_extension module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_dav1d_extension");
            Logging.i(TAG, "AgoraDav1d module loaded.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            RtcEngineImpl.loadLibrary("agora_video_process_extension");
            Logging.i(TAG, "AgoraVideoProcess module loaded.");
        }
        catch (Throwable throwable) {
            Logging.e(TAG, "AgoraVideoProcess module load failed.");
        }
    }

    public static synchronized boolean initializeNativeLibs() {
        if (!sLibLoaded) {
            RtcEngineImpl.loadNativeLibrary();
            sLibLoaded = RtcEngineImpl.nativeClassInit() == 0;
        }
        return sLibLoaded;
    }

    public static boolean checkIfInUIThread(String string) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            Logging.i(TAG, string + " in UI Thread");
            return true;
        }
        Logging.i(TAG, string + " not in UI Thread");
        return false;
    }

    private void refresh_device_list() {
        RtcEngineImpl.nativeDeviceChanged(this.mNativeHandle);
    }

    private void initDeviceNotify(Context context) {
        this.filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        this.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        this.filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        this.filter.addAction("android.hardware.usb.action.USB_STATE");
        context.registerReceiver(this.mUsbStateChangeReceiver, this.filter);
    }

    private void unRegisterBroadcstReceiver(Context context) {
        context.unregisterReceiver(this.mUsbStateChangeReceiver);
    }

    public RtcEngineImpl(Context context, String string, IRtcEngineEventHandler iRtcEngineEventHandler) throws Exception {
        this.mContext = new WeakReference<Context>(context);
        this.addHandler(iRtcEngineEventHandler);
        this.mNativeHandle = this.nativeObjectInit(context, string, "", "", "", "", "", "");
        this.initDeviceNotify(context);
        this.setParameter("che.android_app_external_storage_path", CommonUtility.getAppPrivateStorageDir(context));
        if (externalLibPath != null) {
            this.setParameter("rtc.android_dynamic_loading", 1);
        }
    }

    public RtcEngineImpl(RtcEngineConfig rtcEngineConfig) throws Exception {
        this.mContext = new WeakReference<Context>(rtcEngineConfig.mContext);
        this.addHandler(rtcEngineConfig.mEventHandler);
        this.mNativeHandle = this.nativeObjectInitWithConfig(rtcEngineConfig);
        this.initDeviceNotify(rtcEngineConfig.mContext);
        this.setParameter("che.android_app_external_storage_path", CommonUtility.getAppPrivateStorageDir(rtcEngineConfig.mContext));
        if (externalLibPath != null) {
            this.setParameter("rtc.android_dynamic_loading", 1);
        }
    }

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroy() {
        Object object;
        try {
            object = (Context)this.mContext.get();
            if (object != null) {
                this.unRegisterBroadcstReceiver((Context)object);
            }
        }
        catch (Exception exception) {
            Logging.e(exception.getMessage());
        }
        this.setExternalVideoSource(false, false, true);
        this.doStopMonitorSystemEvent();
        object = this;
        synchronized (object) {
            if (this.mDefaultRtcChannel != null) {
                this.mDefaultRtcChannel.onEngineDestroy();
            }
            for (RtcChannelImpl rtcChannelImpl : this.mRtcChannels) {
                rtcChannelImpl.onEngineDestroy();
            }
        }
        this.stopScreenCapture();
        this.nativeDestroy(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    public void reinitialize(Context context, String string, IRtcEngineEventHandler iRtcEngineEventHandler) {
        this.addHandler(iRtcEngineEventHandler);
    }

    @Override
    public void addHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        this.mRtcHandlers.put(iRtcEngineEventHandler, 0);
    }

    @Override
    public void removeHandler(IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (this.mRtcHandlers.containsKey(iRtcEngineEventHandler)) {
            this.mRtcHandlers.remove(iRtcEngineEventHandler);
        }
    }

    private int setVideoRotateCapturedFrames(int n2, int n3) {
        return this.setParameterObject("che.video.local.rotate_video", RtcEngineImpl.formatString("{\"degree\":%d,\"rotation\":%d}", n2, n3));
    }

    @Override
    public int setupRemoteVideo(VideoCanvas videoCanvas) {
        RtcEngineImpl.checkIfInUIThread("setupRemoteVideo");
        if (videoCanvas != null) {
            Object object = videoCanvas.view;
            if (videoCanvas.view != null && videoCanvas.view.getClass().getName().equals(TextureView.class.getName())) {
                object = new ViETextureViewWrapper((TextureView)videoCanvas.view);
            }
            if (videoCanvas.channelId != null) {
                return this.nativeSetupVideoRemote(this.mNativeHandle, object, videoCanvas.renderMode, videoCanvas.channelId, videoCanvas.uid, videoCanvas.mirrorMode);
            }
            return this.nativeSetupVideoRemote(this.mNativeHandle, object, videoCanvas.renderMode, "", videoCanvas.uid, videoCanvas.mirrorMode);
        }
        return -1;
    }

    @Override
    public int sendCustomReportMessage(String string, String string2, String string3, String string4, int n2) {
        return this.nativeSendCustomReportMessage(this.mNativeHandle, string, string2, string3, string4, n2);
    }

    @Override
    public int setupLocalVideo(VideoCanvas videoCanvas) {
        RtcEngineImpl.checkIfInUIThread("setupLocalVideo");
        if (this.mVideoSourceType == 3) {
            return -1;
        }
        if (videoCanvas != null) {
            this.mUseLocalView = true;
            if (videoCanvas.view != null && videoCanvas.view.getClass().getName().equals(TextureView.class.getName())) {
                ViETextureViewWrapper viETextureViewWrapper = new ViETextureViewWrapper((TextureView)videoCanvas.view);
                this.nativeSetupVideoLocal(this.mNativeHandle, viETextureViewWrapper, videoCanvas.renderMode, videoCanvas.mirrorMode);
            } else {
                this.nativeSetupVideoLocal(this.mNativeHandle, videoCanvas.view, videoCanvas.renderMode, videoCanvas.mirrorMode);
            }
        } else {
            this.mUseLocalView = false;
            this.nativeSetupVideoLocal(this.mNativeHandle, null, 1, 0);
        }
        return 0;
    }

    @Override
    public int setLocalRenderMode(int n2) {
        return this.setRemoteRenderMode(0, n2);
    }

    @Override
    public int setLocalRenderMode(int n2, int n3) {
        return this.setRemoteRenderMode(0, n2, n3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3) {
        return this.nativeSetRemoteRenderMode(this.mNativeHandle, (int)((long)n2 & 0xFFFFFFFFL), n3);
    }

    @Override
    public int setRemoteRenderMode(int n2, int n3, int n4) {
        return this.nativeSetRemoteRenderModeWithMirrorMode(this.mNativeHandle, (int)((long)n2 & 0xFFFFFFFFL), n3, n4);
    }

    @Override
    public int setLocalVideoMirrorMode(int n2) {
        return this.nativeSetLocalVideoMirrorMode(this.mNativeHandle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetsCacheFile(Context context, String string) {
        try {
            String string2 = "wm_" + string.replace(File.separator, "_");
            File file = new File(context.getCacheDir(), string2);
            if (file.exists()) {
                file.delete();
            }
            try (InputStream inputStream = context.getAssets().open(string);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);){
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public int addVideoWatermark(AgoraImage agoraImage) {
        WatermarkOptions watermarkOptions = null;
        String string = null;
        if (agoraImage != null) {
            string = agoraImage.url;
            watermarkOptions = new WatermarkOptions();
            watermarkOptions.visibleInPreview = false;
            watermarkOptions.positionInPortraitMode = watermarkOptions.positionInLandscapeMode = new WatermarkOptions.Rectangle(agoraImage.x, agoraImage.y, agoraImage.width, agoraImage.height);
        }
        return this.addVideoWatermark(string, watermarkOptions);
    }

    @Override
    public int addVideoWatermark(String string, WatermarkOptions watermarkOptions) {
        if (string == null || TextUtils.isEmpty((CharSequence)string) || watermarkOptions == null) {
            return -2;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (watermarkOptions.positionInLandscapeMode != null) {
            n2 = watermarkOptions.positionInLandscapeMode.x;
            n3 = watermarkOptions.positionInLandscapeMode.y;
            n4 = watermarkOptions.positionInLandscapeMode.width;
            n5 = watermarkOptions.positionInLandscapeMode.height;
        }
        if (watermarkOptions.positionInPortraitMode != null) {
            n6 = watermarkOptions.positionInPortraitMode.x;
            n7 = watermarkOptions.positionInPortraitMode.y;
            n8 = watermarkOptions.positionInPortraitMode.width;
            n9 = watermarkOptions.positionInPortraitMode.height;
        }
        return this.nativeAddVideoWatermark(this.mNativeHandle, string, watermarkOptions.visibleInPreview, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public int clearVideoWatermarks() {
        return this.nativeClearVideoWatermarks(this.mNativeHandle);
    }

    @Override
    public int enableDualStreamMode(boolean bl) {
        return this.setParameters(String.format("{\"rtc.dual_stream_mode\":%b,\"che.video.enableLowBitRateStream\":%d}", bl, bl ? 1 : 0));
    }

    @Override
    @Deprecated
    public void monitorHeadsetEvent(boolean bl) {
        Logging.i(TAG, "enter monitorHeadsetEvent:" + bl);
    }

    @Override
    @Deprecated
    @TargetApi(value=11)
    public void monitorBluetoothHeadsetEvent(boolean bl) {
        Logging.i(TAG, "enter monitorBluetoothHeadsetEvent:" + bl);
    }

    @Override
    public boolean enableHighPerfWifiMode(boolean bl) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return false;
        }
        if (bl) {
            int n2 = context.checkPermission("android.permission.WAKE_LOCK", Process.myPid(), Process.myUid());
            if (n2 != 0) {
                this.mWifiLock = null;
                return false;
            }
            if (this.mWifiLock == null) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                this.mWifiLock = wifiManager.createWifiLock(3, "agora.voip.lock");
            }
        } else {
            this.mWifiLock = null;
        }
        return true;
    }

    public IRtcEngineEventHandler.RtcStats getRtcStats() {
        if (this.mRtcStats == null) {
            this.mRtcStats = new IRtcEngineEventHandler.RtcStats();
        }
        return this.mRtcStats;
    }

    public synchronized void updateRtcStats(RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats) {
        IRtcEngineEventHandler.RtcStats rtcStats = this.getRtcStats();
        if (rtcStats == null) {
            return;
        }
        rtcStats.totalDuration = pMediaResRtcStats.totalDuration;
        rtcStats.txBytes = pMediaResRtcStats.totalTxBytes;
        rtcStats.rxBytes = pMediaResRtcStats.totalRxBytes;
        rtcStats.txAudioBytes = pMediaResRtcStats.txAudioBytes;
        rtcStats.txVideoBytes = pMediaResRtcStats.txVideoBytes;
        rtcStats.rxAudioBytes = pMediaResRtcStats.rxAudioBytes;
        rtcStats.rxVideoBytes = pMediaResRtcStats.rxVideoBytes;
        rtcStats.txKBitRate = pMediaResRtcStats.txKBitRate;
        rtcStats.rxKBitRate = pMediaResRtcStats.rxKBitRate;
        rtcStats.txAudioKBitRate = pMediaResRtcStats.txAudioKBitRate;
        rtcStats.rxAudioKBitRate = pMediaResRtcStats.rxAudioKBitRate;
        rtcStats.txVideoKBitRate = pMediaResRtcStats.txVideoKBitRate;
        rtcStats.rxVideoKBitRate = pMediaResRtcStats.rxVideoKBitRate;
        rtcStats.lastmileDelay = pMediaResRtcStats.lastmileDelay;
        rtcStats.txPacketLossRate = pMediaResRtcStats.txPacketLossRate;
        rtcStats.rxPacketLossRate = pMediaResRtcStats.rxPacketLossRate;
        rtcStats.users = pMediaResRtcStats.users;
        rtcStats.cpuTotalUsage = (double)pMediaResRtcStats.cpuTotalUsage / 100.0;
        rtcStats.cpuAppUsage = (double)pMediaResRtcStats.cpuAppUsage / 100.0;
        rtcStats.gatewayRtt = pMediaResRtcStats.gatewayRtt;
        rtcStats.memoryAppUsageRatio = pMediaResRtcStats.memoryAppUsageRatio;
        rtcStats.memoryTotalUsageRatio = pMediaResRtcStats.memoryTotalUsageRatio;
        rtcStats.memoryAppUsageInKbytes = pMediaResRtcStats.memoryAppUsageInKbytes;
    }

    private void doMonitorSystemEvent(Context context) {
        if (context == null) {
            return;
        }
        int n2 = context.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid());
        if (n2 != 0) {
            return;
        }
        if (Connectivity.getNetworkType(context) != 2) {
            return;
        }
        int n3 = context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid());
        if (n3 != 0) {
            return;
        }
        if (this.mWifiLock != null) {
            this.mWifiLock.acquire();
            Logging.i(TAG, "hp connection mode detected");
        }
    }

    private int doCheckPermission(Context context) {
        try {
            this.checkVoipPermissions(context, "android.permission.INTERNET");
        }
        catch (SecurityException securityException) {
            Logging.e(TAG, "can't join channel because no permission");
            return -9;
        }
        return 0;
    }

    private void doJoinChannelCheck(Context context) {
        if (this.joinChannelFirstTimeOrAllChannelLeft()) {
            this.doMonitorSystemEvent(context);
            int n2 = this.doCheckPermission(context);
        }
    }

    private void doLeaveChannelCheck() {
        if (this.joinChannelFirstTimeOrAllChannelLeft()) {
            this.doStopMonitorSystemEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannel(String string, String string2, String string3, int n2) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doJoinChannelCheck(context);
        int n3 = this.nativeJoinChannel(this.mNativeHandle, null, string, string2, string3, n2, null);
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel == null) {
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n3 == 0) {
                this.mDefaultRtcChannel.initialize(this, this.nativeGetDefaultRtcChannel(this.mNativeHandle));
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannel(String string, String string2, String string3, int n2, ChannelMediaOptions channelMediaOptions) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        if (channelMediaOptions == null) {
            return -2;
        }
        this.doJoinChannelCheck(context);
        int n3 = this.nativeJoinChannel(this.mNativeHandle, null, string, string2, string3, n2, channelMediaOptions);
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel == null) {
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n3 == 0) {
                this.mDefaultRtcChannel.initialize(this, this.nativeGetDefaultRtcChannel(this.mNativeHandle));
            }
        }
        return n3;
    }

    @Override
    public int switchChannel(String string, String string2) {
        ChannelMediaOptions channelMediaOptions = new ChannelMediaOptions();
        channelMediaOptions.autoSubscribeAudio = true;
        channelMediaOptions.autoSubscribeVideo = true;
        return this.switchChannel(string, string2, channelMediaOptions);
    }

    @Override
    public int switchChannel(String string, String string2, ChannelMediaOptions channelMediaOptions) {
        if (channelMediaOptions == null) {
            return -2;
        }
        int n2 = this.nativeSwitchChannel(this.mNativeHandle, string, string2, channelMediaOptions);
        return n2;
    }

    private void doStopMonitorSystemEvent() {
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
            Logging.i(TAG, "hp connection mode ended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int leaveChannel() {
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel != null) {
                this.mDefaultRtcChannel = null;
            }
        }
        this.doLeaveChannelCheck();
        return this.nativeLeaveChannel(this.mNativeHandle);
    }

    @Override
    public int setAVSyncSource(String string, int n2) {
        return this.nativeSetAVSyncSource(this.mNativeHandle, string, n2);
    }

    @Override
    public int startEchoTest() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTest(this.mNativeHandle, null);
    }

    @Override
    public int startEchoTest(int n2) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTestWithInterval(this.mNativeHandle, null, n2);
    }

    @Override
    public int stopEchoTest() {
        return this.nativeStopEchoTest(this.mNativeHandle);
    }

    @Override
    public int startEchoTest(EchoTestConfiguration echoTestConfiguration) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        if (echoTestConfiguration.channelId == null || echoTestConfiguration.channelId.length() == 0) {
            return -2;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTestWithConfig(this.mNativeHandle, echoTestConfiguration);
    }

    @Override
    public int setCloudProxy(int n2) {
        return this.nativeSetCloudProxy(this.mNativeHandle, n2);
    }

    @Override
    public int enableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", true);
    }

    @Override
    public int disableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", false);
    }

    @Override
    public int startLastmileProbeTest(LastmileProbeConfig lastmileProbeConfig) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartLastmileProbeTest(this.mNativeHandle, null, lastmileProbeConfig.probeUplink, lastmileProbeConfig.probeDownlink, lastmileProbeConfig.expectedUplinkBitrate, lastmileProbeConfig.expectedDownlinkBitrate);
    }

    @Override
    public int stopLastmileProbeTest() {
        return this.nativeStopLastmileProbeTest(this.mNativeHandle);
    }

    @Override
    public int setLocalAccessPoint(LocalAccessPointConfiguration localAccessPointConfiguration) {
        if (localAccessPointConfiguration.ipList == null) {
            localAccessPointConfiguration.ipList = new ArrayList();
        }
        if (localAccessPointConfiguration.domainList == null) {
            localAccessPointConfiguration.domainList = new ArrayList();
        }
        if (localAccessPointConfiguration.verifyDomainName == null) {
            localAccessPointConfiguration.verifyDomainName = "";
        }
        if (localAccessPointConfiguration.advancedConfig == null) {
            localAccessPointConfiguration.advancedConfig = new LocalAccessPointConfiguration.AdvancedConfigInfo();
        }
        return this.nativeSetLocalAccessPoint(this.mNativeHandle, localAccessPointConfiguration.ipList, localAccessPointConfiguration.domainList, localAccessPointConfiguration.verifyDomainName, localAccessPointConfiguration.mode, localAccessPointConfiguration.advancedConfig);
    }

    @Override
    public int startScreenCapture(ScreenCaptureParameters screenCaptureParameters) {
        int n2 = 0;
        if (Build.VERSION.SDK_INT < 21) {
            Logging.e("current android version not support for screen capture!");
            return 2;
        }
        if (Build.VERSION.SDK_INT < 29 && screenCaptureParameters.captureAudio) {
            Logging.e("current android version not support for capture audio!, set enableSystemPlayoutAudio to false");
            screenCaptureParameters.captureAudio = false;
            n2 = 3;
            if (!screenCaptureParameters.captureVideo) {
                Logging.e("both enableScreenCapture and enableSystemPlayoutAudio are false, return!!!");
                return 3;
            }
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("io.agora.rtc.ss.ScreenSharingClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        if (clazz == null) {
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        Method method = null;
        try {
            method = clazz.getMethod("startScreenCapture", Context.class, RtcEngine.class, ScreenCaptureParameters.class, ExternalScreenSharingCallback.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            Logging.e("cannot find startScreenCapture method");
            return 4;
        }
        if (method == null) {
            Logging.e("cannot find startScreenCapture method");
            return 4;
        }
        if (screenCaptureParameters == null) {
            Logging.i("screen capture parameter is null ,start screen capture using default parameters");
            screenCaptureParameters = new ScreenCaptureParameters();
        }
        try {
            method.invoke(null, this.mContext.get(), this, screenCaptureParameters, new ExternalScreenSharingCallback(){

                @Override
                public void onExtenalScreenCaptureEvent(int n2, int n3) {
                    Iterator iterator = RtcEngineImpl.this.mRtcHandlers.keySet().iterator();
                    while (iterator.hasNext()) {
                        IRtcEngineEventHandler iRtcEngineEventHandler = (IRtcEngineEventHandler)iterator.next();
                        if (iRtcEngineEventHandler == null) {
                            iterator.remove();
                            continue;
                        }
                        if (n3 != 16) continue;
                        iRtcEngineEventHandler.onLocalVideoStateChanged(3, 16);
                    }
                }
            });
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            Logging.e("cannot start startScreenCapture method");
            return 4;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logging.e("cannot start startScreenCapture method");
            return 4;
        }
        return n2;
    }

    @Override
    public int stopScreenCapture() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("io.agora.rtc.ss.ScreenSharingClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        if (clazz == null) {
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        Method method = null;
        try {
            method = clazz.getMethod("stopScreenCapture", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logging.e("cannot find stopScreenCapture method");
            return 4;
        }
        if (method == null) {
            Logging.e("cannot find stopScreenCapture method");
            return 4;
        }
        try {
            method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logging.e("cannot start stopScreenCapture method");
            return 4;
        }
        catch (InvocationTargetException invocationTargetException) {
            Logging.e("cannot start stopScreenCapture method");
            return 4;
        }
        return 0;
    }

    @Override
    public int updateScreenCaptureParameters(boolean bl, boolean bl2, ScreenCaptureParameters.VideoCaptureParameters videoCaptureParameters) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("io.agora.rtc.ss.ScreenSharingClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        if (clazz == null) {
            Logging.e("Screen Sharing Module not found! ");
            return 157;
        }
        Method method = null;
        try {
            method = clazz.getMethod("updateScreenCaptureParameters", Boolean.TYPE, Boolean.TYPE, ScreenCaptureParameters.VideoCaptureParameters.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            Logging.e("cannot find stopScreenCapture method");
            return 4;
        }
        if (method == null) {
            Logging.e("cannot find stopScreenCapture method");
            return 4;
        }
        if (!bl2 && !bl) {
            Logging.e("Both enableAudio and enableVideo are false , do you mean stopScreenCapture?");
            return 2;
        }
        try {
            method.invoke(null, bl, bl2, videoCaptureParameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            Logging.e("cannot start stopScreenCapture method");
            return 4;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logging.e("cannot start stopScreenCapture method");
            return 4;
        }
        return 0;
    }

    @Override
    public int enableVideo() {
        this.mLocalVideoEnabled = true;
        return this.nativeEnableVideo(this.mNativeHandle);
    }

    @Override
    public int disableVideo() {
        this.mLocalVideoEnabled = false;
        return this.nativeDisableVideo(this.mNativeHandle);
    }

    @Override
    public int enableLocalVideo(boolean bl) {
        this.mLocalVideoEnabled = bl;
        return this.setParameters(String.format("{\"rtc.video.capture\":%b,\"che.video.local.capture\":%b,\"che.video.local.render\":%b,\"che.video.local.send\":%b}", bl, bl, bl, bl));
    }

    @Override
    public int startPreview() {
        if (this.mVideoSourceType == 3) {
            return -4;
        }
        return this.nativeStartPreview(this.mNativeHandle);
    }

    @Override
    public int stopPreview() {
        return this.setParameter("rtc.video.preview", false);
    }

    @Override
    public int enableAudio() {
        return this.nativeEnableAudio(this.mNativeHandle);
    }

    @Override
    public int enableLocalAudio(boolean bl) {
        return this.nativeEnableLocalAudio(this.mNativeHandle, bl);
    }

    @Override
    public int disableAudio() {
        return this.nativeDisableAudio(this.mNativeHandle);
    }

    @Override
    public int pauseAudio() {
        return this.setParameter("rtc.audio.paused", true);
    }

    @Override
    public int resumeAudio() {
        return this.setParameter("rtc.audio.paused", false);
    }

    @Override
    public int muteLocalAudioStream(boolean bl) {
        return this.nativeMuteLocalAudioStream(this.mNativeHandle, bl);
    }

    @Override
    public int muteLocalVideoStream(boolean bl) {
        return this.nativeMuteLocalVideoStream(this.mNativeHandle, bl);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean bl) {
        return this.setParameter("rtc.audio.mute_peers", bl);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean bl) {
        return this.setParameter("rtc.audio.set_default_mute_peers", bl);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean bl) {
        return this.nativeMuteAllRemoteVideoStreams(this.mNativeHandle, bl);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean bl) {
        return this.setParameter("rtc.video.set_default_mute_peers", bl);
    }

    @Override
    public int setBeautyEffectOptions(boolean bl, BeautyOptions beautyOptions) {
        if (Build.VERSION.SDK_INT < 21) {
            return -4;
        }
        if (beautyOptions == null) {
            if (bl) {
                return -2;
            }
            beautyOptions = new BeautyOptions();
        }
        return this.nativeSetBeautyEffectOptions(this.mNativeHandle, bl, beautyOptions.lighteningContrastLevel, beautyOptions.lighteningLevel, beautyOptions.smoothnessLevel, beautyOptions.rednessLevel, beautyOptions.sharpnessLevel);
    }

    @Override
    public int setLowlightEnhanceOptions(boolean bl, LowLightEnhanceOptions lowLightEnhanceOptions) {
        if (Build.VERSION.SDK_INT < 21) {
            return -4;
        }
        if (lowLightEnhanceOptions == null) {
            if (bl) {
                return -2;
            }
            lowLightEnhanceOptions = new LowLightEnhanceOptions();
        }
        return this.nativeSetLowlightEnhanceOptions(this.mNativeHandle, bl, lowLightEnhanceOptions.lowlightEnhanceMode, lowLightEnhanceOptions.lowlightEnhanceLevel);
    }

    @Override
    public int setVideoDenoiserOptions(boolean bl, VideoDenoiserOptions videoDenoiserOptions) {
        if (Build.VERSION.SDK_INT < 21) {
            return -4;
        }
        if (videoDenoiserOptions == null) {
            if (bl) {
                return -2;
            }
            videoDenoiserOptions = new VideoDenoiserOptions();
        }
        return this.nativeSetVideoDenoiserOptions(this.mNativeHandle, bl, videoDenoiserOptions.denoiserMode, videoDenoiserOptions.denoiserLevel);
    }

    @Override
    public int setColorEnhanceOptions(boolean bl, ColorEnhanceOptions colorEnhanceOptions) {
        if (Build.VERSION.SDK_INT < 21) {
            return -4;
        }
        if (colorEnhanceOptions == null) {
            if (bl) {
                return -2;
            }
            colorEnhanceOptions = new ColorEnhanceOptions();
        }
        return this.nativeSetColorEnhanceOptions(this.mNativeHandle, bl, colorEnhanceOptions.strengthLevel, colorEnhanceOptions.skinProtectLevel);
    }

    @Override
    public int enableVirtualBackground(boolean bl, VirtualBackgroundSource virtualBackgroundSource) {
        if (virtualBackgroundSource == null) {
            if (bl) {
                return -2;
            }
            virtualBackgroundSource = new VirtualBackgroundSource();
        }
        return this.nativeEnableVirtualBackground(this.mNativeHandle, bl, virtualBackgroundSource);
    }

    @Override
    public int muteRemoteAudioStream(int n2, boolean bl) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.mute_peer\":{\"uid\":%d,\"mute\":%b}}", (long)n2 & 0xFFFFFFFFL, bl));
    }

    @Override
    public int adjustUserPlaybackSignalVolume(int n2, int n3) {
        return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.playout.uid.volume\":{\"uid\":%d,\"volume\":%d}}", (long)n2 & 0xFFFFFFFFL, n3));
    }

    @Override
    public int muteRemoteVideoStream(int n2, boolean bl) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.mute_peer\":{\"uid\":%d,\"mute\":%b}}", (long)n2 & 0xFFFFFFFFL, bl));
    }

    @Override
    public int renewToken(String string) {
        if (string == null) {
            return -2;
        }
        return this.setParameter("rtc.renew_token", string);
    }

    @Override
    public int registerLocalUserAccount(String string, String string2) {
        if (string == null || string2 == null) {
            return -2;
        }
        return this.nativeRegisterLocalUserAccount(this.mNativeHandle, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannelWithUserAccount(String string, String string2, String string3) {
        int n2 = this.nativeJoinChannelWithUserAccount(this.mNativeHandle, string, string2, string3, null);
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel == null) {
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n2 == 0) {
                this.mDefaultRtcChannel.initialize(this, this.nativeGetDefaultRtcChannel(this.mNativeHandle));
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannelWithUserAccount(String string, String string2, String string3, ChannelMediaOptions channelMediaOptions) {
        if (channelMediaOptions == null) {
            return -2;
        }
        int n2 = this.nativeJoinChannelWithUserAccount(this.mNativeHandle, string, string2, string3, channelMediaOptions);
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel == null) {
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (n2 == 0) {
                this.mDefaultRtcChannel.initialize(this, this.nativeGetDefaultRtcChannel(this.mNativeHandle));
            }
        }
        return n2;
    }

    @Override
    public int getUserInfoByUserAccount(String string, UserInfo userInfo) {
        return this.nativeGetUserInfoByUserAccount(this.mNativeHandle, string, userInfo);
    }

    @Override
    public int getUserInfoByUid(int n2, UserInfo userInfo) {
        return this.nativeGetUserInfoByUid(this.mNativeHandle, n2, userInfo);
    }

    @Override
    public int setDefaultAudioRoutetoSpeakerphone(boolean bl) {
        Logging.i(String.format("API call to setDefaultAudioRoutetoSpeakerphone :%b", bl));
        return this.nativeSetDefaultAudioRoutetoSpeakerphone(this.mNativeHandle, bl);
    }

    @Override
    public int setEnableSpeakerphone(boolean bl) {
        Logging.i(String.format("API call to setEnableSpeakerphone to %b", bl));
        return this.nativeSetEnableSpeakerphone(this.mNativeHandle, bl);
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        return this.nativeIsSpeakerphoneEnabled(this.mNativeHandle);
    }

    @Override
    public int adjustRecordingSignalVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 400) {
            n2 = 400;
        }
        return this.setParameter("che.audio.record.signal.volume", n2);
    }

    @Override
    public int adjustPlaybackSignalVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 400) {
            n2 = 400;
        }
        if (n2 < 100) {
            this.setParameter("che.audio.farend.compression", 100);
            return this.setParameter("che.audio.playout.signal.volume", n2);
        }
        this.setParameter("che.audio.playout.signal.volume", 100);
        n2 = 100 + (n2 - 100) / 3 * 7;
        return this.setParameter("che.audio.farend.compression", n2);
    }

    @Override
    public int setRecordingAudioFrameParameters(int n2, int n3, int n4, int n5) {
        return this.setParameterObject("che.audio.set_capture_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", n2, n3, n4, n5));
    }

    @Override
    public int setPlaybackAudioFrameParameters(int n2, int n3, int n4, int n5) {
        return this.setParameterObject("che.audio.set_render_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", n2, n3, n4, n5));
    }

    @Override
    public int setMixedAudioFrameParameters(int n2, int n3) {
        return this.setParameterObject("che.audio.set_mixed_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"samplesPerCall\":%d}", n2, n3));
    }

    @Override
    public int setHighQualityAudioParameters(boolean bl, boolean bl2, boolean bl3) {
        return this.setParameterObject("che.audio.codec.hq", RtcEngineImpl.formatString("{\"fullband\":%b,\"stereo\":%b,\"fullBitrate\":%b}", bl, bl2, bl3));
    }

    @Override
    public int enableInEarMonitoring(boolean bl) {
        return this.setParameter("che.audio.headset.monitoring", bl);
    }

    @Override
    public int enableWebSdkInteroperability(boolean bl) {
        return this.setParameters(String.format("{\"rtc.video.web_h264_interop_enable\":%b,\"che.video.web_h264_interop_enable\":%b}", bl, bl));
    }

    @Override
    public int setVideoQualityParameters(boolean bl) {
        return this.setParameters(String.format("{\"rtc.video.prefer_frame_rate\":%b,\"che.video.prefer_frame_rate\":%b}", bl, bl));
    }

    @Override
    @Deprecated
    public void setPreferHeadset(boolean bl) {
    }

    @Override
    public int enableAudioVolumeIndication(int n2, int n3, boolean bl) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (bl) {
            return this.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", n2, n3, 1));
        }
        return this.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", n2, n3, 0));
    }

    @Override
    public int enableLocalVoicePitchCallback(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        return this.setParameterObject("che.audio.local_pitch_callback", RtcEngineImpl.formatString("{\"interval\":%d}", n2));
    }

    @Override
    @Deprecated
    public int enableAudioQualityIndication(boolean bl) {
        return this.setParameter("rtc.audio_quality_indication", bl);
    }

    @Override
    public int enableTransportQualityIndication(boolean bl) {
        return this.setParameter("rtc.transport_quality_indication", bl);
    }

    @Override
    public int playRecap() {
        return this.setParameter("che.audio.recap.start_play", true);
    }

    @Override
    public int enableRecap(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        return this.setParameter("che.audio.recap.interval", n2);
    }

    @Override
    public int setVideoProfile(int n2, boolean bl) {
        if (n2 < 0) {
            return -2;
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.profile\":[%d,%b]}", n2, bl));
    }

    @Override
    public int setVideoProfile(int n2, int n3, int n4, int n5) {
        return this.nativeSetVideoProfileEx(this.mNativeHandle, n2, n3, n4, n5);
    }

    @Override
    public int setVideoEncoderConfiguration(VideoEncoderConfiguration videoEncoderConfiguration) {
        return this.nativeSetVideoEncoderConfiguration(this.mNativeHandle, videoEncoderConfiguration.dimensions.width, videoEncoderConfiguration.dimensions.height, videoEncoderConfiguration.frameRate, videoEncoderConfiguration.minFrameRate, videoEncoderConfiguration.bitrate, videoEncoderConfiguration.minBitrate, videoEncoderConfiguration.orientationMode.getValue(), videoEncoderConfiguration.degradationPrefer.getValue(), videoEncoderConfiguration.mirrorMode);
    }

    @Override
    public int setAudioProfile(int n2, int n3) {
        return this.nativeSetAudioProfile(this.mNativeHandle, n2, n3);
    }

    @Override
    public int monitorAudioRouteChange(boolean bl) {
        Logging.i("API call monitorAudioRouteChange:" + bl);
        return 0;
    }

    @Override
    public int switchCamera() {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        return this.nativeSwitchCamera(this.mNativeHandle);
    }

    private int switchCamera(CameraCapturerConfiguration.CAMERA_DIRECTION cAMERA_DIRECTION) {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        return this.nativeSwitchCameraByDirection(this.mNativeHandle, cAMERA_DIRECTION.getValue());
    }

    @Override
    public boolean isCameraZoomSupported() {
        return this.nativeIsCameraZoomSupported(this.mNativeHandle);
    }

    @Override
    public boolean isCameraTorchSupported() {
        return this.nativeIsCameraTorchSupported(this.mNativeHandle);
    }

    @Override
    public boolean isCameraFocusSupported() {
        return this.nativeIsCameraFocusSupported(this.mNativeHandle);
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        return this.nativeIsCameraExposurePositionSupported(this.mNativeHandle);
    }

    @Override
    public boolean isCameraAutoFocusFaceModeSupported() {
        return this.nativeIsCameraAutoFocusFaceModeSupported(this.mNativeHandle);
    }

    @Override
    public int setCameraZoomFactor(float f2) {
        return this.nativeSetCameraZoomFactor(this.mNativeHandle, f2);
    }

    @Override
    public float getCameraMaxZoomFactor() {
        return this.nativeGetCameraMaxZoomFactor(this.mNativeHandle);
    }

    @Override
    public int setCameraFocusPositionInPreview(float f2, float f3) {
        return this.nativeSetCameraFocusPositionInPreview(this.mNativeHandle, f2, f3);
    }

    @Override
    public int setCameraCaptureRotation(int n2) {
        return this.nativeSetCameraCaptureRotation(this.mNativeHandle, n2);
    }

    @Override
    public int setCameraExposurePosition(float f2, float f3) {
        return this.nativeSetCameraExposurePosition(this.mNativeHandle, f2, f3);
    }

    @Override
    public int setCameraTorchOn(boolean bl) {
        return this.nativeSetCameraTorchOn(this.mNativeHandle, bl);
    }

    @Override
    public int setCameraAutoFocusFaceModeEnabled(boolean bl) {
        return this.nativeSetCameraAutoFocusFaceModeEnabled(this.mNativeHandle, bl);
    }

    @Override
    public int enableFaceDetection(boolean bl) {
        return this.setParameter("che.video.faceDistance", bl);
    }

    public int enableRemoteVideo(boolean bl, int n2) {
        return this.setParameterObject("che.video.peer.receive", RtcEngineImpl.formatString("{\"enable\":%b, \"uid\":%d}", bl, (long)n2 & 0xFFFFFFFFL));
    }

    public int stopRemoteVideo(int n2) {
        return this.setParameter("che.video.peer.stop_video", (long)n2 & 0xFFFFFFFFL);
    }

    private static String formatString(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public int stopAllRemoteVideo() {
        return this.setParameter("che.video.peer.stop_all_renders", true);
    }

    @Override
    public int startAudioRecording(String string, int n2) {
        return this.startAudioRecording(string, 32000, n2);
    }

    @Override
    public int selectAudioTrack(int n2) {
        if (n2 < 0) {
            return -2;
        }
        return this.setParameter("che.audio.select_audio_track", n2);
    }

    @Override
    public int getAudioTrackCount() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_audio_track_count", null);
    }

    @Override
    public int setAudioMixingDualMonoMode(int n2) {
        if (n2 < 0 || n2 > 3) {
            return -2;
        }
        return this.setParameter("che.audio.set_dual_mono_mode", n2);
    }

    @Override
    public int startAudioRecording(String string, int n2, int n3) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -2;
        }
        return this.setParameterObject("che.audio.start_recording", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"sampleRate\":%d, \"quality\":%d}", string, n2, n3));
    }

    @Override
    public int startAudioRecording(AudioRecordingConfiguration audioRecordingConfiguration) {
        return this.nativeStartAudioRecording(this.mNativeHandle, audioRecordingConfiguration.filePath, audioRecordingConfiguration.recordingQuality, audioRecordingConfiguration.recordingPosition, audioRecordingConfiguration.recordingSampleRate, audioRecordingConfiguration.recordingChannel);
    }

    @Override
    public int stopAudioRecording() {
        return this.nativeStopAudioRecording(this.mNativeHandle);
    }

    @Override
    public int setAudioMixingPlaybackSpeed(int n2) {
        double d2 = (double)n2 / 100.0;
        return this.setParameter("che.audio.set_audio_mixing_play_tempo", d2);
    }

    @Override
    public int startAudioMixing(String string, boolean bl, boolean bl2, int n2, int n3) {
        return this.setParameterObject("che.audio.start_file_as_playout", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"loopback\":%b, \"replace\":%b, \"cycle\":%d, \"startPos\": %d}", string, bl, bl2, n2, n3));
    }

    @Override
    @Deprecated
    public int startAudioMixing(String string, boolean bl, boolean bl2, int n2) {
        return this.startAudioMixing(string, bl, bl2, n2, 0);
    }

    @Override
    public int stopAudioMixing() {
        return this.setParameter("che.audio.stop_file_as_playout", true);
    }

    @Override
    public int pauseAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", true);
    }

    @Override
    public int resumeAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", false);
    }

    @Override
    public int adjustAudioMixingVolume(int n2) {
        int n3 = this.adjustAudioMixingPlayoutVolume(n2);
        if (n3 == 0) {
            this.adjustAudioMixingPublishVolume(n2);
        }
        return n3;
    }

    @Override
    public int adjustAudioMixingPlayoutVolume(int n2) {
        return this.setParameter("che.audio.set_file_as_playout_volume", n2);
    }

    @Override
    public int adjustAudioMixingPublishVolume(int n2) {
        return this.setParameter("che.audio.set_file_as_playout_publish_volume", n2);
    }

    @Override
    public int getAudioMixingPlayoutVolume() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_file_as_playout_volume", null);
    }

    @Override
    public int getAudioMixingPublishVolume() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_file_as_playout_publish_volume", null);
    }

    @Override
    @Deprecated
    public int getAudioMixingDuration() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_mixing_file_length_ms", null);
    }

    @Override
    public int getAudioMixingCurrentPosition() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_mixing_file_played_ms", null);
    }

    @Override
    public int setAudioMixingPosition(int n2) {
        return this.setParameter("che.audio.mixing.file.position", n2);
    }

    @Override
    public int setAudioMixingPitch(int n2) {
        if (n2 > 12 || n2 < -12) {
            return -2;
        }
        return this.setParameter("che.audio.set_playout_file_pitch_semitones", n2);
    }

    @Override
    public int getAudioFileInfo(String string) {
        return this.setParameterObject("che.audio.get_file_info", RtcEngineImpl.formatString("{\"url\":\"%s\"}", string));
    }

    @Override
    public int useExternalAudioDevice() {
        return this.setParameters("{\"che.audio.audioSampleRate\":32000, \"che.audio.external_device\":true}");
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver iAudioFrameObserver) {
        boolean bl;
        boolean bl2 = bl = iAudioFrameObserver != null;
        if (iAudioFrameObserver != null) {
            AudioParams audioParams = iAudioFrameObserver.getMixedAudioParams();
            if (audioParams != null) {
                this.setMixedAudioFrameParameters(audioParams.sampleRate, audioParams.samplesPerCall);
            }
            if ((audioParams = iAudioFrameObserver.getRecordAudioParams()) != null) {
                this.setRecordingAudioFrameParameters(audioParams.sampleRate, audioParams.channel, audioParams.mode, audioParams.samplesPerCall);
            }
            if ((audioParams = iAudioFrameObserver.getPlaybackAudioParams()) != null) {
                this.setPlaybackAudioFrameParameters(audioParams.sampleRate, audioParams.channel, audioParams.mode, audioParams.samplesPerCall);
            }
        }
        return this.nativeRegisterAudioFrameObserver(this.mNativeHandle, iAudioFrameObserver);
    }

    @Override
    public int registerVideoFrameObserver(IVideoFrameObserver iVideoFrameObserver) {
        return this.nativeRegisterVideoFrameObserver(this.mNativeHandle, iVideoFrameObserver);
    }

    @Override
    public int registerVideoEncodedFrameObserver(IVideoEncodedFrameObserver iVideoEncodedFrameObserver) {
        return this.nativeRegisterVideoEncodedFrameObserver(this.mNativeHandle, iVideoEncodedFrameObserver);
    }

    @Override
    public int setExternalAudioSink(boolean bl, int n2, int n3) {
        if (n3 != 1 && n3 != 2) {
            return -1;
        }
        if (n2 != 8000 && n2 != 16000 && n2 != 32000 && n2 != 44100 && n2 != 48000) {
            return -2;
        }
        this.mExAudioSinkChannels = n3;
        this.mExAudioSinkSampleRate = n2;
        if (bl) {
            return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b,\"che.audio.set_render_raw_audio_format\":{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d}}", bl, bl, n2, n3, 0));
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b}", bl, bl, bl));
    }

    @Override
    public int pullPlaybackAudioFrame(byte[] byArray, int n2) {
        if (this.mExAudioSinkChannels != 1 && this.mExAudioSinkChannels != 2) {
            return -1;
        }
        return this.nativePullAudioFrame(this.mNativeHandle, byArray, n2, this.mExAudioSinkChannels);
    }

    @Override
    public int setExternalAudioSource(boolean bl, int n2, int n3) {
        this.mExAudioSourceSampleRate = n2;
        this.mExAudioSourceChannels = n3;
        if (bl) {
            return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.set_external_source_format\":{\"sampleRate\":%d,\"channelCnt\":%d}}", bl, n2, n3));
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.external_capture\":%b}", bl, bl));
    }

    @Override
    @Deprecated
    public int pushExternalAudioFrame(byte[] byArray, long l2) {
        return this.nativePushExternalAudioFrameRawData(this.mNativeHandle, byArray, l2, this.mExAudioSourceSampleRate, this.mExAudioSourceChannels);
    }

    @Override
    public int pushExternalAudioFrame(byte[] byArray, long l2, int n2, int n3, int n4, int n5) {
        return this.nativePushExternalAudioFrameRawDataExt(this.mNativeHandle, byArray, l2, n2, n3, n4, n5);
    }

    @Override
    public int setExternalAudioSourceVolume(int n2, int n3) {
        return this.nativeSetExternalAudioSourceVolume(this.mNativeHandle, n2, n3);
    }

    @Override
    public int setLogFile(String string) {
        int n2 = this.setParameter("rtc.log_file", string);
        if (n2 == 0) {
            this.getParameters("[\"rtc.log_file\"]").equals(string);
        }
        return n2;
    }

    @Override
    public int setLogFilter(int n2) {
        return this.setParameter("rtc.log_filter", n2 & 0x80F);
    }

    @Override
    public int setLogFileSize(int n2) {
        return this.setParameter("rtc.log_size", n2);
    }

    @Override
    public String uploadLogFile() {
        return this.nativeUploadLogFile(this.mNativeHandle);
    }

    @Override
    public int setProfile(String string, boolean bl) {
        return this.nativeSetProfile(this.mNativeHandle, string, bl);
    }

    public String getProfile() {
        return this.nativeGetProfile(this.mNativeHandle);
    }

    @Override
    public int setAppType(int n2) {
        return this.nativeSetAppType(this.mNativeHandle, n2);
    }

    @Override
    public int setParameters(String string) {
        return this.nativeSetParameters(this.mNativeHandle, string);
    }

    @Override
    public String getParameters(String string) {
        return this.nativeGetParameters(this.mNativeHandle, string);
    }

    @Override
    public String getParameter(String string, String string2) {
        return this.nativeGetParameter(this.mNativeHandle, string, string2);
    }

    @Override
    public String makeQualityReportUrl(String string, int n2, int n3, int n4) {
        return this.nativeMakeQualityReportUrl(this.mNativeHandle, string, n2, n3, n4);
    }

    @Override
    public String getCallId() {
        return this.nativeGetCallId(this.mNativeHandle);
    }

    @Override
    public int rate(String string, int n2, String string2) {
        return this.nativeRate(this.mNativeHandle, string, n2, string2);
    }

    @Override
    public int complain(String string, String string2) {
        return this.nativeComplain(this.mNativeHandle, string, string2);
    }

    @Override
    public int setChannelProfile(int n2) {
        if (n2 == 0) {
            this.setClientRole(1);
        }
        return this.nativeSetChannelProfile(this.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2) {
        return this.nativeSetClientRole(this.mNativeHandle, n2);
    }

    @Override
    public int setClientRole(int n2, ClientRoleOptions clientRoleOptions) {
        return this.nativeSetClientRoleOptions(this.mNativeHandle, n2, clientRoleOptions);
    }

    @Override
    public int setCameraCapturerConfiguration(CameraCapturerConfiguration cameraCapturerConfiguration) {
        int n2 = this.setParameter("che.video.camera_capture_mode", cameraCapturerConfiguration.preference.getValue());
        if (cameraCapturerConfiguration.preference == CameraCapturerConfiguration.CAPTURER_OUTPUT_PREFERENCE.CAPTURER_OUTPUT_PREFERENCE_MANUAL && cameraCapturerConfiguration.dimensions != null) {
            this.setParameter("che.video.capture_width", cameraCapturerConfiguration.dimensions.width);
            this.setParameter("che.video.capture_height", cameraCapturerConfiguration.dimensions.height);
        }
        if (0 == n2) {
            return this.switchCamera(cameraCapturerConfiguration.cameraDirection);
        }
        return n2;
    }

    @Override
    public int setRemoteVideoStreamType(int n2, int n3) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.set_remote_video_stream\":{\"uid\":%d,\"stream\":%d},\"che.video.setstream\":{\"uid\":%d,\"stream\":%d}}", (long)n2 & 0xFFFFFFFFL, n3, (long)n2 & 0xFFFFFFFFL, n3));
    }

    @Override
    public int enableWirelessAccelerate(boolean bl) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.wifi_acc_enable\":%s}", bl ? "true" : "false"));
    }

    @Override
    public int setRemoteUserPriority(int n2, int n3) {
        return this.nativeSetRemoteUserPriority(this.mNativeHandle, n2, n3);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int n2) {
        return this.setParameter("rtc.video.set_remote_default_video_stream_type", n2);
    }

    @Override
    public int setLocalPublishFallbackOption(int n2) {
        return this.setParameter("rtc.local_publish_fallback_option", n2);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int n2) {
        return this.setParameter("rtc.remote_subscribe_fallback_option", n2);
    }

    @Override
    public int setEncryptionMode(String string) {
        return this.setParameter("rtc.encryption.mode", string);
    }

    @Override
    public int setEncryptionSecret(String string) {
        return this.nativeSetEncryptionSecret(this.mNativeHandle, string);
    }

    @Override
    public int enableEncryption(boolean bl, EncryptionConfig encryptionConfig) {
        return this.nativeEnableEncryption(this.mNativeHandle, bl, encryptionConfig.encryptionMode.getValue(), encryptionConfig.encryptionKey, encryptionConfig.encryptionKdfSalt);
    }

    private void onLogEvent(int n2, String string) {
    }

    protected void onEvent(int n2, byte[] byArray) {
        Iterator iterator = this.mRtcHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            IRtcEngineEventHandler iRtcEngineEventHandler = (IRtcEngineEventHandler)iterator.next();
            if (iRtcEngineEventHandler == null) {
                iterator.remove();
                continue;
            }
            this.handleEvent(n2, byArray, iRtcEngineEventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelEvent(String string, int n2, byte[] byArray) {
        if (string == null || string.length() <= 0) {
            return;
        }
        RtcChannelImpl rtcChannelImpl = null;
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            for (RtcChannelImpl rtcChannelImpl2 : this.mRtcChannels) {
                if (rtcChannelImpl2.channelId() == null || !rtcChannelImpl2.channelId().equals(string)) continue;
                rtcChannelImpl = rtcChannelImpl2;
                break;
            }
        }
        if (rtcChannelImpl == null || !rtcChannelImpl.isInitialized()) {
            return;
        }
        if (rtcChannelImpl.getEventHandler() == null) {
            return;
        }
        this.handleChannelEvent(n2, byArray, rtcChannelImpl.getEventHandler(), rtcChannelImpl);
    }

    protected void handleEvent(int n2, byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (iRtcEngineEventHandler == null) {
            return;
        }
        block0 : switch (n2) {
            case 100: {
                this.sendLogEvent(byArray);
                break;
            }
            case 101: {
                RtcEngineMessage.PError pError = new RtcEngineMessage.PError();
                pError.unmarshall(byArray);
                iRtcEngineEventHandler.onError(pError.err);
                break;
            }
            case 102: {
                RtcEngineMessage.PError pError = new RtcEngineMessage.PError();
                pError.unmarshall(byArray);
                iRtcEngineEventHandler.onWarning(pError.err);
                break;
            }
            case 1006: {
                iRtcEngineEventHandler.onMediaEngineStartCallSuccess();
                break;
            }
            case 10001: {
                RtcEngineMessage.MediaResSetupTime mediaResSetupTime = new RtcEngineMessage.MediaResSetupTime();
                mediaResSetupTime.unmarshall(byArray);
                break;
            }
            case 13001: {
                RtcEngineMessage.PMediaResJoinMedia pMediaResJoinMedia = new RtcEngineMessage.PMediaResJoinMedia();
                pMediaResJoinMedia.unmarshall(byArray);
                if (pMediaResJoinMedia.firstSuccess) {
                    iRtcEngineEventHandler.onJoinChannelSuccess(pMediaResJoinMedia.channel, pMediaResJoinMedia.uid, pMediaResJoinMedia.elapsed);
                    break;
                }
                iRtcEngineEventHandler.onRejoinChannelSuccess(pMediaResJoinMedia.channel, pMediaResJoinMedia.uid, pMediaResJoinMedia.elapsed);
                break;
            }
            case 1005: {
                iRtcEngineEventHandler.onCameraReady();
                break;
            }
            case 1108: {
                iRtcEngineEventHandler.onRequestToken();
                break;
            }
            case 1109: {
                RtcEngineMessage.PClientRoleChanged pClientRoleChanged = new RtcEngineMessage.PClientRoleChanged();
                pClientRoleChanged.unmarshall(byArray);
                iRtcEngineEventHandler.onClientRoleChanged(pClientRoleChanged.oldRole, pClientRoleChanged.newRole);
                break;
            }
            case 1119: {
                RtcEngineMessage.PRtmpStreamingState pRtmpStreamingState = new RtcEngineMessage.PRtmpStreamingState();
                pRtmpStreamingState.unmarshall(byArray);
                iRtcEngineEventHandler.onRtmpStreamingStateChanged(pRtmpStreamingState.url, pRtmpStreamingState.state, pRtmpStreamingState.error);
                break;
            }
            case 1110: {
                RtcEngineMessage.PStreamPublished pStreamPublished = new RtcEngineMessage.PStreamPublished();
                pStreamPublished.unmarshall(byArray);
                iRtcEngineEventHandler.onStreamPublished(pStreamPublished.url, pStreamPublished.error);
                break;
            }
            case 1111: {
                RtcEngineMessage.PStreamUnPublished pStreamUnPublished = new RtcEngineMessage.PStreamUnPublished();
                pStreamUnPublished.unmarshall(byArray);
                iRtcEngineEventHandler.onStreamUnpublished(pStreamUnPublished.url);
                break;
            }
            case 1112: {
                iRtcEngineEventHandler.onTranscodingUpdated();
                break;
            }
            case 1120: {
                RtcEngineMessage.PStreamEvent pStreamEvent = new RtcEngineMessage.PStreamEvent();
                pStreamEvent.unmarshall(byArray);
                iRtcEngineEventHandler.onRtmpStreamingEvent(pStreamEvent.url, pStreamEvent.error);
                break;
            }
            case 1116: {
                RtcEngineMessage.PStreamInjectedStatus pStreamInjectedStatus = new RtcEngineMessage.PStreamInjectedStatus();
                pStreamInjectedStatus.unmarshall(byArray);
                iRtcEngineEventHandler.onStreamInjectedStatus(pStreamInjectedStatus.url, pStreamInjectedStatus.uid, pStreamInjectedStatus.status);
                break;
            }
            case 1117: {
                RtcEngineMessage.PPrivilegeWillExpire pPrivilegeWillExpire = new RtcEngineMessage.PPrivilegeWillExpire();
                pPrivilegeWillExpire.unmarshall(byArray);
                iRtcEngineEventHandler.onTokenPrivilegeWillExpire(pPrivilegeWillExpire.token);
            }
            case 1002: {
                iRtcEngineEventHandler.onMediaEngineLoadSuccess();
                break;
            }
            case 1104: {
                RtcEngineMessage.PMediaEngineEvent pMediaEngineEvent = new RtcEngineMessage.PMediaEngineEvent();
                pMediaEngineEvent.unmarshall(byArray);
                switch (pMediaEngineEvent.code) {
                    case 10: {
                        iRtcEngineEventHandler.onAudioMixingFinished();
                        break block0;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        break block0;
                    }
                    case 14: {
                        iRtcEngineEventHandler.onMicrophoneEnabled(true);
                        break block0;
                    }
                    case 15: {
                        iRtcEngineEventHandler.onMicrophoneEnabled(false);
                        break block0;
                    }
                    case 720: 
                    case 721: 
                    case 722: 
                    case 726: {
                        iRtcEngineEventHandler.onAudioMixingStateChanged(710, pMediaEngineEvent.code);
                        break block0;
                    }
                    case 725: {
                        iRtcEngineEventHandler.onAudioMixingStateChanged(711, pMediaEngineEvent.code);
                        break block0;
                    }
                    case 723: 
                    case 724: {
                        iRtcEngineEventHandler.onAudioMixingStateChanged(713, pMediaEngineEvent.code);
                        break block0;
                    }
                    case 701: 
                    case 702: 
                    case 703: {
                        iRtcEngineEventHandler.onAudioMixingStateChanged(714, pMediaEngineEvent.code);
                        break block0;
                    }
                }
                Logging.d(TAG, "Unknown media engine event " + pMediaEngineEvent.code);
                break;
            }
            case 1007: {
                iRtcEngineEventHandler.onVideoStopped();
                break;
            }
            case 1101: {
                RtcEngineMessage.PMediaResTransportQuality pMediaResTransportQuality = new RtcEngineMessage.PMediaResTransportQuality();
                pMediaResTransportQuality.unmarshall(byArray);
                if (pMediaResTransportQuality.isAudio) {
                    ((IRtcEngineEventHandlerEx)iRtcEngineEventHandler).onAudioTransportQuality(pMediaResTransportQuality.peer_uid, pMediaResTransportQuality.bitrate, pMediaResTransportQuality.delay, pMediaResTransportQuality.lost);
                    break;
                }
                ((IRtcEngineEventHandlerEx)iRtcEngineEventHandler).onVideoTransportQuality(pMediaResTransportQuality.peer_uid, pMediaResTransportQuality.bitrate, pMediaResTransportQuality.delay, pMediaResTransportQuality.lost);
                break;
            }
            case 1102: {
                RtcEngineMessage.PMediaResAudioQuality pMediaResAudioQuality = new RtcEngineMessage.PMediaResAudioQuality();
                pMediaResAudioQuality.unmarshall(byArray);
                iRtcEngineEventHandler.onAudioQuality(pMediaResAudioQuality.peer_uid, pMediaResAudioQuality.quality, pMediaResAudioQuality.delay, pMediaResAudioQuality.lost);
                break;
            }
            case 1106: {
                this.onApiCallExecuted(byArray, iRtcEngineEventHandler);
                break;
            }
            case 13010: {
                RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats = new RtcEngineMessage.PMediaResRtcStats();
                pMediaResRtcStats.unmarshall(byArray);
                this.updateRtcStats(pMediaResRtcStats);
                iRtcEngineEventHandler.onRtcStats(this.getRtcStats());
                break;
            }
            case 13006: {
                Context context = (Context)this.mContext.get();
                if (context != null) {
                    this.getAudioManager(context).setMode(0);
                }
                RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats = new RtcEngineMessage.PMediaResRtcStats();
                pMediaResRtcStats.unmarshall(byArray);
                this.updateRtcStats(pMediaResRtcStats);
                iRtcEngineEventHandler.onLeaveChannel(this.getRtcStats());
                break;
            }
            case 13007: {
                RtcEngineMessage.PMediaResNetworkQuality pMediaResNetworkQuality = new RtcEngineMessage.PMediaResNetworkQuality();
                pMediaResNetworkQuality.unmarshall(byArray);
                iRtcEngineEventHandler.onNetworkQuality(pMediaResNetworkQuality.uid, pMediaResNetworkQuality.txQuality, pMediaResNetworkQuality.rxQuality);
                break;
            }
            case 13017: {
                RtcEngineMessage.PMediaResLastmileQuality pMediaResLastmileQuality = new RtcEngineMessage.PMediaResLastmileQuality();
                pMediaResLastmileQuality.unmarshall(byArray);
                iRtcEngineEventHandler.onLastmileQuality(pMediaResLastmileQuality.quality);
                break;
            }
            case 13021: {
                RtcEngineMessage.PMediaResWlAccMessage pMediaResWlAccMessage = new RtcEngineMessage.PMediaResWlAccMessage();
                pMediaResWlAccMessage.unmarshall(byArray);
                iRtcEngineEventHandler.onWlAccMessage(pMediaResWlAccMessage.reason, pMediaResWlAccMessage.action, pMediaResWlAccMessage.wlAccMsg);
                break;
            }
            case 13022: {
                RtcEngineMessage.PMediaResWlAccStats pMediaResWlAccStats = new RtcEngineMessage.PMediaResWlAccStats();
                pMediaResWlAccStats.unmarshall(byArray);
                IRtcEngineEventHandler.WlAccStats wlAccStats = new IRtcEngineEventHandler.WlAccStats();
                wlAccStats.e2eDelayPercent = pMediaResWlAccStats.e2eDelayPercentCur;
                wlAccStats.frozenRatioPercent = pMediaResWlAccStats.frozenRatioPercentCur;
                wlAccStats.lossRatePercent = pMediaResWlAccStats.lossRatePercentCur;
                IRtcEngineEventHandler.WlAccStats wlAccStats2 = new IRtcEngineEventHandler.WlAccStats();
                wlAccStats2.e2eDelayPercent = pMediaResWlAccStats.e2eDelayPercentAve;
                wlAccStats2.frozenRatioPercent = pMediaResWlAccStats.frozenRatioPercentAve;
                wlAccStats2.lossRatePercent = pMediaResWlAccStats.lossRatePercentAve;
                iRtcEngineEventHandler.onWlAccStats(wlAccStats, wlAccStats2);
                break;
            }
            case 13020: {
                RtcEngineMessage.PMediaResLastmileProbeResult pMediaResLastmileProbeResult = new RtcEngineMessage.PMediaResLastmileProbeResult();
                pMediaResLastmileProbeResult.unmarshall(byArray);
                IRtcEngineEventHandler.LastmileProbeResult lastmileProbeResult = new IRtcEngineEventHandler.LastmileProbeResult();
                lastmileProbeResult.state = pMediaResLastmileProbeResult.state;
                lastmileProbeResult.rtt = pMediaResLastmileProbeResult.rtt;
                lastmileProbeResult.uplinkReport.packetLossRate = pMediaResLastmileProbeResult.uplinkReport.packetLossRate;
                lastmileProbeResult.uplinkReport.jitter = pMediaResLastmileProbeResult.uplinkReport.jitter;
                lastmileProbeResult.uplinkReport.availableBandwidth = pMediaResLastmileProbeResult.uplinkReport.availableBandwidth;
                lastmileProbeResult.downlinkReport.packetLossRate = pMediaResLastmileProbeResult.downlinkReport.packetLossRate;
                lastmileProbeResult.downlinkReport.jitter = pMediaResLastmileProbeResult.downlinkReport.jitter;
                lastmileProbeResult.downlinkReport.availableBandwidth = pMediaResLastmileProbeResult.downlinkReport.availableBandwidth;
                iRtcEngineEventHandler.onLastmileProbeResult(lastmileProbeResult);
                break;
            }
            case 13013: {
                RtcEngineMessage.PMediaResUserJoinedEvent pMediaResUserJoinedEvent = new RtcEngineMessage.PMediaResUserJoinedEvent();
                pMediaResUserJoinedEvent.unmarshall(byArray);
                iRtcEngineEventHandler.onUserJoined(pMediaResUserJoinedEvent.uid, pMediaResUserJoinedEvent.elapsed);
                break;
            }
            case 13008: {
                RtcEngineMessage.PMediaResUserOfflineEvent pMediaResUserOfflineEvent = new RtcEngineMessage.PMediaResUserOfflineEvent();
                pMediaResUserOfflineEvent.unmarshall(byArray);
                iRtcEngineEventHandler.onUserOffline(pMediaResUserOfflineEvent.uid, pMediaResUserOfflineEvent.reason);
                break;
            }
            case 13014: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcEngineEventHandler.onUserMuteAudio(pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 13015: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcEngineEventHandler.onUserMuteVideo(pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 13016: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcEngineEventHandler.onUserEnableVideo(pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 13019: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcEngineEventHandler.onUserEnableLocalVideo(pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 14000: {
                ((IRtcEngineEventHandlerEx)iRtcEngineEventHandler).onRecap(byArray);
                break;
            }
            case 14019: {
                iRtcEngineEventHandler.onConnectionBanned();
                break;
            }
            case 14001: {
                this.onSpeakersReport(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14021: {
                this.onLocalVoicePitchInHz(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14016: {
                RtcEngineMessage.PActiveSpeaker pActiveSpeaker = new RtcEngineMessage.PActiveSpeaker();
                pActiveSpeaker.unmarshall(byArray);
                iRtcEngineEventHandler.onActiveSpeaker(pActiveSpeaker.uid);
                break;
            }
            case 14014: {
                this.onFirstLocalAudioFrame(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14044: {
                this.onFirstLocalAudioFramePublished(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14015: {
                this.onFirstRemoteAudioFrame(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14005: {
                this.onFirstLocalVideoFrame(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14006: {
                this.onFirstLocalVideoFramePublished(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14002: {
                this.onFirstRemoteVideoFrame(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14007: {
                this.onFirstRemoteVideoDecoded(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14020: {
                this.onCameraFocusAreaChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14029: {
                this.onCameraExposureAreaChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14043: {
                this.onFacePositionChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14013: {
                this.onVideoSizeChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14040: {
                this.onRemoteAudioStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14045: {
                this.onAudioPublishStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14046: {
                this.onVideoPublishStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14047: {
                this.onAudioSubscribeStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14048: {
                this.onVideoSubscribeStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14036: {
                this.onRemoteVideoStateChangedExt(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14049: {
                this.onUserSuperResolutionEnabled(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14051: {
                this.onVirtualBackgroundSourceEnabled(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14053: {
                this.onSnapshotTaken(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14052: {
                this.onRequestAudioFileInfo(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14054: {
                this.onContentInspectResult(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14003: {
                this.onLocalVideoStat(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14004: {
                this.onRemoteVideoStat(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14041: {
                this.onLocalAudioStat(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14030: {
                this.onRemoteAudioStat(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14008: {
                iRtcEngineEventHandler.onConnectionLost();
                break;
            }
            case 14010: {
                iRtcEngineEventHandler.onConnectionInterrupted();
                break;
            }
            case 14028: {
                RtcEngineMessage.PConnectionState pConnectionState = new RtcEngineMessage.PConnectionState();
                pConnectionState.unmarshall(byArray);
                iRtcEngineEventHandler.onConnectionStateChanged(pConnectionState.state, pConnectionState.reason);
                break;
            }
            case 14009: {
                this.onStreamMessage(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14012: {
                this.onStreamMessageError(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14022: {
                RtcEngineMessage.PLocalFallbackStatus pLocalFallbackStatus = new RtcEngineMessage.PLocalFallbackStatus();
                pLocalFallbackStatus.unmarshall(byArray);
                iRtcEngineEventHandler.onLocalPublishFallbackToAudioOnly(pLocalFallbackStatus.state);
                break;
            }
            case 14023: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcEngineEventHandler.onRemoteSubscribeFallbackToAudioOnly(pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 14011: {
                break;
            }
            case 13018: {
                RtcEngineMessage.PMediaResAudioEffectFinished pMediaResAudioEffectFinished = new RtcEngineMessage.PMediaResAudioEffectFinished();
                pMediaResAudioEffectFinished.unmarshall(byArray);
                iRtcEngineEventHandler.onAudioEffectFinished(pMediaResAudioEffectFinished.soundId);
                break;
            }
            case 14037: {
                this.onChannelMediaRelayStateChanged(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14038: {
                this.onChannelMediaRelayEvent(byArray, iRtcEngineEventHandler);
                break;
            }
            case 1118: {
                RtcEngineMessage.PMediaResLocalVideoStateChanged pMediaResLocalVideoStateChanged = new RtcEngineMessage.PMediaResLocalVideoStateChanged();
                pMediaResLocalVideoStateChanged.unmarshall(byArray);
                iRtcEngineEventHandler.onLocalVideoStateChanged(pMediaResLocalVideoStateChanged.localVideoState, pMediaResLocalVideoStateChanged.error);
                break;
            }
            case 14042: {
                RtcEngineMessage.PMediaResLocalAudioStateChanged pMediaResLocalAudioStateChanged = new RtcEngineMessage.PMediaResLocalAudioStateChanged();
                pMediaResLocalAudioStateChanged.unmarshall(byArray);
                iRtcEngineEventHandler.onLocalAudioStateChanged(pMediaResLocalAudioStateChanged.state, pMediaResLocalAudioStateChanged.error);
                break;
            }
            case 14033: {
                RtcEngineMessage.PMediaResFirstRemoteAudioDecoded pMediaResFirstRemoteAudioDecoded = new RtcEngineMessage.PMediaResFirstRemoteAudioDecoded();
                pMediaResFirstRemoteAudioDecoded.unmarshall(byArray);
                iRtcEngineEventHandler.onFirstRemoteAudioDecoded(pMediaResFirstRemoteAudioDecoded.uid, pMediaResFirstRemoteAudioDecoded.elapsed);
                break;
            }
            case 14032: {
                RtcEngineMessage.PAudioRoutingChanged pAudioRoutingChanged = new RtcEngineMessage.PAudioRoutingChanged();
                pAudioRoutingChanged.unmarshall(byArray);
                iRtcEngineEventHandler.onAudioRouteChanged(pAudioRoutingChanged.routing);
                break;
            }
            case 14024: {
                RtcEngineMessage.PUserTransportStat pUserTransportStat = new RtcEngineMessage.PUserTransportStat();
                pUserTransportStat.unmarshall(byArray);
                if (pUserTransportStat.isAudio) {
                    iRtcEngineEventHandler.onRemoteAudioTransportStats(pUserTransportStat.peer_uid, pUserTransportStat.delay, pUserTransportStat.lost, pUserTransportStat.rxKBitRate);
                    break;
                }
                iRtcEngineEventHandler.onRemoteVideoTransportStats(pUserTransportStat.peer_uid, pUserTransportStat.delay, pUserTransportStat.lost, pUserTransportStat.rxKBitRate);
                break;
            }
            case 14031: {
                RtcEngineMessage.PNetworkTypeChanged pNetworkTypeChanged = new RtcEngineMessage.PNetworkTypeChanged();
                pNetworkTypeChanged.unmarshall(byArray);
                iRtcEngineEventHandler.onNetworkTypeChanged(pNetworkTypeChanged.type);
                break;
            }
            case 14034: {
                RtcEngineMessage.PUserAccountInfo pUserAccountInfo = new RtcEngineMessage.PUserAccountInfo();
                pUserAccountInfo.unmarshall(byArray);
                iRtcEngineEventHandler.onLocalUserRegistered(pUserAccountInfo.uid, pUserAccountInfo.userAccount);
                break;
            }
            case 14035: {
                RtcEngineMessage.PUserAccountInfo pUserAccountInfo = new RtcEngineMessage.PUserAccountInfo();
                pUserAccountInfo.unmarshall(byArray);
                UserInfo userInfo = new UserInfo();
                userInfo.uid = pUserAccountInfo.uid;
                userInfo.userAccount = pUserAccountInfo.userAccount;
                iRtcEngineEventHandler.onUserInfoUpdated(pUserAccountInfo.uid, userInfo);
                break;
            }
            case 14055: {
                RtcEngineMessage.PProxyConnect pProxyConnect = new RtcEngineMessage.PProxyConnect();
                pProxyConnect.unmarshall(byArray);
                iRtcEngineEventHandler.onProxyConnected(pProxyConnect.channel, pProxyConnect.uid, pProxyConnect.proxyType, pProxyConnect.localProxyIp, pProxyConnect.elapsed);
                break;
            }
            case 14050: {
                this.onUploadLogResult(byArray, iRtcEngineEventHandler);
                break;
            }
            case 14057: {
                RtcEngineMessage.PClientRoleChangeFailed pClientRoleChangeFailed = new RtcEngineMessage.PClientRoleChangeFailed();
                pClientRoleChangeFailed.unmarshall(byArray);
                iRtcEngineEventHandler.onClientRoleChangeFailed(pClientRoleChangeFailed.reason, pClientRoleChangeFailed.currentRole);
                break;
            }
        }
    }

    protected void handleChannelEvent(int n2, byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        if (iRtcChannelEventHandler == null || rtcChannelImpl == null) {
            return;
        }
        switch (n2) {
            case 101: {
                RtcEngineMessage.PError pError = new RtcEngineMessage.PError();
                pError.unmarshall(byArray);
                iRtcChannelEventHandler.onChannelError(rtcChannelImpl, pError.err);
                break;
            }
            case 102: {
                RtcEngineMessage.PError pError = new RtcEngineMessage.PError();
                pError.unmarshall(byArray);
                iRtcChannelEventHandler.onChannelWarning(rtcChannelImpl, pError.err);
                break;
            }
            case 13001: {
                RtcEngineMessage.PMediaResJoinMedia pMediaResJoinMedia = new RtcEngineMessage.PMediaResJoinMedia();
                pMediaResJoinMedia.unmarshall(byArray);
                if (pMediaResJoinMedia.firstSuccess) {
                    iRtcChannelEventHandler.onJoinChannelSuccess(rtcChannelImpl, pMediaResJoinMedia.uid, pMediaResJoinMedia.elapsed);
                    break;
                }
                iRtcChannelEventHandler.onRejoinChannelSuccess(rtcChannelImpl, pMediaResJoinMedia.uid, pMediaResJoinMedia.elapsed);
                break;
            }
            case 1108: {
                iRtcChannelEventHandler.onRequestToken(rtcChannelImpl);
                break;
            }
            case 1109: {
                RtcEngineMessage.PClientRoleChanged pClientRoleChanged = new RtcEngineMessage.PClientRoleChanged();
                pClientRoleChanged.unmarshall(byArray);
                iRtcChannelEventHandler.onClientRoleChanged(rtcChannelImpl, pClientRoleChanged.oldRole, pClientRoleChanged.newRole);
                break;
            }
            case 1119: {
                RtcEngineMessage.PRtmpStreamingState pRtmpStreamingState = new RtcEngineMessage.PRtmpStreamingState();
                pRtmpStreamingState.unmarshall(byArray);
                iRtcChannelEventHandler.onRtmpStreamingStateChanged(rtcChannelImpl, pRtmpStreamingState.url, pRtmpStreamingState.state, pRtmpStreamingState.error);
                break;
            }
            case 1110: {
                break;
            }
            case 1111: {
                break;
            }
            case 1112: {
                iRtcChannelEventHandler.onTranscodingUpdated(rtcChannelImpl);
                break;
            }
            case 1120: {
                RtcEngineMessage.PStreamEvent pStreamEvent = new RtcEngineMessage.PStreamEvent();
                pStreamEvent.unmarshall(byArray);
                iRtcChannelEventHandler.onRtmpStreamingEvent(rtcChannelImpl, pStreamEvent.url, pStreamEvent.error);
                break;
            }
            case 1116: {
                RtcEngineMessage.PStreamInjectedStatus pStreamInjectedStatus = new RtcEngineMessage.PStreamInjectedStatus();
                pStreamInjectedStatus.unmarshall(byArray);
                iRtcChannelEventHandler.onStreamInjectedStatus(rtcChannelImpl, pStreamInjectedStatus.url, pStreamInjectedStatus.uid, pStreamInjectedStatus.status);
                break;
            }
            case 1117: {
                RtcEngineMessage.PPrivilegeWillExpire pPrivilegeWillExpire = new RtcEngineMessage.PPrivilegeWillExpire();
                pPrivilegeWillExpire.unmarshall(byArray);
                iRtcChannelEventHandler.onTokenPrivilegeWillExpire(rtcChannelImpl, pPrivilegeWillExpire.token);
                break;
            }
            case 13010: {
                RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats = new RtcEngineMessage.PMediaResRtcStats();
                pMediaResRtcStats.unmarshall(byArray);
                this.updateRtcStats(pMediaResRtcStats);
                iRtcChannelEventHandler.onRtcStats(rtcChannelImpl, this.getRtcStats());
                break;
            }
            case 13006: {
                Context context = (Context)this.mContext.get();
                if (context != null) {
                    this.getAudioManager(context).setMode(0);
                }
                RtcEngineMessage.PMediaResRtcStats pMediaResRtcStats = new RtcEngineMessage.PMediaResRtcStats();
                pMediaResRtcStats.unmarshall(byArray);
                this.updateRtcStats(pMediaResRtcStats);
                iRtcChannelEventHandler.onLeaveChannel(rtcChannelImpl, this.getRtcStats());
                break;
            }
            case 13007: {
                RtcEngineMessage.PMediaResNetworkQuality pMediaResNetworkQuality = new RtcEngineMessage.PMediaResNetworkQuality();
                pMediaResNetworkQuality.unmarshall(byArray);
                iRtcChannelEventHandler.onNetworkQuality(rtcChannelImpl, pMediaResNetworkQuality.uid, pMediaResNetworkQuality.txQuality, pMediaResNetworkQuality.rxQuality);
                break;
            }
            case 13013: {
                RtcEngineMessage.PMediaResUserJoinedEvent pMediaResUserJoinedEvent = new RtcEngineMessage.PMediaResUserJoinedEvent();
                pMediaResUserJoinedEvent.unmarshall(byArray);
                iRtcChannelEventHandler.onUserJoined(rtcChannelImpl, pMediaResUserJoinedEvent.uid, pMediaResUserJoinedEvent.elapsed);
                break;
            }
            case 13008: {
                RtcEngineMessage.PMediaResUserOfflineEvent pMediaResUserOfflineEvent = new RtcEngineMessage.PMediaResUserOfflineEvent();
                pMediaResUserOfflineEvent.unmarshall(byArray);
                iRtcChannelEventHandler.onUserOffline(rtcChannelImpl, pMediaResUserOfflineEvent.uid, pMediaResUserOfflineEvent.reason);
                break;
            }
            case 13014: {
                break;
            }
            case 14016: {
                RtcEngineMessage.PActiveSpeaker pActiveSpeaker = new RtcEngineMessage.PActiveSpeaker();
                pActiveSpeaker.unmarshall(byArray);
                iRtcChannelEventHandler.onActiveSpeaker(rtcChannelImpl, pActiveSpeaker.uid);
                break;
            }
            case 14015: {
                break;
            }
            case 14002: {
                this.onRtcChannelFirstRemoteVideoFrame(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14013: {
                this.onRtcChannelVideoSizeChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14040: {
                this.onRtcChannelRemoteAudioStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14045: {
                this.onRtcChannelAudioPublishStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14046: {
                this.onRtcChannelVideoPublishStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14047: {
                this.onRtcChannelAudioSubscribeStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14048: {
                this.onRtcChannelVideoSubscribeStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14036: {
                this.onRtcChannelRemoteVideoStateChangedExt(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14049: {
                this.onRtcChannelUserSuperResolutionEnabledExt(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14004: {
                this.onRtcChannelRemoteVideoStat(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14030: {
                this.onRtcChannelRemoteAudioStat(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14008: {
                iRtcChannelEventHandler.onConnectionLost(rtcChannelImpl);
                break;
            }
            case 14028: {
                RtcEngineMessage.PConnectionState pConnectionState = new RtcEngineMessage.PConnectionState();
                pConnectionState.unmarshall(byArray);
                iRtcChannelEventHandler.onConnectionStateChanged(rtcChannelImpl, pConnectionState.state, pConnectionState.reason);
                break;
            }
            case 14009: {
                this.onRtcChannelStreamMessage(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14012: {
                this.onRtcChannelStreamMessageError(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14022: {
                RtcEngineMessage.PLocalFallbackStatus pLocalFallbackStatus = new RtcEngineMessage.PLocalFallbackStatus();
                pLocalFallbackStatus.unmarshall(byArray);
                iRtcChannelEventHandler.onLocalPublishFallbackToAudioOnly(rtcChannelImpl, pLocalFallbackStatus.state);
                break;
            }
            case 14023: {
                RtcEngineMessage.PMediaResUserState pMediaResUserState = new RtcEngineMessage.PMediaResUserState();
                pMediaResUserState.unmarshall(byArray);
                iRtcChannelEventHandler.onRemoteSubscribeFallbackToAudioOnly(rtcChannelImpl, pMediaResUserState.uid, pMediaResUserState.state);
                break;
            }
            case 14037: {
                this.onRtcChannelChannelMediaRelayStateChanged(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14038: {
                this.onRtcChannelChannelMediaRelayEvent(byArray, iRtcChannelEventHandler, rtcChannelImpl);
                break;
            }
            case 14033: {
                break;
            }
            case 14055: {
                RtcEngineMessage.PProxyConnect pProxyConnect = new RtcEngineMessage.PProxyConnect();
                pProxyConnect.unmarshall(byArray);
                iRtcChannelEventHandler.onProxyConnected(rtcChannelImpl, pProxyConnect.uid, pProxyConnect.proxyType, pProxyConnect.localProxyIp, pProxyConnect.elapsed);
                break;
            }
            case 14057: {
                RtcEngineMessage.PClientRoleChangeFailed pClientRoleChangeFailed = new RtcEngineMessage.PClientRoleChangeFailed();
                pClientRoleChangeFailed.unmarshall(byArray);
                iRtcChannelEventHandler.onClientRoleChangeFailed(rtcChannelImpl, pClientRoleChangeFailed.reason, pClientRoleChangeFailed.currentRole);
                break;
            }
        }
    }

    private void onApiCallExecuted(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PApiCallExecuted pApiCallExecuted = new RtcEngineMessage.PApiCallExecuted();
        pApiCallExecuted.unmarshall(byArray);
        iRtcEngineEventHandler.onApiCallExecuted(pApiCallExecuted.error, pApiCallExecuted.api, pApiCallExecuted.result);
    }

    private void onFirstRemoteVideoDecoded(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteVideoDecoded pFirstRemoteVideoDecoded = new RtcEngineMessage.PFirstRemoteVideoDecoded();
        pFirstRemoteVideoDecoded.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstRemoteVideoDecoded(pFirstRemoteVideoDecoded.uid, pFirstRemoteVideoDecoded.width, pFirstRemoteVideoDecoded.height, pFirstRemoteVideoDecoded.elapsed);
    }

    private void onCameraFocusAreaChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCameraFocusAreaChanged pCameraFocusAreaChanged = new RtcEngineMessage.PCameraFocusAreaChanged();
        pCameraFocusAreaChanged.unmarshall(byArray);
        iRtcEngineEventHandler.onCameraFocusAreaChanged(new Rect(pCameraFocusAreaChanged.x, pCameraFocusAreaChanged.y, pCameraFocusAreaChanged.x + pCameraFocusAreaChanged.width, pCameraFocusAreaChanged.y + pCameraFocusAreaChanged.height));
    }

    private void onCameraExposureAreaChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCameraExposureAreaChanged pCameraExposureAreaChanged = new RtcEngineMessage.PCameraExposureAreaChanged();
        pCameraExposureAreaChanged.unmarshall(byArray);
        iRtcEngineEventHandler.onCameraExposureAreaChanged(new Rect(pCameraExposureAreaChanged.x, pCameraExposureAreaChanged.y, pCameraExposureAreaChanged.x + pCameraExposureAreaChanged.width, pCameraExposureAreaChanged.y + pCameraExposureAreaChanged.height));
    }

    private void onFacePositionChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (byArray == null) {
            return;
        }
        RtcEngineMessage.PFaceDetectValue pFaceDetectValue = new RtcEngineMessage.PFaceDetectValue();
        pFaceDetectValue.unmarshall(byArray);
        this.faceRectArr = null;
        if (pFaceDetectValue.rectArr != null && pFaceDetectValue.rectArr.length > 0) {
            this.faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[pFaceDetectValue.rectArr.length];
            for (int i2 = 0; i2 < pFaceDetectValue.rectArr.length; ++i2) {
                RtcEngineMessage.PFaceDetectValue.FaceRect faceRect = pFaceDetectValue.rectArr[i2];
                IRtcEngineEventHandler.AgoraFacePositionInfo agoraFacePositionInfo = new IRtcEngineEventHandler.AgoraFacePositionInfo();
                agoraFacePositionInfo.x = faceRect.x;
                agoraFacePositionInfo.y = faceRect.y;
                agoraFacePositionInfo.width = faceRect.width;
                agoraFacePositionInfo.height = faceRect.height;
                agoraFacePositionInfo.distance = pFaceDetectValue.disArr[i2];
                this.faceRectArr[i2] = agoraFacePositionInfo;
            }
        } else {
            this.faceRectArr = new IRtcEngineEventHandler.AgoraFacePositionInfo[0];
        }
        iRtcEngineEventHandler.onFacePositionChanged(pFaceDetectValue.imageWidth, pFaceDetectValue.imageHeight, this.faceRectArr);
    }

    private void onVideoSizeChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PVideoSizeChanged pVideoSizeChanged = new RtcEngineMessage.PVideoSizeChanged();
        pVideoSizeChanged.unmarshall(byArray);
        iRtcEngineEventHandler.onVideoSizeChanged(pVideoSizeChanged.uid, pVideoSizeChanged.width, pVideoSizeChanged.height, pVideoSizeChanged.rotation);
    }

    private void onRtcChannelFirstRemoteVideoFrame(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PFirstRemoteVideoFrame pFirstRemoteVideoFrame = new RtcEngineMessage.PFirstRemoteVideoFrame();
        pFirstRemoteVideoFrame.unmarshall(byArray);
        iRtcChannelEventHandler.onFirstRemoteVideoFrame(rtcChannelImpl, pFirstRemoteVideoFrame.uid, pFirstRemoteVideoFrame.width, pFirstRemoteVideoFrame.height, pFirstRemoteVideoFrame.elapsed);
    }

    private void onRtcChannelVideoSizeChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PVideoSizeChanged pVideoSizeChanged = new RtcEngineMessage.PVideoSizeChanged();
        pVideoSizeChanged.unmarshall(byArray);
        iRtcChannelEventHandler.onVideoSizeChanged(rtcChannelImpl, pVideoSizeChanged.uid, pVideoSizeChanged.width, pVideoSizeChanged.height, pVideoSizeChanged.rotation);
    }

    private void onRemoteAudioStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteAudioState pRemoteAudioState = new RtcEngineMessage.PRemoteAudioState();
        pRemoteAudioState.unmarshall(byArray);
        iRtcEngineEventHandler.onRemoteAudioStateChanged(pRemoteAudioState.uid, pRemoteAudioState.state, pRemoteAudioState.reason, pRemoteAudioState.elapsed);
    }

    private void onRtcChannelRemoteAudioStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteAudioState pRemoteAudioState = new RtcEngineMessage.PRemoteAudioState();
        pRemoteAudioState.unmarshall(byArray);
        iRtcChannelEventHandler.onRemoteAudioStateChanged(rtcChannelImpl, pRemoteAudioState.uid, pRemoteAudioState.state, pRemoteAudioState.reason, pRemoteAudioState.elapsed);
    }

    private void onRtcChannelAudioPublishStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PPublishAudioState pPublishAudioState = new RtcEngineMessage.PPublishAudioState();
        pPublishAudioState.unmarshall(byArray);
        iRtcChannelEventHandler.onAudioPublishStateChanged(rtcChannelImpl, pPublishAudioState.oldstate, pPublishAudioState.newstate, pPublishAudioState.elapsed);
    }

    private void onRtcChannelVideoPublishStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PPublishVideoState pPublishVideoState = new RtcEngineMessage.PPublishVideoState();
        pPublishVideoState.unmarshall(byArray);
        iRtcChannelEventHandler.onVideoPublishStateChanged(rtcChannelImpl, pPublishVideoState.oldstate, pPublishVideoState.newstate, pPublishVideoState.elapsed);
    }

    private void onRtcChannelAudioSubscribeStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PSubscribeAudioState pSubscribeAudioState = new RtcEngineMessage.PSubscribeAudioState();
        pSubscribeAudioState.unmarshall(byArray);
        iRtcChannelEventHandler.onAudioSubscribeStateChanged(rtcChannelImpl, pSubscribeAudioState.uid, pSubscribeAudioState.oldstate, pSubscribeAudioState.newstate, pSubscribeAudioState.elapsed);
    }

    private void onRtcChannelVideoSubscribeStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PSubscribeVideoState pSubscribeVideoState = new RtcEngineMessage.PSubscribeVideoState();
        pSubscribeVideoState.unmarshall(byArray);
        iRtcChannelEventHandler.onVideoSubscribeStateChanged(rtcChannelImpl, pSubscribeVideoState.uid, pSubscribeVideoState.oldstate, pSubscribeVideoState.newstate, pSubscribeVideoState.elapsed);
    }

    private void onAudioPublishStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PPublishAudioState pPublishAudioState = new RtcEngineMessage.PPublishAudioState();
        pPublishAudioState.unmarshall(byArray);
        iRtcEngineEventHandler.onAudioPublishStateChanged(pPublishAudioState.channel, pPublishAudioState.oldstate, pPublishAudioState.newstate, pPublishAudioState.elapsed);
    }

    private void onVideoPublishStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PPublishVideoState pPublishVideoState = new RtcEngineMessage.PPublishVideoState();
        pPublishVideoState.unmarshall(byArray);
        iRtcEngineEventHandler.onVideoPublishStateChanged(pPublishVideoState.channel, pPublishVideoState.oldstate, pPublishVideoState.newstate, pPublishVideoState.elapsed);
    }

    private void onAudioSubscribeStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PSubscribeAudioState pSubscribeAudioState = new RtcEngineMessage.PSubscribeAudioState();
        pSubscribeAudioState.unmarshall(byArray);
        iRtcEngineEventHandler.onAudioSubscribeStateChanged(pSubscribeAudioState.channel, pSubscribeAudioState.uid, pSubscribeAudioState.oldstate, pSubscribeAudioState.newstate, pSubscribeAudioState.elapsed);
    }

    private void onVideoSubscribeStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PSubscribeVideoState pSubscribeVideoState = new RtcEngineMessage.PSubscribeVideoState();
        pSubscribeVideoState.unmarshall(byArray);
        iRtcEngineEventHandler.onVideoSubscribeStateChanged(pSubscribeVideoState.channel, pSubscribeVideoState.uid, pSubscribeVideoState.oldstate, pSubscribeVideoState.newstate, pSubscribeVideoState.elapsed);
    }

    private void onUserSuperResolutionEnabled(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PUserSuperResolutionEnabled pUserSuperResolutionEnabled = new RtcEngineMessage.PUserSuperResolutionEnabled();
        pUserSuperResolutionEnabled.unmarshall(byArray);
        iRtcEngineEventHandler.onUserSuperResolutionEnabled(pUserSuperResolutionEnabled.uid, pUserSuperResolutionEnabled.enabled, pUserSuperResolutionEnabled.reason);
    }

    private void onVirtualBackgroundSourceEnabled(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PVirtualBackgroundSourceEnabled pVirtualBackgroundSourceEnabled = new RtcEngineMessage.PVirtualBackgroundSourceEnabled();
        pVirtualBackgroundSourceEnabled.unmarshall(byArray);
        iRtcEngineEventHandler.onVirtualBackgroundSourceEnabled(pVirtualBackgroundSourceEnabled.enabled, pVirtualBackgroundSourceEnabled.reason);
    }

    private void onContentInspectResult(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PContentInspectResult pContentInspectResult = new RtcEngineMessage.PContentInspectResult();
        pContentInspectResult.unmarshall(byArray);
        iRtcEngineEventHandler.onContentInspectResult(pContentInspectResult.result);
    }

    private void onSnapshotTaken(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PSnapshotTaken pSnapshotTaken = new RtcEngineMessage.PSnapshotTaken();
        pSnapshotTaken.unmarshall(byArray);
        iRtcEngineEventHandler.onSnapshotTaken(pSnapshotTaken.channel, pSnapshotTaken.uid, pSnapshotTaken.filepath, pSnapshotTaken.width, pSnapshotTaken.height, pSnapshotTaken.errCode);
    }

    private void onUploadLogResult(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PUploadLogResult pUploadLogResult = new RtcEngineMessage.PUploadLogResult();
        pUploadLogResult.unmarshall(byArray);
        iRtcEngineEventHandler.onUploadLogResult(pUploadLogResult.requestId, pUploadLogResult.success, pUploadLogResult.reason);
    }

    private void onRtcChannelUserSuperResolutionEnabledExt(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PUserSuperResolutionEnabled pUserSuperResolutionEnabled = new RtcEngineMessage.PUserSuperResolutionEnabled();
        pUserSuperResolutionEnabled.unmarshall(byArray);
        iRtcChannelEventHandler.onUserSuperResolutionEnabled(rtcChannelImpl, pUserSuperResolutionEnabled.uid, pUserSuperResolutionEnabled.enabled, pUserSuperResolutionEnabled.reason);
    }

    private void onRemoteVideoStateChangedExt(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteVideoStateExt pRemoteVideoStateExt = new RtcEngineMessage.PRemoteVideoStateExt();
        pRemoteVideoStateExt.unmarshall(byArray);
        iRtcEngineEventHandler.onRemoteVideoStateChanged(pRemoteVideoStateExt.uid, pRemoteVideoStateExt.state, pRemoteVideoStateExt.reason, pRemoteVideoStateExt.elapsed);
    }

    private void onRtcChannelRemoteVideoStateChangedExt(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteVideoStateExt pRemoteVideoStateExt = new RtcEngineMessage.PRemoteVideoStateExt();
        pRemoteVideoStateExt.unmarshall(byArray);
        iRtcChannelEventHandler.onRemoteVideoStateChanged(rtcChannelImpl, pRemoteVideoStateExt.uid, pRemoteVideoStateExt.state, pRemoteVideoStateExt.reason, pRemoteVideoStateExt.elapsed);
    }

    private void onStreamMessage(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PStreamMessage pStreamMessage = new RtcEngineMessage.PStreamMessage();
        pStreamMessage.unmarshall(byArray);
        iRtcEngineEventHandler.onStreamMessage(pStreamMessage.uid, pStreamMessage.streamId, pStreamMessage.payload);
    }

    private void onRtcChannelStreamMessage(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PStreamMessage pStreamMessage = new RtcEngineMessage.PStreamMessage();
        pStreamMessage.unmarshall(byArray);
        iRtcChannelEventHandler.onStreamMessage(rtcChannelImpl, pStreamMessage.uid, pStreamMessage.streamId, pStreamMessage.payload);
    }

    private void onStreamMessageError(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PStreamMessageError pStreamMessageError = new RtcEngineMessage.PStreamMessageError();
        pStreamMessageError.unmarshall(byArray);
        iRtcEngineEventHandler.onStreamMessageError(pStreamMessageError.uid, pStreamMessageError.streamId, pStreamMessageError.error, pStreamMessageError.missed, pStreamMessageError.cached);
    }

    private void onRtcChannelStreamMessageError(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PStreamMessageError pStreamMessageError = new RtcEngineMessage.PStreamMessageError();
        pStreamMessageError.unmarshall(byArray);
        iRtcChannelEventHandler.onStreamMessageError(rtcChannelImpl, pStreamMessageError.uid, pStreamMessageError.streamId, pStreamMessageError.error, pStreamMessageError.missed, pStreamMessageError.cached);
    }

    private void onFirstLocalVideoFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalVideoFrame pFirstLocalVideoFrame = new RtcEngineMessage.PFirstLocalVideoFrame();
        pFirstLocalVideoFrame.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalVideoFrame(pFirstLocalVideoFrame.width, pFirstLocalVideoFrame.height, pFirstLocalVideoFrame.elapsed);
    }

    private void onFirstLocalVideoFramePublished(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalVideoFramePublished pFirstLocalVideoFramePublished = new RtcEngineMessage.PFirstLocalVideoFramePublished();
        pFirstLocalVideoFramePublished.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalVideoFramePublished(pFirstLocalVideoFramePublished.elapsed);
    }

    private void onRemoteVideoStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteVideoStat pRemoteVideoStat = new RtcEngineMessage.PRemoteVideoStat();
        pRemoteVideoStat.unmarshall(byArray);
        if (pRemoteVideoStat.stats.uid == 0) {
            return;
        }
        iRtcEngineEventHandler.onRemoteVideoStats(pRemoteVideoStat.stats);
    }

    private void onRtcChannelRemoteVideoStat(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteVideoStat pRemoteVideoStat = new RtcEngineMessage.PRemoteVideoStat();
        pRemoteVideoStat.unmarshall(byArray);
        if (pRemoteVideoStat.stats.uid == 0) {
            return;
        }
        iRtcChannelEventHandler.onRemoteVideoStats(rtcChannelImpl, pRemoteVideoStat.stats);
    }

    private void onRemoteAudioStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PRemoteAudioStat pRemoteAudioStat = new RtcEngineMessage.PRemoteAudioStat();
        pRemoteAudioStat.unmarshall(byArray);
        if (pRemoteAudioStat.stats.uid == 0) {
            return;
        }
        iRtcEngineEventHandler.onRemoteAudioStats(pRemoteAudioStat.stats);
    }

    private void onRtcChannelRemoteAudioStat(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PRemoteAudioStat pRemoteAudioStat = new RtcEngineMessage.PRemoteAudioStat();
        pRemoteAudioStat.unmarshall(byArray);
        if (pRemoteAudioStat.stats.uid == 0) {
            return;
        }
        iRtcChannelEventHandler.onRemoteAudioStats(rtcChannelImpl, pRemoteAudioStat.stats);
    }

    private void onLocalAudioStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PLocalAudioStat pLocalAudioStat = new RtcEngineMessage.PLocalAudioStat();
        pLocalAudioStat.unmarshall(byArray);
        iRtcEngineEventHandler.onLocalAudioStats(pLocalAudioStat.stats);
    }

    private void onLocalVideoStat(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PLocalVideoStat pLocalVideoStat = new RtcEngineMessage.PLocalVideoStat();
        pLocalVideoStat.unmarshall(byArray);
        iRtcEngineEventHandler.onLocalVideoStats(pLocalVideoStat.stats);
    }

    private void onRequestAudioFileInfo(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PAudioFileInfo pAudioFileInfo = new RtcEngineMessage.PAudioFileInfo();
        pAudioFileInfo.unmarshall(byArray);
        IRtcEngineEventHandler.AudioFileInfo audioFileInfo = new IRtcEngineEventHandler.AudioFileInfo();
        audioFileInfo.filePath = pAudioFileInfo.filePath;
        audioFileInfo.durationMs = pAudioFileInfo.durationMs;
        iRtcEngineEventHandler.onRequestAudioFileInfo(audioFileInfo, pAudioFileInfo.error);
    }

    private void onFirstRemoteVideoFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteVideoFrame pFirstRemoteVideoFrame = new RtcEngineMessage.PFirstRemoteVideoFrame();
        pFirstRemoteVideoFrame.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstRemoteVideoFrame(pFirstRemoteVideoFrame.uid, pFirstRemoteVideoFrame.width, pFirstRemoteVideoFrame.height, pFirstRemoteVideoFrame.elapsed);
    }

    private void onFirstLocalAudioFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalAudioFrame pFirstLocalAudioFrame = new RtcEngineMessage.PFirstLocalAudioFrame();
        pFirstLocalAudioFrame.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalAudioFrame(pFirstLocalAudioFrame.elapsed);
    }

    private void onFirstLocalAudioFramePublished(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstLocalAudioFramePublished pFirstLocalAudioFramePublished = new RtcEngineMessage.PFirstLocalAudioFramePublished();
        pFirstLocalAudioFramePublished.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstLocalAudioFramePublished(pFirstLocalAudioFramePublished.elapsed);
    }

    private void onFirstRemoteAudioFrame(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PFirstRemoteAudioFrame pFirstRemoteAudioFrame = new RtcEngineMessage.PFirstRemoteAudioFrame();
        pFirstRemoteAudioFrame.unmarshall(byArray);
        iRtcEngineEventHandler.onFirstRemoteAudioFrame(pFirstRemoteAudioFrame.uid, pFirstRemoteAudioFrame.elapsed);
    }

    private void onChannelMediaRelayStateChanged(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCrossChannelState pCrossChannelState = new RtcEngineMessage.PCrossChannelState();
        pCrossChannelState.unmarshall(byArray);
        iRtcEngineEventHandler.onChannelMediaRelayStateChanged(pCrossChannelState.state, pCrossChannelState.code);
    }

    private void onRtcChannelChannelMediaRelayStateChanged(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PCrossChannelState pCrossChannelState = new RtcEngineMessage.PCrossChannelState();
        pCrossChannelState.unmarshall(byArray);
        iRtcChannelEventHandler.onChannelMediaRelayStateChanged(rtcChannelImpl, pCrossChannelState.state, pCrossChannelState.code);
    }

    private void onChannelMediaRelayEvent(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        RtcEngineMessage.PCrossChannelEvent pCrossChannelEvent = new RtcEngineMessage.PCrossChannelEvent();
        pCrossChannelEvent.unmarshall(byArray);
        iRtcEngineEventHandler.onChannelMediaRelayEvent(pCrossChannelEvent.code);
    }

    private void onRtcChannelChannelMediaRelayEvent(byte[] byArray, IRtcChannelEventHandler iRtcChannelEventHandler, RtcChannelImpl rtcChannelImpl) {
        RtcEngineMessage.PCrossChannelEvent pCrossChannelEvent = new RtcEngineMessage.PCrossChannelEvent();
        pCrossChannelEvent.unmarshall(byArray);
        iRtcChannelEventHandler.onChannelMediaRelayEvent(rtcChannelImpl, pCrossChannelEvent.code);
    }

    private void onSpeakersReport(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (byArray == null) {
            return;
        }
        RtcEngineMessage.PMediaResSpeakersReport pMediaResSpeakersReport = new RtcEngineMessage.PMediaResSpeakersReport();
        pMediaResSpeakersReport.unmarshall(byArray);
        if (pMediaResSpeakersReport.speakers != null && pMediaResSpeakersReport.speakers.length >= 0) {
            IRtcEngineEventHandler.AudioVolumeInfo[] audioVolumeInfoArray = new IRtcEngineEventHandler.AudioVolumeInfo[pMediaResSpeakersReport.speakers.length];
            for (int i2 = 0; i2 < pMediaResSpeakersReport.speakers.length; ++i2) {
                audioVolumeInfoArray[i2] = new IRtcEngineEventHandler.AudioVolumeInfo();
                audioVolumeInfoArray[i2].uid = pMediaResSpeakersReport.speakers[i2].uid;
                audioVolumeInfoArray[i2].volume = pMediaResSpeakersReport.speakers[i2].volume;
                audioVolumeInfoArray[i2].vad = pMediaResSpeakersReport.speakers[i2].vad;
                audioVolumeInfoArray[i2].channelId = pMediaResSpeakersReport.speakers[i2].channelId;
            }
            iRtcEngineEventHandler.onAudioVolumeIndication(audioVolumeInfoArray, pMediaResSpeakersReport.mixVolume);
        } else {
            iRtcEngineEventHandler.onAudioVolumeIndication(new IRtcEngineEventHandler.AudioVolumeInfo[0], 0);
        }
    }

    private void onLocalVoicePitchInHz(byte[] byArray, IRtcEngineEventHandler iRtcEngineEventHandler) {
        if (byArray == null) {
            return;
        }
        RtcEngineMessage.PLocalVoicePitch pLocalVoicePitch = new RtcEngineMessage.PLocalVoicePitch();
        pLocalVoicePitch.unmarshall(byArray);
        iRtcEngineEventHandler.onLocalVoicePitchInHz(pLocalVoicePitch.pitchInHz);
    }

    private void sendLogEvent(byte[] byArray) {
        try {
            String string = new String(byArray, "ISO-8859-1");
            this.onLogEvent(0, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager;
    }

    protected ActivityManager getActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        return activityManager;
    }

    private RtcEngineMessage.PVideoNetOptions getOptionsByVideoProfile(int n2) {
        try {
            byte[] byArray = RtcEngineImpl.nativeGetOptionsByVideoProfile(this.mNativeHandle, n2);
            if (byArray != null) {
                RtcEngineMessage.PVideoNetOptions pVideoNetOptions = new RtcEngineMessage.PVideoNetOptions();
                pVideoNetOptions.unmarshall(byArray);
                return pVideoNetOptions;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int createDataStream(boolean bl, boolean bl2) {
        return this.nativeCreateDataStream(this.mNativeHandle, bl, bl2);
    }

    @Override
    public int createDataStream(DataStreamConfig dataStreamConfig) {
        return this.nativeCreateDataStream2(this.mNativeHandle, dataStreamConfig.ordered, dataStreamConfig.syncWithAudio);
    }

    @Override
    public int sendStreamMessage(int n2, byte[] byArray) {
        return this.nativeSendStreamMessage(this.mNativeHandle, n2, byArray);
    }

    private int setRootContext(EglBase.Context context) {
        return this.nativeSetEglBaseRootContext(this.mNativeHandle, context);
    }

    @Override
    public int updateSharedContext(javax.microedition.khronos.egl.EGLContext eGLContext) {
        return this.nativeSetEGL10Context(this.mNativeHandle, eGLContext);
    }

    @Override
    public int updateSharedContext(EGLContext eGLContext) {
        return this.nativeSetEGL14Context(this.mNativeHandle, eGLContext);
    }

    @Override
    public int setTextureId(int n2, javax.microedition.khronos.egl.EGLContext eGLContext, int n3, int n4, long l2) {
        return this.nativeSetEGL10TextureId(this.mNativeHandle, n2, eGLContext, 10, n3, n4, l2, sMatrix);
    }

    @Override
    public int setTextureId(int n2, EGLContext eGLContext, int n3, int n4, long l2) {
        return this.nativeSetEGL14TextureId(this.mNativeHandle, n2, eGLContext, 11, n3, n4, l2, sMatrix);
    }

    public int setTextureIdWithMatrix(int n2, javax.microedition.khronos.egl.EGLContext eGLContext, int n3, int n4, int n5, long l2, float[] fArray) {
        if (fArray == null) {
            return this.nativeSetEGL10TextureId(this.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, sMatrix);
        }
        if (fArray.length < 16) {
            return -2;
        }
        return this.nativeSetEGL10TextureId(this.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, fArray);
    }

    public int setTextureIdWithMatrix(int n2, EGLContext eGLContext, int n3, int n4, int n5, long l2, float[] fArray) {
        if (fArray == null) {
            return this.nativeSetEGL14TextureId(this.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, sMatrix);
        }
        if (fArray.length < 16) {
            return -2;
        }
        return this.nativeSetEGL14TextureId(this.mNativeHandle, n2, eGLContext, n3, n4, n5, l2, fArray);
    }

    @Override
    public boolean isTextureEncodeSupported() {
        boolean bl = DeviceUtils.getRecommendedEncoderType() == 0;
        return bl;
    }

    @Override
    public void setExternalVideoSource(boolean bl, boolean bl2, boolean bl3) {
        this.mVideoSourceType = bl ? 3 : 1;
        if (bl2) {
            if (bl) {
                this.setParameter("che.video.enable_external_texture_input", true);
            } else {
                this.setParameter("che.video.enable_external_texture_input", false);
                Logging.w("setExternalVideoSource: on Android, texture mode cannot be disabled once enabled.");
            }
        }
        this.setExtVideoSource(this.mNativeHandle, bl ? 1 : 0, bl3 ? 1 : 0);
    }

    @Override
    public boolean pushExternalVideoFrame(AgoraVideoFrame agoraVideoFrame) {
        if (agoraVideoFrame == null || agoraVideoFrame.format == 12) {
            Logging.e("pushExternalVideoFrame failed!! invalid video frame.");
            return false;
        }
        if (this.mVideoSourceType != 3) {
            Logging.e("pushExternalVideoFrame failed!! Call setExternalVideoSource to enable enable external video source!!");
            return false;
        }
        if (agoraVideoFrame.format == 10 || agoraVideoFrame.format == 11) {
            if (agoraVideoFrame.textureID == 0) {
                Logging.e("pushExternalVideoFrame failed!! invalid texture ID.");
                return false;
            }
            if (agoraVideoFrame.eglContext14 != null) {
                if (this.updateSharedContext(agoraVideoFrame.eglContext14) == 0) {
                    return this.setTextureIdWithMatrix(agoraVideoFrame.textureID, agoraVideoFrame.eglContext14, agoraVideoFrame.format, agoraVideoFrame.stride, agoraVideoFrame.height, agoraVideoFrame.timeStamp, agoraVideoFrame.transform) == 0;
                }
            } else if (agoraVideoFrame.eglContext11 != null && this.updateSharedContext(agoraVideoFrame.eglContext11) == 0) {
                return this.setTextureIdWithMatrix(agoraVideoFrame.textureID, agoraVideoFrame.eglContext11, agoraVideoFrame.format, agoraVideoFrame.stride, agoraVideoFrame.height, agoraVideoFrame.timeStamp, agoraVideoFrame.transform) == 0;
            }
        } else if (agoraVideoFrame.format > 0 && agoraVideoFrame.format <= 8 || agoraVideoFrame.format == 16) {
            return this.deliverFrame(this.mNativeHandle, agoraVideoFrame.buf, agoraVideoFrame.stride, agoraVideoFrame.height, agoraVideoFrame.cropLeft, agoraVideoFrame.cropTop, agoraVideoFrame.cropRight, agoraVideoFrame.cropBottom, agoraVideoFrame.rotation, agoraVideoFrame.timeStamp, agoraVideoFrame.format) == 0;
        }
        return false;
    }

    @Override
    public int addPublishStreamUrl(String string, boolean bl) {
        return this.nativeAddPublishStreamUrl(this.mNativeHandle, string, bl);
    }

    @Override
    public int removePublishStreamUrl(String string) {
        return this.nativeRemovePublishStreamUrl(this.mNativeHandle, string);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding liveTranscoding) {
        if (liveTranscoding == null) {
            return -2;
        }
        RtcEngineMessage.PLiveTranscoding pLiveTranscoding = new RtcEngineMessage.PLiveTranscoding();
        byte[] byArray = pLiveTranscoding.marshall(liveTranscoding);
        return this.nativeSetLiveTranscoding(this.mNativeHandle, byArray);
    }

    @Override
    public int startRtmpStreamWithoutTranscoding(String string) {
        return this.nativeStartRtmpStreamWithoutTranscoding(this.mNativeHandle, string);
    }

    @Override
    public int startRtmpStreamWithTranscoding(String string, LiveTranscoding liveTranscoding) {
        if (liveTranscoding == null) {
            return -2;
        }
        RtcEngineMessage.PLiveTranscoding pLiveTranscoding = new RtcEngineMessage.PLiveTranscoding();
        byte[] byArray = pLiveTranscoding.marshall(liveTranscoding);
        return this.nativeStartRtmpStreamWithTranscoding(this.mNativeHandle, string, byArray);
    }

    @Override
    public int updateRtmpTranscoding(LiveTranscoding liveTranscoding) {
        if (liveTranscoding == null) {
            return -2;
        }
        RtcEngineMessage.PLiveTranscoding pLiveTranscoding = new RtcEngineMessage.PLiveTranscoding();
        byte[] byArray = pLiveTranscoding.marshall(liveTranscoding);
        return this.nativeUpdateRtmpTranscoding(this.mNativeHandle, byArray);
    }

    @Override
    public int stopRtmpStream(String string) {
        return this.nativeStopRtmpStream(this.mNativeHandle, string);
    }

    @Override
    public int addInjectStreamUrl(String string, LiveInjectStreamConfig liveInjectStreamConfig) {
        if (string == null || liveInjectStreamConfig == null) {
            return -2;
        }
        RtcEngineMessage.PInjectStreamConfig pInjectStreamConfig = new RtcEngineMessage.PInjectStreamConfig();
        byte[] byArray = pInjectStreamConfig.marshall(liveInjectStreamConfig);
        return this.nativeAddInjectStreamUrl(this.mNativeHandle, string, byArray);
    }

    @Override
    public int removeInjectStreamUrl(String string) {
        if (string == null) {
            return -2;
        }
        return this.nativeRemoveInjectStreamUrl(this.mNativeHandle, string);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> object2 : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (object2.getValue().channelName != null && object2.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pChannelMediaRelayConfiguration = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] byArray = pChannelMediaRelayConfiguration.marshall(channelMediaRelayConfiguration);
        return this.nativeStartChannelMediaRelay(this.mNativeHandle, byArray);
    }

    @Override
    public int stopChannelMediaRelay() {
        return this.nativeStopChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> object2 : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (object2.getValue().channelName != null && object2.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pChannelMediaRelayConfiguration = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] byArray = pChannelMediaRelayConfiguration.marshall(channelMediaRelayConfiguration);
        return this.nativeUpdateChannelMediaRelay(this.mNativeHandle, byArray);
    }

    @Override
    public int pauseAllChannelMediaRelay() {
        return this.nativePauseAllChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int resumeAllChannelMediaRelay() {
        return this.nativeResumeAllChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int startDumpVideoReceiveTrack(int n2, String string) {
        return this.nativeStartDumpVideoReceiveTrack(this.mNativeHandle, n2, string);
    }

    @Override
    public int stopDumpVideoReceiveTrack() {
        return this.nativeStopDumpVideoReceiveTrack(this.mNativeHandle);
    }

    @Override
    public long getNativeHandle() {
        return this.nativeGetHandle(this.mNativeHandle);
    }

    private static String inetAddressToIpAddress(InetAddress inetAddress) {
        if (!inetAddress.isLoopbackAddress()) {
            if (inetAddress instanceof Inet4Address) {
                Inet4Address inet4Address = (Inet4Address)inetAddress;
                return inet4Address.getHostAddress();
            }
            if (inetAddress instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    protected static String getLocalHost() {
        try {
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : arrayList) {
                if (networkInterface.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> arrayList2 = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : arrayList2) {
                    String string = RtcEngineImpl.inetAddressToIpAddress(inetAddress);
                    if (string == null || string.isEmpty()) continue;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int setVideoSource(IVideoSource iVideoSource) {
        this.mVideoSourceType = iVideoSource == null ? 0 : (iVideoSource instanceof AgoraDefaultSource ? 1 : 2);
        return this.nativeAddVideoCapturer(this.mNativeHandle, iVideoSource, this.mVideoSourceType);
    }

    @Override
    public int setLocalVideoRenderer(IVideoSink iVideoSink) {
        int n2 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        return this.nativeAddLocalVideoRender(this.mNativeHandle, iVideoSink, n2);
    }

    @Override
    public int setRemoteVideoRenderer(int n2, IVideoSink iVideoSink) {
        int n3 = iVideoSink == null ? 0 : (iVideoSink instanceof AgoraDefaultRender ? 1 : 2);
        return this.nativeAddRemoteVideoRender(this.mNativeHandle, n2, iVideoSink, n3);
    }

    public int removeRemoteVideoTrack(int n2) {
        return this.nativeRemoveVideoReceiveTrack(this.mNativeHandle, n2);
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        return this;
    }

    @Override
    public int enableDeepLearningDenoise(boolean bl) {
        return this.nativeEnableDeepLearningDenoise(this.mNativeHandle, bl);
    }

    @Override
    public int enableSoundPositionIndication(boolean bl) {
        return this.nativeEnableSoundPositionIndication(this.mNativeHandle, bl);
    }

    @Override
    public int setRemoteVoicePosition(int n2, double d2, double d3) {
        return this.setParameterObject("che.audio.game_place_sound_position", RtcEngineImpl.formatString("{\"uid\":%d,\"pan\":%f,\"gain\":%f}", (long)n2 & 0xFFFFFFFFL, d2, d3));
    }

    @Override
    public int enableSpatialAudio(boolean bl) {
        return this.nativeEnableSpatialAudio(this.mNativeHandle, bl);
    }

    @Override
    public synchronized int setRemoteUserSpatialAudioParams(int n2, SpatialAudioParams spatialAudioParams) {
        return this.nativeSetRemoteUserSpatialAudioParams(this.mNativeHandle, n2, spatialAudioParams);
    }

    @Override
    public int setLocalVoicePitch(double d2) {
        return this.setParameter("che.audio.morph.pitch_shift", (int)(d2 * 100.0));
    }

    @Override
    public int setLocalVoiceEqualization(int n2, int n3) {
        return this.setParameterObject("che.audio.morph.equalization", RtcEngineImpl.formatString("{\"index\":%d,\"gain\":%d}", n2, n3));
    }

    @Override
    public int setLocalVoiceReverb(int n2, int n3) {
        return this.setParameterObject("che.audio.morph.reverb", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", n2, n3));
    }

    @Override
    @Deprecated
    public int setLocalVoiceChanger(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", n2);
        }
        if (n2 > 0 && n2 < 0x100000) {
            return this.setParameter("che.audio.morph.voice_changer", n2);
        }
        if (n2 > 0x100000 && n2 < 0x200000) {
            return this.setParameter("che.audio.morph.voice_changer", n2 - 0x100000 + 6);
        }
        if (n2 > 0x200000 && n2 < 0x300000) {
            return this.setParameter("che.audio.morph.beauty_voice", n2 - 0x200000);
        }
        return -2;
    }

    @Override
    @Deprecated
    public int setLocalVoiceReverbPreset(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.reverb_preset", n2);
        }
        if (n2 > 0 && n2 < 0x100000) {
            return this.setParameter("che.audio.morph.reverb_preset", n2 + 8);
        }
        if (n2 > 0x100000 && n2 < 0x200000) {
            return this.setParameter("che.audio.morph.reverb_preset", n2 - 0x100000);
        }
        if (n2 > 0x200000 && n2 < 0x200002) {
            return this.setParameter("che.audio.morph.virtual_stereo", n2 - 0x200000);
        }
        if (n2 > 0x300000 && n2 < 0x300002) {
            return this.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", 1, 4));
        }
        if (n2 > 0x400000 && n2 < 0x400002) {
            return this.setParameter("che.audio.morph.threedim_voice", 10);
        }
        return -2;
    }

    @Override
    public int setVoiceBeautifierPreset(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x1010100) {
            return this.setParameter("che.audio.morph.beauty_voice", 1);
        }
        if (n2 == 0x1010200) {
            return this.setParameter("che.audio.morph.beauty_voice", 2);
        }
        if (n2 == 0x1010300) {
            return this.setParameter("che.audio.morph.beauty_voice", 3);
        }
        if (n2 == 0x1020100) {
            return this.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", 1, 1));
        }
        if (n2 == 0x1020200) {
            return this.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", 2, 1));
        }
        if (n2 == 0x1030100) {
            return this.setParameter("che.audio.morph.voice_changer", 7);
        }
        if (n2 == 16974336) {
            return this.setParameter("che.audio.morph.voice_changer", 8);
        }
        if (n2 == 0x1030300) {
            return this.setParameter("che.audio.morph.voice_changer", 9);
        }
        if (n2 == 16974848) {
            return this.setParameter("che.audio.morph.voice_changer", 10);
        }
        if (n2 == 16975104) {
            return this.setParameter("che.audio.morph.voice_changer", 11);
        }
        if (n2 == 16975360) {
            return this.setParameter("che.audio.morph.voice_changer", 12);
        }
        if (n2 == 16975616) {
            return this.setParameter("che.audio.morph.voice_changer", 13);
        }
        if (n2 == 16975872) {
            return this.setParameter("che.audio.morph.voice_changer", 14);
        }
        return -2;
    }

    @Override
    public int setAudioEffectPreset(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x2010100) {
            return this.setParameter("che.audio.morph.reverb_preset", 1);
        }
        if (n2 == 0x2010200) {
            return this.setParameter("che.audio.morph.reverb_preset", 2);
        }
        if (n2 == 33620736) {
            return this.setParameter("che.audio.morph.reverb_preset", 5);
        }
        if (n2 == 33620992) {
            return this.setParameter("che.audio.morph.reverb_preset", 8);
        }
        if (n2 == 33621248) {
            return this.setParameter("che.audio.morph.virtual_stereo", 1);
        }
        if (n2 == 33621504) {
            return this.setParameter("che.audio.morph.voice_changer", 15);
        }
        if (n2 == 33621760) {
            return this.setParameter("che.audio.morph.voice_changer", 5);
        }
        if (n2 == 33622016) {
            return this.setParameter("che.audio.morph.threedim_voice", 10);
        }
        if (n2 == 0x2020100) {
            return this.setParameter("che.audio.morph.reverb_preset", 3);
        }
        if (n2 == 0x2020200) {
            return this.setParameter("che.audio.morph.voice_changer", 1);
        }
        if (n2 == 0x2020300) {
            return this.setParameter("che.audio.morph.voice_changer", 2);
        }
        if (n2 == 0x2020400) {
            return this.setParameter("che.audio.morph.reverb_preset", 4);
        }
        if (n2 == 0x2020500) {
            return this.setParameter("che.audio.morph.voice_changer", 3);
        }
        if (n2 == 0x2020600) {
            return this.setParameter("che.audio.morph.voice_changer", 4);
        }
        if (n2 == 0x2020700) {
            return this.setParameter("che.audio.morph.voice_changer", 6);
        }
        if (n2 == 33751296) {
            return this.setParameter("che.audio.morph.reverb_preset", 7);
        }
        if (n2 == 0x2030200) {
            return this.setParameter("che.audio.morph.reverb_preset", 6);
        }
        if (n2 == 33816832) {
            return this.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", 1, 4));
        }
        return -2;
    }

    @Override
    public int setVoiceConversionPreset(int n2) {
        if (n2 == 0) {
            return this.setParameter("che.audio.morph.voice_changer", 0);
        }
        if (n2 == 0x3010100) {
            return this.setParameter("che.audio.morph.vocal_changer", 1);
        }
        if (n2 == 50397696) {
            return this.setParameter("che.audio.morph.vocal_changer", 2);
        }
        if (n2 == 0x3010300) {
            return this.setParameter("che.audio.morph.vocal_changer", 3);
        }
        if (n2 == 50398208) {
            return this.setParameter("che.audio.morph.vocal_changer", 4);
        }
        return -2;
    }

    @Override
    public int setAudioEffectParameters(int n2, int n3, int n4) {
        if (n2 == 33816832) {
            return this.setParameterObject("che.audio.morph.electronic_voice", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", n3, n4));
        }
        if (n2 == 33622016) {
            return this.setParameter("che.audio.morph.threedim_voice", n3);
        }
        return -2;
    }

    @Override
    public int setVoiceBeautifierParameters(int n2, int n3, int n4) {
        if (n2 == 0x1020100 || n2 == 0x1020200) {
            return this.setParameterObject("che.audio.morph.beauty_sing", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", n3, n4));
        }
        return -2;
    }

    @Override
    public int setInEarMonitoringVolume(int n2) {
        return this.setParameter("che.audio.headset.monitoring.parameter", n2);
    }

    @Override
    public double getEffectsVolume() {
        return this.getEffectsPlayoutVolume();
    }

    @Override
    public int setEffectsVolume(double d2) {
        int n2 = this.adjustEffectsPlayoutVolume((int)d2);
        if (n2 == 0) {
            n2 = this.adjustEffectsPublishVolume((int)d2);
        }
        return n2;
    }

    @Override
    public int setVolumeOfEffect(int n2, double d2) {
        return this.setParameterObject("che.audio.game_adjust_effect_volume", RtcEngineImpl.formatString("{\"soundId\":%d,\"gain\":%f}", n2, d2));
    }

    @Override
    @Deprecated
    public int playEffect(int n2, String string, int n3, double d2, double d3, double d4) {
        return this.playEffect(n2, string, n3, d2, d3, d4, false, 0);
    }

    @Override
    @Deprecated
    public int playEffect(int n2, String string, int n3, double d2, double d3, double d4, boolean bl) {
        return this.playEffect(n2, string, n3, d2, d3, d4, bl, 0);
    }

    @Override
    public int playEffect(int n2, String string, int n3, double d2, double d3, double d4, boolean bl, int n4) {
        return this.setParameterObject("che.audio.game_play_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\",\"loopCount\":%d, \"pitch\":%f,\"pan\":%f,\"gain\":%f, \"send2far\":%d, \"startPos\":%d}", n2, string, n3, d2, d3, d4, bl ? 1 : 0, n4));
    }

    @Override
    public int stopEffect(int n2) {
        return this.setParameter("che.audio.game_stop_effect", n2);
    }

    @Override
    public int stopAllEffects() {
        return this.setParameter("che.audio.game_stop_all_effects", true);
    }

    @Override
    public int preloadEffect(int n2, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -2;
        }
        return this.setParameterObject("che.audio.game_preload_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\"}", n2, string));
    }

    @Override
    public int unloadEffect(int n2) {
        return this.setParameter("che.audio.game_unload_effect", n2);
    }

    @Override
    public int pauseEffect(int n2) {
        return this.setParameter("che.audio.game_pause_effect", n2);
    }

    @Override
    public int pauseAllEffects() {
        return this.setParameter("che.audio.game_pause_all_effects", true);
    }

    @Override
    public int resumeEffect(int n2) {
        return this.setParameter("che.audio.game_resume_effect", n2);
    }

    @Override
    public int resumeAllEffects() {
        return this.setParameter("che.audio.game_resume_all_effects", true);
    }

    @Override
    public int getEffectCurrentPosition(int n2) {
        int n3 = this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_effect_file_position", RtcEngineImpl.formatString("%d", n2));
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    @Override
    public int setEffectPosition(int n2, int n3) {
        return this.setParameterObject("che.audio.set_effect_file_position", RtcEngineImpl.formatString("{\"soundId\":%d,\"effectPos\":%d}", n2, n3));
    }

    @Override
    public int getEffectDuration(String string) {
        int n2 = this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_effect_file_duration", RtcEngineImpl.formatString("%s", string));
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public int startRhythmPlayer(String string, String string2, AgoraRhythmPlayerConfig agoraRhythmPlayerConfig) {
        return this.setParameterObject("che.audio.play_rhythm", RtcEngineImpl.formatString("{\"file1\":\"%s\",\"file2\":\"%s\",\"beatsPerMeasure\":%d, \"beatsPerMinute\":%d,\"publish\":%d}", string, string2, agoraRhythmPlayerConfig.beatsPerMeasure, agoraRhythmPlayerConfig.beatsPerMinute, agoraRhythmPlayerConfig.publish ? 1 : 0));
    }

    @Override
    public int stopRhythmPlayer() {
        return this.setParameter("che.audio.stop_rhythm", true);
    }

    @Override
    public int configRhythmPlayer(AgoraRhythmPlayerConfig agoraRhythmPlayerConfig) {
        return this.setParameterObject("che.audio.config_rhythm", RtcEngineImpl.formatString("{\"beatsPerMeasure\":%d,\"beatsPerMinute\":%d,\"publish\":%d}", agoraRhythmPlayerConfig.beatsPerMeasure, agoraRhythmPlayerConfig.beatsPerMinute, agoraRhythmPlayerConfig.publish ? 1 : 0));
    }

    @Override
    public int setApiCallMode(int n2) {
        return this.nativeSetApiCallMode(this.mNativeHandle, n2);
    }

    @Override
    public int getConnectionState() {
        return this.nativeGetConncetionState(this.mNativeHandle);
    }

    @Override
    public int enableRemoteSuperResolution(int n2, boolean bl) {
        return this.nativeEnableRemoteSuperResolutionDepercated(this.mNativeHandle, n2, bl);
    }

    @Override
    public int enableRemoteSuperResolution(boolean bl, int n2, int n3) {
        return this.nativeEnableRemoteSuperResolution(this.mNativeHandle, bl, n2, n3);
    }

    public void finalize() {
        if (this.mNativeHandle != 0L) {
            this.nativeDestroy(this.mNativeHandle);
        }
    }

    @Override
    public int registerMediaMetadataObserver(IMetadataObserver iMetadataObserver, int n2) {
        return this.nativeRegisterMediaMetadataObserver(this.mNativeHandle, iMetadataObserver, n2);
    }

    @Override
    public int setLogWriter(ILogWriter iLogWriter) {
        return this.nativeSetLogWriter(this.mNativeHandle, iLogWriter);
    }

    @Override
    public int releaseLogWriter() {
        return this.nativeReleaseLogWriter(this.mNativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtcChannel createRtcChannel(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(string) && this.mDefaultRtcChannel.isInitialized()) {
                return this.mDefaultRtcChannel;
            }
            for (RtcChannelImpl rtcChannelImpl : this.mRtcChannels) {
                if (rtcChannelImpl.channelId() == null || !rtcChannelImpl.channelId().equals(string) || !rtcChannelImpl.isInitialized()) continue;
                return rtcChannelImpl;
            }
            long l2 = this.nativeCreateRtcChannel(this.mNativeHandle, string);
            if (l2 != 0L) {
                RtcChannelImpl rtcChannelImpl = new RtcChannelImpl();
                rtcChannelImpl.initialize(this, l2);
                this.mRtcChannels.add(rtcChannelImpl);
                return rtcChannelImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroyRtcChannel(String string) {
        if (string == null || string.length() <= 0) {
            return -102;
        }
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(string)) {
                return -5;
            }
            for (RtcChannelImpl rtcChannelImpl : this.mRtcChannels) {
                if (rtcChannelImpl.channelId() == null || !rtcChannelImpl.channelId().equals(string)) continue;
                int n2 = this.nativeRtcChannelRelease(rtcChannelImpl.getNativeHandle());
                this.mRtcChannels.remove(rtcChannelImpl);
                return n2;
            }
        }
        return 0;
    }

    public void onRtcChannelJoinChannel() {
        this.doJoinChannelCheck(this.getContext());
    }

    public void onRtcChannelLeaveChannel() {
        this.doLeaveChannelCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinChannelFirstTimeOrAllChannelLeft() {
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel != null) {
                return false;
            }
            boolean bl = true;
            for (RtcChannelImpl rtcChannelImpl : this.mRtcChannels) {
                if (!rtcChannelImpl.hasJoined()) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    @Override
    public int enableContentInspect(boolean bl, ContentInspectConfig contentInspectConfig) {
        byte[] byArray = null;
        if (bl) {
            if (contentInspectConfig == null) {
                return -2;
            }
            RtcEngineMessage.PContentInspectConfig pContentInspectConfig = new RtcEngineMessage.PContentInspectConfig();
            byArray = pContentInspectConfig.marshall(contentInspectConfig);
        }
        return this.nativeEnableContentInspect(this.mNativeHandle, bl, byArray);
    }

    @Override
    public int takeSnapshot(String string, int n2, String string2) {
        return this.nativeTakeSnapshot(this.mNativeHandle, string, n2, string2);
    }

    public int getMediaRecorder(AgoraMediaRecorder.IMediaRecorderCallback iMediaRecorderCallback) {
        return this.nativeGetMediaRecorder(this.mNativeHandle, iMediaRecorderCallback);
    }

    public int startRecording(String string, int n2, int n3, int n4, int n5) {
        return this.nativeStartRecording(this.mNativeHandle, string, n2, n3, n4, n5);
    }

    public int stopRecording() {
        return this.nativeStopRecording(this.mNativeHandle);
    }

    public void releaseRecorder() {
        this.nativeReleaseRecorder(this.mNativeHandle);
    }

    private int setParameter(String string, boolean bl) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%b}", string, bl));
    }

    private int setParameter(String string, int n2) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", string, n2));
    }

    private int setParameter(String string, long l2) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", string, l2));
    }

    private int setParameter(String string, double d2) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%f}", string, d2));
    }

    private int setParameter(String string, String string2) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":\"%s\"}", string, string2));
    }

    private int setParameterObject(String string, String string2) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%s}", string, string2));
    }

    private int adjustEffectsPlayoutVolume(int n2) {
        return this.setParameter("che.audio.set_effect_file_playout_volume", n2);
    }

    private int adjustEffectsPublishVolume(int n2) {
        return this.setParameter("che.audio.set_effect_file_publish_volume", n2);
    }

    private int getEffectsPlayoutVolume() {
        int n2 = this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_effect_file_playout_volume", null);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private synchronized boolean checkStatus() {
        if (this.mNativeHandle == 0L) {
            throw new IllegalStateException("RtcEngine does not initialize or it may be destroyed");
        }
        return true;
    }

    private static native int nativeClassInit();

    private native long nativeObjectInit(Object var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    private native long nativeObjectInitWithConfig(Object var1);

    private native int nativeDestroy(long var1);

    private native int nativeSetProfile(long var1, String var3, boolean var4);

    private native int nativeSetEncryptionSecret(long var1, String var3);

    private native int nativeEnableEncryption(long var1, boolean var3, int var4, String var5, byte[] var6);

    private native int nativeSetAppType(long var1, int var3);

    private native String nativeGetProfile(long var1);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetParameters(long var1, String var3);

    private native String nativeGetParameter(long var1, String var3, String var4);

    private native int nativeGetIntParameter(long var1, String var3, String var4);

    private native int nativeJoinChannel(long var1, byte[] var3, String var4, String var5, String var6, int var7, Object var8);

    private native int nativeSwitchChannel(long var1, String var3, String var4, Object var5);

    private native int nativeLeaveChannel(long var1);

    private native int nativeSetAVSyncSource(long var1, String var3, int var4);

    private native int nativeRegisterLocalUserAccount(long var1, String var3, String var4);

    private native int nativeJoinChannelWithUserAccount(long var1, String var3, String var4, String var5, Object var6);

    private native int nativeGetUserInfoByUserAccount(long var1, String var3, Object var4);

    private native int nativeGetUserInfoByUid(long var1, int var3, Object var4);

    private native int nativeStartEchoTest(long var1, byte[] var3);

    private native int nativeStartEchoTestWithInterval(long var1, byte[] var3, int var4);

    private native int nativeStopEchoTest(long var1);

    private native int nativeStartEchoTestWithConfig(long var1, Object var3);

    private native int nativeSetCloudProxy(long var1, int var3);

    private native int nativeSwitchCamera(long var1);

    private native int nativeSwitchCameraByDirection(long var1, int var3);

    private native boolean nativeIsCameraZoomSupported(long var1);

    private native boolean nativeIsCameraTorchSupported(long var1);

    private native boolean nativeIsCameraFocusSupported(long var1);

    private native boolean nativeIsCameraExposurePositionSupported(long var1);

    private native boolean nativeIsCameraAutoFocusFaceModeSupported(long var1);

    private native int nativeSetCameraZoomFactor(long var1, float var3);

    private native float nativeGetCameraMaxZoomFactor(long var1);

    private native int nativeSetCameraFocusPositionInPreview(long var1, float var3, float var4);

    private native int nativeSetCameraExposurePosition(long var1, float var3, float var4);

    private native int nativeSetCameraCaptureRotation(long var1, int var3);

    private native int nativeSetCameraTorchOn(long var1, boolean var3);

    private native int nativeSetCameraAutoFocusFaceModeEnabled(long var1, boolean var3);

    private native int nativeStartPreview(long var1);

    private native int nativeStartLastmileProbeTest(long var1, byte[] var3, boolean var4, boolean var5, int var6, int var7);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeCreateDataStream(long var1, boolean var3, boolean var4);

    private native int nativeCreateDataStream2(long var1, boolean var3, boolean var4);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeAddPublishStreamUrl(long var1, String var3, boolean var4);

    private native int nativeRemovePublishStreamUrl(long var1, String var3);

    private native int nativeSetLiveTranscoding(long var1, byte[] var3);

    private native int nativeStartRtmpStreamWithoutTranscoding(long var1, String var3);

    private native int nativeStartRtmpStreamWithTranscoding(long var1, String var3, byte[] var4);

    private native int nativeUpdateRtmpTranscoding(long var1, byte[] var3);

    private native int nativeStopRtmpStream(long var1, String var3);

    private native int nativeAddInjectStreamUrl(long var1, String var3, byte[] var4);

    private native int nativeRemoveInjectStreamUrl(long var1, String var3);

    private native int nativeRenewChannelKey(long var1, String var3);

    private native int nativeRenewToken(long var1, String var3);

    static native int nativeLog(int var0, String var1);

    private native int nativeSendCustomReportMessage(long var1, String var3, String var4, String var5, String var6, int var7);

    private native int nativeSetupVideoRemote(long var1, Object var3, int var4, String var5, int var6, int var7);

    private native int nativeSetupVideoLocal(long var1, Object var3, int var4, int var5);

    private native int nativeSetRemoteRenderMode(long var1, int var3, int var4);

    private native int nativeSetRemoteRenderModeWithMirrorMode(long var1, int var3, int var4, int var5);

    private native int nativeSetLocalVideoMirrorMode(long var1, int var3);

    private native int nativeSetEglBaseRootContext(long var1, EglBase.Context var3);

    private native int nativeSetEGL10Context(long var1, javax.microedition.khronos.egl.EGLContext var3);

    private native int nativeSetEGL14Context(long var1, EGLContext var3);

    private native int nativeSetEGL10TextureId(long var1, int var3, javax.microedition.khronos.egl.EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetEGL14TextureId(long var1, int var3, EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetVideoProfileEx(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetAudioProfile(long var1, int var3, int var4);

    private native int nativeSetVideoEncoderConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native int nativeAddVideoWatermark(long var1, String var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private native int nativeClearVideoWatermarks(long var1);

    private native int nativeSetBeautyEffectOptions(long var1, boolean var3, int var4, float var5, float var6, float var7, float var8);

    private native int nativeSetLowlightEnhanceOptions(long var1, boolean var3, int var4, int var5);

    private native int nativeSetVideoDenoiserOptions(long var1, boolean var3, int var4, int var5);

    private native int nativeSetColorEnhanceOptions(long var1, boolean var3, float var4, float var5);

    private native int nativeEnableVirtualBackground(long var1, boolean var3, Object var4);

    private native int nativeSetRemoteUserPriority(long var1, int var3, int var4);

    private native int nativeStartChannelMediaRelay(long var1, byte[] var3);

    private native int nativeStopChannelMediaRelay(long var1);

    private native int nativePauseAllChannelMediaRelay(long var1);

    private native int nativeResumeAllChannelMediaRelay(long var1);

    private native int nativeUpdateChannelMediaRelay(long var1, byte[] var3);

    private native int nativeSetScreenCaptureContentHint(long var1, int var3);

    private native int nativeStartDumpVideoReceiveTrack(long var1, int var3, String var4);

    private native int nativeStopDumpVideoReceiveTrack(long var1);

    private native String nativeMakeQualityReportUrl(long var1, String var3, int var4, int var5, int var6);

    private native String nativeGetCallId(long var1);

    private native int nativeRate(long var1, String var3, int var4, String var5);

    private native int nativeComplain(long var1, String var3, String var4);

    private native int nativeRegisterAudioFrameObserver(long var1, Object var3);

    private native int nativeRegisterVideoEncodedFrameObserver(long var1, Object var3);

    private native int nativeRegisterVideoFrameObserver(long var1, Object var3);

    private native int nativePullAudioFrame(long var1, byte[] var3, int var4, int var5);

    private native int nativePushExternalAudioFrameRawData(long var1, byte[] var3, long var4, int var6, int var7);

    private native int nativePushExternalAudioFrameRawDataExt(long var1, byte[] var3, long var4, int var6, int var7, int var8, int var9);

    private native int nativeSetExternalAudioSourceVolume(long var1, int var3, int var4);

    private native int nativeSetApiCallMode(long var1, int var3);

    public static native String nativeGetSdkVersion();

    public static native String nativeGetChatEngineVersion();

    public static native String nativeGetErrorDescription(int var0);

    private static native byte[] nativeGetOptionsByVideoProfile(long var0, int var2);

    private native long nativeGetHandle(long var1);

    private native String nativeUploadLogFile(long var1);

    private native int setExtVideoSource(long var1, int var3, int var4);

    private native int deliverFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13);

    private native int nativeAddVideoCapturer(long var1, IVideoSource var3, int var4);

    private native int nativeAddLocalVideoRender(long var1, IVideoSink var3, int var4);

    private native int nativeAddRemoteVideoRender(long var1, int var3, IVideoSink var4, int var5);

    private native int nativeRemoveVideoReceiveTrack(long var1, int var3);

    private native int nativeGetConncetionState(long var1);

    private native int nativeEnableRemoteSuperResolutionDepercated(long var1, int var3, boolean var4);

    private native int nativeEnableRemoteSuperResolution(long var1, boolean var3, int var4, int var5);

    private native int nativeRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeSetLogWriter(long var1, Object var3);

    private native int nativeReleaseLogWriter(long var1);

    private native int nativeEnableVideo(long var1);

    private native int nativeDisableVideo(long var1);

    private native int nativeEnableAudio(long var1);

    private native int nativeDisableAudio(long var1);

    private native int nativeMuteLocalAudioStream(long var1, boolean var3);

    private native int nativeMuteLocalVideoStream(long var1, boolean var3);

    private native int nativeMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeSetDefaultAudioRoutetoSpeakerphone(long var1, boolean var3);

    private native int nativeEnableDeepLearningDenoise(long var1, boolean var3);

    private native int nativeEnableSoundPositionIndication(long var1, boolean var3);

    private native int nativeEnableSpatialAudio(long var1, boolean var3);

    private native int nativeSetRemoteUserSpatialAudioParams(long var1, int var3, Object var4);

    private native int nativeEnableLocalAudio(long var1, boolean var3);

    private native int nativeSetEnableSpeakerphone(long var1, boolean var3);

    private native boolean nativeIsSpeakerphoneEnabled(long var1);

    private native int nativeSetChannelProfile(long var1, int var3);

    private native int nativeSetClientRole(long var1, int var3);

    private native int nativeSetClientRoleOptions(long var1, int var3, Object var4);

    private native int nativeStartAudioRecording(long var1, String var3, int var4, int var5, int var6, int var7);

    private native int nativeStopAudioRecording(long var1);

    private native int nativeSetLocalAccessPoint(long var1, ArrayList<String> var3, ArrayList<String> var4, String var5, int var6, Object var7);

    private native long nativeGetDefaultRtcChannel(long var1);

    private native long nativeCreateRtcChannel(long var1, String var3);

    private native int nativeRtcChannelRelease(long var1);

    private static native int nativeDeviceChanged(long var0);

    private native int nativeTakeSnapshot(long var1, String var3, int var4, String var5);

    private native int nativeEnableContentInspect(long var1, boolean var3, byte[] var4);

    private native int nativeGetMediaRecorder(long var1, Object var3);

    private native int nativeStartRecording(long var1, String var3, int var4, int var5, int var6, int var7);

    private native int nativeStopRecording(long var1);

    private native int nativeReleaseRecorder(long var1);
}

