/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter;

import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.musiccontentcenter.IMusicContentCenterEventHandler;
import io.agora.musiccontentcenter.MusicContentCenterConfiguration;
import io.agora.musiccontentcenter.internal.MusicContentCenterImpl;
import io.agora.rtc2.RtcEngine;

public abstract class IAgoraMusicContentCenter {
    private static IAgoraMusicContentCenter mInstance = null;

    public static synchronized IAgoraMusicContentCenter create(RtcEngine rtcEngine) {
        if (mInstance == null) {
            mInstance = new MusicContentCenterImpl(rtcEngine);
        }
        return mInstance;
    }

    public static synchronized void destroy() {
        if (mInstance == null) {
            return;
        }
        mInstance.release();
        mInstance = null;
    }

    public abstract int initialize(MusicContentCenterConfiguration var1);

    public abstract IAgoraMusicPlayer createMusicPlayer();

    public abstract int registerEventHandler(IMusicContentCenterEventHandler var1);

    public abstract int unregisterEventHandler();

    public abstract int preload(long var1, String var3);

    public abstract int isPreloaded(long var1);

    public abstract String getMusicCharts();

    public String getMusicCollectionByMusicChartId(int musicChartId, int page, int pageSize) {
        return this.getMusicCollectionByMusicChartId(musicChartId, page, pageSize, null);
    }

    public abstract String getMusicCollectionByMusicChartId(int var1, int var2, int var3, String var4);

    public String searchMusic(String keyword, int page, int pageSize) {
        return this.searchMusic(keyword, page, pageSize, null);
    }

    public abstract String searchMusic(String var1, int var2, int var3, String var4);

    public abstract String getLyric(long var1, int var3);

    protected abstract void release();
}

