/*
 * Decompiled with CFR 0.152.
 */
package io.agora.musiccontentcenter.internal;

import io.agora.musiccontentcenter.IAgoraMusicContentCenter;
import io.agora.musiccontentcenter.IAgoraMusicPlayer;
import io.agora.musiccontentcenter.IMusicContentCenterEventHandler;
import io.agora.musiccontentcenter.MusicContentCenterConfiguration;
import io.agora.musiccontentcenter.internal.AgoraMusicPlayerImpl;
import io.agora.musiccontentcenter.internal.MusicPlayerProperty;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.internal.RtcEngineImpl;

public class MusicContentCenterImpl
extends IAgoraMusicContentCenter {
    private long mNativeHandle = 0L;
    private final RtcEngineImpl mRtcEngine;

    public MusicContentCenterImpl(RtcEngine rtcEngine) {
        this.mNativeHandle = this.nativeObjectInit(rtcEngine.getNativeHandle());
        this.mRtcEngine = rtcEngine instanceof RtcEngineImpl ? (RtcEngineImpl)rtcEngine : null;
    }

    @Override
    public int initialize(MusicContentCenterConfiguration configuration) {
        return this.nativeInitialize(this.mNativeHandle, configuration);
    }

    @Override
    public IAgoraMusicPlayer createMusicPlayer() {
        AgoraMusicPlayerImpl musicPlayer = null;
        MusicPlayerProperty playerProperty = this.nativeCreateMusicPlayer(this.mNativeHandle);
        if (playerProperty.handler != 0L) {
            musicPlayer = new AgoraMusicPlayerImpl(this.mRtcEngine, playerProperty.handler, playerProperty.id);
        }
        return musicPlayer;
    }

    @Override
    public int registerEventHandler(IMusicContentCenterEventHandler eventHandler) {
        return this.nativeRegisterEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int unregisterEventHandler() {
        return this.nativeUnregisterEventHandler(this.mNativeHandle);
    }

    @Override
    public String getMusicCharts() {
        return this.nativeGetMusicCharts(this.mNativeHandle);
    }

    @Override
    public String getMusicCollectionByMusicChartId(int musicChartId, int page, int pageSize, String option) {
        return this.nativeGetMusicCollectionByMusicChartId(this.mNativeHandle, musicChartId, page, pageSize, option);
    }

    @Override
    public String searchMusic(String keyword, int page, int pageSize, String option) {
        return this.nativeSearchMusic(this.mNativeHandle, keyword, page, pageSize, option);
    }

    @Override
    public String getLyric(long songCode, int lyricType) {
        return this.nativeGetLyric(this.mNativeHandle, songCode, lyricType);
    }

    @Override
    protected void release() {
        if (this.mNativeHandle != 0L) {
            MusicContentCenterImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
    }

    @Override
    public int preload(long songCode, String jsonOption) {
        return this.nativePreload(this.mNativeHandle, songCode, jsonOption);
    }

    @Override
    public int isPreloaded(long songCode) {
        return this.nativeIsPreloaded(this.mNativeHandle, songCode);
    }

    private static native int nativeDestroy(long var0);

    private native long nativeObjectInit(long var1);

    private native int nativeInitialize(long var1, Object var3);

    private native int nativePreload(long var1, long var3, String var5);

    private native int nativeIsPreloaded(long var1, long var3);

    private native String nativeGetMusicCharts(long var1);

    private native String nativeGetMusicCollectionByMusicChartId(long var1, int var3, int var4, int var5, String var6);

    private native String nativeSearchMusic(long var1, String var3, int var4, int var5, String var6);

    private native String nativeGetLyric(long var1, long var3, int var5);

    private native int nativeRegisterEventHandler(long var1, Object var3);

    private native int nativeUnregisterEventHandler(long var1);

    private native MusicPlayerProperty nativeCreateMusicPlayer(long var1);
}

