/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.net.Uri;
import android.view.View;
import io.agora.mediaplayer.Constants;
import io.agora.mediaplayer.IMediaPlayer;
import io.agora.mediaplayer.IMediaPlayerAudioFrameObserver;
import io.agora.mediaplayer.IMediaPlayerCustomDataProvider;
import io.agora.mediaplayer.IMediaPlayerObserver;
import io.agora.mediaplayer.IMediaPlayerVideoFrameObserver;
import io.agora.mediaplayer.data.MediaPlayerSource;
import io.agora.mediaplayer.data.MediaStreamInfo;
import io.agora.rtc2.SpatialAudioParams;
import io.agora.rtc2.audio.IAudioSpectrumObserver;
import io.agora.rtc2.internal.CommonUtility;
import io.agora.rtc2.internal.Logging;
import io.agora.rtc2.internal.RtcEngineImpl;

public class MediaPlayerImpl
implements IMediaPlayer {
    private static final String TAG = MediaPlayerImpl.class.getSimpleName();
    private final RtcEngineImpl mRtcEngineImpl;
    private final int mNativeMediaPlayerSourceId;

    public MediaPlayerImpl(RtcEngineImpl rtcEngineImpl, int sourceId) {
        this.mRtcEngineImpl = rtcEngineImpl;
        this.mNativeMediaPlayerSourceId = sourceId;
    }

    @Override
    public int getMediaPlayerId() {
        return this.mNativeMediaPlayerSourceId;
    }

    @Override
    public int open(Uri uri, long startPos) {
        String procPath = CommonUtility.getContentFilePath(this.mRtcEngineImpl.getContext(), uri);
        if (procPath == null || procPath.equals("")) {
            Logging.e(TAG, "Media Player Can not open incorrect Uri Param");
            return -2;
        }
        return this.mRtcEngineImpl.mediaPlayerOpen(this.mNativeMediaPlayerSourceId, procPath, startPos);
    }

    @Override
    public int open(String url, long startPos) {
        String realPath = null;
        if (url != null && url.startsWith("content://")) {
            Uri uri = Uri.parse((String)url);
            realPath = CommonUtility.getContentFilePath(this.mRtcEngineImpl.getContext(), uri);
        }
        if (realPath == null) {
            realPath = url;
        }
        return this.mRtcEngineImpl.mediaPlayerOpen(this.mNativeMediaPlayerSourceId, realPath, startPos);
    }

    @Override
    @Deprecated
    public int openWithCustomSource(long startPos, IMediaPlayerCustomDataProvider provider) {
        return this.mRtcEngineImpl.mediaPlayerOpenWithCustomSource(this.mNativeMediaPlayerSourceId, startPos, provider);
    }

    @Override
    public int openWithMediaSource(MediaPlayerSource source) {
        return this.mRtcEngineImpl.mediaPlayerOpenWithMediaSource(this.mNativeMediaPlayerSourceId, source);
    }

    @Override
    public int play() {
        return this.mRtcEngineImpl.mediaPlayerPlay(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int pause() {
        return this.mRtcEngineImpl.mediaPlayerPause(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int stop() {
        return this.mRtcEngineImpl.mediaPlayerStop(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int resume() {
        return this.mRtcEngineImpl.mediaPlayerResume(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int seek(long newPos) {
        return this.mRtcEngineImpl.mediaPlayerSeek(this.mNativeMediaPlayerSourceId, newPos);
    }

    @Override
    public int setAudioPitch(int pitch) {
        return this.mRtcEngineImpl.mediaPlayerSetAudioPitch(this.mNativeMediaPlayerSourceId, pitch);
    }

    @Override
    public int mute(boolean muted) {
        return this.mRtcEngineImpl.mediaPlayerMute(this.mNativeMediaPlayerSourceId, muted);
    }

    @Override
    public boolean getMute() {
        return this.mRtcEngineImpl.mediaPlayerGetMute(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public long getPlayPosition() {
        return this.mRtcEngineImpl.mediaPlayerGetPlayPosition(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public long getDuration() {
        return this.mRtcEngineImpl.mediaPlayerGetDuration(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public Constants.MediaPlayerState getState() {
        return Constants.MediaPlayerState.getStateByValue(this.mRtcEngineImpl.mediaPlayerGetState(this.mNativeMediaPlayerSourceId));
    }

    @Override
    public int getStreamCount() {
        return this.mRtcEngineImpl.mediaPlayerGetStreamCount(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int setView(View videoView) {
        return this.mRtcEngineImpl.mediaPlayerSetView(this.mNativeMediaPlayerSourceId, videoView);
    }

    @Override
    public int setRenderMode(int mode) {
        return this.mRtcEngineImpl.mediaPlayerSetRenderMode(this.mNativeMediaPlayerSourceId, mode);
    }

    @Override
    public MediaStreamInfo getStreamInfo(int index) {
        return this.mRtcEngineImpl.mediaPlayerGetStreamInfo(this.mNativeMediaPlayerSourceId, index);
    }

    @Override
    public int setLoopCount(int loopCount) {
        return this.mRtcEngineImpl.mediaPlayerSetLoopCount(this.mNativeMediaPlayerSourceId, loopCount);
    }

    @Override
    public int setPlaybackSpeed(int speed) {
        return this.mRtcEngineImpl.mediaPlayerChangePlaybackSpeed(this.mNativeMediaPlayerSourceId, speed);
    }

    @Override
    public int selectAudioTrack(int index) {
        return this.mRtcEngineImpl.mediaPlayerSelectAudioTrack(this.mNativeMediaPlayerSourceId, index);
    }

    @Override
    public int setPlayerOption(String key, int value) {
        return this.mRtcEngineImpl.mediaPlayerSetPlayerOption(this.mNativeMediaPlayerSourceId, key, value);
    }

    @Override
    public int setPlayerOptionString(String key, String value) {
        return this.mRtcEngineImpl.mediaPlayerSetPlayerOptionString(this.mNativeMediaPlayerSourceId, key, value);
    }

    @Override
    public int takeScreenshot(String filename) {
        return this.mRtcEngineImpl.mediaPlayerTakeScreenshot(this.mNativeMediaPlayerSourceId, filename);
    }

    @Override
    public int selectInternalSubtitle(int index) {
        return this.mRtcEngineImpl.mediaPlayerSelectInternalSubtitle(this.mNativeMediaPlayerSourceId, index);
    }

    @Override
    public int setExternalSubtitle(String url) {
        return this.mRtcEngineImpl.mediaPlayerSetExternalSubtitle(this.mNativeMediaPlayerSourceId, url);
    }

    @Override
    public int adjustPlayoutVolume(int volume) {
        return this.mRtcEngineImpl.mediaPlayerAdjustPlayoutVolume(this.mNativeMediaPlayerSourceId, volume);
    }

    @Override
    public int getPlayoutVolume() {
        return this.mRtcEngineImpl.mediaPlayerGetPlayoutVolume(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int adjustPublishSignalVolume(int volume) {
        return this.mRtcEngineImpl.mediaPlayerAdjustPublishSignalVolume(this.mNativeMediaPlayerSourceId, volume);
    }

    @Override
    public int getPublishSignalVolume() {
        return this.mRtcEngineImpl.mediaPlayerGetPublishSignalVolume(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public String getPlaySrc() {
        return this.mRtcEngineImpl.mediaPlayerGetPlaySrc(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int switchSrc(String src, boolean syncPts) {
        return this.mRtcEngineImpl.mediaPlayerSwitchSrc(this.mNativeMediaPlayerSourceId, src, syncPts);
    }

    @Override
    public int preloadSrc(String src, long startPos) {
        return this.mRtcEngineImpl.mediaPlayerPreloadSrc(this.mNativeMediaPlayerSourceId, src, startPos);
    }

    @Override
    public int unloadSrc(String src) {
        return this.mRtcEngineImpl.mediaPlayerUnloadSrc(this.mNativeMediaPlayerSourceId, src);
    }

    @Override
    public int playPreloadedSrc(String src) {
        return this.mRtcEngineImpl.mediaPlayerPlayPreloadedSrc(this.mNativeMediaPlayerSourceId, src);
    }

    @Override
    public int destroy() {
        return this.mRtcEngineImpl.mediaPlayerDestroy(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int registerPlayerObserver(IMediaPlayerObserver playerObserver) {
        return this.mRtcEngineImpl.mediaPlayerRegisterPlayerObserver(this.mNativeMediaPlayerSourceId, playerObserver);
    }

    @Override
    public int unRegisterPlayerObserver(IMediaPlayerObserver playerObserver) {
        return this.mRtcEngineImpl.mediaPlayerUnRegisterPlayerObserver(this.mNativeMediaPlayerSourceId, playerObserver);
    }

    @Override
    public int registerAudioFrameObserver(IMediaPlayerAudioFrameObserver audioFrameObserver, int mode) {
        return this.mRtcEngineImpl.mediaPlayerRegisterAudioFrameObserver(this.mNativeMediaPlayerSourceId, audioFrameObserver, mode);
    }

    @Override
    public int registerMediaPlayerAudioSpectrumObserver(IAudioSpectrumObserver observer, int intervalInMS) {
        return this.mRtcEngineImpl.registerMediaPlayerAudioSpectrumObserver(this.mNativeMediaPlayerSourceId, observer, intervalInMS);
    }

    @Override
    public int unregisterMediaPlayerAudioSpectrumObserver(IAudioSpectrumObserver observer) {
        return this.mRtcEngineImpl.unregisterMediaPlayerAudioSpectrumObserver(this.mNativeMediaPlayerSourceId, observer);
    }

    @Override
    public int setAudioDualMonoMode(int mode) {
        return this.mRtcEngineImpl.mediaPlayerSetAudioDualMonoMode(this.mNativeMediaPlayerSourceId, mode);
    }

    @Override
    public int registerVideoFrameObserver(IMediaPlayerVideoFrameObserver videoFrameObserver) {
        return this.mRtcEngineImpl.mediaPlayerRegisterVideoFrameObserver(this.mNativeMediaPlayerSourceId, videoFrameObserver);
    }

    @Override
    public int openWithAgoraCDNSrc(String src, long startPos) {
        return this.mRtcEngineImpl.mediaPlayerOpenWithAgoraCDNSrc(this.mNativeMediaPlayerSourceId, src, startPos);
    }

    @Override
    public int getAgoraCDNLineCount() {
        return this.mRtcEngineImpl.mediaPlayerGetAgoraCDNLineCount(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int switchAgoraCDNLineByIndex(int index) {
        return this.mRtcEngineImpl.mediaPlayerSwitchAgoraCDNLineByIndex(this.mNativeMediaPlayerSourceId, index);
    }

    @Override
    public int getCurrentAgoraCDNIndex() {
        return this.mRtcEngineImpl.mediaPlayerGetCurrentAgoraCDNIndex(this.mNativeMediaPlayerSourceId);
    }

    @Override
    public int enableAutoSwitchAgoraCDN(boolean enable) {
        return this.mRtcEngineImpl.mediaPlayerEnableAutoSwitchAgoraCDN(this.mNativeMediaPlayerSourceId, enable);
    }

    @Override
    public int renewAgoraCDNSrcToken(String token, long ts) {
        return this.mRtcEngineImpl.mediaPlayerRenewAgoraCDNSrcToken(this.mNativeMediaPlayerSourceId, token, ts);
    }

    @Override
    public int switchAgoraCDNSrc(String src, boolean syncPts) {
        return this.mRtcEngineImpl.mediaPlayerSwitchAgoraCDNSrc(this.mNativeMediaPlayerSourceId, src, syncPts);
    }

    @Override
    public int setSpatialAudioParams(SpatialAudioParams spatialAudioParams) {
        return this.mRtcEngineImpl.mediaPlayerSetSpatialAudioParams(this.mNativeMediaPlayerSourceId, spatialAudioParams);
    }
}

