/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import io.agora.base.internal.SurfaceEglRenderer;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoSink;
import java.util.Random;

public abstract class SurfaceEglRendererHelper
implements VideoSink,
RendererCommon.RendererEvents,
View.OnLayoutChangeListener {
    private static final String TAG = "SurfaceEglRendererHelper";
    protected long nativeVideoRendererAndroid;
    protected final Object nativeLock = new Object();
    @NonNull
    protected final View view;
    protected final Object eglRenderLock = new Object();
    protected final String resourceName;
    @NonNull
    protected SurfaceEglRenderer eglRenderer;
    protected volatile boolean mirror;
    protected volatile Rect rect;
    protected volatile int renderMode;
    protected volatile boolean disposed;
    private final Handler handler;
    private EglBase.Context sharedContext;
    private int viewWidth;
    private int viewHeight;

    @CalledByNative
    public static SurfaceEglRendererHelper newInstance(long nativeRendererHelper, View view) {
        if (view instanceof SurfaceView) {
            return new SurfaceViewEglRenderHelper(nativeRendererHelper, (SurfaceView)view);
        }
        if (view instanceof TextureView) {
            return new TextureViewEglRenderHelper(nativeRendererHelper, (TextureView)view);
        }
        return null;
    }

    public SurfaceEglRendererHelper(long nativeRendererHelper, @NonNull View renderView) {
        this.nativeVideoRendererAndroid = nativeRendererHelper;
        this.view = renderView;
        this.resourceName = this.getResourceName(renderView);
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.handler = new Handler(Looper.getMainLooper());
        this.disposed = false;
        this.viewWidth = this.view.getWidth();
        this.viewHeight = this.view.getHeight();
        this.view.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    protected boolean initImpl(EglBase.Context sharedContext, boolean mirror, int renderMode) {
        this.sharedContext = sharedContext;
        this.mirror = mirror;
        this.logD("init() [mirror: " + mirror + ", renderMode: " + renderMode + "]");
        this.eglRenderer.init(sharedContext, this, EglBase.CONFIG_PLAIN, new GlRectDrawer());
        this.eglRenderer.setMirror(mirror);
        this.setRenderMode(renderMode);
        this.postOrRun(new Runnable(){

            @Override
            public void run() {
                SurfaceEglRendererHelper.this.checkAndSetExistSurface();
            }
        });
        return true;
    }

    @CalledByNative
    public final boolean init(EglBase.Context sharedContext, boolean mirror, int renderMode) {
        try {
            return this.initImpl(sharedContext, mirror, renderMode);
        }
        catch (Throwable e) {
            Logging.w(TAG, " Failed to init eglRender", e);
            return false;
        }
    }

    protected abstract void reInit(EglBase.Context var1);

    protected abstract void checkAndSetExistSurface();

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v != this.view) {
            return;
        }
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        if (this.viewWidth != viewWidth || this.viewHeight != viewHeight) {
            this.logD("onLayoutChange()");
            this.viewWidth = viewWidth;
            this.viewHeight = viewHeight;
            this.updateRenderSettings();
        }
    }

    @CalledByNative
    public void dispose() {
        this.view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @CalledByNative
    public void setMirror(boolean mirror) {
        this.logD("setMirror() [mirror: " + mirror + "]");
        if (this.disposed) {
            return;
        }
        this.mirror = mirror;
        this.eglRenderer.setMirror(mirror);
    }

    @CalledByNative
    public void updateCropArea(int left, int top, int right, int bottom) {
        Rect rect = new Rect(left, top, right, bottom);
        this.logD("updateCropArea() [rect: " + rect.toString() + "]");
        if (this.disposed) {
            return;
        }
        this.rect = rect;
        this.eglRenderer.updateCropArea(rect);
    }

    @CalledByNative
    public void setRenderMode(int renderMode) {
        this.logD("setRenderMode() [renderMode: " + renderMode + "]");
        if (this.disposed) {
            return;
        }
        this.renderMode = renderMode;
        this.updateRenderSettings();
    }

    @CalledByNative
    public int getFrameDrawn() {
        return this.eglRenderer.getFrameDrawn();
    }

    @Override
    @CalledByNative
    public void onFrame(VideoFrame frame) {
        EglBase.Context sharedContextInFrame;
        if (this.disposed) {
            return;
        }
        VideoFrame.Buffer videoFrameBuffer = frame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        if (isTextureBuffer && !SurfaceEglRendererHelper.objectsEquals(this.sharedContext, sharedContextInFrame = ((VideoFrame.TextureBuffer)videoFrameBuffer).getEglBaseContext())) {
            this.reInit(sharedContextInFrame);
        }
        this.eglRenderer.onFrame(frame);
    }

    private String getResourceName(View view) {
        try {
            return view.getContext().getResources().getResourceEntryName(view.getId());
        }
        catch (Exception e) {
            return "" + Math.abs(new Random().nextInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstFrameRendered(int videoWidth, int videoHeight, int rotation) {
        this.logD("onFirstFrameRendered videoWidth:" + videoWidth + " videoHeight:" + videoHeight + " rotation:" + rotation);
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeVideoRendererAndroid != 0L) {
                this.nativeNotifyFirstVideoFrame(this.nativeVideoRendererAndroid, videoWidth, videoHeight, rotation);
            }
        }
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
    }

    private int getViewWidth() {
        if (this.viewWidth == 0) {
            this.viewWidth = this.view.getWidth();
        }
        return this.viewWidth;
    }

    private int getViewHeight() {
        if (this.viewHeight == 0) {
            this.viewHeight = this.view.getHeight();
        }
        return this.viewHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRenderSettings() {
        Object object = this.eglRenderLock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            int viewWidth = this.getViewWidth();
            int viewHeight = this.getViewHeight();
            float layoutAspectRatio = 0.0f;
            if (viewWidth != 0 && viewHeight != 0) {
                layoutAspectRatio = (float)viewWidth / (float)viewHeight;
            }
            this.logD("updateRenderSettings. Layout size: " + viewWidth + "x" + viewHeight);
            if (this.renderMode == 1) {
                this.eglRenderer.setLayoutAspectRatio(layoutAspectRatio);
                this.eglRenderer.setLayoutScaledFit(false);
            } else if (this.renderMode == 2) {
                this.eglRenderer.setLayoutAspectRatio(layoutAspectRatio);
                this.eglRenderer.setLayoutScaledFit(true);
            } else {
                this.eglRenderer.setLayoutAspectRatio(0.0f);
                this.eglRenderer.setLayoutScaledFit(false);
            }
        }
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == this.handler.getLooper().getThread()) {
            r.run();
        } else {
            this.handler.post(r);
        }
    }

    protected void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }

    private static boolean objectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected native void nativeNotifySurfaceSizeChanged(long var1, int var3, int var4);

    protected native void nativeNotifyFirstVideoFrame(long var1, int var3, int var4, int var5);

    private static class TextureViewEglRenderHelper
    extends SurfaceEglRendererHelper
    implements TextureView.SurfaceTextureListener {
        @NonNull
        private final TextureView renderView;

        TextureViewEglRenderHelper(long nativeVideoRendererAndroid, @NonNull TextureView view) {
            super(nativeVideoRendererAndroid, (View)view);
            this.renderView = view;
        }

        @Override
        public boolean initImpl(EglBase.Context sharedContext, boolean mirror, int renderMode) {
            if (!super.initImpl(sharedContext, mirror, renderMode)) {
                return false;
            }
            this.renderView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkAndSetExistSurface() {
            ThreadUtils.checkIsOnMainThread();
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                SurfaceTexture surfaceTexture = this.renderView.getSurfaceTexture();
                if (surfaceTexture != null) {
                    this.onSurfaceTextureAvailable(surfaceTexture, 0, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reInit(EglBase.Context sharedContext) {
            this.logD("reInit()");
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                this.renderView.setSurfaceTextureListener(null);
                this.eglRenderer.release();
                this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
                this.initImpl(sharedContext, this.mirror, this.renderMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            super.dispose();
            if (this.disposed) {
                return;
            }
            Object object = this.eglRenderLock;
            synchronized (object) {
                this.disposed = true;
                this.logD("dispose()");
                this.renderView.setSurfaceTextureListener(null);
                this.eglRenderer.release();
            }
            object = this.nativeLock;
            synchronized (object) {
                this.nativeVideoRendererAndroid = 0L;
            }
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            this.logD("onSurfaceTextureAvailable = " + surfaceTexture);
            ThreadUtils.checkIsOnMainThread();
            this.eglRenderer.onSurfaceTextureAvailable(surfaceTexture, width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            this.logD("onSurfaceTextureSizeChanged = " + surfaceTexture);
            this.eglRenderer.onSurfaceTextureSizeChanged(surfaceTexture, width, height);
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifySurfaceSizeChanged(this.nativeVideoRendererAndroid, width, height);
                }
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            this.logD("onSurfaceTextureSizeChanged = " + surfaceTexture);
            this.eglRenderer.onSurfaceTextureDestroyed(surfaceTexture);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    private static class SurfaceViewEglRenderHelper
    extends SurfaceEglRendererHelper
    implements SurfaceHolder.Callback {
        @NonNull
        private final SurfaceView renderView;
        private final SurfaceHolder holder;

        SurfaceViewEglRenderHelper(long nativeRendererHelper, @NonNull SurfaceView view) {
            super(nativeRendererHelper, (View)view);
            this.renderView = view;
            this.holder = view.getHolder();
        }

        @Override
        public boolean initImpl(EglBase.Context sharedContext, boolean mirror, int renderMode) {
            if (this.holder == null) {
                Logging.e(SurfaceEglRendererHelper.TAG, "error! holder is null");
                return false;
            }
            if (!super.initImpl(sharedContext, mirror, renderMode)) {
                return false;
            }
            this.holder.addCallback((SurfaceHolder.Callback)this);
            this.holder.addCallback((SurfaceHolder.Callback)this.eglRenderer);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkAndSetExistSurface() {
            ThreadUtils.checkIsOnMainThread();
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                Surface surface = this.holder.getSurface();
                if (surface == null || !surface.isValid()) {
                    return;
                }
                this.surfaceCreated(this.holder);
                this.eglRenderer.surfaceCreated(this.holder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reInit(EglBase.Context sharedContext) {
            this.logD("reInit()");
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                this.holder.removeCallback((SurfaceHolder.Callback)this.eglRenderer);
                this.eglRenderer.release();
                this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
                this.initImpl(sharedContext, this.mirror, this.renderMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            super.dispose();
            if (this.disposed) {
                return;
            }
            Object object = this.eglRenderLock;
            synchronized (object) {
                this.disposed = true;
                this.logD("dispose()");
                this.holder.removeCallback((SurfaceHolder.Callback)this);
                this.holder.removeCallback((SurfaceHolder.Callback)this.eglRenderer);
                this.eglRenderer.release();
            }
            object = this.nativeLock;
            synchronized (object) {
                this.nativeVideoRendererAndroid = 0L;
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            this.logD("surfaceCreated()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            this.logD("surfaceChanged():" + width + " height:" + height);
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifySurfaceSizeChanged(this.nativeVideoRendererAndroid, width, height);
                }
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            this.logD("surfaceDestroyed()");
        }
    }

    static @interface RenderModeType {
        public static final int RENDER_MODE_HIDDEN = 1;
        public static final int RENDER_MODE_FIT = 2;
        public static final int RENDER_MODE_ADAPTIVE = 3;
    }
}

