/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.graphics.Matrix;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.rtc2.video.IVideoCapture;
import io.agora.rtc2.video.VideoCaptureFormat;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Observable;

public abstract class VideoCapture
implements IVideoCapture {
    public static final int ERR_OK = 0;
    public static final int ERR_FAILED = 1;
    public static final int ERR_INVALID_ARGUMENT = 2;
    public static final int ERR_NOT_READY = 3;
    public static final int ERR_NOT_SUPPORTED = 4;
    public static final boolean DEBUG_MODE = false;
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    protected int mCameraNativeOrientation;
    protected boolean mInvertDeviceOrientationReadings;
    protected VideoCaptureFormat mCaptureFormat;
    protected final long mNativeVideoCaptureAndroid;
    protected boolean mPQFirst = false;
    @Nullable
    protected ISurfaceTextureHelper mSurfaceTextureHelper;
    @VisibleForTesting
    private IVideoCapture.Events mEventsCallback;
    @VisibleForTesting
    private Observable mInjector;

    VideoCapture(long nativeVideoCaptureAndroid, EglBase.Context sharedContext) {
        this(nativeVideoCaptureAndroid, SurfaceTextureHelper.create(VIDEO_CAPTURER_THREAD_NAME, sharedContext));
    }

    VideoCapture(long nativeVideoCaptureAndroid, @Nullable ISurfaceTextureHelper helper) {
        this.mNativeVideoCaptureAndroid = nativeVideoCaptureAndroid;
        this.mSurfaceTextureHelper = helper;
    }

    public boolean allocate(int width, int height, int fps) {
        return this.allocate(new VideoCaptureFormat(width, height, fps, 0));
    }

    @Override
    public void dispose() {
        if (this.mSurfaceTextureHelper != null) {
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
        }
    }

    @Override
    public VideoCaptureFormat getCaptureFormat() {
        return this.mCaptureFormat;
    }

    static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBuffer buffer, boolean mirror, int rotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return buffer.applyTransformMatrix(transformMatrix, buffer.getWidth(), buffer.getHeight());
    }

    protected final int getCameraRotation() {
        int rotation = this.mInvertDeviceOrientationReadings ? 360 - this.getDeviceRotation() : this.getDeviceRotation();
        return (this.mCameraNativeOrientation + rotation) % 360;
    }

    protected final int getDeviceRotation() {
        int orientation;
        int rotation = 0;
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayManager dm = (DisplayManager)ContextUtils.getApplicationContext().getSystemService("display");
            rotation = dm.getDisplay(0).getRotation();
        } else {
            WindowManager wm = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
            rotation = wm.getDefaultDisplay().getRotation();
        }
        switch (rotation) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    @Override
    @VisibleForTesting
    public void setEventsCallback(IVideoCapture.Events event) {
        this.mEventsCallback = event;
    }

    @VisibleForTesting
    public void setInjector(Observable injector) {
        this.mInjector = injector;
    }

    void onStarted() {
        if (this.mEventsCallback != null) {
            this.mEventsCallback.onStarted();
            return;
        }
        this.nativeOnStarted(this.mNativeVideoCaptureAndroid);
    }

    static VideoCaptureFormat FindBestMatchedCapability(List<VideoCaptureFormat> formatList, VideoCaptureFormat req) {
        if (formatList == null || req == null) {
            return null;
        }
        return VideoCapture.nativeFindBestMatchedCapability(formatList, req);
    }

    void onFrameCaptured(VideoFrame frame) {
        if (this.mEventsCallback != null) {
            this.mEventsCallback.onFrameCaptured(frame);
            return;
        }
        this.nativeOnFrameCaptured(this.mNativeVideoCaptureAndroid, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs(), frame.getBuffer(), frame.getMetaInfo());
    }

    void onI420FrameAvailable(ByteBuffer yBuffer, int yStride, ByteBuffer uBuffer, ByteBuffer vBuffer, int uvRowStride, int uvPixelStride, int width, int height, int rotation, long timestamp) {
        if (this.mEventsCallback != null) {
            this.mEventsCallback.onI420FrameAvailable(yBuffer, yStride, uBuffer, vBuffer, uvRowStride, uvPixelStride, width, height, rotation, timestamp);
            return;
        }
        this.nativeOnI420FrameAvailable(this.mNativeVideoCaptureAndroid, yBuffer, yStride, uBuffer, vBuffer, uvRowStride, uvPixelStride, width, height, rotation, timestamp);
    }

    void onFrameDropped(int androidVideoCaptureFrameDropReason) {
        if (this.mEventsCallback != null) {
            this.mEventsCallback.onFrameDropped(androidVideoCaptureFrameDropReason);
            return;
        }
        this.nativeOnFrameDropped(this.mNativeVideoCaptureAndroid, androidVideoCaptureFrameDropReason);
    }

    void onError(int androidVideoCaptureError, String message) {
        if (this.mEventsCallback != null) {
            this.mEventsCallback.onError(androidVideoCaptureError, message);
            return;
        }
        if (this.mNativeVideoCaptureAndroid != 0L) {
            this.nativeOnError(this.mNativeVideoCaptureAndroid, androidVideoCaptureError, message);
        }
    }

    void notifyInjector(Object arg) {
        if (this.mInjector != null) {
            this.mInjector.notifyObservers(arg);
        }
    }

    static native VideoCaptureFormat nativeFindBestMatchedCapability(List<VideoCaptureFormat> var0, VideoCaptureFormat var1);

    private native void nativeOnFrameCaptured(long var1, int var3, int var4, int var5, long var6, VideoFrame.Buffer var8, VideoFrameMetaInfo var9);

    private native void nativeOnI420FrameAvailable(long var1, ByteBuffer var3, int var4, ByteBuffer var5, ByteBuffer var6, int var7, int var8, int var9, int var10, int var11, long var12);

    private native void nativeOnError(long var1, int var3, String var4);

    private native void nativeOnFrameDropped(long var1, int var3);

    private native void nativeOnStarted(long var1);

    static class FramerateRange {
        public int min;
        public int max;

        public FramerateRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "{\"min\":" + this.min + ",\"max\":" + this.max + '}';
        }
    }

    static @interface AndroidVideoCaptureFrameDropReason {
        public static final int ANDROID_API_1_UNEXPECTED_DATA_LENGTH = 8;
        public static final int ANDROID_API_2_ACQUIRED_IMAGE_IS_NULL = 9;
    }

    static @interface AndroidVideoCaptureError {
        public static final int kVideoCaptureEventNone = 0;
        public static final int kCameraErrorCameraInUse = 1;
        public static final int kCameraErrorMaxCamerasInUse = 2;
        public static final int kCameraErrorCameraDisabled = 3;
        public static final int kCameraErrorCameraDevice = 4;
        public static final int kCameraErrorCameraService = 5;
        public static final int kCameraErrorDisconnected = 6;
        public static final int kCameraErrorDeviceNotFound = 7;
        public static final int kCameraErrorNoPermission = 8;
        public static final int kCameraErrorConfigureInitiation = 100;
        public static final int kCameraErrorConfigureSession = 101;
        public static final int kCameraErrorConfigureRequest = 102;
        public static final int kCameraErrorRuntimeUnknown = 901;
    }

    static @interface AndroidImageFormat {
        public static final int NV21 = 17;
        public static final int YUY2 = 20;
        public static final int YUV_420_888 = 35;
        public static final int YV12 = 842094169;
        public static final int UNKNOWN = 0;
    }

    static @interface VideoCaptureTransportType {
        public static final int MACOSX_USB_OR_BUILT_IN = 0;
        public static final int OTHER_TRANSPORT = 1;
    }

    static @interface VideoCaptureApi {
        public static final int LINUX_V4L2_SINGLE_PLANE = 0;
        public static final int WIN_MEDIA_FOUNDATION = 1;
        public static final int WIN_MEDIA_FOUNDATION_SENSOR = 2;
        public static final int WIN_DIRECT_SHOW = 3;
        public static final int MACOSX_AVFOUNDATION = 4;
        public static final int MACOSX_DECKLINK = 5;
        public static final int ANDROID_API1 = 6;
        public static final int ANDROID_API2_LEGACY = 7;
        public static final int ANDROID_API2_FULL = 8;
        public static final int ANDROID_API2_LIMITED = 9;
        public static final int VIRTUAL_DEVICE = 10;
        public static final int UNKNOWN = 11;
    }

    static @interface AndroidFillLightMode {
        public static final int NOT_SET = 0;
        public static final int OFF = 1;
        public static final int AUTO = 2;
        public static final int FLASH = 3;
    }

    static @interface AndroidMeteringMode {
        public static final int NOT_SET = 0;
        public static final int NONE = 1;
        public static final int FIXED = 2;
        public static final int SINGLE_SHOT = 3;
        public static final int CONTINUOUS = 4;
    }

    static @interface VideoFacingMode {
        public static final int MEDIA_VIDEO_FACING_NONE = 0;
        public static final int MEDIA_VIDEO_FACING_USER = 1;
        public static final int MEDIA_VIDEO_FACING_ENVIRONMENT = 2;
        public static final int NUM_MEDIA_VIDEO_FACING_MODES = 3;
    }
}

