/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.NV21Buffer;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.rtc2.video.CoordinatesTransform;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=15)
public class VideoCaptureCamera1
extends VideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera1.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private static final int NUM_CAPTURE_BUFFERS = 3;
    private static final SparseArray<String> COLOR_TEMPERATURES_MAP = new SparseArray();
    private static int IMAGE_FORMAT;
    private int mExpectedFrameSize;
    private Camera.Area mAreaOfInterest;
    private Camera.Parameters mPreviewParameters;
    @Nullable
    private Camera mCamera;
    private ReentrantLock mPreviewBufferLock = new ReentrantLock();
    private final Object mLock = new Object();
    private boolean mIsRunning;
    private final Object mObjectLock = new Object();

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int id) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id, (Camera.CameraInfo)cameraInfo);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraInfo: Camera.getCameraInfo: " + ex.getMessage());
            return null;
        }
        return cameraInfo;
    }

    @Nullable
    private String getClosestWhiteBalance(int colorTemperature, List<String> supportedTemperatures) {
        int minDiff = Integer.MAX_VALUE;
        String matchedTemperature = null;
        for (int i = 0; i < COLOR_TEMPERATURES_MAP.size(); ++i) {
            int diff;
            if (!supportedTemperatures.contains(COLOR_TEMPERATURES_MAP.valueAt(i)) || (diff = Math.abs(colorTemperature - COLOR_TEMPERATURES_MAP.keyAt(i))) >= minDiff) continue;
            minDiff = diff;
            matchedTemperature = (String)COLOR_TEMPERATURES_MAP.valueAt(i);
        }
        return matchedTemperature;
    }

    static int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    static int getCaptureApiType(int id) {
        if (VideoCaptureCamera1.getCameraInfo(id) == null) {
            return 11;
        }
        return 6;
    }

    static int getFacingMode(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(id);
        if (cameraInfo == null) {
            return 0;
        }
        switch (cameraInfo.facing) {
            case 1: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 0;
    }

    @Nullable
    static String getName(int id) {
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(id);
        if (cameraInfo == null) {
            return null;
        }
        return "camera " + id + ", facing " + (cameraInfo.facing == 1 ? "front" : "back");
    }

    @Nullable
    static String getDeviceId(int id) {
        return Integer.toString(id);
    }

    @Nullable
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int id) {
        Camera camera;
        Logging.d(TAG, "getDeviceSupportedFormats() " + id);
        try {
            camera = Camera.open((int)id);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "Camera.open: " + ex.getMessage());
            return null;
        }
        if (camera == null) {
            return null;
        }
        Camera.Parameters parameters = null;
        try {
            parameters = camera.getParameters();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "Failed to get camera parameters " + id, ex);
        }
        List<VideoCaptureFormat> formatList = VideoCaptureCamera1.getFormatsFromParemeters(parameters, IMAGE_FORMAT);
        try {
            camera.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Failed to release camera: " + id, e);
        }
        return formatList;
    }

    @NonNull
    private static List<VideoCaptureFormat> getFormatsFromParemeters(@Nullable Camera.Parameters parameters, int filterImageForamt) {
        Logging.d(TAG, "getFormatsFromParemeters() ");
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        if (parameters == null) {
            return formatList;
        }
        List pixelFormats = parameters.getSupportedPreviewFormats();
        if (pixelFormats == null || pixelFormats.isEmpty()) {
            Logging.d(TAG, "failed to getFormatsFromParemeters, preview formats null or empty");
            return formatList;
        }
        for (Integer previewFormat : pixelFormats) {
            if (previewFormat != filterImageForamt) continue;
            int pixelFormat = 17;
            ArrayList<int[]> listFpsRange = null;
            try {
                listFpsRange = parameters.getSupportedPreviewFpsRange();
            }
            catch (StringIndexOutOfBoundsException ex) {
                Logging.e(TAG, "Camera.Parameters.getSupportedPreviewFpsRange: " + ex.getMessage());
            }
            if (listFpsRange == null) {
                listFpsRange = new ArrayList<int[]>();
            }
            if (listFpsRange.size() == 0) {
                listFpsRange.add(new int[]{0, 0});
            }
            int maxFps = 0;
            for (int[] fpsRange : listFpsRange) {
                int fps = (fpsRange[1] + 999) / 1000;
                if (maxFps >= fps) continue;
                maxFps = fps;
            }
            List supportedSizes = parameters.getSupportedPreviewSizes();
            if (supportedSizes == null || supportedSizes.isEmpty()) continue;
            for (Camera.Size size : supportedSizes) {
                if (VideoCaptureCamera1.shouldExcludeSize(size.width, size.height)) continue;
                formatList.add(new VideoCaptureFormat(size.width, size.height, maxFps, pixelFormat));
            }
        }
        return formatList;
    }

    VideoCaptureCamera1(int id, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean pqFirst, EglBase.Context sharedContext) {
        super(id, nativeVideoCaptureAndroid, captureToTexture, pqFirst, sharedContext);
    }

    @Override
    public boolean allocate(@NonNull VideoCaptureFormat req) {
        Logging.d(TAG, String.format(Locale.US, "allocate: requested (%d x %d) @%dfps", req.getWidth(), req.getHeight(), req.getFramerate()));
        if (this.mSurfaceTextureHelper == null) {
            Logging.e(TAG, "surfaceTextureHelper null");
            return false;
        }
        try {
            this.mCamera = Camera.open((int)this.mId);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "allocate: Camera.open: " + ex.getMessage());
            return false;
        }
        Camera.CameraInfo cameraInfo = VideoCaptureCamera1.getCameraInfo(this.mId);
        if (cameraInfo == null) {
            Logging.e(TAG, "failed to get camera info for " + this.mId);
            this.releaseCamera();
            return false;
        }
        this.mCameraNativeOrientation = cameraInfo.orientation;
        this.mInvertDeviceOrientationReadings = cameraInfo.facing == 0;
        Logging.d(TAG, String.format(Locale.US, "allocate: Rotation dev=%d, cam=%d, facing back? %s", this.getDeviceRotation(), this.mCameraNativeOrientation, this.mInvertDeviceOrientationReadings));
        Camera.Parameters parameters = null;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "failed to get camera parameters for " + this.mId, ex);
        }
        if (parameters == null) {
            Logging.e(TAG, "failed to get camera parameters");
            this.releaseCamera();
            return false;
        }
        List<VideoCaptureFormat> formatList = VideoCaptureCamera1.getFormatsFromParemeters(parameters, IMAGE_FORMAT);
        this.mCaptureFormat = VideoCaptureCamera1.FindBestMatchedCapability(formatList, req);
        if (this.mCaptureFormat == null) {
            Logging.e(TAG, "failed to match capability");
            this.releaseCamera();
            return false;
        }
        int frameRate = this.mCaptureFormat.mFramerate;
        if (this.mPQFirst) {
            this.setPreviewFrameRateModePQ(parameters, frameRate);
        } else {
            this.setPreviewFrameRateModeFPS(parameters, frameRate);
        }
        if (parameters.isVideoStabilizationSupported()) {
            Logging.d(TAG, "Image stabilization supported, currently: " + parameters.getVideoStabilization() + ", setting it.");
            parameters.setVideoStabilization(true);
        } else {
            Logging.d(TAG, "Image stabilization not supported.");
        }
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else {
            Logging.d(TAG, "Continuous focus mode not supported.");
        }
        parameters.setPreviewSize(this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight);
        parameters.setPreviewFormat(this.mCaptureFormat.mPixelFormat);
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "setParameters: " + ex.getMessage());
            this.releaseCamera();
            return false;
        }
        this.mSurfaceTextureHelper.setTextureSize(this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight);
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException ex) {
            Logging.e(TAG, "allocate: " + ex.getMessage());
            this.releaseCamera();
            return false;
        }
        CrErrorCallback errorCallback = new CrErrorCallback();
        this.notifyInjector(errorCallback);
        this.mCamera.setErrorCallback((Camera.ErrorCallback)errorCallback);
        if (!this.mCaptureToTexture) {
            this.mExpectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
            for (int i = 0; i < 3; ++i) {
                byte[] buffer = new byte[this.mExpectedFrameSize];
                this.mCamera.addCallbackBuffer(buffer);
            }
        }
        this.mCamera.setDisplayOrientation(0);
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        Logging.d(TAG, "startCaptureMaybeAsync()");
        if (this.mCamera == null) {
            Logging.e(TAG, "startCaptureAsync: mCamera is null");
            return false;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (this.mIsRunning) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        if (this.mCaptureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.mCamera.startPreview();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "startCaptureAsync: Camera.startPreview: " + ex.getMessage());
            return false;
        }
        this.onFaceDetectionRequestChanged();
        this.mPreviewBufferLock.lock();
        try {
            this.onStarted();
            this.mIsRunning = true;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        return true;
    }

    private void setPreviewFrameRateModePQ(Camera.Parameters parameters, int frameRate) {
        List supportedRates = parameters.getSupportedPreviewFrameRates();
        if (supportedRates == null || supportedRates.size() == 0) {
            Logging.w(TAG, "allocate: camera don't supported PQ first.");
            this.setPreviewFrameRateModeFPS(parameters, frameRate);
        } else {
            int diff = Math.abs((Integer)supportedRates.get(0) - frameRate);
            int closedFps = (Integer)supportedRates.get(0);
            for (Integer supportedRate : supportedRates) {
                int diffTemp = Math.abs(supportedRate - frameRate);
                if (diffTemp >= diff) continue;
                diff = diffTemp;
                closedFps = supportedRate;
            }
            parameters.setPreviewFrameRate(closedFps);
            Logging.d(TAG, String.format(Locale.US, "allocate: matched (%d x %d) @%d, PQ first", this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, closedFps));
        }
    }

    private void setPreviewFrameRateModeFPS(Camera.Parameters parameters, int frameRate) {
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange == null || listFpsRange.size() == 0) {
            Logging.w(TAG, "allocate: camera don't supported fps first.");
            parameters.setPreviewFrameRate(frameRate);
        } else {
            int fpsUnitFactor = ((int[])listFpsRange.get(0))[0] > 1000 ? 1 : 1000;
            ArrayList<VideoCapture.FramerateRange> framerateRanges = new ArrayList<VideoCapture.FramerateRange>(listFpsRange.size());
            for (int[] range : listFpsRange) {
                framerateRanges.add(new VideoCapture.FramerateRange(range[0] * fpsUnitFactor, range[1] * fpsUnitFactor));
            }
            VideoCapture.FramerateRange aeFramerateRange = VideoCaptureCamera1.findBestFrameRateRange(framerateRanges, frameRate * 1000, false);
            if (aeFramerateRange != null) {
                parameters.setPreviewFpsRange(aeFramerateRange.min / fpsUnitFactor, aeFramerateRange.max / fpsUnitFactor);
                Logging.d(TAG, String.format(Locale.US, "allocate: matched (%d x %d) @[%d - %d], fps first", this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, aeFramerateRange.min / fpsUnitFactor, aeFramerateRange.max / fpsUnitFactor));
            }
        }
    }

    private void onFaceDetectionRequestChanged() {
        if (this.mEnableAutoFaceFocus && this.isAutoFaceFocusSupported()) {
            Logging.d(TAG, "startFaceDetection for auto focus enabled");
            Camera.FaceDetectionListener listener = new Camera.FaceDetectionListener(){
                private long mLastFocusedTs;

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    if (VideoCaptureCamera1.this.mEnableFaceDetection) {
                        VideoCaptureCamera1.this.notifyFaceDetection(faces);
                    }
                    if (faces == null || faces.length == 0 || camera == null || !VideoCaptureCamera1.this.mEnableAutoFaceFocus) {
                        return;
                    }
                    if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                        if (faces[0].score > 20) {
                            VideoCaptureCamera1.this.notifyCameraFocusAreaChanged(faces[0].rect);
                        }
                        return;
                    }
                    if (faces[0].score <= 50) {
                        Logging.d(TAG, "face score = " + faces[0].score);
                        return;
                    }
                    try {
                        ArrayList<Camera.Area> focusList = new ArrayList<Camera.Area>();
                        Camera.Area firstFace = new Camera.Area(faces[0].rect, 1000);
                        focusList.add(firstFace);
                        if (camera.getParameters().getMaxNumFocusAreas() > 0) {
                            camera.getParameters().setFocusAreas(focusList);
                        }
                        if (camera.getParameters().getMaxNumMeteringAreas() > 0) {
                            camera.getParameters().setMeteringAreas(focusList);
                        }
                        VideoCaptureCamera1.this.notifyCameraFocusAreaChanged(faces[0].rect);
                        camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                Logging.d(TAG, "auto face focus called api1 every 3 seconds");
                                try {
                                    if (camera != null) {
                                        camera.cancelAutoFocus();
                                    }
                                }
                                catch (RuntimeException e) {
                                    Logging.w(TAG, "Exception in cancelAutoFocus: " + Log.getStackTraceString((Throwable)e));
                                }
                            }
                        });
                        this.mLastFocusedTs = System.currentTimeMillis();
                    }
                    catch (RuntimeException e) {
                        Logging.w(TAG, "Exception in onFaceDetection callback: " + Log.getStackTraceString((Throwable)e));
                    }
                }
            };
            this.safetyStarFaceDetection(listener);
        } else if (this.mEnableFaceDetection && this.isFaceDetectSupported()) {
            Camera.FaceDetectionListener listener = new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    if (VideoCaptureCamera1.this.mEnableFaceDetection) {
                        VideoCaptureCamera1.this.notifyFaceDetection(faces);
                    }
                }
            };
            Logging.d(TAG, "startFaceDetection for face dectect enabled");
            this.safetyStarFaceDetection(listener);
        } else {
            this.safetyStopFaceDetection();
        }
    }

    private void safetyStarFaceDetection(Camera.FaceDetectionListener listener) {
        block4: {
            Logging.d(TAG, "facedetect: " + this.mEnableFaceDetection);
            try {
                if (this.mCamera != null) {
                    if (this.mIsFaceDetectionStarted) {
                        this.mCamera.stopFaceDetection();
                    }
                    this.mCamera.setFaceDetectionListener(listener);
                    this.mCamera.startFaceDetection();
                    this.mIsFaceDetectionStarted = true;
                }
            }
            catch (RuntimeException e) {
                Logging.e(TAG, "Failed to stop face detection", e);
                if (this.mCamera == null) break block4;
                this.mCamera.setFaceDetectionListener(null);
            }
        }
    }

    private void safetyStopFaceDetection() {
        Logging.d(TAG, "stopFaceDetection()");
        try {
            if (this.mIsFaceDetectionStarted) {
                if (this.mCamera != null) {
                    this.mCamera.stopFaceDetection();
                }
                this.mIsFaceDetectionStarted = false;
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Failed to stop face detection", e);
        }
        finally {
            if (this.mCamera != null) {
                this.mCamera.setFaceDetectionListener(null);
            }
        }
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        Logging.d(TAG, "stopCaptureAndBlockUntilStopped()");
        if (this.mCamera == null) {
            Logging.e(TAG, "stopCaptureAndBlockUntilStopped: mCamera is null");
            return;
        }
        this.mPreviewBufferLock.lock();
        try {
            if (!this.mIsRunning) {
                return;
            }
            this.mIsRunning = false;
        }
        finally {
            this.mPreviewBufferLock.unlock();
        }
        this.safetyStopFaceDetection();
        if (this.mCaptureToTexture) {
            if (this.mSurfaceTextureHelper != null) {
                this.mSurfaceTextureHelper.stopListening();
            }
        } else {
            this.mCamera.setPreviewCallbackWithBuffer(null);
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception e) {
            Logging.e(TAG, "stopPreview got exception:" + e.toString());
        }
    }

    @Override
    public boolean needFallback() {
        return false;
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.getCameraParameters();
            return this.isZoomSupported(parameters);
        }
        return false;
    }

    @Override
    public int setZoom(float zoomValue) {
        Camera.Parameters parameters;
        if (zoomValue < 0.0f || this.mCamera == null) {
            return -1;
        }
        int zoomRatio = (int)(zoomValue * 100.0f + 0.5f);
        List<Integer> zoomRatios = this.getZoomRatios();
        if (zoomRatios == null) {
            return -1;
        }
        int zoomLevel = 0;
        for (int i = 0; i < zoomRatios.size(); ++i) {
            int temp = zoomRatios.get(i);
            if (zoomRatio > temp) continue;
            zoomLevel = i;
            break;
        }
        if (!this.isZoomSupported(parameters = this.getCameraParameters())) {
            return -1;
        }
        int maxZoom = parameters.getMaxZoom();
        if (zoomLevel > maxZoom) {
            Logging.w(TAG, "zoom value is larger than maxZoom value");
            return -1;
        }
        parameters.setZoom(zoomLevel);
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (Exception e) {
            Logging.w(TAG, "setParameters failed, zoomLevel: " + zoomLevel + ", " + e);
            return -1;
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mCamera != null) {
            List<Integer> zoomRatios;
            Camera.Parameters parameters = this.getCameraParameters();
            int maxZoom = 0;
            if (this.isZoomSupported(parameters)) {
                maxZoom = parameters.getMaxZoom();
            }
            if ((zoomRatios = this.getZoomRatios()) != null && zoomRatios.size() > maxZoom) {
                return (float)zoomRatios.get(maxZoom).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    @Override
    public boolean isFocusSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera1.isSupported("auto", parameters.getSupportedFocusModes());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setFocus(float x, float y) {
        Logging.d(TAG, "setFocus called camera api1");
        if (this.mCamera == null) {
            return -1;
        }
        if (x < 0.0f || x > (float)this.mRenderView.getWidth() || y < 0.0f || y > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null) {
            return -1;
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(x, y, x, y), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        x = startRect.left;
        y = startRect.top;
        Rect focusRect = CoordinatesTransform.calculateFocusArea(x, y, 1.0f);
        Rect meteringRect = CoordinatesTransform.calculateFocusArea(x, y, 1.5f);
        RectF temp = CoordinatesTransform.cameraToNormalized(new RectF(meteringRect));
        if ((temp = CoordinatesTransform.normalizedToSensor(temp, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, 0, false)) == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        temp.round(meteringRect);
        Log.w((String)TAG, (String)("mCamera.autoFocus focusRect: " + focusRect + ", meteringRect: " + meteringRect));
        try {
            this.mCamera.cancelAutoFocus();
        }
        catch (RuntimeException e) {
            Logging.w(TAG, "Failed to cancle AutoFocus" + e);
        }
        Camera.Parameters params = this.getCameraParameters();
        if (params == null) {
            return -1;
        }
        if (params.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Logging.w(TAG, "focus areas not supported");
        }
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Logging.w(TAG, "metering areas not supported");
        }
        final String currentFocusMode = params.getFocusMode();
        if (VideoCaptureCamera1.isSupported("macro", params.getSupportedFocusModes())) {
            params.setFocusMode("macro");
            Object object = this.mObjectLock;
            synchronized (object) {
                try {
                    this.mCamera.setParameters(params);
                }
                catch (Exception e) {
                    Logging.w(TAG, "mCamera.setParameters Exception: " + e);
                }
            }
        }
        Logging.w("focus", "FOCUS_MODE_MACRO is not supported");
        try {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAutoFocus(boolean success, Camera camera) {
                    if (VideoCaptureCamera1.this.mCamera == null) {
                        return;
                    }
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    Object object = VideoCaptureCamera1.this.mObjectLock;
                    synchronized (object) {
                        try {
                            camera.setParameters(params);
                        }
                        catch (Exception e) {
                            Logging.w(TAG, "mCamera setParameters Exception: " + e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.w(TAG, "mCamera.autoFocus Exception: " + e);
            return -1;
        }
        Rect rect = new Rect();
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(meteringRect), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, false);
        translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        translated = CoordinatesTransform.cameraToNormalized(new RectF(focusRect));
        translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (translated == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraFocusAreaChanged(rect);
        return 0;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCaptureCamera1.isSupported("auto", parameters.getSupportedFocusModes());
        }
        return false;
    }

    @Override
    public int setAutoFaceFocus(boolean enable) {
        if (this.mEnableAutoFaceFocus == enable) {
            return 0;
        }
        this.mEnableAutoFaceFocus = enable;
        this.onFaceDetectionRequestChanged();
        return 0;
    }

    @Override
    public int setFaceDetection(boolean enable) {
        if (this.mEnableFaceDetection == enable) {
            return 0;
        }
        this.mEnableFaceDetection = enable;
        this.onFaceDetectionRequestChanged();
        return 0;
    }

    @Override
    public boolean isFaceDetectSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.getMaxNumDetectedFaces() > 0;
        }
        return false;
    }

    @Override
    public boolean isTorchSupported() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCaptureCamera1.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    @Override
    public int setTorchMode(boolean isOn) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            List supportedFlashModes = parameters.getSupportedFlashModes();
            if (supportedFlashModes != null && supportedFlashModes.contains("torch")) {
                if (isOn) {
                    parameters.setFlashMode("torch");
                } else {
                    parameters.setFlashMode("off");
                }
                this.mCamera.setParameters(parameters);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isExposureSupported() {
        Camera.Parameters parameters;
        boolean isExposureSupported = false;
        if (this.mCamera != null && (parameters = this.getCameraParameters()) != null) {
            isExposureSupported = parameters.getMaxNumMeteringAreas() > 0;
        }
        return isExposureSupported;
    }

    @Override
    public int setExposure(float positionXinView, float positionYinView) {
        Logging.v(TAG, "setExposure called camera api1 x = " + positionXinView + " y = " + positionYinView);
        if (this.mCamera == null) {
            Logging.d(TAG, "setExposure fucking null mCamera");
            return -1;
        }
        if (positionXinView < 0.0f || positionXinView > (float)this.mRenderView.getWidth() || positionYinView < 0.0f || positionYinView > (float)this.mRenderView.getHeight()) {
            Logging.d(TAG, "setExposure unreasonable inputs!");
            return -1;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null) {
            return -1;
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(positionXinView, positionYinView, positionXinView, positionYinView), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        positionXinView = startRect.left;
        positionYinView = startRect.top;
        Rect meteringRect = CoordinatesTransform.calculateFocusArea(positionXinView, positionYinView, 1.5f);
        RectF temp = CoordinatesTransform.cameraToNormalized(new RectF(meteringRect));
        if ((temp = CoordinatesTransform.normalizedToSensor(temp, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, 0, false)) == null) {
            Logging.e(TAG, "Failed to translate input coordinate");
            return -1;
        }
        temp.round(meteringRect);
        if (this.mCamera != null) {
            Camera.Parameters params = this.getCameraParameters();
            if (params == null) {
                Logging.d(TAG, "getCameraParameters null");
                return -1;
            }
            if (params.getMaxNumMeteringAreas() > 0) {
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(meteringRect, 800));
                params.setMeteringAreas(meteringAreas);
            } else {
                Logging.d(TAG, "metering areas not supported");
            }
            try {
                this.mCamera.setParameters(params);
                this.mCamera.startPreview();
            }
            catch (Exception e) {
                Logging.d(TAG, "setExposure failed, " + e);
                return -1;
            }
        }
        Rect rect = new Rect();
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(meteringRect), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, false);
        if ((translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode)) == null) {
            Logging.w(TAG, "failed to translate coordinate from normalized to view!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        Object object = this.mLock;
        synchronized (object) {
            Logging.d(TAG, "deallocate()");
            if (this.mCamera == null) {
                return;
            }
            this.stopCaptureAndBlockUntilStopped();
            try {
                if (this.mCamera != null) {
                    this.mCamera.setPreviewTexture(null);
                }
            }
            catch (Exception ex) {
                Logging.e(TAG, "deallocate: failed to setPreviewTexture " + ex.getMessage());
            }
            this.mCaptureFormat = null;
            this.releaseCamera();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCamera() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mCamera != null) {
                    this.mCamera.release();
                    this.mCamera = null;
                }
            }
            catch (Exception ex) {
                Logging.e(TAG, "releaseCamera: failed to release camera, " + ex.getMessage());
            }
        }
    }

    private void listenForTextureFrames() {
        if (this.mSurfaceTextureHelper == null) {
            return;
        }
        this.mSurfaceTextureHelper.startListening(new SurfaceTextureHelper.IVideoCapture(){

            @Override
            public void onFrame(VideoFrame frame) {
                VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                try {
                    if (!VideoCaptureCamera1.this.mIsRunning) {
                        return;
                    }
                    VideoFrame modifiedFrame = new VideoFrame(VideoCapture.createTextureBufferWithModifiedTransformMatrix((TextureBuffer)frame.getBuffer(), !VideoCaptureCamera1.this.mInvertDeviceOrientationReadings, 0), VideoCaptureCamera1.this.getCameraRotation(), frame.getTimestampNs());
                    VideoCaptureCamera1.this.attachPerFrameMetaInfos(modifiedFrame);
                    VideoCaptureCamera1.this.onFrameCaptured(modifiedFrame);
                    modifiedFrame.release();
                }
                finally {
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                }
            }

            @Override
            public void onFrameDropped(int dropReason) {
                VideoCaptureCamera1.super.onFrameDropped(dropReason);
            }
        });
    }

    private void listenForBytebufferFrames() {
        this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] data, final Camera camera) {
                VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                if (!VideoCaptureCamera1.this.mIsRunning) {
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                    return;
                }
                if (data.length == VideoCaptureCamera1.this.mExpectedFrameSize) {
                    long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                    NV21Buffer frameBuffer = new NV21Buffer(data, VideoCaptureCamera1.this.mCaptureFormat.getWidth(), VideoCaptureCamera1.this.mCaptureFormat.getHeight(), new Runnable(){

                        @Override
                        public void run() {
                            VideoCaptureCamera1.this.mPreviewBufferLock.lock();
                            if (!VideoCaptureCamera1.this.mIsRunning) {
                                VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                                return;
                            }
                            VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                            if (camera != null) {
                                VideoCaptureCamera1.this.mCamera.addCallbackBuffer(data);
                            }
                        }
                    });
                    VideoFrame frame = new VideoFrame(frameBuffer, VideoCaptureCamera1.this.getCameraRotation(), captureTimeNs);
                    VideoCaptureCamera1.this.attachPerFrameMetaInfos(frame);
                    VideoCaptureCamera1.this.onFrameCaptured(frame);
                    frame.release();
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                } else {
                    VideoCaptureCamera1.this.onFrameDropped(8);
                    VideoCaptureCamera1.this.mPreviewBufferLock.unlock();
                    if (camera != null) {
                        camera.addCallbackBuffer(data);
                    }
                }
            }
        });
    }

    public Camera.Parameters getCameraParameters() {
        Camera.Parameters parameters;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (RuntimeException ex) {
            Logging.e(TAG, "getCameraParameters: Camera.getParameters: ", ex);
            if (this.mCamera != null) {
                this.safetyStopFaceDetection();
                this.releaseCamera();
            }
            return null;
        }
        return parameters;
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.mCamera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean isZoomSupported = parameters.isZoomSupported();
            if (isZoomSupported) {
                return true;
            }
            Logging.w(TAG, "camera zoom is not supported!");
            return false;
        }
        return false;
    }

    private void notifyFaceDetection(Camera.Face[] faces) {
        ArrayList<RectF> rectArray = new ArrayList<RectF>();
        ArrayList<Double> distanceArray = new ArrayList<Double>();
        boolean numFaces = false;
        boolean isMirror = false;
        if (this.mId == 1) {
            isMirror = true;
        }
        this.mPreviewParameters = this.getCameraParameters();
        if (this.mPreviewParameters == null || this.mPreviewParameters.getPreviewSize() == null) {
            return;
        }
        for (Camera.Face face : faces) {
            RectF translated = CoordinatesTransform.cameraToNormalized(new RectF(face.rect));
            if (translated == null) continue;
            distanceArray.add(this.mId == 1 ? 11.237 * Math.pow(face.rect.height(), -0.958) : 14.719 * Math.pow(face.rect.height(), -0.971));
            translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mPreviewParameters.getPreviewSize().width, this.mPreviewParameters.getPreviewSize().height, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
            if (translated == null) {
                distanceArray.remove(distanceArray.size() - 1);
                continue;
            }
            rectArray.add(translated);
        }
        if (rectArray.isEmpty()) {
            return;
        }
        this.notifyFaceDetection(this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), rectArray, distanceArray);
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported != null && supported.indexOf(value) >= 0;
    }

    static {
        COLOR_TEMPERATURES_MAP.append(2850, (Object)"incandescent");
        COLOR_TEMPERATURES_MAP.append(2950, (Object)"warm-fluorescent");
        COLOR_TEMPERATURES_MAP.append(4250, (Object)"fluorescent");
        COLOR_TEMPERATURES_MAP.append(4600, (Object)"twilight");
        COLOR_TEMPERATURES_MAP.append(5500, (Object)"daylight");
        COLOR_TEMPERATURES_MAP.append(6000, (Object)"cloudy-daylight");
        COLOR_TEMPERATURES_MAP.append(7000, (Object)"shade");
        IMAGE_FORMAT = 17;
    }

    class CrErrorCallback
    implements Camera.ErrorCallback {
        CrErrorCallback() {
        }

        public void onError(int error, Camera camera) {
            if (error == 2 || error == 100 || error == 1) {
                VideoCaptureCamera1.this.deallocate();
                int cameraEvent = 901;
                if (error == 2) {
                    cameraEvent = 6;
                } else if (error == 100) {
                    cameraEvent = 5;
                }
                VideoCaptureCamera1.this.onError(cameraEvent, "Camera ErrorCallback id: " + error);
            }
        }
    }

    private static class BuggyDeviceHack {
        private static final String[] COLORSPACE_BUGGY_DEVICE_LIST = new String[]{"SAMSUNG-SGH-I747", "ODROID-U2", "XT1092", "XT1095", "XT1096", "XT1097"};

        private BuggyDeviceHack() {
        }

        static int getImageFormat() {
            return BuggyDeviceHack.isBuggyDevice() ? 17 : 842094169;
        }

        static boolean isBuggyDevice() {
            for (String buggyDevice : COLORSPACE_BUGGY_DEVICE_LIST) {
                if (!buggyDevice.contentEquals(Build.MODEL)) continue;
                return true;
            }
            return false;
        }
    }
}

