/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.rtc2.video.CoordinatesTransform;
import io.agora.rtc2.video.VideoCapture;
import io.agora.rtc2.video.VideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@TargetApi(value=23)
public class VideoCaptureCamera2
extends VideoCaptureCamera {
    private static final String TAG = VideoCaptureCamera2.class.getSimpleName();
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){
        private long mLastFocusedTs;

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            Long exposure_time_value = (Long)result.get(CaptureResult.SENSOR_EXPOSURE_TIME);
            if (exposure_time_value != null) {
                VideoCaptureCamera2.this.mLastExposureTimeNs = exposure_time_value;
            }
            if (VideoCaptureCamera2.this.mEnableAutoFaceFocus && VideoCaptureCamera2.this.isAutoFaceFocusSupported()) {
                this.process((CaptureResult)result);
            }
            if (VideoCaptureCamera2.this.mEnableFaceDetection) {
                this.notifyFaceDetection((Rect)result.get(CaptureResult.SCALER_CROP_REGION), (Face[])result.get(CaptureResult.STATISTICS_FACES));
            }
        }

        private void process(CaptureResult result) {
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            if (faces != null && faces.length > 0) {
                if (System.currentTimeMillis() - this.mLastFocusedTs < 3000L) {
                    if (faces[0].getScore() > 20) {
                        Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                        this.notifyCameraFocusAreaChanged(cropRegion, faces[0].getBounds());
                    }
                    return;
                }
                if (faces[0].getScore() <= 50) {
                    return;
                }
                Rect rect = VideoCaptureCamera2.this.clampFace(faces[0].getBounds());
                if (rect.width() <= 0 || rect.height() <= 0) {
                    return;
                }
                this.addRegionsToCaptureRequestBuilder(VideoCaptureCamera2.this.mPreviewRequestBuilder, new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
                if (VideoCaptureCamera2.this.mCameraState != 2) {
                    return;
                }
                try {
                    Rect cropRegion = (Rect)result.get(CaptureResult.SCALER_CROP_REGION);
                    Logging.d(TAG, "cropRegion = " + cropRegion);
                    Logging.d(TAG, "capture size wxh = " + VideoCaptureCamera2.this.mCaptureFormat.getWidth() + " x " + VideoCaptureCamera2.this.mCaptureFormat.getHeight());
                    this.notifyCameraFocusAreaChanged(cropRegion, rect);
                    VideoCaptureCamera2.this.mPreviewSession.capture(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, null);
                }
                catch (Exception ex) {
                    Logging.e(TAG, "capture: " + ex);
                    return;
                }
                VideoCaptureCamera2.this.createCaptureRequest();
                this.mLastFocusedTs = System.currentTimeMillis();
            }
        }

        private void notifyCameraFocusAreaChanged(Rect cropRegion, Rect faceRect) {
            RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(faceRect), cropRegion.width(), cropRegion.height(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, true);
            if ((translated = CoordinatesTransform.normalizedToView(translated, VideoCaptureCamera2.this.mRenderView.getWidth(), VideoCaptureCamera2.this.mRenderView.getHeight(), VideoCaptureCamera2.this.mCaptureFormat.getWidth(), VideoCaptureCamera2.this.mCaptureFormat.getHeight(), VideoCaptureCamera2.this.mId == 1, (VideoCaptureCamera2.this.mId == 1 ? 1 : -1) * VideoCaptureCamera2.this.getCameraRotation(), VideoCaptureCamera2.this.mRenderMode)) == null) {
                Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
                return;
            }
            Rect rect = new Rect();
            translated.round(rect);
            VideoCaptureCamera2.this.notifyCameraFocusAreaChanged(rect);
        }

        private void notifyFaceDetection(Rect cropRegion, Face[] faces) {
            ArrayList<RectF> rectArray = new ArrayList<RectF>();
            ArrayList<Double> distanceArray = new ArrayList<Double>();
            for (Face face : faces) {
                RectF translated = CoordinatesTransform.sensorToNormalized(new RectF(face.getBounds()), cropRegion.width(), cropRegion.height(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, true);
                if (translated == null) continue;
                distanceArray.add(VideoCaptureCamera2.this.mId == 1 ? 11.237 * Math.pow(translated.height(), -0.958) : 14.719 * Math.pow(translated.height(), -0.971));
                translated = CoordinatesTransform.normalizedToView(translated, VideoCaptureCamera2.this.mRenderView.getWidth(), VideoCaptureCamera2.this.mRenderView.getHeight(), VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, VideoCaptureCamera2.this.mId == 1, (VideoCaptureCamera2.this.mId == 1 ? 1 : -1) * VideoCaptureCamera2.this.getCameraRotation(), VideoCaptureCamera2.this.mRenderMode);
                if (translated == null) {
                    distanceArray.remove(distanceArray.size() - 1);
                    continue;
                }
                rectArray.add(translated);
            }
            if (rectArray.isEmpty()) {
                return;
            }
            VideoCaptureCamera2.this.notifyFaceDetection(VideoCaptureCamera2.this.mCaptureFormat.mWidth, VideoCaptureCamera2.this.mCaptureFormat.mHeight, rectArray, distanceArray);
        }

        private void addRegionsToCaptureRequestBuilder(CaptureRequest.Builder builder, MeteringRectangle[] regions) {
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            builder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)regions);
            builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)regions);
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        }
    };
    private CameraCaptureSession.CaptureCallback mAfCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (null == afState) {
                return;
            }
            if (4 == afState || 5 == afState) {
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                VideoCaptureCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                try {
                    VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(VideoCaptureCamera2.this.mPreviewRequestBuilder.build(), VideoCaptureCamera2.this.mCaptureCallback, VideoCaptureCamera2.this.mCameraThreadHandler);
                }
                catch (CameraAccessException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (SecurityException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    Logging.e(TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };
    private static int IMAGE_FORMAT = 35;
    private static final double kNanosecondsPerSecond = 1.0E9;
    private static final long kNanosecondsPer100Microsecond = 100000L;
    private static final String[] AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST = new String[]{"Pixel 3", "Pixel 3 XL"};
    private static final SparseIntArray COLOR_TEMPERATURES_MAP = new SparseIntArray();
    private final Object mCameraStateLock = new Object();
    @Nullable
    private CameraDevice mCameraDevice;
    @Nullable
    private CameraCaptureSession mPreviewSession;
    private CaptureRequest mPreviewRequest;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    @Nullable
    private Surface mSurface;
    private ImageReader mImageReader;
    private Handler mCameraThreadHandler;
    private ConditionVariable mWaitForDeviceClosedConditionVariable = new ConditionVariable();
    private Range<Integer> mAeFpsRange;
    private int mCameraState = 4;
    private float mMaxZoom = 1.0f;
    private Rect mCropRect = new Rect();
    private int mFocusMode = 4;
    private float mCurrentFocusDistance = 1.0f;
    private int mExposureMode = 4;
    private long mLastExposureTimeNs;
    private MeteringRectangle mAreaOfInterest;
    private int mExposureCompensation;
    private int mWhiteBalanceMode = 4;
    private int mColorTemperature = -1;
    private int mIso;
    private boolean mRedEyeReduction;
    private int mFillLightMode = 1;
    private boolean mTorch;
    private ThreadUtils.ThreadChecker mThreadChecker;
    private static final float ZOOM_UNSUPPORTED_DEFAULT_VALUE = 1.0f;
    private static final float DEFAULT_VALUE = -1.0f;
    private float mLastZoomRatio = -1.0f;
    private Rect mSensorRect = null;
    private boolean mFaceDetectSupported = false;
    private int mFaceDetectMode;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_LEGACY = 1;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_EXTERNAL = 2;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_LIMITED = 3;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_FULL = 4;
    static final int ANDROID_CAMERA_HARDWARE_LEVEL_3 = 5;
    static final int ANDROID_CAMERA_HARDWARE_NOT_SUPPORT = Integer.MIN_VALUE;
    static final SparseIntArray ANDROID_CAMERA_HARDWARE_LEVEL_MAP;

    Rect clampFace(Rect rect) {
        return new Rect(CoordinatesTransform.clamp(rect.left, 0, rect.right), CoordinatesTransform.clamp(rect.top, 0, rect.bottom), CoordinatesTransform.clamp(rect.right, 0, rect.right), CoordinatesTransform.clamp(rect.bottom, 0, rect.bottom));
    }

    static int getCamera2SupportedLevel(int index) {
        if (Build.VERSION.SDK_INT < 21) {
            return Integer.MIN_VALUE;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return Integer.MIN_VALUE;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(int index) {
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (index >= cameraIdList.length) {
                Logging.e(TAG, "Invalid camera Id: " + index);
                return null;
            }
            return manager.getCameraCharacteristics(cameraIdList[index]);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ex.getMessage());
        }
        catch (AssertionError ex) {
            Logging.e(TAG, "getCameraCharacteristics: " + ((Throwable)((Object)ex)).getMessage());
        }
        return null;
    }

    private void createPreviewObjectsAndStartPreviewOrFailWith(int androidVideoCaptureError) {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCaptureToTexture ? this.createTexturePreviewObjectsAndStartPreview() : this.createBufferPreviewObjectsAndStartPreview()) {
            return;
        }
        this.changeCameraStateAndNotify(4);
        this.onError(androidVideoCaptureError, "Error starting or restarting preview");
    }

    @Deprecated
    private boolean createBufferPreviewObjectsAndStartPreview() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCameraDevice == null) {
            return false;
        }
        this.mImageReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
        CrPreviewReaderListener imageReaderListener = new CrPreviewReaderListener();
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, this.mCameraThreadHandler);
        return this.createPreviewObjectsAndStartPreview(this.mImageReader.getSurface());
    }

    private boolean createTexturePreviewObjectsAndStartPreview() {
        this.mThreadChecker.checkIsOnValidThread();
        if (this.mCameraDevice == null || this.mSurfaceTextureHelper == null) {
            return false;
        }
        this.mSurfaceTextureHelper.setTextureSize(this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight());
        this.mSurface = new Surface(this.mSurfaceTextureHelper.getSurfaceTexture());
        TextureVideoSinkListener textureVideoSinkListener = new TextureVideoSinkListener();
        this.mSurfaceTextureHelper.startListening(textureVideoSinkListener);
        return this.createPreviewObjectsAndStartPreview(this.mSurface);
    }

    private boolean createPreviewObjectsAndStartPreview(Surface surface) {
        int[] stabilizationModes;
        try {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureRequest: " + ex.getMessage());
            return false;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.e(TAG, "mPreviewRequestBuilder error");
            return false;
        }
        this.mPreviewRequestBuilder.addTarget(surface);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.EDGE_MODE, (Object)1);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.e(TAG, "mPreviewRequestBuilder getCameraCharacteristics error");
            return false;
        }
        for (int mode : stabilizationModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) {
            if (mode != 1) continue;
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
            break;
        }
        this.configureCommonCaptureSettings(this.mPreviewRequestBuilder);
        if (this.mEnableFaceDetection) {
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
        }
        if (this.mFaceDetectSupported && (this.mEnableAutoFaceFocus || this.mEnableFaceDetection)) {
            this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
        }
        this.mPreviewRequest = this.mPreviewRequestBuilder.build();
        try {
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface), (CameraCaptureSession.StateCallback)new CrPreviewSessionListener(this.mPreviewRequest), null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "createCaptureSession: " + ex.getMessage());
            return false;
        }
        return true;
    }

    private void configureCommonCaptureSettings(CaptureRequest.Builder requestBuilder) {
        this.mThreadChecker.checkIsOnValidThread();
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (this.mFocusMode == 4) {
            requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            requestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
        } else if (this.mFocusMode == 2) {
            requestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            requestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            requestBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(1.0f / this.mCurrentFocusDistance));
        }
        if (this.mExposureMode == 1 || this.mExposureMode == 2) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            if (this.mLastExposureTimeNs != 0L) {
                requestBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)(this.mLastExposureTimeNs / 100000L));
            } else if (cameraCharacteristics != null) {
                Range range = (Range)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
                requestBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)(((Long)range.getLower() + ((Long)range.getUpper() + (Long)range.getLower()) / 2L) / 100000L));
            }
        } else {
            requestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            if (!VideoCaptureCamera2.shouldSkipSettingAeTargetFpsRange()) {
                requestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mAeFpsRange);
            }
        }
        if (this.mTorch) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)(this.mExposureMode == 4 ? 1 : 0));
            requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
        } else {
            switch (this.mFillLightMode) {
                case 1: {
                    requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 2: {
                    requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)(this.mRedEyeReduction ? 4 : 2));
                    break;
                }
                case 3: {
                    requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    requestBuilder.set(CaptureRequest.FLASH_MODE, (Object)1);
                    break;
                }
            }
            requestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
        }
        requestBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)this.mExposureCompensation);
        if (this.mWhiteBalanceMode == 4) {
            requestBuilder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
            requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
        } else if (this.mWhiteBalanceMode == 1) {
            requestBuilder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
            requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)0);
        } else if (this.mWhiteBalanceMode == 2) {
            requestBuilder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)true);
        }
        if (this.mColorTemperature > 0) {
            int colorSetting = -1;
            if (cameraCharacteristics != null) {
                colorSetting = VideoCaptureCamera2.getClosestWhiteBalance(this.mColorTemperature, (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES));
            }
            Logging.d(TAG, String.format(Locale.US, " Color temperature (%d ==> %d)", this.mColorTemperature, colorSetting));
            if (colorSetting != -1) {
                requestBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)colorSetting);
            }
        }
        if (this.mAreaOfInterest != null) {
            MeteringRectangle[] array = new MeteringRectangle[]{this.mAreaOfInterest};
            Logging.d(TAG, String.format(Locale.US, "Area of interest %s", this.mAreaOfInterest.toString()));
            requestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)array);
            requestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)array);
            requestBuilder.set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)array);
        }
        if (!this.mCropRect.isEmpty()) {
            requestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.mCropRect);
        }
        if (this.mIso > 0) {
            requestBuilder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)this.mIso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(int state) {
        Logging.d(TAG, "changeCameraStateAndNotify() " + state);
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = state;
            this.mCameraStateLock.notifyAll();
        }
    }

    private static boolean shouldSkipSettingAeTargetFpsRange() {
        for (String buggyDevice : AE_TARGET_FPS_RANGE_BUGGY_DEVICE_LIST) {
            if (!buggyDevice.contentEquals(Build.MODEL)) continue;
            return true;
        }
        return false;
    }

    private static int findInIntArray(int[] hayStack, int needle) {
        for (int i = 0; i < hayStack.length; ++i) {
            if (needle != hayStack[i]) continue;
            return i;
        }
        return -1;
    }

    private static int getClosestWhiteBalance(int colorTemperature, int[] supportedTemperatures) {
        int minDiff = Integer.MAX_VALUE;
        int matchedTemperature = -1;
        for (int i = 0; i < COLOR_TEMPERATURES_MAP.size(); ++i) {
            int diff;
            if (VideoCaptureCamera2.findInIntArray(supportedTemperatures, COLOR_TEMPERATURES_MAP.valueAt(i)) == -1 || (diff = Math.abs(colorTemperature - COLOR_TEMPERATURES_MAP.keyAt(i))) >= minDiff) continue;
            minDiff = diff;
            matchedTemperature = COLOR_TEMPERATURES_MAP.valueAt(i);
        }
        return matchedTemperature;
    }

    public static boolean isLegacyDevice(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
    }

    public static int getNumberOfCameras() {
        CameraManager manager = null;
        try {
            manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "getSystemService(Context.CAMERA_SERVICE): " + ex.getMessage());
            return 0;
        }
        if (manager == null) {
            return 0;
        }
        try {
            return manager.getCameraIdList().length;
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ex.getMessage());
            return 0;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ex.getMessage());
            return 0;
        }
        catch (AssertionError ex) {
            Logging.e(TAG, "getNumberOfCameras: getCameraIdList(): " + ((Throwable)((Object)ex)).getMessage());
            return 0;
        }
    }

    public static int getCaptureApiType(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return 11;
        }
        int supportedHWLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (supportedHWLevel == 2) {
            return 7;
        }
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean backwardCompatible = false;
        for (int cap : capabilities) {
            if (cap != 0) continue;
            backwardCompatible = true;
            break;
        }
        if (!backwardCompatible) {
            return 11;
        }
        switch (supportedHWLevel) {
            case 1: {
                return 8;
            }
            case 0: {
                return 9;
            }
        }
        return 7;
    }

    public static int getFacingMode(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return 0;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        switch (facing) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    @Nullable
    public static String getName(int index) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return null;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + index + ", facing " + (facing == 0 ? "front" : "back");
    }

    @Nullable
    static String getDeviceId(int index) {
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (index >= cameraIdList.length) {
                Logging.e(TAG, "Invalid camera index: " + index);
                return null;
            }
            return cameraIdList[index];
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "manager.getCameraIdList: " + (Object)((Object)ex));
            return null;
        }
    }

    @Nullable
    static List<VideoCaptureFormat> getDeviceSupportedFormats(int index) {
        Logging.d(TAG, "getDeviceSupportedFormats() " + index);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        if (cameraCharacteristics == null) {
            return null;
        }
        return VideoCaptureCamera2.getFormatsFromParemeters(cameraCharacteristics, IMAGE_FORMAT);
    }

    @NonNull
    private static List<VideoCaptureFormat> getFormatsFromParemeters(@NonNull CameraCharacteristics cameraCharacteristics, int filterImageForamt) {
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean minFrameDurationAvailable = false;
        for (int cap : capabilities) {
            if (cap != 1) continue;
            minFrameDurationAvailable = true;
            break;
        }
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        try {
            int[] formats;
            StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            for (int format : formats = streamMap.getOutputFormats()) {
                Size[] sizes;
                if (format != filterImageForamt || (sizes = streamMap.getOutputSizes(format)) == null) continue;
                for (Size size : sizes) {
                    long minFrameDurationInNanoseconds;
                    if (VideoCaptureCamera2.shouldExcludeSize(size.getWidth(), size.getHeight())) continue;
                    double minFrameRate = 0.0;
                    int defaultFPS = 30;
                    minFrameRate = minFrameDurationAvailable ? ((minFrameDurationInNanoseconds = streamMap.getOutputMinFrameDuration(format, size)) == 0L ? (double)defaultFPS : 1.0E9 / (double)minFrameDurationInNanoseconds) : (double)defaultFPS;
                    formatList.add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), (int)minFrameRate, format));
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to catch device supported video formats: ", e);
        }
        return formatList;
    }

    VideoCaptureCamera2(int index, long nativeVideoCaptureAndroid, boolean captureToTexture, boolean pqFirst, EglBase.Context sharedContext) {
        super(index, nativeVideoCaptureAndroid, captureToTexture, pqFirst, sharedContext);
        HandlerThread thread = new HandlerThread("VideoCaptureCamera2_CameraThread");
        thread.start();
        this.mCameraThreadHandler = new Handler(thread.getLooper());
        this.mThreadChecker = new ThreadUtils.ThreadChecker((Thread)thread);
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(index);
        this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
    }

    Handler getCameraThreadHandler() {
        return this.mCameraThreadHandler;
    }

    public void finalize() {
        this.mCameraThreadHandler.getLooper().quit();
    }

    @Override
    public boolean needFallback() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocate(@NonNull VideoCaptureFormat req) {
        Logging.d(TAG, String.format(Locale.US, "allocate: requested (%d x %d) @%dfps", req.getWidth(), req.getHeight(), req.getFramerate()));
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == 0 || this.mCameraState == 1) {
                Logging.e(TAG, "allocate() invoked while Camera is busy opening/configuring.");
                return false;
            }
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.e(TAG, "failed to getCameraCharacteristics.");
            return false;
        }
        List<VideoCaptureFormat> formatList = VideoCaptureCamera2.getFormatsFromParemeters(cameraCharacteristics, IMAGE_FORMAT);
        Logging.d(TAG, "format list: " + Arrays.toString(formatList.toArray()));
        this.mCaptureFormat = VideoCaptureCamera2.FindBestMatchedCapability(formatList, req);
        if (this.mCaptureFormat == null) {
            Logging.e(TAG, "failed to match capability");
            return false;
        }
        List<Object> fpsRanges = Arrays.asList((Object[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
        Logging.d(TAG, "fpsRanges: " + Arrays.toString(fpsRanges.toArray()));
        if (fpsRanges.isEmpty()) {
            Logging.e(TAG, "No supported framerate ranges.");
            return false;
        }
        ArrayList<VideoCapture.FramerateRange> framerateRanges = new ArrayList<VideoCapture.FramerateRange>(fpsRanges.size());
        int fpsUnitFactor = (Integer)((Range)fpsRanges.get(0)).getUpper() > 1000 ? 1 : 1000;
        for (Range range : fpsRanges) {
            framerateRanges.add(new VideoCapture.FramerateRange((Integer)range.getLower() * fpsUnitFactor, (Integer)range.getUpper() * fpsUnitFactor));
        }
        VideoCapture.FramerateRange aeFramerateRange = VideoCaptureCamera2.findBestFrameRateRange(framerateRanges, this.mCaptureFormat.getFramerate() * 1000, this.mPQFirst);
        if (aeFramerateRange == null) {
            Logging.e(TAG, "No matched framerate ranges.");
            return false;
        }
        this.mAeFpsRange = new Range((Comparable)Integer.valueOf(aeFramerateRange.min / fpsUnitFactor), (Comparable)Integer.valueOf(aeFramerateRange.max / fpsUnitFactor));
        Logging.d(TAG, String.format(Locale.US, "allocate: matched (%d x %d) @[%d - %d]", this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mAeFpsRange.getLower(), this.mAeFpsRange.getUpper()));
        this.mCameraNativeOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mInvertDeviceOrientationReadings = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        Integer maxFDCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        if (nArray != null && nArray.length > 1 && maxFDCount != null && maxFDCount > 0) {
            this.mFaceDetectSupported = true;
            int modeSum = 0;
            for (int fdMode : nArray) {
                modeSum += fdMode;
            }
            this.mFaceDetectMode = modeSum % 2 != 0 ? 1 : 2;
        }
        Logging.d(TAG, "allocate() face detection: " + this.mFaceDetectMode + " " + maxFDCount + " " + this.mFaceDetectSupported);
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        Logging.d(TAG, "startCaptureMaybeAsync() ");
        this.changeCameraStateAndNotify(0);
        CameraManager manager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        CrStateListener stateListener = new CrStateListener();
        this.notifyInjector((Object)stateListener);
        try {
            String[] cameraIdList = manager.getCameraIdList();
            if (this.mId >= cameraIdList.length) {
                Logging.e(TAG, "Invalid camera Id: " + this.mId);
                return false;
            }
            manager.openCamera(cameraIdList[this.mId], (CameraDevice.StateCallback)stateListener, this.mCameraThreadHandler);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "allocate: manager.openCamera: " + ex.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCaptureAndBlockUntilStopped() {
        Logging.d(TAG, "stopCaptureAndBlockUntilStopped()");
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != 2 && this.mCameraState != 4 && this.mCameraState != 3) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException ex) {
                    Logging.e(TAG, "CaptureStartedEvent: " + ex.getMessage());
                }
            }
            if (this.mCameraState == 4) {
                return;
            }
        }
        if (this.mSurfaceTextureHelper != null) {
            this.mSurfaceTextureHelper.stopListening();
        }
        this.mCameraThreadHandler.post((Runnable)new StopCaptureTask());
        this.mWaitForDeviceClosedConditionVariable.block();
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mPerFrameFaceDetectionInfoQueue.clear();
    }

    @Override
    public void deallocate() {
        Logging.d(TAG, "deallocate()");
    }

    @Override
    public boolean isZoomSupported() {
        if (this.mMaxZoom > 1.0f) {
            return true;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        return this.mMaxZoom > 1.0f;
    }

    @Override
    public int setZoom(float zoomValue) {
        boolean needZoom;
        Logging.d(TAG, "setCameraZoom api2 called zoomValue =" + zoomValue);
        if (this.mPreviewRequestBuilder == null) {
            Logging.d(TAG, "setZoom mPreviewRequestBuilder is null");
            return -1;
        }
        if (this.mSensorRect == null) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
            if (cameraCharacteristics == null) {
                Logging.w(TAG, "warning cameraCharacteristics is null");
                return -1;
            }
            this.mSensorRect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        if (Math.abs(this.mMaxZoom - 1.0f) < 0.001f) {
            Logging.w(TAG, "Camera " + this.mId + " does not support camera zoom");
            return -1;
        }
        boolean bl = needZoom = zoomValue >= 1.0f && zoomValue <= this.mMaxZoom && zoomValue != this.mLastZoomRatio;
        if (!needZoom) {
            return -2;
        }
        Rect zoomRect = this.cropRegionForZoom(zoomValue);
        this.mPreviewRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomRect);
        this.mLastZoomRatio = zoomValue;
        if (this.mPreviewSession != null) {
            try {
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -3;
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -4;
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -4;
            }
        }
        return 0;
    }

    @Override
    public float getMaxZoom() {
        if (this.mMaxZoom <= 1.0f) {
            CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
            this.mMaxZoom = VideoCaptureCamera2.getMaxZoom(cameraCharacteristics);
        }
        return this.mMaxZoom;
    }

    @Override
    public boolean isFocusSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int setFocus(float valX, float valY) {
        Logging.d(TAG, "setFocus " + valX + " - " + valY);
        if (valX < 0.0f || valX > (float)this.mRenderView.getWidth() || valY < 0.0f || valY > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set focus unreasonable inputs");
            return -1;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.d(TAG, "setFocus mPreviewRequestBuilder is null");
            return -1;
        }
        Rect cropRegion = (Rect)this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        int cropWidth = cropRegion.width();
        int cropHeight = cropRegion.height();
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(valX, valY, valX, valY), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.d(TAG, "setFocus coordinate " + valX + " - " + valY + " out of image bounds!!");
            return -1;
        }
        float tempX = startRect.left;
        float tempY = startRect.top;
        float tapAreaRatio = 0.1f;
        RectF rectf = new RectF();
        rectf.left = CoordinatesTransform.clamp(tempX - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.right = CoordinatesTransform.clamp(tempX + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.top = CoordinatesTransform.clamp(tempY - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.bottom = CoordinatesTransform.clamp(tempY + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        startRect = CoordinatesTransform.normalizedToSensor(rectf, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, cropWidth, cropHeight, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), true);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        Rect rect = new Rect();
        if (startRect.width() == 0.0f || startRect.height() == 0.0f) {
            rect = new Rect(0, 0, 0, 0);
        } else {
            startRect.round(rect);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mCameraThreadHandler != null) {
            if (this.mPreviewSession != null) {
                try {
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mAfCaptureCallback, this.mCameraThreadHandler);
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                    return -1;
                }
            }
            RectF translated = CoordinatesTransform.sensorToNormalized(startRect, cropWidth, cropHeight, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, true);
            if ((translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode)) == null) {
                Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
                return -1;
            }
            translated.round(rect);
            this.notifyCameraFocusAreaChanged(rect);
        }
        return 0;
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        if (!this.isFocusSupported()) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer maxFaceCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return maxFaceCount != null && maxFaceCount > 0;
    }

    @Override
    public int setAutoFaceFocus(final boolean enable) {
        this.mCameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureCamera2.this.setAutoFaceFocusInternal(enable);
            }
        });
        return 0;
    }

    private void setAutoFaceFocusInternal(boolean enable) {
        if (this.mEnableAutoFaceFocus == enable) {
            Logging.w(TAG, "face detect no change");
            return;
        }
        this.mEnableAutoFaceFocus = enable;
        if (!this.mFaceDetectSupported) {
            Logging.w(TAG, "face detect not supported");
            return;
        }
        if (this.mCameraThreadHandler != null && this.mPreviewRequestBuilder != null) {
            if (this.mEnableAutoFaceFocus) {
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
            } else {
                if (this.mEnableFaceDetection) {
                    Logging.w(TAG, "face detect did not turn off due to faceDistance on");
                    return;
                }
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
            }
            if (this.mPreviewSession != null) {
                try {
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                    return;
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
            }
        }
    }

    @Override
    public int setFaceDetection(final boolean enable) {
        this.mCameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCaptureCamera2.this.setFaceDetectionInternal(enable);
            }
        });
        return 0;
    }

    private void setFaceDetectionInternal(boolean enable) {
        if (this.mEnableFaceDetection == enable) {
            Logging.w(TAG, "face detect no change");
            return;
        }
        this.mEnableFaceDetection = enable;
        if (!this.mFaceDetectSupported) {
            Logging.w(TAG, "face detect not supported");
            return;
        }
        if (this.mCameraThreadHandler != null && this.mPreviewRequestBuilder != null) {
            if (this.mEnableFaceDetection) {
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.mFaceDetectMode);
            } else {
                if (this.mEnableAutoFaceFocus) {
                    Logging.w(TAG, "face detect did not turn off due to autoFocus on");
                    return;
                }
                this.mPreviewRequestBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.mPerFrameFaceDetectionInfoQueue.clear();
            }
            if (this.mPreviewSession != null) {
                try {
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mCameraThreadHandler);
                    return;
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isFaceDetectSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Integer maxFaceCount = (Integer)cameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT);
        return maxFaceCount != null && maxFaceCount > 0;
    }

    @Override
    public boolean isTorchSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        return available == null ? false : available;
    }

    @Override
    public int setTorchMode(boolean isOn) {
        boolean isFlashSupported;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.w(TAG, "warning mPreviewRequestBuilder is null");
            return -1;
        }
        Boolean available = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        boolean bl = isFlashSupported = available == null ? false : available;
        if (isFlashSupported) {
            if (isOn) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            if (this.mPreviewSession != null) {
                try {
                    this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), null, this.mCameraThreadHandler);
                    this.mTorch = isOn;
                    return 0;
                }
                catch (CameraAccessException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalStateException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    ThrowableExtension.printStackTrace((Throwable)e);
                }
            }
        } else {
            Logging.w(TAG, "flash is not supported");
        }
        return -1;
    }

    @Override
    public boolean isExposureSupported() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mId);
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return false;
        }
        int[] availableModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (availableModes != null) {
            for (int i = 0; i < availableModes.length; ++i) {
                Logging.d(TAG, "isExposureSupported AE mode = " + availableModes[i]);
                if (1 != i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int setExposure(float positionXinView, float positionYinView) {
        Logging.d(TAG, "setExposure called camera api2");
        if (positionXinView < 0.0f || positionXinView > (float)this.mRenderView.getWidth() || positionYinView < 0.0f || positionYinView > (float)this.mRenderView.getHeight()) {
            Logging.e(TAG, "set exposure unreasonable inputs");
            return -1;
        }
        if (this.mPreviewRequestBuilder == null) {
            Logging.w(TAG, "setExposure mPreviewBuilder is null");
            return -1;
        }
        Rect cropRegion = (Rect)this.mPreviewRequestBuilder.get(CaptureRequest.SCALER_CROP_REGION);
        if (cropRegion == null) {
            return -1;
        }
        RectF startRect = CoordinatesTransform.viewToNormalized(new RectF(positionXinView, positionYinView, positionXinView, positionYinView), this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode);
        if (startRect == null) {
            Logging.d(TAG, "setExposure coordinate " + positionXinView + " - " + positionYinView + " out of image bounds!!");
            return -1;
        }
        float tempX = startRect.left;
        float tempY = startRect.top;
        float tapAreaRatio = 0.1f;
        RectF rectf = new RectF();
        rectf.left = CoordinatesTransform.clamp(tempX - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.right = CoordinatesTransform.clamp(tempX + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.top = CoordinatesTransform.clamp(tempY - tapAreaRatio / 2.0f, 0.0f, 1.0f);
        rectf.bottom = CoordinatesTransform.clamp(tempY + tapAreaRatio / 2.0f, 0.0f, 1.0f);
        startRect = CoordinatesTransform.normalizedToSensor(rectf, this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, cropRegion.width(), cropRegion.height(), (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), true);
        if (startRect == null) {
            Logging.w(TAG, "Failed to translate input coordinate");
            return -1;
        }
        Rect rect = new Rect();
        if (startRect.width() == 0.0f || startRect.height() == 0.0f) {
            rect = new Rect(0, 0, 0, 0);
        } else {
            startRect.round(rect);
        }
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{new MeteringRectangle(rect, 1000)});
        this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        if (this.mPreviewSession != null) {
            try {
                this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), null, null);
            }
            catch (CameraAccessException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
                return -1;
            }
        }
        RectF translated = CoordinatesTransform.sensorToNormalized(new RectF((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom), cropRegion.width(), cropRegion.height(), this.mCaptureFormat.mWidth, this.mCaptureFormat.mHeight, true);
        if ((translated = CoordinatesTransform.normalizedToView(translated, this.mRenderView.getWidth(), this.mRenderView.getHeight(), this.mCaptureFormat.getWidth(), this.mCaptureFormat.getHeight(), this.mId == 1, (this.mId == 1 ? 1 : -1) * this.getCameraRotation(), this.mRenderMode)) == null) {
            Logging.w(TAG, "Failed to translate coordinate from normalized to view!!");
            return -1;
        }
        translated.round(rect);
        this.notifyCameraExposureAreaChanged(rect);
        return 0;
    }

    private static float getMaxZoom(CameraCharacteristics cameraCharacteristics) {
        if (cameraCharacteristics == null) {
            Logging.w(TAG, "warning cameraCharacteristics is null");
            return -1.0f;
        }
        Float maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            Logging.w(TAG, "warning get max zoom return null");
            return -1.0f;
        }
        return maxZoom.floatValue();
    }

    private Rect cropRegionForZoom(float ratio) {
        int xCenter = this.mSensorRect.width() / 2;
        int yCenter = this.mSensorRect.height() / 2;
        int xDelta = (int)(0.5f * (float)this.mSensorRect.width() / ratio);
        int yDelta = (int)(0.5f * (float)this.mSensorRect.height() / ratio);
        return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
    }

    private int createCaptureRequest() {
        try {
            this.mPreviewSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, null);
        }
        catch (CameraAccessException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -1;
        }
        catch (IllegalArgumentException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -2;
        }
        catch (SecurityException ex) {
            Logging.e(TAG, "setRepeatingRequest: ", ex);
            return -3;
        }
        catch (IllegalStateException ex) {
            Logging.e(TAG, "capture:" + ex);
            return -4;
        }
        return 0;
    }

    static {
        COLOR_TEMPERATURES_MAP.append(2850, 2);
        COLOR_TEMPERATURES_MAP.append(2950, 4);
        COLOR_TEMPERATURES_MAP.append(4250, 3);
        COLOR_TEMPERATURES_MAP.append(4600, 7);
        COLOR_TEMPERATURES_MAP.append(5000, 5);
        COLOR_TEMPERATURES_MAP.append(6000, 6);
        COLOR_TEMPERATURES_MAP.append(7000, 8);
        ANDROID_CAMERA_HARDWARE_LEVEL_MAP = new SparseIntArray();
        if (Build.VERSION.SDK_INT >= 21) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(2, 1);
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(0, 3);
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(1, 4);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(4, 2);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ANDROID_CAMERA_HARDWARE_LEVEL_MAP.append(3, 5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface CameraState {
        public static final int OPENING = 0;
        public static final int CONFIGURING = 1;
        public static final int STARTED = 2;
        public static final int EVICTED = 3;
        public static final int STOPPED = 4;
    }

    private class StopCaptureTask
    implements Runnable {
        private StopCaptureTask() {
        }

        @Override
        public void run() {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            if (VideoCaptureCamera2.this.mCameraDevice == null) {
                return;
            }
            VideoCaptureCamera2.this.mCameraDevice.close();
            VideoCaptureCamera2.this.changeCameraStateAndNotify(4);
            VideoCaptureCamera2.this.mCropRect = new Rect();
        }
    }

    private class CrPreviewReaderListener
    implements ImageReader.OnImageAvailableListener {
        private CrPreviewReaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Image image = null;
            try {
                image = reader.acquireLatestImage();
                if (image == null) {
                    VideoCaptureCamera2.this.onFrameDropped(9);
                    return;
                }
                if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                    Logging.e(TAG, "Unexpected image format: " + image.getFormat() + " or #planes: " + image.getPlanes().length);
                    throw new IllegalStateException();
                }
                if (reader.getWidth() != image.getWidth() || reader.getHeight() != image.getHeight()) {
                    Logging.e(TAG, "ImageReader size (" + reader.getWidth() + "x" + reader.getHeight() + ") did not match Image size (" + image.getWidth() + "x" + image.getHeight() + ")");
                    throw new IllegalStateException();
                }
                VideoCaptureCamera2.this.onI420FrameAvailable(image.getPlanes()[0].getBuffer(), image.getPlanes()[0].getRowStride(), image.getPlanes()[1].getBuffer(), image.getPlanes()[2].getBuffer(), image.getPlanes()[1].getRowStride(), image.getPlanes()[1].getPixelStride(), image.getWidth(), image.getHeight(), VideoCaptureCamera2.this.getCameraRotation(), image.getTimestamp());
            }
            catch (IllegalStateException ex) {
                Logging.e(TAG, "acquireLatestImage():" + ex.getMessage());
            }
            finally {
                if (image != null) {
                    image.close();
                }
            }
        }
    }

    private class TextureVideoSinkListener
    implements SurfaceTextureHelper.IVideoCapture {
        private TextureVideoSinkListener() {
        }

        @Override
        public void onFrame(VideoFrame frame) {
            VideoFrame modifiedFrame = new VideoFrame(VideoCapture.createTextureBufferWithModifiedTransformMatrix((TextureBuffer)frame.getBuffer(), !VideoCaptureCamera2.this.mInvertDeviceOrientationReadings, -VideoCaptureCamera2.this.mCameraNativeOrientation), VideoCaptureCamera2.this.getCameraRotation(), frame.getTimestampNs());
            VideoCaptureCamera2.this.attachPerFrameMetaInfos(modifiedFrame);
            VideoCaptureCamera2.this.onFrameCaptured(modifiedFrame);
            modifiedFrame.release();
        }

        @Override
        public void onFrameDropped(int dropReason) {
            VideoCaptureCamera2.super.onFrameDropped(dropReason);
        }
    }

    private class CrPreviewSessionListener
    extends CameraCaptureSession.StateCallback {
        private final CaptureRequest mPreviewRequest;

        CrPreviewSessionListener(CaptureRequest previewRequest) {
            this.mPreviewRequest = previewRequest;
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "CrPreviewSessionListener.onConfigured");
            VideoCaptureCamera2.this.mPreviewSession = cameraCaptureSession;
            try {
                Logging.d(TAG, "CrPreviewSessionListener.onConfigured facedetect: " + this.mPreviewRequest.get(CaptureRequest.STATISTICS_FACE_DETECT_MODE));
                VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(this.mPreviewRequest, VideoCaptureCamera2.this.mCaptureCallback, null);
            }
            catch (CameraAccessException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (SecurityException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (IllegalStateException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "setRepeatingRequest: " + ex.getMessage());
                VideoCaptureCamera2.this.onError(102, "Fail to setup capture session");
                return;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(2);
            VideoCaptureCamera2.this.onStarted();
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "CrPreviewSessionListener.onConfigureFailed");
            VideoCaptureCamera2.this.changeCameraStateAndNotify(4);
            VideoCaptureCamera2.this.mPreviewSession = null;
            VideoCaptureCamera2.this.onError(101, "Camera session configuration error");
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "CrPreviewSessionListener.onClosed");
            VideoCaptureCamera2.this.mPreviewSession = null;
        }
    }

    class CrStateListener
    extends CameraDevice.StateCallback {
        CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "CameraDevice.StateCallback onOpened");
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.close();
            VideoCaptureCamera2.this.changeCameraStateAndNotify(1);
            VideoCaptureCamera2.this.createPreviewObjectsAndStartPreviewOrFailWith(100);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.e(TAG, "cameraDevice was closed unexpectedly");
            if (VideoCaptureCamera2.this.mCameraState != 4) {
                if (VideoCaptureCamera2.this.mCameraDevice != null) {
                    VideoCaptureCamera2.this.mCameraDevice.close();
                    VideoCaptureCamera2.this.mCameraDevice = null;
                }
                VideoCaptureCamera2.this.onError(6, "Camera disconnected");
                VideoCaptureCamera2.this.changeCameraStateAndNotify(3);
            }
        }

        public void onError(CameraDevice cameraDevice, int error) {
            VideoCaptureCamera2.this.mThreadChecker.checkIsOnValidThread();
            Logging.e(TAG, "cameraDevice encountered an error, code: " + error);
            if (VideoCaptureCamera2.this.mCameraState == 3) {
                return;
            }
            if (VideoCaptureCamera2.this.mCameraDevice != null) {
                VideoCaptureCamera2.this.mCameraDevice.close();
                VideoCaptureCamera2.this.mCameraDevice = null;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(4);
            int errorCode = 0;
            String msg = "";
            switch (error) {
                case 1: {
                    errorCode = 1;
                    msg = "Camera In Use";
                    break;
                }
                case 2: {
                    errorCode = 2;
                    msg = "Camera In Use";
                    break;
                }
                case 3: {
                    errorCode = 3;
                    msg = "Camera disabled";
                    break;
                }
                case 5: {
                    errorCode = 5;
                    msg = "Camera service error";
                    break;
                }
                case 4: {
                    errorCode = 4;
                    msg = "Camera device error";
                    break;
                }
                default: {
                    errorCode = 901;
                    msg = "Camera runtime erro";
                }
            }
            VideoCaptureCamera2.this.onError(errorCode, msg);
        }

        public void onClosed(CameraDevice camera) {
            Logging.d(TAG, "cameraDevice closed");
            if (VideoCaptureCamera2.this.mPreviewSession != null) {
                VideoCaptureCamera2.this.mPreviewSession = null;
            }
            VideoCaptureCamera2.this.mWaitForDeviceClosedConditionVariable.open();
        }
    }
}

