/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import android.text.TextUtils;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.Logging;
import java.io.File;

class SqliteWrapper {
    private static final String TAG = "SQLITE";
    private SQLiteDatabase db = null;
    private final Object lock = new Object();

    @CalledByNative
    public SqliteWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.db != null && this.db.isOpen()) {
                this.db.close();
            }
            this.db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public boolean open(String path) {
        if (!this.isPathValid(path)) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (Build.VERSION.SDK_INT >= 28) {
                    SQLiteDatabase.OpenParams.Builder builder = new SQLiteDatabase.OpenParams.Builder();
                    builder.setOpenFlags(0x10000000);
                    builder.setJournalMode("off");
                    SQLiteDatabase.OpenParams params = builder.build();
                    this.db = SQLiteDatabase.openDatabase((File)new File(path), (SQLiteDatabase.OpenParams)params);
                } else {
                    this.db = SQLiteDatabase.openDatabase((String)path, null, (int)0x10000000);
                }
            }
            catch (Exception e) {
                if (this.db != null && this.db.isOpen()) {
                    this.db.close();
                }
                this.db = null;
                Logging.d(TAG, "Can not open database: " + path);
                return false;
            }
            try {
                this.db.execSQL("PRAGMA TEMP_STORE = MEMORY;");
                this.db.execSQL("PRAGMA SYNCHRONOUS = OFF;");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.db.isOpen()) {
                    this.db.close();
                }
                this.db = null;
                Logging.d(TAG, "Can not open database: " + path);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void close() {
        if (!this.isDatabaseValid()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.db.close();
            this.db = null;
        }
    }

    @CalledByNative
    boolean touch(String path) {
        return this.executeCommandOnPath(path, "create table if not exists \"" + path + "\" (key text primary key, value text, expired INTEGER);");
    }

    @CalledByNative
    boolean drop(String path) {
        return this.executeCommandOnPath(path, "drop table if exists \"" + path + "\";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    long save(String path, String key, byte[] buffer, long expired) {
        if (!this.isPathValid(path)) {
            return 0L;
        }
        if (!this.isPathValid(key)) {
            return 0L;
        }
        if (buffer == null || buffer.length == 0) {
            return 0L;
        }
        if (buffer.length >= 524288) {
            return 0L;
        }
        if (!this.touch(path)) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            long retSize;
            SQLiteStatement stmt;
            block15: {
                String cmd = "replace into \"" + path + "\" (key, value, expired) values (\"" + key + "\", ?, " + expired + ");";
                stmt = null;
                retSize = 0L;
                this.db.beginTransaction();
                try {
                    stmt = this.db.compileStatement(cmd);
                }
                catch (Exception e) {
                    break block15;
                }
                try {
                    stmt.bindBlob(1, buffer);
                }
                catch (Exception e) {
                    break block15;
                }
                try {
                    stmt.execute();
                }
                catch (Exception e) {
                    break block15;
                }
                retSize = buffer.length;
            }
            this.db.setTransactionSuccessful();
            this.db.endTransaction();
            if (stmt != null) {
                stmt.close();
            }
            return retSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @CalledByNative
    StorageItem load(String path, String key, boolean testSize) {
        if (!this.isDatabaseValid()) {
            return new StorageItem();
        }
        if (!this.isPathValid(path)) {
            return new StorageItem();
        }
        if (!this.isPathValid(key)) {
            return new StorageItem();
        }
        var4_4 = this.lock;
        synchronized (var4_4) {
            block23: {
                retSize = 0L;
                result = null;
                exp = 0L;
                cursor = null;
                tableExist = false;
                table_query = "select DISTINCT tbl_name from sqlite_master where tbl_name = \"" + path + "\";";
                try {
                    cursor = this.db.rawQuery(table_query, new String[0]);
                    ** if (cursor == null) goto lbl-1000
                }
                catch (Exception e) {
                    try {
                        cursor = null;
                        ** if (cursor == null) goto lbl-1000
                    }
                    catch (Throwable var14_13) {
                        if (cursor != null) {
                            tableExist = cursor.getCount() > 0;
                            cursor.close();
                            cursor = null;
                        }
                        throw var14_13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        tableExist = cursor.getCount() > 0;
                        cursor.close();
                        cursor = null;
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    tableExist = cursor.getCount() > 0;
                    cursor.close();
                    cursor = null;
                }
lbl-1000:
                // 2 sources

                {
                }
                if (tableExist) {
                    cmd = "select key, value, expired from \"" + path + "\" where key = \"" + key + "\";";
                    try {
                        cursor = this.db.rawQuery(cmd, new String[0]);
                    }
                    catch (Exception e) {
                        break block23;
                    }
                    if (!cursor.isClosed() && cursor.moveToFirst() && cursor.getCount() == 1) {
                        try {
                            result = cursor.getBlob(1);
                        }
                        catch (Exception e) {
                            break block23;
                        }
                        try {
                            exp = cursor.getLong(2);
                        }
                        catch (Exception e) {
                            break block23;
                        }
                        v0 = retSize = result.length > 524288 ? 524288L : (long)result.length;
                    }
                }
            }
            if (cursor != null) {
                cursor.close();
            }
            if (retSize == 0L || result.length == 0) {
                return new StorageItem();
            }
            return new StorageItem(result, retSize, exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    boolean delete(String path, String key) {
        if (!this.isDatabaseValid()) {
            return false;
        }
        if (!this.isPathValid(path)) {
            return false;
        }
        if (!this.isPathValid(key)) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            String cmd = "delete from \"" + path + "\" where key = \"" + key + "\";";
            try {
                this.db.execSQL(cmd);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    private boolean isDatabaseValid() {
        return this.db != null && this.db.isOpen() && !this.db.isReadOnly();
    }

    private boolean isPathValid(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\"' && c != '\'' && c != ';') continue;
            return false;
        }
        return !path.toLowerCase().contains("sqlite_master");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCommandOnPath(String path, String cmd) {
        if (!this.isDatabaseValid()) {
            return false;
        }
        if (!this.isPathValid(path)) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.db.execSQL(cmd);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    static class StorageItem {
        byte[] data;
        long actualSize;
        long expired;

        public StorageItem(byte[] data, long size, long exp) {
            this.data = data;
            this.actualSize = size;
            this.expired = exp;
        }

        public StorageItem() {
            this.data = null;
            this.actualSize = 0L;
            this.expired = 0L;
        }

        @CalledByNative(value="StorageItem")
        public long getActualSize() {
            return this.actualSize;
        }

        @CalledByNative(value="StorageItem")
        public long getExpired() {
            return this.expired;
        }

        @CalledByNative(value="StorageItem")
        public byte[] getData() {
            return this.data;
        }
    }
}

