/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.agora.CallBack;
import io.agora.MessageListener;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.CmdMessageBody;
import io.agora.chat.Conversation;
import io.agora.chat.GroupReadAck;
import io.agora.chat.MessageBody;
import io.agora.chat.MessageReactionChange;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.bean.EaseCallInfo;
import io.agora.chat.callkit.event.EaseCallAlertEvent;
import io.agora.chat.callkit.event.EaseCallAnswerEvent;
import io.agora.chat.callkit.event.EaseCallBaseEvent;
import io.agora.chat.callkit.event.EaseCallCallCancelEvent;
import io.agora.chat.callkit.event.EaseCallConfirmCallEvent;
import io.agora.chat.callkit.event.EaseCallConfirmRingEvent;
import io.agora.chat.callkit.event.EaseCallInviteEventEase;
import io.agora.chat.callkit.general.EaseCallAction;
import io.agora.chat.callkit.general.EaseCallEndReason;
import io.agora.chat.callkit.general.EaseCallError;
import io.agora.chat.callkit.general.EaseCallFloatWindow;
import io.agora.chat.callkit.general.EaseCallKitConfig;
import io.agora.chat.callkit.general.EaseCallProcessError;
import io.agora.chat.callkit.general.EaseCallState;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.listener.EaseCallKitListener;
import io.agora.chat.callkit.livedatas.EaseCallLiveDataBus;
import io.agora.chat.callkit.ui.EaseCallBaseActivity;
import io.agora.chat.callkit.ui.EaseCallMultipleBaseActivity;
import io.agora.chat.callkit.ui.EaseCallSingleBaseActivity;
import io.agora.chat.callkit.utils.EaseCallAudioControl;
import io.agora.chat.callkit.utils.EaseCallKitNotifier;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.utils.EaseCallMsgUtils;
import io.agora.chat.callkit.utils.EaseCallStatusBarCompat;
import io.agora.exceptions.ChatException;
import io.agora.util.EMLog;
import io.agora.util.EasyUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class EaseCallKit {
    private static final String TAG = EaseCallKit.class.getSimpleName();
    private static EaseCallKit instance = null;
    private boolean callKitInit = false;
    private Context mContext = null;
    private MessageListener messageListener = null;
    private EaseCallType callType = EaseCallType.SINGLE_VIDEO_CALL;
    private EaseCallState callState = EaseCallState.CALL_IDLE;
    private String channelName;
    private String fromUserId;
    public static String deviceId = "android_";
    public String clallee_devId;
    private String callID = null;
    private JSONObject inviteExt = null;
    private EaseCallInfo callInfo = new EaseCallInfo();
    private TimeHandler timeHandler;
    private Map<String, EaseCallInfo> callInfoMap = new HashMap<String, EaseCallInfo>();
    private EaseCallKitListener callListener;
    private static boolean isComingCall = true;
    private ArrayList<String> inviteeUsers = new ArrayList();
    private EaseCallKitConfig callKitConfig;
    private EaseCallKitNotifier notifier;
    private Class<? extends EaseCallBaseActivity> curCallCls;
    private Handler handler;
    private View headview;
    private int largestNumInChannel = 16;
    private Class<? extends EaseCallSingleBaseActivity> defaultVideoCallCls = EaseCallSingleBaseActivity.class;
    private Class<? extends EaseCallMultipleBaseActivity> defaultMultiVideoCls = EaseCallMultipleBaseActivity.class;
    private WeakReference<Activity> currentActivity;

    private EaseCallKit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseCallKit getInstance() {
        if (instance != null) return instance;
        Class<EaseCallKit> clazz = EaseCallKit.class;
        synchronized (EaseCallKit.class) {
            if (instance != null) return instance;
            instance = new EaseCallKit();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized boolean init(Context context, EaseCallKitConfig config) {
        if (this.callKitInit) {
            return true;
        }
        this.removeMessageListener();
        this.mContext = context;
        if (!this.isMainProcess(this.mContext)) {
            Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        deviceId = deviceId + EaseCallKitUtils.getPhoneSign();
        this.timeHandler = new TimeHandler();
        this.callKitConfig = new EaseCallKitConfig();
        this.callKitConfig.setAgoraAppId(config.getAgoraAppId());
        this.callKitConfig.setUserInfoMap(config.getUserInfoMap());
        this.callKitConfig.setDefaultHeadImage(config.getDefaultHeadImage());
        this.callKitConfig.setCallTimeOut(config.getCallTimeOut());
        this.callKitConfig.setRingFile(config.getRingFile());
        this.callKitConfig.setEnableRTCToken(config.isEnableRTCToken());
        this.initNotifier();
        this.addMessageListener();
        this.callKitInit = true;
        this.handler = new Handler(this.mContext.getMainLooper());
        EaseCallAudioControl.getInstance().init(context);
        this.registerActivityLifecycleCallbacks(this.mContext);
        return true;
    }

    private void registerActivityLifecycleCallbacks(Context appContext) {
        EMLog.d((String)TAG, (String)"registerActivityLifecycleCallbacks");
        ((Application)appContext).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onActivityStarted(@NonNull Activity activity) {
            }

            public void onActivityResumed(@NonNull Activity activity) {
                EaseCallKit.this.currentActivity = new WeakReference<Activity>(activity);
                EaseCallKit.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (EaseCallKit.this.headview != null && EaseCallKit.this.headview.getParent() != null) {
                            ((ViewGroup)EaseCallKit.this.headview.getParent()).removeView(EaseCallKit.this.headview);
                            String fromUserId = (String)EaseCallKit.this.headview.getTag(R.id.tag_from_userid);
                            EaseCallType callType = (EaseCallType)((Object)EaseCallKit.this.headview.getTag(R.id.tag_call_type));
                            EaseCallKit.this.showCallingHeadDialog(fromUserId, callType);
                        }
                    }
                });
            }

            public void onActivityPaused(@NonNull Activity activity) {
            }

            public void onActivityStopped(@NonNull Activity activity) {
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
            }
        });
    }

    public void registerVideoCallClass(Class<? extends EaseCallSingleBaseActivity> videoCallClass) {
        this.defaultVideoCallCls = videoCallClass;
    }

    public void registerMultipleVideoClass(Class<? extends EaseCallMultipleBaseActivity> multipleVideoClass) {
        this.defaultMultiVideoCls = multipleVideoClass;
    }

    public EaseCallKitConfig getCallKitConfig() {
        return this.callKitConfig;
    }

    private void initNotifier() {
        this.notifier = new EaseCallKitNotifier(this.mContext);
    }

    public void startSingleCall(EaseCallType type, String user, Map<String, Object> ext) {
        this.startSingleCall(type, user, ext, this.defaultVideoCallCls);
    }

    public void startSingleCall(EaseCallType type, String user, Map<String, Object> ext, Class<? extends EaseCallSingleBaseActivity> cls) {
        if (this.callState != EaseCallState.CALL_IDLE) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_STATE_ERROR.code, "current state is busy");
            }
            return;
        }
        if (type == EaseCallType.CONFERENCE_VIDEO_CALL || type == EaseCallType.CONFERENCE_VOICE_CALL) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_TYPE_ERROR.code, "call type is error");
            }
            return;
        }
        if (user != null && user.length() == 0) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_PARAM_ERROR.code, "user is null");
            }
            return;
        }
        this.callType = type;
        this.callState = EaseCallState.CALL_OUTGOING;
        this.fromUserId = user;
        if (ext != null) {
            this.inviteExt = EaseCallKitUtils.convertMapToJSONObject(ext);
        }
        this.curCallCls = cls;
        Intent intent = new Intent(this.mContext, this.curCallCls).addFlags(0x10000000);
        Bundle bundle = new Bundle();
        isComingCall = false;
        bundle.putBoolean("isComingCall", false);
        bundle.putString("username", user);
        this.channelName = EaseCallKitUtils.getRandomString(10);
        bundle.putString("channelName", this.channelName);
        intent.putExtras(bundle);
        this.mContext.startActivity(intent);
    }

    public void startInviteMultipleCall(EaseCallType type, String[] users, Map<String, Object> ext) {
        this.startInviteMultipleCall(type, users, ext, this.defaultMultiVideoCls);
    }

    public void startInviteMultipleCall(EaseCallType type, String[] users, Map<String, Object> ext, Class<? extends EaseCallMultipleBaseActivity> cls) {
        if (users != null && ((String[])users).length > this.largestNumInChannel) {
            this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_PARAM_ERROR.code, this.mContext.getString(R.string.ease_call_max_people_in_channel));
            return;
        }
        if (type == EaseCallType.SINGLE_VOICE_CALL || type == EaseCallType.SINGLE_VIDEO_CALL) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_TYPE_ERROR.code, "call type is error");
            }
            return;
        }
        if (users == null || ((String[])users).length == 0) {
            this.inviteeUsers.clear();
            this.callType = type;
            this.curCallCls = cls;
            this.callState = EaseCallState.CALL_OUTGOING;
            if (ext != null) {
                this.inviteExt = EaseCallKitUtils.convertMapToJSONObject(ext);
                try {
                    this.channelName = this.inviteExt.getString(EaseCallMsgUtils.CALL_CHANNELNAME);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Intent intent = new Intent(this.mContext, this.curCallCls);
            intent.addFlags(0x10000000);
            Bundle bundle = new Bundle();
            isComingCall = false;
            bundle.putBoolean("isComingCall", false);
            bundle.putString("channelName", this.channelName);
            intent.putExtras(bundle);
            this.mContext.startActivity(intent);
        } else {
            Intent intent;
            this.callType = type;
            this.inviteeUsers.clear();
            for (String user : users) {
                this.inviteeUsers.add(user);
            }
            if (this.curCallCls == null) {
                if (users != null && ((String[])users).length > 0) {
                    if (ext != null) {
                        this.inviteExt = EaseCallKitUtils.convertMapToJSONObject(ext);
                    }
                    this.callState = EaseCallState.CALL_OUTGOING;
                    this.curCallCls = cls;
                    intent = new Intent(this.mContext, this.curCallCls);
                    intent.addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = false;
                    bundle.putBoolean("isComingCall", false);
                    this.channelName = EaseCallKitUtils.getRandomString(10);
                    bundle.putString("channelName", this.channelName);
                    intent.putExtras(bundle);
                    this.mContext.startActivity(intent);
                }
            } else {
                intent = new Intent(this.mContext, this.curCallCls).addFlags(0x10000000);
                this.mContext.startActivity(intent);
            }
        }
    }

    public Class<? extends EaseCallBaseActivity> getCurrentCallClass() {
        return this.curCallCls;
    }

    public void releaseCall() {
        if (this.curCallCls != null) {
            this.curCallCls = null;
        }
    }

    public int getLargestNumInChannel() {
        return this.largestNumInChannel;
    }

    private void addMessageListener() {
        this.messageListener = new MessageListener(){

            public void onMessageReceived(List<ChatMessage> messages) {
                for (ChatMessage message : messages) {
                    String messageType = message.getStringAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, "");
                    EMLog.d((String)TAG, (String)("Receive msg:" + message.getMsgId() + " from:" + message.getFrom() + "  messageType:" + messageType));
                    if (!TextUtils.equals((CharSequence)messageType, (CharSequence)EaseCallMsgUtils.CALL_MSG_INFO) || TextUtils.equals((CharSequence)message.getFrom(), (CharSequence)ChatClient.getInstance().getCurrentUser())) continue;
                    String action = message.getStringAttribute(EaseCallMsgUtils.CALL_ACTION, "");
                    String callerDevId = message.getStringAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, "");
                    String fromCallId = message.getStringAttribute(EaseCallMsgUtils.CLL_ID, "");
                    String fromUser = message.getFrom();
                    String channel = message.getStringAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, "");
                    JSONObject ext = null;
                    try {
                        ext = message.getJSONObjectAttribute(EaseCallMsgUtils.CALL_INVITE_EXT);
                    }
                    catch (ChatException exception) {
                        exception.printStackTrace();
                    }
                    if (action == null || callerDevId == null || fromCallId == null || fromUser == null || channel == null) {
                        if (EaseCallKit.this.callListener == null) continue;
                        EaseCallKit.this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_RECEIVE_ERROR.code, "receive message error");
                        continue;
                    }
                    EaseCallAction callAction = EaseCallAction.getfrom(action);
                    switch (callAction) {
                        case CALL_INVITE: {
                            EaseCallBaseEvent callEvent;
                            if (message.getChatType() == ChatMessage.ChatType.GroupChat) {
                                return;
                            }
                            int calltype = message.getIntAttribute(EaseCallMsgUtils.CALL_TYPE, 0);
                            EaseCallType callkitType = EaseCallType.getfrom(calltype);
                            if (EaseCallKit.this.callState != EaseCallState.CALL_IDLE) {
                                if (TextUtils.equals((CharSequence)fromCallId, (CharSequence)EaseCallKit.this.callID) && TextUtils.equals((CharSequence)fromUser, (CharSequence)EaseCallKit.this.fromUserId) && callkitType == EaseCallType.SINGLE_VOICE_CALL && EaseCallKit.this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
                                    EaseCallInviteEventEase inviteEvent = new EaseCallInviteEventEase();
                                    inviteEvent.callId = fromCallId;
                                    inviteEvent.type = callkitType;
                                    EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)inviteEvent);
                                    break;
                                }
                                callEvent = new EaseCallAnswerEvent();
                                callEvent.result = EaseCallMsgUtils.CALL_ANSWER_BUSY;
                                callEvent.callerDevId = callerDevId;
                                callEvent.callId = fromCallId;
                                EaseCallKit.this.sendCmdMsg(callEvent, fromUser);
                                break;
                            }
                            EaseCallKit.this.callInfo.setCallerDevId(callerDevId);
                            EaseCallKit.this.callInfo.setCallId(fromCallId);
                            EaseCallKit.this.callInfo.setCallKitType(callkitType);
                            EaseCallKit.this.callInfo.setChannelName(channel);
                            EaseCallKit.this.callInfo.setComming(true);
                            EaseCallKit.this.callInfo.setFromUser(fromUser);
                            EaseCallKit.this.callInfo.setExt(ext);
                            EaseCallKit.this.callInfoMap.put(fromCallId, EaseCallKit.this.callInfo);
                            callEvent = new EaseCallAlertEvent();
                            ((EaseCallAlertEvent)callEvent).callerDevId = callerDevId;
                            ((EaseCallAlertEvent)callEvent).callId = fromCallId;
                            EaseCallKit.this.sendCmdMsg(callEvent, fromUser);
                            EaseCallKit.this.timeHandler.startTime();
                            break;
                        }
                    }
                }
            }

            public void onCmdMessageReceived(List<ChatMessage> messages) {
                for (ChatMessage message : messages) {
                    String messageType = message.getStringAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, "");
                    EMLog.d((String)TAG, (String)("Receive cmdmsg:" + message.getMsgId() + " from:" + message.getFrom() + "  messageType:" + messageType));
                    if (!TextUtils.equals((CharSequence)messageType, (CharSequence)EaseCallMsgUtils.CALL_MSG_INFO) || TextUtils.equals((CharSequence)message.getFrom(), (CharSequence)ChatClient.getInstance().getCurrentUser())) continue;
                    String action = message.getStringAttribute(EaseCallMsgUtils.CALL_ACTION, "");
                    String callerDevId = message.getStringAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, "");
                    String fromCallId = message.getStringAttribute(EaseCallMsgUtils.CLL_ID, "");
                    String fromUser = message.getFrom();
                    String channel = message.getStringAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, "");
                    EaseCallAction callAction = EaseCallAction.getfrom(action);
                    if (action == null || callerDevId == null || fromCallId == null || fromUser == null || channel == null) {
                        if (EaseCallKit.this.callListener == null) continue;
                        EaseCallKit.this.callListener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_RECEIVE_ERROR.code, "receive message error");
                        continue;
                    }
                    switch (callAction) {
                        case CALL_CANCEL: {
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE) {
                                EaseCallKit.this.timeHandler.stopTime();
                                EaseCallKit.this.callInfoMap.remove(fromCallId);
                                EaseCallKit.this.hideCallingHeadDialog();
                                EaseCallKit.this.resetState();
                                break;
                            }
                            EaseCallCallCancelEvent event = new EaseCallCallCancelEvent();
                            event.callerDevId = callerDevId;
                            event.callId = fromCallId;
                            event.userId = fromUser;
                            if (TextUtils.equals((CharSequence)EaseCallKit.this.callID, (CharSequence)fromCallId)) {
                                EaseCallKit.this.callState = EaseCallState.CALL_IDLE;
                                EaseCallKit.this.hideCallingHeadDialog();
                                EaseCallKit.this.resetState();
                            }
                            EaseCallKit.this.notifier.reset();
                            EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)event);
                            break;
                        }
                        case CALL_ALERT: {
                            String calleedDeviceId = message.getStringAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, "");
                            EaseCallAlertEvent alertEvent = new EaseCallAlertEvent();
                            alertEvent.callId = fromCallId;
                            alertEvent.calleeDevId = calleedDeviceId;
                            alertEvent.userId = fromUser;
                            EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)alertEvent);
                            break;
                        }
                        case CALL_CONFIRM_RING: {
                            String calledDvId = message.getStringAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, "");
                            boolean vaild = message.getBooleanAttribute(EaseCallMsgUtils.CALL_STATUS, false);
                            if (!TextUtils.equals((CharSequence)calledDvId, (CharSequence)deviceId)) break;
                            EaseCallKit.this.timeHandler.stopTime();
                            if (!vaild) {
                                EaseCallKit.this.callInfoMap.remove(fromCallId);
                                break;
                            }
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE) {
                                EaseCallKit.this.callState = EaseCallState.CALL_ALERTING;
                                EaseCallKit.this.clallee_devId = callerDevId;
                                EaseCallKit.this.callID = fromCallId;
                                EaseCallInfo info = (EaseCallInfo)EaseCallKit.this.callInfoMap.get(fromCallId);
                                if (info != null) {
                                    EaseCallKit.this.channelName = info.getChannelName();
                                    EaseCallKit.this.callType = info.getCallKitType();
                                    EaseCallKit.this.fromUserId = info.getFromUser();
                                    EaseCallKit.this.inviteExt = info.getExt();
                                }
                                EaseCallKit.this.callInfoMap.clear();
                                EaseCallKit.this.showCallingHeadDialog(EaseCallKit.this.fromUserId, EaseCallKit.this.callType);
                                break;
                            }
                            EaseCallKit.this.callInfoMap.remove(fromCallId);
                            EaseCallKit.this.timeHandler.stopTime();
                            break;
                        }
                        case CALL_CONFIRM_CALLEE: {
                            if (!TextUtils.equals((CharSequence)EaseCallKit.this.callID, (CharSequence)fromCallId)) break;
                            String result = message.getStringAttribute(EaseCallMsgUtils.CALL_RESULT, "");
                            String calledDevId = message.getStringAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, "");
                            EaseCallConfirmCallEvent event = new EaseCallConfirmCallEvent();
                            event.calleeDevId = calledDevId;
                            event.result = result;
                            event.callerDevId = callerDevId;
                            event.callId = fromCallId;
                            event.userId = fromUser;
                            if (TextUtils.equals((CharSequence)calledDevId, (CharSequence)deviceId)) {
                                if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE) && EaseCallKit.this.callListener != null) {
                                    EaseCallKit.this.callListener.onEndCallWithReason(EaseCallKit.this.callType, EaseCallKit.this.channelName, EaseCallEndReason.EaseCallEndReasonRefuse, 0L);
                                }
                            } else {
                                EaseCallKit.this.hideCallingHeadDialog();
                                EaseCallKit.this.resetState();
                                EaseCallEndReason reason = null;
                                if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                                    reason = EaseCallEndReason.EaseCallEndReasonHandleOnOtherDeviceAgreed;
                                } else if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) {
                                    reason = EaseCallEndReason.EaseCallEndReasonHandleOnOtherDeviceRefused;
                                }
                                if (EaseCallKit.this.callListener != null) {
                                    EaseCallKit.this.callListener.onEndCallWithReason(EaseCallKit.this.callType, EaseCallKit.this.channelName, reason, 0L);
                                }
                            }
                            EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)event);
                            break;
                        }
                        case CALL_ANSWER: {
                            EaseCallAnswerEvent answerEvent;
                            String result1 = message.getStringAttribute(EaseCallMsgUtils.CALL_RESULT, "");
                            String calledDevId1 = message.getStringAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, "");
                            boolean transVoice = message.getBooleanAttribute(EaseCallMsgUtils.CALLED_TRANSE_VOICE, false);
                            if (EaseCallKit.this.callType != EaseCallType.CONFERENCE_VIDEO_CALL && EaseCallKit.this.callType != EaseCallType.CONFERENCE_VOICE_CALL) {
                                if (isComingCall && !TextUtils.equals((CharSequence)calledDevId1, (CharSequence)deviceId)) break;
                                answerEvent = new EaseCallAnswerEvent();
                                answerEvent.result = result1;
                                answerEvent.calleeDevId = calledDevId1;
                                answerEvent.callerDevId = callerDevId;
                                answerEvent.callId = fromCallId;
                                answerEvent.userId = fromUser;
                                answerEvent.transVoice = transVoice;
                                EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)answerEvent);
                                break;
                            }
                            if (TextUtils.equals((CharSequence)fromUser, (CharSequence)ChatClient.getInstance().getCurrentUser())) break;
                            answerEvent = new EaseCallAnswerEvent();
                            answerEvent.result = result1;
                            answerEvent.calleeDevId = calledDevId1;
                            answerEvent.callerDevId = callerDevId;
                            answerEvent.callId = fromCallId;
                            answerEvent.userId = fromUser;
                            answerEvent.transVoice = transVoice;
                            EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)answerEvent);
                            break;
                        }
                        case CALL_VIDEO_TO_VOICE: {
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE || !TextUtils.equals((CharSequence)fromCallId, (CharSequence)EaseCallKit.this.callID) || !TextUtils.equals((CharSequence)fromUser, (CharSequence)EaseCallKit.this.fromUserId)) break;
                            EaseCallInviteEventEase inviteEvent = new EaseCallInviteEventEase();
                            inviteEvent.callId = fromCallId;
                            inviteEvent.type = EaseCallType.SINGLE_VOICE_CALL;
                            EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)inviteEvent);
                            break;
                        }
                    }
                }
            }

            public void onMessageRead(List<ChatMessage> messages) {
            }

            public void onGroupMessageRead(List<GroupReadAck> groupReadAcks) {
            }

            public void onMessageDelivered(List<ChatMessage> messages) {
            }

            public void onMessageRecalled(List<ChatMessage> messages) {
            }

            public void onMessageChanged(ChatMessage message, Object change) {
            }

            public void onReadAckForGroupMessageUpdated() {
            }

            public void onReactionChanged(List<MessageReactionChange> messageReactionChangeList) {
            }
        };
        ChatClient.getInstance().chatManager().addMessageListener(this.messageListener);
    }

    private void showCallingHeadDialog(final String fromUserId, final EaseCallType callType) {
        if (!EaseCallKitUtils.isAppRunningForeground(this.mContext)) {
            EaseCallKitUtils.bring2Front(this.mContext);
        }
        this.callType = callType;
        if (this.currentActivity == null) {
            return;
        }
        final Activity activity = (Activity)this.currentActivity.get();
        EMLog.d((String)TAG, (String)("showCallingHeadDialog activity=" + activity));
        EMLog.d((String)TAG, (String)("fromUserId =" + fromUserId));
        if (activity != null) {
            final FrameLayout decorView = (FrameLayout)activity.getWindow().getDecorView();
            decorView.post(new Runnable(){

                @Override
                public void run() {
                    if (EaseCallKitUtils.isAppRunningForeground(EaseCallKit.this.mContext)) {
                        EaseCallAudioControl.getInstance().playRing();
                    }
                    EaseCallKit.this.headview = LayoutInflater.from((Context)activity).inflate(R.layout.ease_call_head_view, (ViewGroup)decorView, false);
                    decorView.addView(EaseCallKit.this.headview);
                    EaseCallKit.this.headview.setTag(R.id.tag_from_userid, (Object)fromUserId);
                    EaseCallKit.this.headview.setTag(R.id.tag_call_type, (Object)callType);
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)EaseCallKit.this.headview.getLayoutParams();
                    layoutParams.setMargins(layoutParams.leftMargin, EaseCallStatusBarCompat.getStatusBarHeight(activity.getApplicationContext()), layoutParams.rightMargin, layoutParams.topMargin);
                    TextView tvName = (TextView)EaseCallKit.this.headview.findViewById(R.id.tv_name);
                    TextView subTitle = (TextView)EaseCallKit.this.headview.findViewById(R.id.tv_subtitle);
                    ImageButton btnAgree = (ImageButton)EaseCallKit.this.headview.findViewById(R.id.btn_call_head_agree);
                    ImageButton btnRefuse = (ImageButton)EaseCallKit.this.headview.findViewById(R.id.btn_call_head_refuse);
                    tvName.setText((CharSequence)fromUserId);
                    switch (callType) {
                        case SINGLE_VOICE_CALL: {
                            subTitle.setText((CharSequence)activity.getString(R.string.ease_call_head_view_single_audio_subtitle));
                            break;
                        }
                        case CONFERENCE_VOICE_CALL: {
                            subTitle.setText((CharSequence)activity.getString(R.string.ease_call_head_view_multiply_audio_subtitle));
                            break;
                        }
                        case SINGLE_VIDEO_CALL: {
                            subTitle.setText((CharSequence)activity.getString(R.string.ease_call_head_view_single_video_subtitle));
                            break;
                        }
                        case CONFERENCE_VIDEO_CALL: {
                            subTitle.setText((CharSequence)activity.getString(R.string.ease_call_head_view_multiply_video_subtitle));
                        }
                    }
                    EaseCallKit.this.headview.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EaseCallKit.this.hideCallingHeadDialog();
                            EaseCallKit.this.timeHandler.startSendEvent(false);
                            EMLog.d((String)TAG, (String)" click headview");
                        }
                    });
                    btnAgree.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EaseCallKit.this.hideCallingHeadDialog();
                            EaseCallKit.this.timeHandler.startSendEvent(true);
                            EMLog.d((String)TAG, (String)"btnAgree removeView(headview)");
                        }
                    });
                    btnRefuse.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            EaseCallKit.this.refused();
                        }
                    });
                }
            });
        }
    }

    private void refused() {
        EaseCallAnswerEvent event = new EaseCallAnswerEvent();
        event.result = EaseCallMsgUtils.CALL_ANSWER_REFUSE;
        event.callId = EaseCallKit.getInstance().getCallID();
        event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
        event.calleeDevId = deviceId;
        this.sendCmdMsg(event, this.fromUserId, new CallBack(){

            public void onSuccess() {
            }

            public void onError(int code, String error) {
                if (EaseCallKit.this.callListener != null) {
                    EaseCallKit.this.callListener.onCallError(EaseCallError.IM_ERROR, code, error);
                }
            }
        });
        this.hideCallingHeadDialog();
        this.resetState();
        EMLog.d((String)TAG, (String)"btnRefuse removeView(headview)");
    }

    private void hideCallingHeadDialog() {
        ViewParent parent;
        EaseCallAudioControl.getInstance().stopPlayRing();
        if (this.headview != null && (parent = this.headview.getParent()) != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ((ViewGroup)parent).removeView(EaseCallKit.this.headview);
                    EaseCallKit.this.headview = null;
                }
            });
        }
    }

    private void resetState() {
        this.setCallState(EaseCallState.CALL_IDLE);
        this.setCallID(null);
    }

    public void setCallKitListener(EaseCallKitListener listener) {
        this.callListener = listener;
    }

    public void removeCallKitListener(EaseCallKitListener listener) {
        this.callListener = null;
    }

    private void removeMessageListener() {
        ChatClient.getInstance().chatManager().removeMessageListener(this.messageListener);
        this.messageListener = null;
    }

    public EaseCallState getCallState() {
        return this.callState;
    }

    public EaseCallType getCallType() {
        return this.callType;
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
    }

    public void setCallState(EaseCallState callState) {
        this.callState = callState;
    }

    public String getCallID() {
        return this.callID;
    }

    public void setCallID(String callID) {
        this.callID = callID;
    }

    public String getClallee_devId() {
        return this.clallee_devId;
    }

    public EaseCallKitListener getCallListener() {
        return this.callListener;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public boolean getIsComingCall() {
        return isComingCall;
    }

    public EaseCallKitNotifier getNotifier() {
        return this.notifier;
    }

    private boolean isMainProcess(Context context) {
        String processName = Build.VERSION.SDK_INT >= 28 ? this.getProcessNameByApplication() : this.getProcessNameByReflection();
        return context.getApplicationInfo().packageName.equals(processName);
    }

    private String getProcessNameByReflection() {
        String processName = null;
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String)invoke;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return processName;
    }

    @RequiresApi(api=28)
    private String getProcessNameByApplication() {
        return Application.getProcessName();
    }

    private void sendCmdMsg(EaseCallBaseEvent event, String username) {
        final ChatMessage message = ChatMessage.createSendMessage((ChatMessage.Type)ChatMessage.Type.CMD);
        message.setTo(username);
        String action = "rtcCall";
        CmdMessageBody cmdBody = new CmdMessageBody(action);
        message.addBody((MessageBody)cmdBody);
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, event.callerDevId);
        message.setAttribute(EaseCallMsgUtils.CLL_ID, event.callId);
        message.setAttribute(EaseCallMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, deviceId);
            message.setAttribute(EaseCallMsgUtils.CALL_RESULT, ((EaseCallAnswerEvent)event).result);
        } else if (event.callAction == EaseCallAction.CALL_ALERT) {
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, deviceId);
        }
        final Conversation conversation = ChatClient.getInstance().chatManager().getConversation(username, Conversation.ConversationType.Chat, true);
        message.setMessageStatusCallback(new CallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                conversation.removeMessage(message.getMsgId());
                if (EaseCallKit.this.callListener != null) {
                    EaseCallKit.this.callListener.onCallError(EaseCallError.IM_ERROR, code, error);
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    private boolean isDestroy(Activity mActivity) {
        return mActivity == null || mActivity.isFinishing() || Build.VERSION.SDK_INT >= 17 && mActivity.isDestroyed();
    }

    public ArrayList<String> getInviteeUsers() {
        return this.inviteeUsers;
    }

    public void InitInviteeUsers() {
        this.inviteeUsers.clear();
    }

    public JSONObject getInviteExt() {
        return this.inviteExt;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void sendCmdMsg(final EaseCallBaseEvent event, String username, final CallBack callBack) {
        final ChatMessage message = ChatMessage.createSendMessage((ChatMessage.Type)ChatMessage.Type.CMD);
        String action = "rtcCall";
        CmdMessageBody cmdBody = new CmdMessageBody(action);
        message.setTo(username);
        message.addBody((MessageBody)cmdBody);
        if (event.callAction.equals((Object)EaseCallAction.CALL_VIDEO_TO_VOICE) || event.callAction.equals((Object)EaseCallAction.CALL_CANCEL)) {
            cmdBody.deliverOnlineOnly(false);
        } else {
            cmdBody.deliverOnlineOnly(true);
        }
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, deviceId);
        message.setAttribute(EaseCallMsgUtils.CLL_ID, event.callId);
        message.setAttribute(EaseCallMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_CONFIRM_RING) {
            message.setAttribute(EaseCallMsgUtils.CALL_STATUS, ((EaseCallConfirmRingEvent)event).valid.booleanValue());
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallConfirmRingEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
            message.setAttribute(EaseCallMsgUtils.CALL_RESULT, ((EaseCallConfirmCallEvent)event).result);
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallConfirmCallEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseCallMsgUtils.CALL_RESULT, ((EaseCallAnswerEvent)event).result);
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallAnswerEvent)event).calleeDevId);
            message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, ((EaseCallAnswerEvent)event).callerDevId);
            message.setAttribute(EaseCallMsgUtils.CALLED_TRANSE_VOICE, ((EaseCallAnswerEvent)event).transVoice);
        }
        final Conversation conversation = ChatClient.getInstance().chatManager().getConversation(username, Conversation.ConversationType.Chat, true);
        message.setMessageStatusCallback(new CallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseCallKit.this.exitCall();
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE && !TextUtils.equals((CharSequence)((EaseCallConfirmCallEvent)event).result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                    EaseCallKit.this.exitCall();
                }
                callBack.onSuccess();
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                if (conversation != null) {
                    conversation.removeMessage(message.getMsgId());
                }
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseCallKit.this.exitCall();
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE && !TextUtils.equals((CharSequence)((EaseCallConfirmCallEvent)event).result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                    EaseCallKit.this.exitCall();
                }
                callBack.onError(code, error);
            }

            public void onProgress(int progress, String status) {
            }
        });
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    private void exitCall() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (EaseCallFloatWindow.getInstance().isShowing()) {
                    EaseCallFloatWindow.getInstance(EaseCallKit.this.mContext).dismiss();
                }
                EaseCallKit.this.setCallState(EaseCallState.CALL_IDLE);
                EaseCallKit.this.setCallID(null);
            }
        });
    }

    private class TimeHandler
    extends Handler {
        private final int MSG_TIMER = 0;
        private final int MSG_START_ACTIVITY = 1;
        private int timePassed = 0;
        private boolean isAgreedInHeadDialog = false;

        public void startTime() {
            this.timePassed = 0;
            this.sendEmptyMessageDelayed(0, 1000L);
        }

        public void startSendEvent(boolean isAgreedInHeadDialog) {
            this.isAgreedInHeadDialog = isAgreedInHeadDialog;
            this.sendEmptyMessage(1);
        }

        public void stopTime() {
            this.removeMessages(1);
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                if (this.timePassed * 1000 == 5000) {
                    EaseCallKit.this.timeHandler.stopTime();
                    EaseCallKit.this.callState = EaseCallState.CALL_IDLE;
                }
                this.sendEmptyMessageDelayed(0, 1000L);
            } else if (msg.what == 1) {
                EaseCallKit.this.timeHandler.stopTime();
                String info = "";
                String userName = EaseCallKitUtils.getUserNickName(EaseCallKit.this.fromUserId);
                if (EaseCallKit.this.callType != EaseCallType.CONFERENCE_VIDEO_CALL && EaseCallKit.this.callType != EaseCallType.CONFERENCE_VOICE_CALL) {
                    EaseCallKit.this.curCallCls = EaseCallKit.this.defaultVideoCallCls;
                    Intent intent = new Intent(EaseCallKit.this.mContext, EaseCallKit.this.curCallCls).addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = true;
                    bundle.putBoolean("isComingCall", true);
                    bundle.putString("channelName", EaseCallKit.this.channelName);
                    bundle.putString("username", EaseCallKit.this.fromUserId);
                    bundle.putBoolean("isAgreedInHeadDialog", this.isAgreedInHeadDialog);
                    intent.putExtras(bundle);
                    EaseCallKit.this.mContext.startActivity(intent);
                    if (Build.VERSION.SDK_INT >= 29 && !EasyUtils.isAppRunningForeground((Context)EaseCallKit.this.mContext)) {
                        EMLog.e((String)TAG, (String)("notifier.notify:" + info));
                        info = EaseCallKit.this.callType == EaseCallType.SINGLE_VIDEO_CALL ? EaseCallKit.this.mContext.getString(R.string.ease_call_alert_request_video, new Object[]{userName}) : EaseCallKit.this.mContext.getString(R.string.ease_call_alert_request_voice, new Object[]{userName});
                        EaseCallKit.this.notifier.notify(intent, EaseCallKit.this.mContext.getString(R.string.ease_call_agora), info);
                    }
                } else {
                    EaseCallKit.this.curCallCls = EaseCallKit.this.defaultMultiVideoCls;
                    Intent intent = new Intent(EaseCallKit.this.mContext, EaseCallKit.this.curCallCls).addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = true;
                    bundle.putBoolean("isComingCall", true);
                    bundle.putString("channelName", EaseCallKit.this.channelName);
                    bundle.putString("username", EaseCallKit.this.fromUserId);
                    bundle.putBoolean("isAgreedInHeadDialog", this.isAgreedInHeadDialog);
                    intent.putExtras(bundle);
                    EaseCallKit.this.mContext.startActivity(intent);
                    if (Build.VERSION.SDK_INT >= 29 && EaseCallKitUtils.isAppRunningForeground(EaseCallKit.this.mContext)) {
                        info = EaseCallKit.this.mContext.getString(R.string.ease_call_alert_request_multiple_video, new Object[]{userName});
                        EaseCallKit.this.notifier.notify(intent, EaseCallKit.this.mContext.getString(R.string.ease_call_agora), info);
                    }
                }
                if (EaseCallKit.this.callListener != null) {
                    EaseCallKit.this.callListener.onReceivedCall(EaseCallKit.this.callType, EaseCallKit.this.fromUserId, EaseCallKit.this.inviteExt);
                }
            }
            super.handleMessage(msg);
        }
    }
}

