/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.general;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import io.agora.chat.ChatClient;
import io.agora.chat.callkit.EaseCallKit;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.bean.EaseUserAccount;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.ui.EaseCallBaseActivity;
import io.agora.chat.callkit.utils.EaseCallImageUtil;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.widget.EaseCallChronometer;
import io.agora.chat.callkit.widget.EaseCallImageView;
import io.agora.chat.callkit.widget.EaseCallMemberView;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.util.EMLog;
import java.util.Map;

public class EaseCallFloatWindow {
    private static final String TAG = "EaseCallFloatWindow";
    private static final int UPDATA_FLOAT_WINDOW_TIME = 111;
    private Context context;
    private static EaseCallFloatWindow instance;
    private WindowManager windowManager = null;
    private WindowManager.LayoutParams layoutParams = null;
    private View floatView;
    private EaseCallImageView avatarView;
    private TextureView textureView;
    private int screenWidth;
    private int floatViewWidth;
    private EaseCallType callType;
    private EaseCallMemberView memberView;
    private RtcEngine rtcEngine;
    private int uId;
    private long costSeconds;
    private ConferenceInfo conferenceInfo;
    private SingleCallInfo singleCallInfo;
    private Handler handler = new Handler(){

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == 111) {
                EaseCallFloatWindow.this.handler.removeMessages(111);
                EaseCallFloatWindow.this.tvTime.setText((CharSequence)EaseCallKitUtils.getCallTimeFormatString(EaseCallFloatWindow.this.getTotalCostSeconds()));
                EaseCallFloatWindow.this.handler.sendEmptyMessageDelayed(111, 1L);
            }
        }
    };
    private TextView tvTime;
    private boolean isRemoteVideoMuted;
    private String currentInstanceName;
    private EaseCallChronometer chronometer;

    public EaseCallFloatWindow(Context context) {
        this.initFloatWindow(context);
    }

    private EaseCallFloatWindow() {
    }

    public static EaseCallFloatWindow getInstance(Context context) {
        if (instance == null) {
            instance = new EaseCallFloatWindow(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseCallFloatWindow getInstance() {
        if (instance != null) return instance;
        Class<EaseCallFloatWindow> clazz = EaseCallFloatWindow.class;
        synchronized (EaseCallFloatWindow.class) {
            if (instance != null) return instance;
            instance = new EaseCallFloatWindow();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
    }

    public EaseCallMemberView getCallMemberView() {
        return this.memberView;
    }

    public void setRtcEngine(RtcEngine rtcEngine) {
        this.rtcEngine = rtcEngine;
    }

    public void setRtcEngine(Context context, RtcEngine rtcEngine) {
        this.rtcEngine = rtcEngine;
        this.initFloatWindow(context);
    }

    private void initFloatWindow(Context context) {
        this.currentInstanceName = context.toString();
        this.context = context.getApplicationContext();
        this.windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        Point point = new Point();
        this.windowManager.getDefaultDisplay().getSize(point);
        this.screenWidth = point.x;
    }

    public EaseCallType getCallType() {
        return this.callType;
    }

    public void setCostSeconds(long seconds) {
        this.costSeconds = seconds;
    }

    public boolean isRemoteVideoMuted() {
        return this.isRemoteVideoMuted;
    }

    public void setRemoteVideoMuted(boolean remoteVideoMuted) {
        this.isRemoteVideoMuted = remoteVideoMuted;
    }

    public void show() {
        if (this.floatView != null) {
            return;
        }
        this.layoutParams = new WindowManager.LayoutParams();
        this.layoutParams.gravity = 8388661;
        this.layoutParams.width = -2;
        this.layoutParams.height = -2;
        this.layoutParams.format = -2;
        this.layoutParams.type = EaseCallKitUtils.getSupportedWindowType();
        this.layoutParams.flags = 131080;
        this.floatView = LayoutInflater.from((Context)this.context).inflate(R.layout.ease_call_activity_float_window, null);
        this.floatView.setFocusableInTouchMode(true);
        if (this.floatView instanceof ViewGroup) {
            this.chronometer = new EaseCallChronometer(this.context);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(0, 0);
            ((ViewGroup)this.floatView).addView((View)this.chronometer, params);
        }
        this.windowManager.addView(this.floatView, (ViewGroup.LayoutParams)this.layoutParams);
        this.startCount();
        if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            this.conferenceInfo = new ConferenceInfo();
        } else {
            this.singleCallInfo = new SingleCallInfo();
        }
        this.floatView.post(new Runnable(){

            @Override
            public void run() {
                if (EaseCallFloatWindow.this.floatView != null) {
                    EaseCallFloatWindow.this.floatViewWidth = EaseCallFloatWindow.this.floatView.getWidth();
                }
            }
        });
        this.avatarView = (EaseCallImageView)this.floatView.findViewById(R.id.iv_avatar);
        this.tvTime = (TextView)this.floatView.findViewById(R.id.tv_time);
        this.floatView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Class<? extends EaseCallBaseActivity> callClass = EaseCallKit.getInstance().getCurrentCallClass();
                Log.e((String)"TAG", (String)("current call class: " + callClass));
                if (callClass != null) {
                    Intent intent = new Intent(EaseCallFloatWindow.this.context, callClass);
                    intent.addFlags(0x10000000);
                    if (EaseCallFloatWindow.this.callType != EaseCallType.CONFERENCE_VIDEO_CALL) {
                        intent.putExtra("uId", EaseCallFloatWindow.this.singleCallInfo != null ? ((EaseCallFloatWindow)EaseCallFloatWindow.this).singleCallInfo.remoteUid : 0);
                    }
                    intent.putExtra("isClickByFloat", true);
                    EaseCallKit.getInstance().getContext().startActivity(intent);
                } else {
                    EMLog.e((String)EaseCallFloatWindow.TAG, (String)"Current call class is null, please not call EaseCallKit.getInstance().releaseCall() before the call is finished");
                }
            }
        });
        this.floatView.setOnTouchListener(new View.OnTouchListener(){
            boolean result = false;
            int left;
            int top;
            float startX = 0.0f;
            float startY = 0.0f;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.result = false;
                        this.startX = event.getRawX();
                        this.startY = event.getRawY();
                        this.left = ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x;
                        this.top = ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y;
                        EMLog.i((String)EaseCallFloatWindow.TAG, (String)("startX: " + this.startX + ", startY: " + this.startY + ", left: " + this.left + ", top: " + this.top));
                        break;
                    }
                    case 2: {
                        if (Math.abs(event.getRawX() - this.startX) > 20.0f || Math.abs(event.getRawY() - this.startY) > 20.0f) {
                            this.result = true;
                        }
                        int deltaX = (int)(this.startX - event.getRawX());
                        ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x = this.left + deltaX;
                        ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y = (int)((float)this.top + event.getRawY() - this.startY);
                        EMLog.i((String)EaseCallFloatWindow.TAG, (String)("startX: " + (event.getRawX() - this.startX) + ", startY: " + (event.getRawY() - this.startY) + ", left: " + this.left + ", top: " + this.top));
                        EaseCallFloatWindow.this.windowManager.updateViewLayout(EaseCallFloatWindow.this.floatView, (ViewGroup.LayoutParams)EaseCallFloatWindow.this.layoutParams);
                        break;
                    }
                    case 1: {
                        EaseCallFloatWindow.this.smoothScrollToBorder();
                    }
                }
                return this.result;
            }
        });
    }

    private void startCount() {
        if (this.chronometer != null) {
            this.chronometer.setBase(SystemClock.elapsedRealtime());
            this.chronometer.start();
        }
    }

    private void stopCount() {
        if (this.chronometer != null) {
            this.chronometer.stop();
            this.chronometer = null;
        }
    }

    public long getFloatCostSeconds() {
        if (this.chronometer != null) {
            return this.chronometer.getCostSeconds();
        }
        Log.e((String)TAG, (String)"chronometer is null, can not get cost seconds");
        return 0L;
    }

    public long getTotalCostSeconds() {
        if (this.chronometer != null) {
            Log.e((String)"activity", (String)("costSeconds: " + this.chronometer.getCostSeconds()));
        }
        if (this.chronometer != null) {
            return this.costSeconds + this.chronometer.getCostSeconds();
        }
        Log.e((String)TAG, (String)"chronometer is null, can not get total cost seconds");
        return 0L;
    }

    public void setConferenceInfo(ConferenceInfo info) {
        this.conferenceInfo = info;
    }

    public ConferenceInfo getConferenceInfo() {
        return this.conferenceInfo;
    }

    public void update(EaseCallMemberView view) {
        if (this.floatView == null) {
            return;
        }
        this.memberView = view;
        this.uId = this.memberView.getUserId();
        if (this.memberView.isShowVideo()) {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(0);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(8);
        } else {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(8);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(0);
            String userAccount = this.memberView.getUserAccount();
            int uId = this.memberView.getUserId();
            boolean isSelf = TextUtils.equals((CharSequence)userAccount, (CharSequence)ChatClient.getInstance().getCurrentUser());
            this.prepareSurfaceView(isSelf, uId);
        }
        this.handler.removeMessages(111);
        this.handler.sendEmptyMessage(111);
    }

    public void update(boolean isSelf, String remoteUrl, int curUid, int remoteUid, boolean surface) {
        if (this.floatView == null) {
            return;
        }
        if (this.singleCallInfo == null) {
            this.singleCallInfo = new SingleCallInfo();
        }
        this.singleCallInfo.curUid = curUid;
        this.singleCallInfo.remoteUid = remoteUid;
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL && surface && !this.isRemoteVideoMuted) {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(8);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(0);
            this.prepareSurfaceView(isSelf, isSelf ? curUid : remoteUid);
        } else {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(0);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(8);
            EaseCallImageUtil.setImage(this.context, (ImageView)this.avatarView, remoteUrl);
        }
        this.handler.removeMessages(111);
        this.handler.sendEmptyMessage(111);
    }

    public SingleCallInfo getSingleCallInfo() {
        return this.singleCallInfo;
    }

    public void setCameraDirection(boolean isFront, boolean changeFlag) {
        if (this.singleCallInfo == null) {
            this.singleCallInfo = new SingleCallInfo();
        }
        this.singleCallInfo.isCameraFront = isFront;
        this.singleCallInfo.changeFlag = changeFlag;
    }

    public boolean isShowing() {
        if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            return this.memberView != null;
        }
        return this.floatView != null;
    }

    public int getUid() {
        if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL && this.memberView != null) {
            return this.memberView.getUserId();
        }
        if ((this.callType == EaseCallType.SINGLE_VIDEO_CALL || this.callType == EaseCallType.SINGLE_VOICE_CALL) && this.singleCallInfo != null) {
            return this.singleCallInfo.remoteUid;
        }
        return -1;
    }

    public void dismiss() {
        Log.i((String)TAG, (String)"dismiss: ");
        if (this.windowManager != null && this.floatView != null) {
            this.stopCount();
            this.windowManager.removeView(this.floatView);
        }
        this.floatView = null;
        this.memberView = null;
        this.textureView = null;
        this.avatarView = null;
        this.tvTime = null;
        if (this.conferenceInfo != null) {
            this.conferenceInfo = null;
        }
        if (this.singleCallInfo != null) {
            this.singleCallInfo = null;
        }
        this.handler.removeCallbacksAndMessages(null);
        this.currentInstanceName = null;
        this.rtcEngine = null;
    }

    public void resetCurrentInstance() {
        this.currentInstanceName = null;
    }

    public String getCurrentInstance() {
        return this.currentInstanceName;
    }

    private void prepareSurfaceView(boolean isSelf, int uid) {
        RelativeLayout surfaceLayout = (RelativeLayout)this.floatView.findViewById(R.id.layout_call_video);
        surfaceLayout.removeAllViews();
        this.textureView = RtcEngine.CreateTextureView((Context)EaseCallKit.getInstance().getContext());
        EaseCallImageUtil.setBgRadius((View)this.textureView, EaseCallKitUtils.dp2px(this.context, 12));
        surfaceLayout.addView((View)this.textureView);
        if (isSelf) {
            this.rtcEngine.setupLocalVideo(new VideoCanvas((View)this.textureView, 1, 0));
        } else {
            this.rtcEngine.setupRemoteVideo(new VideoCanvas((View)this.textureView, 1, uid));
        }
    }

    private void smoothScrollToBorder() {
        EMLog.i((String)TAG, (String)("screenWidth: " + this.screenWidth + ", floatViewWidth: " + this.floatViewWidth));
        int splitLine = this.screenWidth / 2 - this.floatViewWidth / 2;
        int left = this.layoutParams.x;
        final int top = this.layoutParams.y;
        int targetX = left < splitLine ? 0 : this.screenWidth - this.floatViewWidth;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{left, targetX});
        animator.setDuration(100L).addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (EaseCallFloatWindow.this.floatView == null) {
                    return;
                }
                int value = (Integer)animation.getAnimatedValue();
                EMLog.i((String)EaseCallFloatWindow.TAG, (String)("onAnimationUpdate, value: " + value));
                ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x = value;
                ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y = top;
                EaseCallFloatWindow.this.windowManager.updateViewLayout(EaseCallFloatWindow.this.floatView, (ViewGroup.LayoutParams)EaseCallFloatWindow.this.layoutParams);
            }
        });
        animator.start();
    }

    public static class ConferenceInfo {
        public Map<Integer, ViewState> uidToViewList;
        public Map<String, Integer> userAccountToUidMap;
        public Map<Integer, EaseUserAccount> uidToUserAccountMap;

        public static class ViewState {
            public boolean isVideoOff;
            public boolean isAudioOff;
            public boolean isFullScreenMode;
            public boolean speakActivated;
            public boolean isCameraFront;
        }
    }

    public static class SingleCallInfo {
        public int curUid;
        public int remoteUid;
        public boolean isCameraFront = true;
        public boolean changeFlag;
    }
}

