/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.livedatas;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class EaseCallLiveDataBus {
    private final Map<String, BusMutableLiveData<Object>> bus = new HashMap<String, BusMutableLiveData<Object>>();

    private EaseCallLiveDataBus() {
    }

    public static EaseCallLiveDataBus get() {
        return SingletonHolder.DEFAULT_BUS;
    }

    public <T> MutableLiveData<T> with(String key, Class<T> type) {
        if (!this.bus.containsKey(key)) {
            this.bus.put(key, new BusMutableLiveData());
        }
        return this.bus.get(key);
    }

    public MutableLiveData<Object> with(String key) {
        return this.with(key, Object.class);
    }

    private static class BusMutableLiveData<T>
    extends MutableLiveData<T> {
        private Map<Observer, Observer> observerMap = new HashMap<Observer, Observer>();

        private BusMutableLiveData() {
        }

        public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<? super T> observer) {
            super.observe(owner, observer);
            try {
                this.hook(observer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void observeForever(@NonNull Observer<? super T> observer) {
            if (!this.observerMap.containsKey(observer)) {
                this.observerMap.put(observer, new ObserverWrapper<T>(observer));
            }
            super.observeForever(this.observerMap.get(observer));
        }

        public void removeObserver(@NonNull Observer<? super T> observer) {
            Observer realObserver = null;
            realObserver = this.observerMap.containsKey(observer) ? this.observerMap.remove(observer) : observer;
            super.removeObserver(realObserver);
        }

        private void hook(@NonNull Observer<? super T> observer) throws Exception {
            Class<LiveData> classLiveData = LiveData.class;
            Field fieldObservers = classLiveData.getDeclaredField("mObservers");
            fieldObservers.setAccessible(true);
            Object objectObservers = fieldObservers.get((Object)this);
            Class<?> classObservers = objectObservers.getClass();
            Method methodGet = classObservers.getDeclaredMethod("get", Object.class);
            methodGet.setAccessible(true);
            Object objectWrapperEntry = methodGet.invoke(objectObservers, observer);
            Object objectWrapper = null;
            if (objectWrapperEntry instanceof Map.Entry) {
                objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
            }
            if (objectWrapper == null) {
                throw new NullPointerException("Wrapper can not be bull!");
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field fieldLastVersion = classObserverWrapper.getDeclaredField("mLastVersion");
            fieldLastVersion.setAccessible(true);
            Field fieldVersion = classLiveData.getDeclaredField("mVersion");
            fieldVersion.setAccessible(true);
            Object objectVersion = fieldVersion.get((Object)this);
            fieldLastVersion.set(objectWrapper, objectVersion);
        }
    }

    private static class ObserverWrapper<T>
    implements Observer<T> {
        private Observer<T> observer;

        public ObserverWrapper(Observer<T> observer) {
            this.observer = observer;
        }

        public void onChanged(@Nullable T t) {
            if (this.observer != null) {
                if (this.isCallOnObserve()) {
                    return;
                }
                this.observer.onChanged(t);
            }
        }

        private boolean isCallOnObserve() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                for (StackTraceElement element : stackTrace) {
                    if (!"android.arch.lifecycle.LiveData".equals(element.getClassName()) || !"observeForever".equals(element.getMethodName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class SingletonHolder {
        private static final EaseCallLiveDataBus DEFAULT_BUS = new EaseCallLiveDataBus();

        private SingletonHolder() {
        }
    }
}

