/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.livedatas;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;

public class EaseCallSingleSourceLiveData<T>
extends MutableLiveData<T> {
    private LiveData<T> lastSource;
    private T lastData;
    private final Observer<T> observer = new Observer<T>(){

        public void onChanged(T t) {
            if (t != null && t == EaseCallSingleSourceLiveData.this.lastData) {
                return;
            }
            EaseCallSingleSourceLiveData.this.lastData = t;
            EaseCallSingleSourceLiveData.this.setValue(t);
        }
    };

    public void setSource(LiveData<T> source) {
        if (this.lastSource == source) {
            return;
        }
        if (this.lastSource != null) {
            this.lastSource.removeObserver(this.observer);
        }
        this.lastSource = source;
        if (this.hasActiveObservers()) {
            this.lastSource.observeForever(this.observer);
        }
    }

    protected void onActive() {
        super.onActive();
        if (this.lastSource != null) {
            this.lastSource.observeForever(this.observer);
        }
    }

    protected void onInactive() {
        super.onInactive();
        if (this.lastSource != null) {
            this.lastSource.removeObserver(this.observer);
        }
    }
}

