/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import io.agora.CallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.CmdMessageBody;
import io.agora.chat.Conversation;
import io.agora.chat.MessageBody;
import io.agora.chat.callkit.EaseCallKit;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.bean.EaseCallUserInfo;
import io.agora.chat.callkit.bean.EaseUserAccount;
import io.agora.chat.callkit.databinding.EaseCallActivityMultipleBinding;
import io.agora.chat.callkit.event.EaseCallAlertEvent;
import io.agora.chat.callkit.event.EaseCallAnswerEvent;
import io.agora.chat.callkit.event.EaseCallBaseEvent;
import io.agora.chat.callkit.event.EaseCallCallCancelEvent;
import io.agora.chat.callkit.event.EaseCallConfirmCallEvent;
import io.agora.chat.callkit.event.EaseCallConfirmRingEvent;
import io.agora.chat.callkit.general.EaseCallAction;
import io.agora.chat.callkit.general.EaseCallEndReason;
import io.agora.chat.callkit.general.EaseCallError;
import io.agora.chat.callkit.general.EaseCallFloatWindow;
import io.agora.chat.callkit.general.EaseCallKitConfig;
import io.agora.chat.callkit.general.EaseCallProcessError;
import io.agora.chat.callkit.general.EaseCallState;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.listener.EaseCallGetUserAccountCallback;
import io.agora.chat.callkit.listener.EaseCallKitListener;
import io.agora.chat.callkit.listener.EaseCallKitTokenCallback;
import io.agora.chat.callkit.livedatas.EaseCallLiveDataBus;
import io.agora.chat.callkit.ui.EaseCallBaseActivity;
import io.agora.chat.callkit.utils.EaseCallAudioControl;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.utils.EaseCallMsgUtils;
import io.agora.chat.callkit.widget.EaseCallCommingCallView;
import io.agora.chat.callkit.widget.EaseCallMemberView;
import io.agora.chat.callkit.widget.EaseCallMemberViewGroup;
import io.agora.rtc2.ClientRoleOptions;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.UserInfo;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoEncoderConfiguration;
import io.agora.util.EMLog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseCallMultipleBaseActivity
extends EaseCallBaseActivity
implements View.OnClickListener {
    private static final String TAG = EaseCallMultipleBaseActivity.class.getSimpleName();
    private TimeHandler timeHandler;
    private TimeHandler timeUpdataTimer;
    private RtcEngine mRtcEngine;
    protected boolean isInComingCall;
    protected String username;
    protected String channelName;
    private volatile boolean mConfirRing = false;
    private EaseCallType callType;
    private boolean isMuteState = false;
    private boolean isVideoMute = false;
    private boolean isCameraFront = true;
    private EaseCallMemberView localMemberView;
    private String agoraAppId = null;
    private boolean isAgreedInHeadDialog;
    private static final int PERMISSION_REQ_ID = 22;
    private final String[] permissions = new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA"};
    List<String> mPermissionList = new ArrayList<String>();
    private EaseCallActivityMultipleBinding mBinding;
    private String groupId;
    private boolean isPreview;
    private Bundle savedInstanceState;
    private Map<String, Long> invitedUsersTime = new HashMap<String, Long>();
    private final Map<Integer, EaseCallMemberView> inChannelViews = new HashMap<Integer, EaseCallMemberView>();
    private Map<Integer, EaseUserAccount> inChannelAccounts = new HashMap<Integer, EaseUserAccount>();
    private final Map<String, Integer> userIdAndUidMap = new HashMap<String, Integer>();
    private final Map<String, EaseCallMemberView> placeholders = new HashMap<String, EaseCallMemberView>();
    private List<Integer> uidsNotSpeak = new ArrayList<Integer>();
    private Set<String> effectiveUsers = new HashSet<String>();
    EaseCallKitListener listener = EaseCallKit.getInstance().getCallListener();
    private final IRtcEngineEventHandler mRtcEventHandler = new IRtcEngineEventHandler(){

        public void onError(int err) {
            super.onError(err);
            EMLog.d((String)TAG, (String)("IRtcEngineEventHandler onError:" + err));
            if (EaseCallMultipleBaseActivity.this.listener != null) {
                EaseCallMultipleBaseActivity.this.listener.onCallError(EaseCallError.RTC_ERROR, err, "rtc error");
            }
        }

        public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
            ArrayList<String> userList;
            EMLog.d((String)TAG, (String)("onJoinChannelSuccess channel:" + channel + " uid" + uid));
            EaseCallMultipleBaseActivity.this.timeUpdataTimer.startTime(1);
            if (!EaseCallMultipleBaseActivity.this.isInComingCall && (userList = EaseCallKit.getInstance().getInviteeUsers()) != null && userList.size() > 0) {
                EaseCallMultipleBaseActivity.this.handler.sendEmptyMessage(102);
                EaseCallMultipleBaseActivity.this.isInComingCall = false;
            }
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.chronometer.start();
                }
            });
        }

        public void onRejoinChannelSuccess(String channel, int uid, int elapsed) {
            super.onRejoinChannelSuccess(channel, uid, elapsed);
        }

        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            super.onLeaveChannel(stats);
        }

        public void onClientRoleChanged(int oldRole, int newRole, ClientRoleOptions newRoleOptions) {
            super.onClientRoleChanged(oldRole, newRole, newRoleOptions);
        }

        public void onLocalUserRegistered(int uid, String userAccount) {
            super.onLocalUserRegistered(uid, userAccount);
        }

        public void onUserInfoUpdated(final int uid, final UserInfo userInfo) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView placeView;
                    EMLog.d((String)TAG, (String)("onUserInfoUpdated onUserOffline: " + uid + ", account:" + userInfo.userAccount));
                    EaseUserAccount account = new EaseUserAccount(userInfo.uid, userInfo.userAccount);
                    EaseCallMultipleBaseActivity.this.inChannelAccounts.put(uid, account);
                    if (!EaseCallMultipleBaseActivity.this.userIdAndUidMap.containsValue(uid)) {
                        EaseCallMultipleBaseActivity.this.userIdAndUidMap.put(userInfo.userAccount, uid);
                    }
                    if ((placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(userInfo.userAccount))) != null) {
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                    }
                    if (EaseCallMultipleBaseActivity.this.inChannelViews.containsKey(uid)) {
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                        if (memberView != null) {
                            memberView.setUserInfo(account);
                        }
                    } else {
                        EaseCallMultipleBaseActivity.this.notifyUserToUpdateUserInfo(userInfo.userAccount, uid);
                        EaseCallMemberView memberView = new EaseCallMemberView(EaseCallMultipleBaseActivity.this.getApplicationContext());
                        memberView.setUserInfo(account);
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.addView((View)memberView);
                        EaseCallMultipleBaseActivity.this.inChannelViews.put(uid, memberView);
                    }
                }
            });
        }

        public void onUserJoined(int uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
            EaseCallAudioControl.getInstance().stopPlayRing();
            EaseCallMultipleBaseActivity.this.setUserJoinChannelInfo(null, uid);
        }

        public void onUserOffline(final int uid, final int reason) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView;
                    EMLog.d((String)TAG, (String)("onUserOffline: " + uid + ",reason:" + reason));
                    if (EaseCallMultipleBaseActivity.this.isFinishing()) {
                        return;
                    }
                    EaseUserAccount account = (EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid);
                    if (account != null) {
                        EaseCallMultipleBaseActivity.this.effectiveUsers.remove(account.getUserName());
                    }
                    if ((memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.remove(uid))) == null) {
                        return;
                    }
                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)memberView);
                    if (EaseCallMultipleBaseActivity.this.userIdAndUidMap.containsValue(uid) && account != null) {
                        EaseCallMultipleBaseActivity.this.userIdAndUidMap.remove(account.getUserName());
                    }
                    int tempUid = 0;
                    if (EaseCallMultipleBaseActivity.this.inChannelViews.size() > 0) {
                        Set uidSet = EaseCallMultipleBaseActivity.this.inChannelViews.keySet();
                        Iterator iterator = uidSet.iterator();
                        while (iterator.hasNext()) {
                            int id2;
                            tempUid = id2 = ((Integer)iterator.next()).intValue();
                        }
                        EaseCallMultipleBaseActivity.this.updateFloatWindow((EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(tempUid)));
                    }
                    if (EaseCallMultipleBaseActivity.this.inChannelAccounts != null) {
                        EaseCallMultipleBaseActivity.this.inChannelAccounts.remove(uid);
                    }
                }
            });
        }

        public void onFirstRemoteVideoDecoded(final int uid, int width, int height, int elapsed) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (EaseCallMultipleBaseActivity.this.isFinishing()) {
                        return;
                    }
                    if (EaseCallMultipleBaseActivity.this.inChannelViews.containsKey(uid)) {
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                        if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid)) {
                            memberView.setUserInfo((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid));
                            if (!EaseCallMultipleBaseActivity.this.userIdAndUidMap.containsValue(uid)) {
                                EaseCallMultipleBaseActivity.this.userIdAndUidMap.put(((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid)).getUserName(), uid);
                            }
                        }
                        if (memberView != null) {
                            EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(memberView.getUserAccount()));
                            if (placeView != null) {
                                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                            }
                            if (memberView.getSurfaceView() == null) {
                                SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)EaseCallMultipleBaseActivity.this.getApplicationContext());
                                memberView.addSurfaceView(surfaceView);
                                surfaceView.setZOrderOnTop(false);
                                memberView.showVideo(false);
                                surfaceView.setZOrderMediaOverlay(false);
                                EaseCallMultipleBaseActivity.this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)surfaceView, 1, uid));
                            } else {
                                memberView.showVideo(false);
                            }
                        }
                    } else {
                        EaseUserAccount account;
                        EaseCallMemberView placeView;
                        EaseCallMemberView memberView = EaseCallMultipleBaseActivity.this.createCallMemberView();
                        if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid)) {
                            memberView.setUserInfo((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid));
                        }
                        if ((placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(memberView.getUserAccount()))) != null) {
                            ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                        }
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.addView((View)memberView);
                        memberView.showVideo(false);
                        EaseCallMultipleBaseActivity.this.inChannelViews.put(uid, memberView);
                        EaseCallMultipleBaseActivity.this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)memberView.getSurfaceView(), 1, uid));
                        if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid) && (account = (EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid)) != null) {
                            EaseCallMultipleBaseActivity.this.notifyUserToUpdateUserInfo(account.getUserName(), uid);
                        }
                    }
                }
            });
        }

        public void onRemoteVideoStateChanged(final int uid, final int state, int reason, int elapsed) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                    if (memberView != null) {
                        EaseCallMemberView floatView;
                        if (state == 0 || state == 5) {
                            memberView.showVideo(true);
                        } else if (state == 2 || state == 6) {
                            memberView.showVideo(false);
                        }
                        if ((state == 0 || state == 5 || state == 2 || state == 6) && (floatView = EaseCallFloatWindow.getInstance().getCallMemberView()) != null && floatView.getUserId() == uid) {
                            EaseCallMultipleBaseActivity.this.updateFloatWindow((EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid)));
                        }
                    }
                }
            });
        }

        public void onRemoteAudioStateChanged(final int uid, final int state, int reason, final int elapsed) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (state == 1) {
                        EMLog.d((String)TAG, (String)("onRemoteAudioStateChanged:" + uid + ",elapsed:" + elapsed));
                        if (EaseCallMultipleBaseActivity.this.isFinishing()) {
                            return;
                        }
                        if (EaseCallMultipleBaseActivity.this.inChannelViews.containsKey(uid)) {
                            EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                            if (memberView != null) {
                                memberView.setAudioOff(false);
                            }
                            if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid)) {
                                memberView.setUserInfo((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid));
                            }
                            if (!EaseCallMultipleBaseActivity.this.userIdAndUidMap.containsValue(uid) && EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid) != null && ((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid)).getUserName() != null) {
                                EaseCallMultipleBaseActivity.this.userIdAndUidMap.put(((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid)).getUserName(), uid);
                            }
                        } else {
                            EaseUserAccount account;
                            EaseCallMemberView placeView;
                            EaseCallMemberView memberView = new EaseCallMemberView(EaseCallMultipleBaseActivity.this.getApplicationContext());
                            if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid)) {
                                memberView.setUserInfo((EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid));
                            }
                            if ((placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(memberView.getUserAccount()))) != null) {
                                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                            }
                            memberView.setAudioOff(false);
                            ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.addView((View)memberView);
                            EaseCallMultipleBaseActivity.this.inChannelViews.put(uid, memberView);
                            if (EaseCallMultipleBaseActivity.this.inChannelAccounts.containsKey(uid) && (account = (EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid)) != null) {
                                EaseCallMultipleBaseActivity.this.notifyUserToUpdateUserInfo(account.getUserName(), uid);
                            }
                        }
                    } else {
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                        if (memberView != null) {
                            if (state == 5 || state == 0) {
                                memberView.setAudioOff(true);
                            } else if (state == 2 || state == 6) {
                                memberView.setAudioOff(false);
                            }
                        }
                    }
                }
            });
        }

        public void onAudioVolumeIndication(final IRtcEngineEventHandler.AudioVolumeInfo[] speakers, int totalVolume) {
            EaseCallMultipleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (speakers != null && speakers.length > 0) {
                        EaseCallMultipleBaseActivity.this.uidsNotSpeak.clear();
                        EaseCallMultipleBaseActivity.this.uidsNotSpeak.addAll(EaseCallMultipleBaseActivity.this.inChannelViews.keySet());
                        for (IRtcEngineEventHandler.AudioVolumeInfo info : speakers) {
                            EaseCallMemberView memberView;
                            Integer uId = info.uid;
                            int volume = info.volume;
                            EMLog.d((String)TAG, (String)("onAudioVolumeIndication:" + uId + ",volume: " + volume));
                            if (!EaseCallMultipleBaseActivity.this.uidsNotSpeak.contains(uId) || (memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uId))) == null || memberView.getAudioOff()) continue;
                            memberView.setSpeak(true, volume);
                            EaseCallMultipleBaseActivity.this.uidsNotSpeak.remove(uId);
                        }
                        if (EaseCallMultipleBaseActivity.this.uidsNotSpeak.size() > 0) {
                            Iterator iterator = EaseCallMultipleBaseActivity.this.uidsNotSpeak.iterator();
                            while (iterator.hasNext()) {
                                int uid = (Integer)iterator.next();
                                EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                                if (memberView == null || memberView.getAudioOff()) continue;
                                memberView.setSpeak(false, 0);
                            }
                        }
                    }
                }
            });
        }
    };
    private EaseCallCommingCallView.OnActionListener onActionListener = new EaseCallCommingCallView.OnActionListener(){

        @Override
        public void onPickupClick(View v) {
            EaseCallAudioControl.getInstance().stopPlayRing();
            EaseCallMultipleBaseActivity.this.addLocalViewToConferenceViewsGroup();
            ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.incomingCallView.setVisibility(8);
            if (EaseCallMultipleBaseActivity.this.isInComingCall) {
                EaseCallMultipleBaseActivity.this.sendAgreeMessage();
            }
        }

        @Override
        public void onMuteVideoClick(View v) {
            if (EaseCallMultipleBaseActivity.this.isPreview) {
                EaseCallMultipleBaseActivity.this.mRtcEngine.stopPreview();
                EaseCallMultipleBaseActivity.this.localMemberView.setVisibility(8);
                EaseCallMultipleBaseActivity.this.isPreview = false;
            } else {
                EaseCallMultipleBaseActivity.this.mRtcEngine.startPreview();
                EaseCallMultipleBaseActivity.this.localMemberView.setVisibility(0);
                EaseCallMultipleBaseActivity.this.isPreview = true;
            }
            ((ImageView)v).setImageResource(EaseCallMultipleBaseActivity.this.isPreview ? R.drawable.call_video_off : R.drawable.call_video_on);
        }

        @Override
        public void onSwitchCamerClick(View v) {
            if (EaseCallMultipleBaseActivity.this.isCameraFront) {
                EaseCallMultipleBaseActivity.this.changeCameraDirect(false);
            } else {
                EaseCallMultipleBaseActivity.this.changeCameraDirect(true);
            }
        }

        @Override
        public void onRejectClick(View v) {
            if (EaseCallMultipleBaseActivity.this.isInComingCall) {
                EaseCallAudioControl.getInstance().stopPlayRing();
                EaseCallAnswerEvent event = new EaseCallAnswerEvent();
                event.result = EaseCallMsgUtils.CALL_ANSWER_REFUSE;
                event.callId = EaseCallKit.getInstance().getCallID();
                event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallKit.deviceId;
                EaseCallMultipleBaseActivity.this.sendCmdMsg(event, EaseCallMultipleBaseActivity.this.username);
            }
            EaseCallMultipleBaseActivity.this.exitChannel();
        }
    };
    private EaseCallMemberViewGroup.OnScreenModeChangeListener onScreenModeChangeListener = new EaseCallMemberViewGroup.OnScreenModeChangeListener(){

        @Override
        public void onScreenModeChange(boolean isFullScreenMode, @Nullable View fullScreenView) {
            if (isFullScreenMode) {
                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.rlVideoControl.setVisibility(8);
            } else {
                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.rlVideoControl.setVisibility(0);
            }
        }
    };
    private EaseCallMemberViewGroup.OnItemClickListener onItemClickListener = new EaseCallMemberViewGroup.OnItemClickListener(){

        @Override
        public void onItemClick(View v, int position) {
        }
    };
    protected Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            int what = msg.what;
            switch (what) {
                case 100: {
                    break;
                }
                case 101: {
                    break;
                }
                case 102: {
                    ArrayList<String> sendInviteeMsg = EaseCallKit.getInstance().getInviteeUsers();
                    EaseCallMultipleBaseActivity.this.sendInviteeMsg(sendInviteeMsg);
                    break;
                }
                case 301: {
                    EaseCallMultipleBaseActivity.this.handler.removeMessages(100);
                    EaseCallMultipleBaseActivity.this.handler.removeMessages(101);
                    EaseCallMultipleBaseActivity.this.handler.removeMessages(102);
                    break;
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBinding = EaseCallActivityMultipleBinding.inflate(this.getLayoutInflater());
        this.savedInstanceState = savedInstanceState;
        this.setContentView((View)this.mBinding.layoutRoot);
        if (Build.VERSION.SDK_INT >= 23) {
            this.initPermission();
        } else {
            this.init();
        }
    }

    private void init() {
        if (this.savedInstanceState == null) {
            this.initParams(this.getIntent().getExtras());
        } else {
            this.initParams(this.savedInstanceState);
        }
        this.initEngine();
        this.initView();
        this.addLiveDataObserver();
        this.timeHandler = new TimeHandler();
        this.timeUpdataTimer = new TimeHandler();
        this.checkConference(true);
        EaseCallKit.getInstance().getNotifier().reset();
    }

    private void initPermission() {
        this.mPermissionList.clear();
        for (int i = 0; i < this.permissions.length; ++i) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)this.permissions[i]) == 0) continue;
            this.mPermissionList.add(this.permissions[i]);
        }
        if (this.mPermissionList.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)22);
        } else {
            this.init();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean hasPermissionDismiss = false;
        if (22 == requestCode) {
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] != -1) continue;
                hasPermissionDismiss = true;
            }
            if (hasPermissionDismiss) {
                this.exitChannel();
            } else {
                this.init();
            }
        }
    }

    public void initView() {
        this.mBinding.incomingCallView.setOnActionListener(this.onActionListener);
        this.mBinding.surfaceViewGroup.setOnItemClickListener(this.onItemClickListener);
        this.mBinding.surfaceViewGroup.setOnScreenModeChangeListener(this.onScreenModeChangeListener);
        this.mBinding.btnInvite.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnMicSwitchVoice.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnSpeakerSwitchVoice.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnVidicon.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnChangeCameraSwitch.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnHangupVoice.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnFloat.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnHangupVideo.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnVidicon.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnMicSwitchVideo.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnMicSwitchVoice.setActivated(false);
        this.mBinding.btnVidicon.setActivated(true);
        this.mBinding.btnSpeakerSwitchVoice.setActivated(true);
        EaseCallAudioControl.getInstance().openSpeakerOn();
        this.mBinding.surfaceViewGroup.setCallType(this.callType);
        if (this.isInComingCall) {
            if (this.isAgreedInHeadDialog) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EaseCallMultipleBaseActivity.this.addLocalViewToConferenceViewsGroup();
                        EaseCallMultipleBaseActivity.this.sendAgreeMessage();
                    }
                });
            } else {
                EaseCallAudioControl.getInstance().playRing();
                this.mBinding.incomingCallView.setInviteInfo(this.username, this.groupId, this.callType);
                this.mBinding.incomingCallView.setVisibility(0);
                this.notifyUserToUpdateUserInfo(ChatClient.getInstance().getCurrentUser(), 0);
            }
        } else {
            this.mBinding.incomingCallView.setVisibility(8);
            ArrayList<String> inviteeUsers = EaseCallKit.getInstance().getInviteeUsers();
            if (inviteeUsers != null && inviteeUsers.size() > 0) {
                EaseCallAudioControl.getInstance().playRing();
            }
            this.joinChannel();
        }
        if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            this.mBinding.rlVideoControl.setVisibility(0);
            this.mBinding.btnChangeCameraSwitch.setVisibility(0);
        } else {
            this.mBinding.btnChangeCameraSwitch.setVisibility(8);
            this.mBinding.rlVoiceControl.setVisibility(0);
        }
    }

    private void sendAgreeMessage() {
        EaseCallAnswerEvent event = new EaseCallAnswerEvent();
        event.result = EaseCallMsgUtils.CALL_ANSWER_ACCEPT;
        event.callId = EaseCallKit.getInstance().getCallID();
        event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
        event.calleeDevId = EaseCallKit.deviceId;
        this.sendCmdMsg(event, this.username);
    }

    private void initParams(Bundle bundle) {
        if (bundle != null) {
            this.isInComingCall = bundle.getBoolean("isComingCall", false);
            this.username = bundle.getString("username");
            this.channelName = bundle.getString("channelName");
            this.isAgreedInHeadDialog = bundle.getBoolean("isAgreedInHeadDialog");
        } else {
            this.isInComingCall = EaseCallKit.getInstance().getIsComingCall();
            this.username = EaseCallKit.getInstance().getFromUserId();
            this.channelName = EaseCallKit.getInstance().getChannelName();
        }
        this.callType = EaseCallKit.getInstance().getCallType();
        try {
            JSONObject inviteExt = EaseCallKit.getInstance().getInviteExt();
            this.groupId = inviteExt.getString("groupId");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initEngine() {
        this.initializeEngine();
        this.setupVideoConfig();
        this.setupLocalVideo();
    }

    private void initializeEngine() {
        try {
            EaseCallKitConfig config = EaseCallKit.getInstance().getCallKitConfig();
            if (config != null) {
                this.agoraAppId = config.getAgoraAppId();
            }
            this.mRtcEngine = RtcEngine.create((Context)this.getApplicationContext(), (String)this.agoraAppId, (IRtcEngineEventHandler)this.mRtcEventHandler);
            this.mRtcEngine.setChannelProfile(1);
            this.mRtcEngine.setClientRole(1);
            EaseCallFloatWindow.getInstance().setCallType(this.callType);
        }
        catch (Exception e) {
            EMLog.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            throw new RuntimeException("NEED TO check rtc sdk init fatal error\n" + Log.getStackTraceString((Throwable)e));
        }
    }

    private void setupVideoConfig() {
        this.mRtcEngine.enableVideo();
        if (this.callType == EaseCallType.CONFERENCE_VOICE_CALL) {
            this.mRtcEngine.muteLocalVideoStream(true);
        }
        this.mRtcEngine.setVideoEncoderConfiguration(new VideoEncoderConfiguration(VideoEncoderConfiguration.VD_1280x720, VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15, 0, VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT));
        this.mRtcEngine.enableAudioVolumeIndication(500, 3, false);
    }

    private void setupLocalVideo() {
        if (this.isFloatWindowShowing()) {
            return;
        }
        EaseUserAccount account = new EaseUserAccount(0, ChatClient.getInstance().getCurrentUser());
        this.localMemberView = this.createCallMemberView();
        this.localMemberView.setUserInfo(account);
        this.localMemberView.setNameVisiable(8);
        this.localMemberView.setVidiconVisiable(8);
        this.localMemberView.setCameraDirectionFront(this.isCameraFront);
        this.mRtcEngine.setupLocalVideo(new VideoCanvas((View)this.localMemberView.getSurfaceView(), 1, 0));
        if (this.isInComingCall) {
            if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
                this.mBinding.incomingCallView.setVideoView((View)this.localMemberView);
                this.mRtcEngine.startPreview();
                this.isPreview = true;
            }
        } else {
            this.addLocalViewToConferenceViewsGroup();
        }
    }

    public EaseCallMemberView createCallMemberView() {
        EaseCallMemberView memberView = new EaseCallMemberView(this.getApplicationContext());
        SurfaceView surfaceView = RtcEngine.CreateRendererView((Context)this.getApplicationContext());
        surfaceView.setZOrderOnTop(false);
        surfaceView.setZOrderMediaOverlay(false);
        memberView.addSurfaceView(surfaceView);
        if (this.callType == EaseCallType.CONFERENCE_VOICE_CALL) {
            memberView.setVoiceOnlineImageState(false);
            memberView.showVideo(true);
        } else {
            memberView.showVideo(false);
            memberView.setVoiceOnlineImageState(true);
        }
        return memberView;
    }

    private void joinChannel() {
        EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
        if (this.listener != null && callKitConfig != null && callKitConfig.isEnableRTCToken()) {
            this.listener.onGenerateRTCToken(ChatClient.getInstance().getCurrentUser(), this.channelName, new EaseCallKitTokenCallback(){

                @Override
                public void onSetToken(String token, int uId) {
                    EaseCallMultipleBaseActivity.this.mRtcEngine.joinChannel(token, EaseCallMultipleBaseActivity.this.channelName, null, uId);
                    EaseCallMultipleBaseActivity.this.inChannelAccounts.put(uId, new EaseUserAccount(uId, ChatClient.getInstance().getCurrentUser()));
                }

                @Override
                public void onGetTokenError(int error, String errorMsg) {
                    EMLog.e((String)TAG, (String)("onGenerateToken error :" + ChatClient.getInstance().getAccessToken()));
                    EaseCallMultipleBaseActivity.this.exitChannel();
                }
            });
        } else {
            this.mRtcEngine.joinChannel(null, this.channelName, null, 0);
            this.inChannelAccounts.put(0, new EaseUserAccount(0, ChatClient.getInstance().getCurrentUser()));
        }
    }

    private void changeMuteState(boolean isMute) {
        this.localMemberView.setAudioOff(isMute);
        this.mRtcEngine.muteLocalAudioStream(isMute);
        this.isMuteState = isMute;
        this.mBinding.btnMicSwitchVoice.setBackground(isMute ? this.getResources().getDrawable(R.drawable.call_mute_on) : this.getResources().getDrawable(R.drawable.call_mute_normal));
        this.mBinding.btnMicSwitchVideo.setBackground(isMute ? this.getResources().getDrawable(R.drawable.call_mute_on) : this.getResources().getDrawable(R.drawable.call_mute_normal));
    }

    private void changeSpeakerState(boolean isActive) {
        this.localMemberView.setSpeakActivated(isActive);
        this.mBinding.btnSpeakerSwitchVoice.setActivated(isActive);
        this.mBinding.btnSpeakerSwitchVoice.setBackground(isActive ? this.getResources().getDrawable(R.drawable.ease_call_voice_on) : this.getResources().getDrawable(R.drawable.ease_call_voice_off));
        if (isActive) {
            EaseCallAudioControl.getInstance().openSpeakerOn();
        } else {
            EaseCallAudioControl.getInstance().closeSpeakerOn();
        }
    }

    private void changeVideoState(boolean videoOff) {
        this.localMemberView.showVideo(videoOff);
        this.mRtcEngine.muteLocalVideoStream(videoOff);
        this.isVideoMute = videoOff;
        this.mBinding.btnVidicon.setBackground(videoOff ? this.getResources().getDrawable(R.drawable.call_video_off) : this.getResources().getDrawable(R.drawable.call_video_on));
    }

    private void changeCameraDirect(boolean isFront) {
        if (this.isCameraFront != isFront) {
            if (this.mRtcEngine != null) {
                this.mRtcEngine.switchCamera();
            }
            this.isCameraFront = isFront;
            if (this.localMemberView != null) {
                this.localMemberView.setCameraDirectionFront(isFront);
            }
        }
    }

    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.btn_mic_switch_voice || viewId == R.id.btn_mic_switch_video) {
            this.changeMuteState(!this.isMuteState);
        } else if (viewId == R.id.btn_speaker_switch_voice) {
            this.changeSpeakerState(!this.mBinding.btnSpeakerSwitchVoice.isActivated());
        } else if (viewId == R.id.btn_vidicon) {
            this.changeVideoState(!this.isVideoMute);
        } else if (viewId == R.id.btn_change_camera_switch) {
            this.changeCameraDirect(!this.isCameraFront);
        } else if (viewId == R.id.btn_hangup_voice || viewId == R.id.btn_hangup_video) {
            if (this.listener != null) {
                this.listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, this.timeUpdataTimer.timePassed * 1000);
            }
            this.exitChannel();
        } else if (viewId == R.id.btn_float) {
            this.showFloatWindow();
        } else if (viewId == R.id.btn_invite && this.listener != null) {
            int size = this.effectiveUsers.size();
            JSONObject object = EaseCallKit.getInstance().getInviteExt();
            if (size >= EaseCallKit.getInstance().getLargestNumInChannel() - 1) {
                this.listener.onCallError(EaseCallError.PROCESS_ERROR, EaseCallProcessError.CALL_PARAM_ERROR.code, this.getString(R.string.ease_call_max_people_in_channel));
            } else if (size > 0) {
                String[] users = new String[size];
                int i = 0;
                for (String user : this.effectiveUsers) {
                    users[i++] = user;
                }
                this.listener.onInviteUsers(this.callType, users, object);
            } else {
                this.listener.onInviteUsers(this.callType, null, object);
            }
        }
    }

    protected void addLiveDataObserver() {
        EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString(), EaseCallBaseEvent.class).observe((LifecycleOwner)this, event -> {
            if (event != null) {
                switch (event.callAction) {
                    case CALL_ALERT: {
                        EaseCallAlertEvent alertEvent = (EaseCallAlertEvent)event;
                        EaseCallConfirmRingEvent ringEvent = new EaseCallConfirmRingEvent();
                        String user = alertEvent.userId;
                        if (TextUtils.equals((CharSequence)alertEvent.callId, (CharSequence)EaseCallKit.getInstance().getCallID()) && this.invitedUsersTime.containsKey(user)) {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = true;
                            ringEvent.userId = alertEvent.userId;
                            this.sendCmdMsg(ringEvent, alertEvent.userId);
                        } else {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.valid = false;
                            this.sendCmdMsg(ringEvent, alertEvent.userId);
                        }
                        this.mConfirRing = true;
                        break;
                    }
                    case CALL_CANCEL: {
                        if (this.userIdAndUidMap.get(event.userId) == null && !TextUtils.equals((CharSequence)event.userId, (CharSequence)ChatClient.getInstance().getCurrentUser())) break;
                        if (!this.isInComingCall) {
                            this.timeHandler.stopTime();
                        }
                        this.exitChannel();
                        break;
                    }
                    case CALL_ANSWER: {
                        EaseCallAnswerEvent answerEvent = (EaseCallAnswerEvent)event;
                        EaseCallConfirmCallEvent callEvent = new EaseCallConfirmCallEvent();
                        callEvent.calleeDevId = answerEvent.calleeDevId;
                        callEvent.result = answerEvent.result;
                        final String userId = answerEvent.userId;
                        this.invitedUsersTime.remove(userId);
                        if (TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_BUSY)) {
                            if (!this.mConfirRing) {
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        EaseCallMultipleBaseActivity.this.effectiveUsers.remove(userId);
                                        EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(userId));
                                        if (placeView != null) {
                                            ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                                        }
                                        if (EaseCallMultipleBaseActivity.this.listener != null) {
                                            EaseCallMultipleBaseActivity.this.listener.onEndCallWithReason(EaseCallMultipleBaseActivity.this.callType, EaseCallMultipleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonBusy, EaseCallMultipleBaseActivity.this.timeUpdataTimer.timePassed * 1000);
                                        }
                                        if (EaseCallMultipleBaseActivity.this.placeholders.size() == 0) {
                                            EaseCallAudioControl.getInstance().stopPlayRing();
                                        }
                                    }
                                });
                                break;
                            }
                            this.sendCmdMsg(callEvent, this.username);
                            break;
                        }
                        if (TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                            EaseCallKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                            this.sendCmdMsg(callEvent, answerEvent.userId);
                            break;
                        }
                        if (!TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) break;
                        this.sendCmdMsg(callEvent, answerEvent.userId);
                        this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                EaseCallMultipleBaseActivity.this.effectiveUsers.remove(userId);
                                EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(userId));
                                if (placeView != null) {
                                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                                }
                            }
                        });
                        if (this.listener != null) {
                            this.listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonRefuse, 0L);
                        }
                        if (this.placeholders.size() != 0) break;
                        EaseCallAudioControl.getInstance().stopPlayRing();
                        break;
                    }
                    case CALL_CONFIRM_RING: {
                        break;
                    }
                    case CALL_CONFIRM_CALLEE: {
                        EaseCallConfirmCallEvent confirmEvent = (EaseCallConfirmCallEvent)event;
                        String deviceId = confirmEvent.calleeDevId;
                        String result = confirmEvent.result;
                        this.timeHandler.stopTime();
                        if (TextUtils.equals((CharSequence)deviceId, (CharSequence)EaseCallKit.deviceId)) {
                            if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                                this.joinChannel();
                                break;
                            }
                            if (!TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) break;
                            this.exitChannel();
                            break;
                        }
                        this.exitChannel();
                    }
                }
            }
        });
        EaseCallLiveDataBus.get().with("updateUserInfo", EaseCallUserInfo.class).observe((LifecycleOwner)this, userInfo -> {
            if (userInfo != null) {
                EaseCallKit.getInstance().getCallKitConfig().setUserInfo(userInfo.getUserId(), (EaseCallUserInfo)userInfo);
                if (userInfo.getUserId() != null && this.userIdAndUidMap.containsKey(userInfo.getUserId())) {
                    int uid = this.userIdAndUidMap.get(userInfo.getUserId());
                    this.updateUserInfo(uid);
                    this.runOnUiThread(new Runnable((EaseCallUserInfo)userInfo){
                        final /* synthetic */ EaseCallUserInfo val$userInfo;
                        {
                            this.val$userInfo = easeCallUserInfo;
                        }

                        @Override
                        public void run() {
                            if (TextUtils.equals((CharSequence)EaseCallMultipleBaseActivity.this.username, (CharSequence)this.val$userInfo.getUserId()) && ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.incomingCallView != null) {
                                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.incomingCallView.setInviteInfo(EaseCallMultipleBaseActivity.this.username, EaseCallMultipleBaseActivity.this.groupId, EaseCallMultipleBaseActivity.this.callType);
                            }
                        }
                    });
                }
            }
        });
    }

    private void addLocalViewToConferenceViewsGroup() {
        this.mBinding.incomingCallView.removeVideoView((View)this.localMemberView);
        this.mBinding.surfaceViewGroup.addView((View)this.localMemberView);
        this.notifyUserToUpdateUserInfo(ChatClient.getInstance().getCurrentUser(), 0);
        this.inChannelViews.put(0, this.localMemberView);
    }

    private void leaveChannel() {
        if (this.mRtcEngine != null) {
            this.mRtcEngine.leaveChannel();
        }
    }

    private void updateConferenceTime(String time) {
        Log.e((String)TAG, (String)("time: " + time));
        this.mBinding.tvCallTime.setText((CharSequence)time);
    }

    private void updateTime(TimeHandler handler) {
        String time = handler.dateFormat.format(handler.timePassed * 1000);
        this.updateConferenceTime(time);
        handler.removeMessages(1);
        handler.sendEmptyMessageDelayed(1, 1000L);
    }

    private void sendInviteeMsg(ArrayList<String> userArray) {
        this.isInComingCall = false;
        this.timeHandler.startTime(0);
        for (final String username : userArray) {
            if (this.placeholders.containsKey(username) || this.userIdAndUidMap.containsKey(username)) continue;
            this.notifyUserToUpdateUserInfo(username, 0);
            long totalMilliSeconds = System.currentTimeMillis();
            EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
            long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() * 1000L : 30000L;
            this.invitedUsersTime.put(username, totalMilliSeconds += intervalTime);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallMemberView memberView = new EaseCallMemberView(EaseCallMultipleBaseActivity.this.getApplicationContext());
                    memberView.setUserInfo(new EaseUserAccount(0, username));
                    memberView.showVideo(true);
                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.addView((View)memberView);
                    EaseCallMultipleBaseActivity.this.placeholders.put(username, memberView);
                }
            });
            ChatMessage message = this.callType == EaseCallType.CONFERENCE_VIDEO_CALL ? ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invite_you_for_video_call), (String)username) : ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invite_you_for_audio_call), (String)username);
            this.setInviteeMessageAttr(message);
            ChatClient.getInstance().chatManager().sendMessage(message);
        }
        ChatMessage message = ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invited_to_make_multi_party_call), (String)this.groupId);
        message.setChatType(ChatMessage.ChatType.GroupChat);
        this.setInviteeMessageAttr(message);
        ChatClient.getInstance().chatManager().sendMessage(message);
        EaseCallKit.getInstance().InitInviteeUsers();
    }

    private void setInviteeMessageAttr(ChatMessage message) {
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, EaseCallAction.CALL_INVITE.state);
        message.setAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, this.channelName);
        message.setAttribute(EaseCallMsgUtils.CALL_TYPE, this.callType.code);
        message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, EaseCallKit.deviceId);
        JSONObject object = EaseCallKit.getInstance().getInviteExt();
        if (object != null) {
            message.setAttribute(EaseCallMsgUtils.CALL_INVITE_EXT, object);
        } else {
            try {
                JSONObject obj = new JSONObject();
                message.setAttribute(EaseCallMsgUtils.CALL_INVITE_EXT, obj);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        if (EaseCallKit.getInstance().getCallID() == null) {
            EaseCallKit.getInstance().setCallID(EaseCallKitUtils.getRandomString(10));
        }
        message.setAttribute(EaseCallMsgUtils.CLL_ID, EaseCallKit.getInstance().getCallID());
        message.setAttribute(EaseCallMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        JSONObject extObject = new JSONObject();
        try {
            String info = this.getApplication().getString(R.string.ease_call_alert_request_multiple_video, new Object[]{ChatClient.getInstance().getCurrentUser()});
            extObject.putOpt("em_push_title", (Object)info);
            extObject.putOpt("em_push_content", (Object)info);
            extObject.putOpt("isRtcCall", (Object)true);
            extObject.putOpt("callType", (Object)EaseCallType.CONFERENCE_VIDEO_CALL.code);
            if (message.getChatType() == ChatMessage.ChatType.Chat) {
                extObject.putOpt("em_push_type", (Object)"voip");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        message.setAttribute("em_apns_ext", extObject);
        if (message.getChatType() == ChatMessage.ChatType.Chat) {
            try {
                JSONObject pushExtObject = new JSONObject();
                pushExtObject.putOpt("type", (Object)"call");
                JSONObject customObject = new JSONObject();
                customObject.putOpt("callId", (Object)EaseCallKit.getInstance().getCallID());
                pushExtObject.putOpt("custom", (Object)customObject);
                message.setAttribute("em_push_ext", pushExtObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Conversation conversation = ChatClient.getInstance().chatManager().getConversation(this.username, Conversation.ConversationType.Chat, true);
        message.setMessageStatusCallback(new CallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)("Invite call success username:" + EaseCallMultipleBaseActivity.this.username));
                if (EaseCallMultipleBaseActivity.this.listener != null) {
                    EaseCallMultipleBaseActivity.this.listener.onInViteCallMessageSent();
                }
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error + " username:" + EaseCallMultipleBaseActivity.this.username));
                if (EaseCallMultipleBaseActivity.this.listener != null) {
                    EaseCallMultipleBaseActivity.this.listener.onCallError(EaseCallError.IM_ERROR, code, error);
                    EaseCallMultipleBaseActivity.this.listener.onInViteCallMessageSent();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
    }

    private void sendCmdMsg(final EaseCallBaseEvent event, String username) {
        final ChatMessage message = ChatMessage.createSendMessage((ChatMessage.Type)ChatMessage.Type.CMD);
        String action = "rtcCall";
        CmdMessageBody cmdBody = new CmdMessageBody(action);
        message.setTo(username);
        message.addBody((MessageBody)cmdBody);
        if (event.callAction.equals((Object)EaseCallAction.CALL_CANCEL)) {
            cmdBody.deliverOnlineOnly(false);
        } else {
            cmdBody.deliverOnlineOnly(true);
        }
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, EaseCallKit.deviceId);
        message.setAttribute(EaseCallMsgUtils.CLL_ID, EaseCallKit.getInstance().getCallID());
        message.setAttribute(EaseCallMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_CONFIRM_RING) {
            message.setAttribute(EaseCallMsgUtils.CALL_STATUS, ((EaseCallConfirmRingEvent)event).valid.booleanValue());
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallConfirmRingEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
            message.setAttribute(EaseCallMsgUtils.CALL_RESULT, ((EaseCallConfirmCallEvent)event).result);
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallConfirmCallEvent)event).calleeDevId);
        } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseCallMsgUtils.CALL_RESULT, ((EaseCallAnswerEvent)event).result);
            message.setAttribute(EaseCallMsgUtils.CALLED_DEVICE_ID, ((EaseCallAnswerEvent)event).calleeDevId);
            message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, ((EaseCallAnswerEvent)event).callerDevId);
        }
        final Conversation conversation = ChatClient.getInstance().chatManager().getConversation(username, Conversation.ConversationType.Chat, true);
        message.setMessageStatusCallback(new CallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
                if (event.callAction != EaseCallAction.CALL_CANCEL && event.callAction == EaseCallAction.CALL_ANSWER) {
                    EaseCallMultipleBaseActivity.this.timeHandler.startTime(0);
                }
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                conversation.removeMessage(message.getMsgId());
                if (EaseCallMultipleBaseActivity.this.listener != null) {
                    EaseCallMultipleBaseActivity.this.listener.onCallError(EaseCallError.IM_ERROR, code, error);
                }
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseCallMultipleBaseActivity.this.exitChannel();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    private void setUserJoinChannelInfo(String userName, int uid) {
        if (TextUtils.isEmpty((CharSequence)userName)) {
            if (this.listener != null) {
                this.listener.onRemoteUserJoinChannel(this.channelName, userName, uid, new EaseCallGetUserAccountCallback(){

                    @Override
                    public void onUserAccount(EaseUserAccount account) {
                        EaseCallMultipleBaseActivity.this.processOnUserAccount(account);
                    }

                    @Override
                    public void onSetUserAccountError(int error, String errorMsg) {
                        EMLog.e((String)TAG, (String)("onRemoteUserJoinChannel error:" + error + "  errorMsg:" + errorMsg));
                    }
                });
            }
        } else {
            EaseUserAccount account = new EaseUserAccount(uid, userName);
            this.processOnUserAccount(account);
        }
    }

    private void processOnUserAccount(EaseUserAccount account) {
        if (account != null) {
            if (account.getUid() != 0) {
                this.inChannelAccounts.put(account.getUid(), account);
                this.effectiveUsers.add(account.getUserName());
            }
            this.notifyUserToUpdateUserInfo(account.getUserName(), account.getUid());
        }
    }

    private void updateView(final EaseUserAccount account) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.equals((CharSequence)account.getUserName(), (CharSequence)ChatClient.getInstance().getCurrentUser())) {
                    EaseCallMultipleBaseActivity.this.updateUserInfo(account.getUid());
                } else {
                    EaseCallMultipleBaseActivity.this.localMemberView.updateUserInfo();
                }
                EaseCallMemberView placeView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(account.getUserName()));
                if (placeView != null) {
                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)placeView);
                }
                if (TextUtils.equals((CharSequence)account.getUserName(), (CharSequence)EaseCallMultipleBaseActivity.this.username) && ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.incomingCallView != null) {
                    ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.incomingCallView.setInviteInfo(account.getUserName(), EaseCallMultipleBaseActivity.this.groupId, EaseCallMultipleBaseActivity.this.callType);
                }
            }
        });
    }

    private void notifyUserToUpdateUserInfo(String username, int uid) {
        if (this.listener != null && !TextUtils.isEmpty((CharSequence)username)) {
            this.listener.onUserInfoUpdate(username);
        }
        if (this.inChannelAccounts.containsKey(uid)) {
            this.updateView(this.inChannelAccounts.get(uid));
        }
    }

    private void resetVideoView() {
        if (this.inChannelViews != null && !this.inChannelViews.isEmpty()) {
            for (Map.Entry<Integer, EaseCallMemberView> entry : this.inChannelViews.entrySet()) {
                Integer uid = entry.getKey();
                EaseCallMemberView memberView = entry.getValue();
                if (this.inChannelAccounts.containsKey(uid)) {
                    memberView.setUserInfo(this.inChannelAccounts.get(uid));
                }
                if (uid != 0) {
                    this.mBinding.surfaceViewGroup.addView((View)memberView);
                    this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)memberView.getSurfaceView(), 1, uid.intValue()));
                    continue;
                }
                this.localMemberView = memberView;
                this.mBinding.surfaceViewGroup.addView((View)memberView, 0);
                this.mRtcEngine.setupLocalVideo(new VideoCanvas((View)memberView.getSurfaceView(), 1, uid.intValue()));
            }
        }
        if (this.localMemberView != null) {
            this.changeCameraDirect(this.localMemberView.isCameraDirectionFront());
            this.changeVideoState(this.localMemberView.isShowVideo());
            this.changeSpeakerState(this.localMemberView.isSpeakActivated());
            this.changeMuteState(this.localMemberView.isAudioOff());
        }
    }

    private void updateUserInfo(final int uid) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (EaseCallMultipleBaseActivity.this.inChannelViews != null) {
                    EaseUserAccount account = (EaseUserAccount)EaseCallMultipleBaseActivity.this.inChannelAccounts.get(uid);
                    EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.inChannelViews.get(uid));
                    if (memberView != null) {
                        if (memberView.getUserInfo() != null) {
                            memberView.updateUserInfo();
                        } else {
                            memberView.setUserInfo(account);
                        }
                    } else {
                        EaseCallMemberView newMemberView = new EaseCallMemberView(EaseCallMultipleBaseActivity.this.getApplicationContext());
                        newMemberView.setUserInfo(account);
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.addView((View)newMemberView);
                        EaseCallMultipleBaseActivity.this.inChannelViews.put(uid, newMemberView);
                    }
                }
            }
        });
    }

    void exitChannel() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EMLog.i((String)TAG, (String)("exit channel channelName: " + EaseCallMultipleBaseActivity.this.channelName));
                EaseCallAudioControl.getInstance().stopPlayRing();
                ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.chronometer.stop();
                EaseCallMultipleBaseActivity.this.leaveChannel();
                if (!EaseCallMultipleBaseActivity.this.isInComingCall && EaseCallMultipleBaseActivity.this.invitedUsersTime.size() > 0) {
                    if (EaseCallMultipleBaseActivity.this.timeHandler != null) {
                        EaseCallMultipleBaseActivity.this.timeHandler.stopTime();
                    }
                    Iterator it_user = EaseCallMultipleBaseActivity.this.invitedUsersTime.keySet().iterator();
                    while (it_user.hasNext()) {
                        String userName = (String)it_user.next();
                        EaseCallCallCancelEvent cancelEvent = new EaseCallCallCancelEvent();
                        cancelEvent.callId = EaseCallKit.getInstance().getCallID();
                        EaseCallMultipleBaseActivity.this.sendCmdMsg(cancelEvent, userName);
                        it_user.remove();
                        EaseCallMultipleBaseActivity.this.effectiveUsers.remove(userName);
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(userName));
                        if (memberView == null) continue;
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)memberView);
                    }
                }
                if (EaseCallMultipleBaseActivity.this.isFloatWindowShowing()) {
                    EaseCallFloatWindow.getInstance().dismiss();
                } else {
                    EaseCallFloatWindow.getInstance().resetCurrentInstance();
                }
                EaseCallMultipleBaseActivity.this.insertCancelMessageToLocal();
                EaseCallMultipleBaseActivity.this.releaseHandler();
                EaseCallKit.getInstance().setCallState(EaseCallState.CALL_IDLE);
                EaseCallKit.getInstance().setCallID(null);
                EaseCallKit.getInstance().releaseCall();
                RtcEngine.destroy();
                EaseCallMultipleBaseActivity.this.finish();
            }
        });
    }

    private void insertCancelMessageToLocal() {
        ChatMessage message = ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invited_to_make_multi_party_call), (String)this.groupId);
        message.setUnread(false);
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, EaseCallAction.CALL_CANCEL.state);
        message.setAttribute(EaseCallMsgUtils.CALL_TYPE, this.callType.code);
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        message.setAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, this.channelName);
        message.setAttribute(EaseCallMsgUtils.CALL_COST_TIME, this.timeUpdataTimer.getPassedTime());
        Conversation conversation = ChatClient.getInstance().chatManager().getConversation(this.groupId);
        if (conversation != null) {
            conversation.insertMessage(message);
        }
    }

    @Override
    public void doShowFloatWindow() {
        super.doShowFloatWindow();
        if (this.timeUpdataTimer != null) {
            Log.e((String)TAG, (String)("timeUpdataTimer cost seconds: " + this.timeUpdataTimer.timePassed));
            EaseCallFloatWindow.getInstance().setCostSeconds(this.timeUpdataTimer.timePassed);
        }
        EaseCallFloatWindow.getInstance().setRtcEngine(this.getApplicationContext(), this.mRtcEngine);
        EaseCallFloatWindow.getInstance().show();
        this.setConferenceInfoAfterShowFloat();
        int uid = 0;
        if (this.inChannelViews.size() > 0) {
            Set<Integer> uidSet = this.inChannelViews.keySet();
            Iterator<Integer> iterator = uidSet.iterator();
            while (iterator.hasNext()) {
                int id2;
                uid = id2 = iterator.next().intValue();
            }
            EaseCallMemberView memberView = this.inChannelViews.get(uid);
            EaseCallFloatWindow.getInstance().update(memberView);
        }
        this.moveTaskToBack(false);
    }

    private void setConferenceInfoAfterShowFloat() {
        EaseCallFloatWindow.ConferenceInfo info = new EaseCallFloatWindow.ConferenceInfo();
        info.uidToUserAccountMap = this.inChannelAccounts;
        info.uidToViewList = this.getViewStateMap();
        info.userAccountToUidMap = this.userIdAndUidMap;
        EaseCallFloatWindow.getInstance().setConferenceInfo(info);
    }

    private Map<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState> getViewStateMap() {
        if (this.inChannelViews == null || this.inChannelViews.isEmpty()) {
            return new HashMap<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState>();
        }
        HashMap<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState> viewStateMap = new HashMap<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState>();
        for (Map.Entry<Integer, EaseCallMemberView> entry : this.inChannelViews.entrySet()) {
            Integer key = entry.getKey();
            EaseCallMemberView value = entry.getValue();
            EaseCallFloatWindow.ConferenceInfo.ViewState viewState = new EaseCallFloatWindow.ConferenceInfo.ViewState();
            if (value != null) {
                viewState.isAudioOff = value.getAudioOff();
                viewState.isCameraFront = value.isCameraDirectionFront();
                viewState.isFullScreenMode = value.isFullScreen();
                viewState.isVideoOff = value.isShowVideo();
                viewState.speakActivated = value.isSpeakActivated();
            }
            viewStateMap.put(key, viewState);
        }
        return viewStateMap;
    }

    private void updateFloatWindow(EaseCallMemberView memberView) {
        if (memberView != null) {
            EaseCallFloatWindow.getInstance().update(memberView);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.checkConference(false);
    }

    private void checkConference(boolean isNew) {
        if (this.isFloatWindowShowing()) {
            EaseCallFloatWindow.ConferenceInfo info;
            EaseCallMemberView memberView;
            int uId = EaseCallFloatWindow.getInstance().getUid();
            if (uId != -1 && (memberView = this.inChannelViews.get(uId)) != null) {
                if (uId == 0) {
                    this.mRtcEngine.setupLocalVideo(new VideoCanvas((View)memberView.getSurfaceView(), 1, uId));
                } else {
                    this.mRtcEngine.setupRemoteVideo(new VideoCanvas((View)memberView.getSurfaceView(), 1, uId));
                }
            }
            if (isNew && (info = EaseCallFloatWindow.getInstance().getConferenceInfo()) != null) {
                this.resetConferenceData(info);
                this.resetVideoView();
            }
            long costSeconds = EaseCallFloatWindow.getInstance().getTotalCostSeconds();
            Log.e((String)TAG, (String)("costSeconds: " + costSeconds));
            if (this.timeUpdataTimer != null) {
                this.timeUpdataTimer.timePassed = (int)costSeconds;
                this.updateTime(this.timeUpdataTimer);
            }
            EaseCallFloatWindow.getInstance().dismiss();
        }
        ArrayList<String> users = EaseCallKit.getInstance().getInviteeUsers();
        if (isNew) {
            this.effectiveUsers.clear();
            this.effectiveUsers.addAll(EaseCallKit.getInstance().getInviteeUsers());
            for (Map.Entry<Integer, EaseUserAccount> entry : this.inChannelAccounts.entrySet()) {
                this.effectiveUsers.add(entry.getValue().getUserName());
            }
        } else {
            this.effectiveUsers.addAll(users);
            if (users != null && users.size() > 0) {
                this.handler.sendEmptyMessage(102);
            }
        }
    }

    private void resetConferenceData(EaseCallFloatWindow.ConferenceInfo info) {
        if (info != null) {
            if (info.uidToUserAccountMap != null) {
                this.inChannelAccounts.putAll(info.uidToUserAccountMap);
            }
            if (info.userAccountToUidMap != null) {
                this.userIdAndUidMap.putAll(info.userAccountToUidMap);
            }
            if (info.uidToViewList != null) {
                Map<Integer, EaseCallMemberView> callViewMap = this.createCallViewMap(info.uidToViewList);
                this.inChannelViews.putAll(callViewMap);
                info.uidToViewList.clear();
            }
        }
    }

    private Map<Integer, EaseCallMemberView> createCallViewMap(Map<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState> viewStateMap) {
        HashMap<Integer, EaseCallMemberView> memberViewMap = new HashMap<Integer, EaseCallMemberView>();
        if (viewStateMap == null || viewStateMap.isEmpty()) {
            return memberViewMap;
        }
        for (Map.Entry<Integer, EaseCallFloatWindow.ConferenceInfo.ViewState> entry : viewStateMap.entrySet()) {
            Integer uid = entry.getKey();
            EaseCallFloatWindow.ConferenceInfo.ViewState state = entry.getValue();
            EaseCallMemberView memberView = this.createCallMemberView();
            memberView.setCameraDirectionFront(state.isCameraFront);
            memberView.setAudioOff(state.isAudioOff);
            memberView.showVideo(state.isVideoOff);
            memberView.setSpeakActivated(state.speakActivated);
            memberView.setFullScreen(state.isFullScreenMode);
            memberViewMap.put(uid, memberView);
        }
        return memberViewMap;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        EMLog.i((String)TAG, (String)("onActivityResult: " + requestCode + ", result code: " + resultCode));
        if (requestCode == 1002 && Build.VERSION.SDK_INT >= 23) {
            this.requestOverlayPermission = false;
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.ease_call_alert_window_permission_denied), (int)0).show();
            }
            return;
        }
    }

    protected void releaseHandler() {
        if (this.handler != null) {
            this.handler.sendEmptyMessage(301);
        }
        if (this.timeHandler != null) {
            this.timeHandler.stopTime();
        }
        if (this.timeUpdataTimer != null) {
            this.timeUpdataTimer.stopTime();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mBinding.surfaceViewGroup.removeAllViews();
        this.releaseHandler();
        if (this.inChannelViews != null) {
            this.inChannelViews.clear();
        }
        if (!this.isFloatWindowShowing()) {
            if (this.userIdAndUidMap != null) {
                this.userIdAndUidMap.clear();
            }
            if (this.inChannelAccounts != null) {
                this.inChannelAccounts.clear();
            }
            this.leaveChannel();
            if (TextUtils.equals((CharSequence)EaseCallFloatWindow.getInstance().getCurrentInstance(), (CharSequence)((Object)((Object)this)).toString())) {
                EaseCallKit.getInstance().releaseCall();
                RtcEngine.destroy();
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.onBackPressed();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onUserLeaveHint() {
        Log.d((String)TAG, (String)"onUserLeaveHint");
        super.onUserLeaveHint();
    }

    public void onBackPressed() {
        this.exitChannelDisplay();
    }

    public void exitChannelDisplay() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        final AlertDialog dialog = builder.create();
        View dialogView = View.inflate((Context)this, (int)R.layout.ease_call_activity_exit_channel, null);
        dialog.setView(dialogView);
        dialog.requestWindowFeature(1);
        WindowManager.LayoutParams wmlp = dialog.getWindow().getAttributes();
        wmlp.gravity = 17;
        dialog.show();
        Button btn_ok = (Button)dialogView.findViewById(R.id.btn_ok);
        Button btn_cancel = (Button)dialogView.findViewById(R.id.btn_cancel);
        btn_ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                EMLog.e((String)TAG, (String)"exitChannelDisplay  exit channel:");
                EaseCallMultipleBaseActivity.this.exitChannel();
            }
        });
        btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                EMLog.e((String)TAG, (String)"exitChannelDisplay not exit channel");
            }
        });
    }

    private class TimeHandler
    extends Handler {
        private DateFormat dateFormat = new SimpleDateFormat("mm:ss");
        private int timePassed = 0;
        private String passedTime;

        public TimeHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void startTime(int timeType) {
            Log.e((String)TAG, (String)"start timer");
            this.timePassed = 0;
            this.removeMessages(timeType);
            this.sendEmptyMessageDelayed(timeType, 1000L);
        }

        public String getPassedTime() {
            this.passedTime = this.dateFormat.format(this.timePassed * 1000);
            return this.passedTime;
        }

        public void stopTime() {
            Log.e((String)TAG, (String)"stopTime");
            this.removeMessages(1);
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                if (!EaseCallMultipleBaseActivity.this.isInComingCall) {
                    long totalMilliSeconds = System.currentTimeMillis();
                    Iterator itUser = EaseCallMultipleBaseActivity.this.invitedUsersTime.keySet().iterator();
                    while (itUser.hasNext()) {
                        String userName = (String)itUser.next();
                        if (totalMilliSeconds < (Long)EaseCallMultipleBaseActivity.this.invitedUsersTime.get(userName)) continue;
                        EaseCallCallCancelEvent cancelEvent = new EaseCallCallCancelEvent();
                        cancelEvent.callId = EaseCallKit.getInstance().getCallID();
                        EaseCallMultipleBaseActivity.this.sendCmdMsg(cancelEvent, userName);
                        itUser.remove();
                        EaseCallMultipleBaseActivity.this.effectiveUsers.remove(userName);
                        EaseCallMemberView memberView = (EaseCallMemberView)((Object)EaseCallMultipleBaseActivity.this.placeholders.remove(userName));
                        if (memberView == null) continue;
                        ((EaseCallMultipleBaseActivity)EaseCallMultipleBaseActivity.this).mBinding.surfaceViewGroup.removeView((View)memberView);
                    }
                    if (EaseCallMultipleBaseActivity.this.invitedUsersTime.size() == 0) {
                        EaseCallMultipleBaseActivity.this.timeHandler.stopTime();
                    } else {
                        this.sendEmptyMessageDelayed(0, 1000L);
                    }
                } else {
                    EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
                    long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() * 1000L : 30000L;
                    this.sendEmptyMessageDelayed(0, 1000L);
                    if ((long)(this.timePassed * 1000) == intervalTime) {
                        EaseCallMultipleBaseActivity.this.timeHandler.stopTime();
                        EaseCallMultipleBaseActivity.this.exitChannel();
                        if (EaseCallMultipleBaseActivity.this.listener != null) {
                            EaseCallMultipleBaseActivity.this.listener.onEndCallWithReason(EaseCallMultipleBaseActivity.this.callType, EaseCallMultipleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                        }
                    }
                }
            } else if (msg.what == 1) {
                ++this.timePassed;
                EaseCallMultipleBaseActivity.this.updateTime(this);
            }
            super.handleMessage(msg);
        }
    }
}

