/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import io.agora.CallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.Conversation;
import io.agora.chat.callkit.EaseCallKit;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.bean.EaseCallUserInfo;
import io.agora.chat.callkit.bean.EaseUserAccount;
import io.agora.chat.callkit.databinding.EaseCallActivitySingleBinding;
import io.agora.chat.callkit.event.EaseCallAlertEvent;
import io.agora.chat.callkit.event.EaseCallAnswerEvent;
import io.agora.chat.callkit.event.EaseCallBaseEvent;
import io.agora.chat.callkit.event.EaseCallCallCancelEvent;
import io.agora.chat.callkit.event.EaseCallConfirmCallEvent;
import io.agora.chat.callkit.event.EaseCallConfirmRingEvent;
import io.agora.chat.callkit.event.EaseCallInviteEventEase;
import io.agora.chat.callkit.event.EaseCallVideoToVoiceeEvent;
import io.agora.chat.callkit.general.EaseCallAction;
import io.agora.chat.callkit.general.EaseCallEndReason;
import io.agora.chat.callkit.general.EaseCallError;
import io.agora.chat.callkit.general.EaseCallFloatWindow;
import io.agora.chat.callkit.general.EaseCallKitConfig;
import io.agora.chat.callkit.general.EaseCallState;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.listener.EaseCallGetUserAccountCallback;
import io.agora.chat.callkit.listener.EaseCallKitListener;
import io.agora.chat.callkit.listener.EaseCallKitTokenCallback;
import io.agora.chat.callkit.livedatas.EaseCallLiveDataBus;
import io.agora.chat.callkit.ui.EaseCallBaseActivity;
import io.agora.chat.callkit.utils.EaseCallAudioControl;
import io.agora.chat.callkit.utils.EaseCallImageUtil;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.utils.EaseCallMsgUtils;
import io.agora.chat.callkit.widget.EaseCallChronometer;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.RtcEngine;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoEncoderConfiguration;
import io.agora.util.EMLog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseCallSingleBaseActivity
extends EaseCallBaseActivity
implements View.OnClickListener {
    private static final String TAG = EaseCallSingleBaseActivity.class.getSimpleName();
    private EaseCallActivitySingleBinding mBinding;
    private Bundle savedInstanceState;
    private static final int PERMISSION_REQ_ID = 22;
    private final String[] permissions = new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA"};
    List<String> mPermissionList = new ArrayList<String>();
    private View rootView;
    private boolean isMuteVoice = false;
    private boolean isSpeakerOn;
    protected boolean isInComingCall;
    protected boolean isOngoingCall;
    protected String username;
    protected String channelName;
    private volatile boolean mConfirmRing = false;
    private int remoteUId = 0;
    private boolean changeFlag = true;
    private String headUrl = null;
    private int idInLocalSurfaceLayout = -1;
    private int idInOppositeSurfaceLayout = -1;
    protected EaseCallType callType;
    private TimeHandler timehandler;
    private InComingCallHandler inComingCallHandler;
    private DateFormat dateFormat = null;
    private RtcEngine mRtcEngine;
    private boolean isLocalVideoMuted = false;
    private boolean isRemoteVideoMuted = false;
    private String agoraAppId = null;
    private boolean isCameraFront;
    private boolean requestOverlayPermission;
    private boolean isAgreedInHeadDialog;
    private Map<Integer, EaseUserAccount> inChannelAccounts = new HashMap<Integer, EaseUserAccount>();
    EaseCallKitListener listener = EaseCallKit.getInstance().getCallListener();
    private final IRtcEngineEventHandler mRtcEventHandler = new IRtcEngineEventHandler(){

        public void onError(int err) {
            super.onError(err);
            EMLog.d((String)TAG, (String)("IRtcEngineEventHandler onError:" + err));
            if (EaseCallSingleBaseActivity.this.listener != null) {
                EaseCallSingleBaseActivity.this.listener.onCallError(EaseCallError.RTC_ERROR, err, "rtc error");
            }
            if (EaseCallSingleBaseActivity.this.inComingCallHandler != null) {
                EaseCallSingleBaseActivity.this.inComingCallHandler.stopTime();
            }
        }

        public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
            EMLog.d((String)TAG, (String)("onJoinChannelSuccess channel:" + channel + " uid" + uid));
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VOICE_CALL) {
                        EaseCallSingleBaseActivity.this.setSpeakerMode(false);
                    } else {
                        EaseCallSingleBaseActivity.this.setSpeakerMode(true);
                    }
                    if (!EaseCallSingleBaseActivity.this.isInComingCall) {
                        if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VIDEO_CALL) {
                            EaseCallSingleBaseActivity.this.handler.sendEmptyMessage(101);
                        } else {
                            EaseCallSingleBaseActivity.this.handler.sendEmptyMessage(100);
                        }
                        EaseCallSingleBaseActivity.this.timehandler.startTime();
                    }
                    if (EaseCallSingleBaseActivity.this.inComingCallHandler != null) {
                        EaseCallSingleBaseActivity.this.inComingCallHandler.stopTime();
                    }
                }
            });
        }

        public void onUserJoined(final int uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallAudioControl.getInstance().stopPlayRing();
                    EaseCallSingleBaseActivity.this.makeOngoingStatus();
                    EaseCallSingleBaseActivity.this.setUserJoinChannelInfo(null, uid);
                }
            });
        }

        public void onUserOffline(final int uid, int reason) {
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallSingleBaseActivity.this.exitChannel();
                    if (EaseCallSingleBaseActivity.this.inChannelAccounts != null) {
                        EaseCallSingleBaseActivity.this.inChannelAccounts.remove(uid);
                    }
                    if (EaseCallSingleBaseActivity.this.listener != null) {
                        long time = EaseCallSingleBaseActivity.this.getChronometerSeconds(((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.chronometer);
                        EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, time * 1000L);
                    }
                }
            });
        }

        public void onFirstRemoteVideoDecoded(final int uid, int width, int height, int elapsed) {
            EaseCallSingleBaseActivity.this.isRemoteVideoMuted = false;
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallSingleBaseActivity.this.remoteUId = uid;
                    if (EaseCallSingleBaseActivity.this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
                        EaseCallSingleBaseActivity.this.updateViewWithCameraStatus();
                    }
                }
            });
        }

        @Deprecated
        public void onFirstRemoteAudioFrame(final int uid, int elapsed) {
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    EaseCallSingleBaseActivity.this.remoteUId = uid;
                    EaseCallSingleBaseActivity.this.startCount();
                    if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VOICE_CALL) {
                        ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.llVoiceCallingControl.setVisibility(0);
                    }
                }
            });
        }

        public void onUserMuteVideo(int uid, final boolean muted) {
            super.onUserMuteVideo(uid, muted);
            EaseCallSingleBaseActivity.this.isRemoteVideoMuted = muted;
            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VIDEO_CALL && muted) {
                        EaseCallSingleBaseActivity.this.updateViewWithCameraStatus();
                    }
                }
            });
        }
    };
    protected Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    EaseCallSingleBaseActivity.this.sendInviteeMsg(EaseCallSingleBaseActivity.this.username, EaseCallType.SINGLE_VOICE_CALL);
                    break;
                }
                case 101: {
                    EaseCallSingleBaseActivity.this.sendInviteeMsg(EaseCallSingleBaseActivity.this.username, EaseCallType.SINGLE_VIDEO_CALL);
                    break;
                }
                case 301: {
                    EaseCallSingleBaseActivity.this.handler.removeMessages(100);
                    EaseCallSingleBaseActivity.this.handler.removeMessages(101);
                    EaseCallSingleBaseActivity.this.handler.removeMessages(301);
                    break;
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.savedInstanceState = savedInstanceState;
        this.mBinding = EaseCallActivitySingleBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.mBinding.rootLayout);
        if (Build.VERSION.SDK_INT >= 23) {
            this.initPermission();
        } else {
            this.init();
        }
    }

    private void initPermission() {
        this.mPermissionList.clear();
        for (int i = 0; i < this.permissions.length; ++i) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)this.permissions[i]) == 0) continue;
            this.mPermissionList.add(this.permissions[i]);
        }
        if (this.mPermissionList.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.permissions, (int)22);
        } else {
            this.init();
        }
    }

    private void init() {
        if (this.savedInstanceState == null) {
            this.initParams(this.getIntent().getExtras());
        } else {
            this.initParams(this.savedInstanceState);
        }
        this.initEngine();
        this.initView();
        this.checkFloatIntent(this.getIntent());
        this.addLiveDataObserver();
        this.timehandler = new TimeHandler();
        if (this.isInComingCall) {
            if (this.inComingCallHandler == null) {
                this.inComingCallHandler = new InComingCallHandler();
            }
            this.inComingCallHandler.startTime();
        }
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        EaseCallKit.getInstance().getNotifier().reset();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean hasPermissionDismiss = false;
        if (22 == requestCode) {
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] != -1) continue;
                hasPermissionDismiss = true;
            }
            if (hasPermissionDismiss) {
                this.exitChannel();
            } else {
                this.init();
            }
        }
    }

    private void initParams(Bundle bundle) {
        if (bundle != null) {
            this.isInComingCall = bundle.getBoolean("isComingCall", false);
            this.username = bundle.getString("username");
            this.channelName = bundle.getString("channelName");
            this.isAgreedInHeadDialog = bundle.getBoolean("isAgreedInHeadDialog");
            int uId = bundle.getInt("uId", -1);
            this.callType = EaseCallKit.getInstance().getCallType();
            if (uId == -1) {
                EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
            } else {
                this.isOngoingCall = true;
            }
        } else {
            this.isInComingCall = EaseCallKit.getInstance().getIsComingCall();
            this.username = EaseCallKit.getInstance().getFromUserId();
            this.channelName = EaseCallKit.getInstance().getChannelName();
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
        }
    }

    public void initView() {
        this.rootView = ((ViewGroup)this.getWindow().getDecorView().findViewById(0x1020002)).getChildAt(0);
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mBinding.llVideoCallingHead.setVisibility(0);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
            this.mBinding.btnSwitchCamera.setVisibility(0);
            if (this.isInComingCall) {
                this.mBinding.btnVideoTranse.setVisibility(8);
                this.mBinding.btnVideoTranseComming.setVisibility(8);
            } else {
                this.mBinding.btnVideoTranse.setVisibility(8);
                this.mBinding.btnVideoTranseComming.setVisibility(8);
            }
            this.mBinding.ivAvatar.setVisibility(8);
        } else {
            this.mBinding.llVideoCallingHead.setVisibility(8);
            this.mBinding.btnVideoTranse.setVisibility(8);
            this.mBinding.btnVideoTranseComming.setVisibility(8);
            this.mBinding.llVoiceCallingHead.setVisibility(0);
            this.mBinding.btnHangupCall.setVisibility(8);
            this.mBinding.tvNickVoice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            this.mBinding.btnSwitchCamera.setVisibility(8);
            String userHeadImage = EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser());
            EaseCallImageUtil.setViewGaussianBlur(this.mBinding.rootLayout, userHeadImage);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.oppositeSurfaceLayout.setVisibility(8);
            this.mBinding.ivAvatar.setVisibility(0);
        }
        this.mBinding.llVideoCalled.setVisibility(8);
        this.mBinding.llVoiceCallingControl.setVisibility(8);
        this.mBinding.btnVideoTranse.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnVideoTranseComming.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnVoiceTrans.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnRefuseCall.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnAnswerCall.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnHangupCall.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnVideoHangupCall.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivMute.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivSpeaker.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnSwitchCamera.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnRefuseVideoCalled.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnAnswerVideoCalled.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivVidiconVideoCalled.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivVidiconVideoCalling.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivVideoMute.setOnClickListener((View.OnClickListener)this);
        this.mBinding.btnCallFloat.setOnClickListener((View.OnClickListener)this);
        this.mBinding.ivCallClose.setOnClickListener(this);
        this.mBinding.ivCallRedial.setOnClickListener(this);
        this.mBinding.localSurfaceLayout.setOnClickListener((View.OnClickListener)this);
        this.mBinding.tvNick.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
        EaseCallImageUtil.setBgRadius((View)this.mBinding.localSurfaceLayout, EaseCallKitUtils.dp2px((Context)this, 12));
        this.headUrl = EaseCallKitUtils.getUserHeadImage(this.username);
        this.loadHeadImage();
        if (this.isInComingCall) {
            if (this.isAgreedInHeadDialog) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EaseCallSingleBaseActivity.this.sendAgreeMessage();
                    }
                });
            } else {
                this.makeComingStatus();
            }
        } else {
            this.makeCallStatus();
            EaseCallAudioControl.getInstance().playRing();
            this.joinChannel();
        }
        if (this.isOngoingCall) {
            this.makeOngoingStatus();
        }
    }

    private void initEngine() {
        this.initializeEngine();
        this.setupVideoConfig();
        this.setupLocalVideo();
    }

    private void makeComingStatus() {
        this.mBinding.groupUseInfo.setVisibility(0);
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mBinding.llVideoCalledControl.setVisibility(0);
            this.mBinding.groupOngoingSettings.setVisibility(8);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.tvCallState.setText((CharSequence)this.getString(R.string.ease_call_video_call));
        } else {
            this.mBinding.llComingCallVoice.setVisibility(0);
            this.mBinding.ivAvatar.setVisibility(0);
            this.mBinding.tvNick.setVisibility(0);
            this.mBinding.tvCallStateVoice.setVisibility(0);
            this.mBinding.tvCallStateVoice.setText((CharSequence)this.getString(R.string.ease_call_voice_call));
        }
        this.mBinding.llVoiceCallingControl.setVisibility(8);
    }

    private void makeOngoingStatus() {
        this.isOngoingCall = true;
        this.mBinding.llComingCallVoice.setVisibility(8);
        this.mBinding.groupUseInfo.setVisibility(8);
        this.mBinding.llVideoCalledControl.setVisibility(8);
        this.callType = EaseCallKit.getInstance().getCallType();
        EaseCallFloatWindow.getInstance().setCallType(this.callType);
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mBinding.groupOngoingSettings.setVisibility(8);
            this.mBinding.localSurfaceLayout.setVisibility(0);
            this.mBinding.llVideoCalled.setVisibility(0);
            this.mBinding.llVideoCallingOutAndOngoingControl.setVisibility(0);
            this.mBinding.llVoiceCallingControl.setVisibility(8);
            this.mBinding.btnHangupCall.setVisibility(8);
            this.mBinding.llVideoCallingHead.setVisibility(8);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
        } else {
            this.mBinding.llVideoCallingOutAndOngoingControl.setVisibility(8);
            this.mBinding.groupOngoingSettings.setVisibility(0);
            this.mBinding.ivAvatar.setVisibility(0);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.oppositeSurfaceLayout.setVisibility(8);
            this.mBinding.tvNick.setVisibility(0);
            this.mBinding.llVideoCalled.setVisibility(8);
            this.mBinding.llVoiceCallingControl.setVisibility(0);
            this.mBinding.btnHangupCall.setVisibility(0);
            this.mBinding.llVideoCallingHead.setVisibility(8);
            this.mBinding.llVoiceCallingHead.setVisibility(0);
            this.mBinding.tvNickVoice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            this.mBinding.tvCallStateVoice.setVisibility(8);
        }
        this.mBinding.btnVideoTranse.setVisibility(8);
        this.mBinding.btnVideoTranseComming.setVisibility(8);
    }

    public void makeCallStatus() {
        if (!this.isInComingCall && this.callType == EaseCallType.SINGLE_VOICE_CALL) {
            this.mBinding.llVoiceCallingControl.setVisibility(0);
            this.mBinding.llVideoCallingHead.setVisibility(8);
            this.mBinding.llVoiceCallingHead.setVisibility(0);
            this.mBinding.tvCallStateVoice.setVisibility(0);
            this.mBinding.tvCallStateVoice.setText((CharSequence)this.getApplicationContext().getString(R.string.ease_call_calling));
        } else {
            this.mBinding.llVoiceCallingControl.setVisibility(8);
            this.mBinding.llVideoCallingOutAndOngoingControl.setVisibility(0);
            this.mBinding.llVideoCallingHead.setVisibility(0);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
            this.mBinding.tvCallState.setText((CharSequence)this.getApplicationContext().getString(R.string.ease_call_calling));
        }
        this.mBinding.llComingCallVoice.setVisibility(8);
        this.mBinding.groupOngoingSettings.setVisibility(8);
        this.mBinding.localSurfaceLayout.setVisibility(8);
        this.mBinding.llVideoCloseControl.setVisibility(8);
        this.mBinding.btnCallFloat.setVisibility(0);
        this.mBinding.btnSwitchCamera.setVisibility(0);
    }

    private void initializeEngine() {
        try {
            EaseCallKitConfig config = EaseCallKit.getInstance().getCallKitConfig();
            if (config != null) {
                this.agoraAppId = config.getAgoraAppId();
            }
            this.mRtcEngine = RtcEngine.create((Context)this.getApplicationContext(), (String)this.agoraAppId, (IRtcEngineEventHandler)this.mRtcEventHandler);
            this.mRtcEngine.setChannelProfile(1);
            this.mRtcEngine.setClientRole(1);
        }
        catch (Exception e) {
            EMLog.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            throw new RuntimeException("NEED TO check rtc sdk init fatal error\n" + Log.getStackTraceString((Throwable)e));
        }
    }

    private void setupVideoConfig() {
        if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mRtcEngine.enableVideo();
            this.mRtcEngine.setVideoEncoderConfiguration(new VideoEncoderConfiguration(VideoEncoderConfiguration.VD_1280x720, VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15, 0, VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT));
            this.isCameraFront = true;
        } else {
            this.mRtcEngine.disableVideo();
        }
    }

    private void setupLocalVideo() {
        if (this.isFloatWindowShowing()) {
            return;
        }
        this.updateOppositeSurfaceLayoutUid(0);
        if (this.isInComingCall && this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mRtcEngine.startPreview();
        }
    }

    private void joinChannel() {
        EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
        if (this.listener != null && callKitConfig != null && callKitConfig.isEnableRTCToken()) {
            this.listener.onGenerateRTCToken(ChatClient.getInstance().getCurrentUser(), this.channelName, new EaseCallKitTokenCallback(){

                @Override
                public void onSetToken(String token, int uId) {
                    EMLog.d((String)TAG, (String)("onSetToken token:" + token + " uid: " + uId));
                    EaseCallSingleBaseActivity.this.mRtcEngine.joinChannel(token, EaseCallSingleBaseActivity.this.channelName, null, uId);
                    EaseCallSingleBaseActivity.this.inChannelAccounts.put(uId, new EaseUserAccount(uId, ChatClient.getInstance().getCurrentUser()));
                }

                @Override
                public void onGetTokenError(int error, String errorMsg) {
                    EMLog.e((String)TAG, (String)("onGenerateToken error :" + error + " errorMsg:" + errorMsg));
                    EaseCallSingleBaseActivity.this.exitChannel();
                }
            });
        } else {
            this.mRtcEngine.joinChannel(null, this.channelName, null, 0);
            this.inChannelAccounts.put(0, new EaseUserAccount(0, ChatClient.getInstance().getCurrentUser()));
        }
    }

    private void changeCameraDirection(boolean isFront) {
        if (this.isCameraFront != isFront) {
            if (this.mRtcEngine != null) {
                this.mRtcEngine.switchCamera();
            }
            this.isCameraFront = isFront;
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.btn_refuse_call || id2 == R.id.btn_refuse_video_called) {
            if (this.isInComingCall) {
                this.sendRefuseMessage();
            }
            this.exitChannel();
        } else if (id2 == R.id.btn_answer_call || id2 == R.id.btn_answer_video_called) {
            if (this.isInComingCall) {
                EaseCallAudioControl.getInstance().stopPlayRing();
                this.sendAgreeMessage();
            }
        } else if (id2 == R.id.btn_hangup_call || id2 == R.id.btn_video_hangup_call) {
            this.stopCount();
            if (this.remoteUId == 0) {
                EaseCallCallCancelEvent cancelEvent = new EaseCallCallCancelEvent();
                cancelEvent.callId = EaseCallKit.getInstance().getCallID();
                this.sendCmdMsg(cancelEvent, this.username);
            } else if (this.listener != null) {
                long time = this.getChronometerSeconds(this.mBinding.chronometer);
                this.listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, time * 1000L);
            }
            this.exitChannel();
        } else if (id2 == R.id.local_surface_layout) {
            this.changeSurface();
        } else if (id2 == R.id.btn_call_float) {
            this.showFloatWindow();
        } else if (id2 == R.id.iv_mute || id2 == R.id.iv_video_mute) {
            if (this.isMuteVoice) {
                this.mBinding.ivMute.setImageResource(R.drawable.call_mute_normal);
                this.mBinding.ivVideoMute.setImageResource(R.drawable.call_mute_normal);
                this.mRtcEngine.muteLocalAudioStream(false);
                this.isMuteVoice = false;
            } else {
                this.mBinding.ivMute.setImageResource(R.drawable.call_mute_on);
                this.mBinding.ivVideoMute.setImageResource(R.drawable.call_mute_on);
                this.mRtcEngine.muteLocalAudioStream(true);
                this.isMuteVoice = true;
            }
        } else if (id2 == R.id.iv_speaker) {
            this.setSpeakerMode(!this.isSpeakerOn);
        } else if (id2 == R.id.btn_switch_camera) {
            this.changeCameraDirection(!this.isCameraFront);
        } else if (id2 == R.id.btn_voice_trans) {
            if (this.callType == EaseCallType.SINGLE_VOICE_CALL) {
                this.callType = EaseCallType.SINGLE_VIDEO_CALL;
                EaseCallKit.getInstance().setCallType(EaseCallType.SINGLE_VIDEO_CALL);
                EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                this.changeVideoVoiceState();
                if (this.mRtcEngine != null) {
                    this.mRtcEngine.muteLocalVideoStream(false);
                }
            } else {
                this.callType = EaseCallType.SINGLE_VOICE_CALL;
                EaseCallKit.getInstance().setCallType(EaseCallType.SINGLE_VOICE_CALL);
                EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                this.setSpeakerMode(true);
                this.mBinding.ivSpeaker.setImageResource(R.drawable.em_icon_speaker_on);
                this.changeVideoVoiceState();
                if (this.mRtcEngine != null) {
                    this.mRtcEngine.muteLocalVideoStream(true);
                }
            }
        } else if (id2 == R.id.btn_video_transe_comming || id2 == R.id.btn_video_transe) {
            this.callType = EaseCallType.SINGLE_VOICE_CALL;
            EaseCallKit.getInstance().setCallType(EaseCallType.SINGLE_VOICE_CALL);
            EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
            if (this.mRtcEngine != null) {
                this.mRtcEngine.disableVideo();
                this.mRtcEngine.muteLocalVideoStream(true);
            }
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.oppositeSurfaceLayout.setVisibility(8);
            EaseCallImageUtil.setViewGaussianBlur(this.rootView, EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser()));
            this.loadHeadImage();
            this.mBinding.llVideoCallingHead.setVisibility(8);
            this.mBinding.btnVideoTranse.setVisibility(8);
            this.mBinding.btnVideoTranseComming.setVisibility(8);
            this.mBinding.llVoiceCallingHead.setVisibility(0);
            this.mBinding.tvNickVoice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            if (this.isInComingCall) {
                EaseCallAudioControl.getInstance().stopPlayRing();
                EaseCallAnswerEvent event = new EaseCallAnswerEvent();
                event.result = EaseCallMsgUtils.CALL_ANSWER_ACCEPT;
                event.callId = EaseCallKit.getInstance().getCallID();
                event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
                event.calleeDevId = EaseCallKit.deviceId;
                event.transVoice = true;
                this.sendCmdMsg(event, this.username);
            } else {
                EaseCallVideoToVoiceeEvent event = new EaseCallVideoToVoiceeEvent();
                event.callId = EaseCallKit.getInstance().getCallID();
                this.sendCmdMsg(event, this.username);
            }
        } else if (id2 == R.id.iv_vidicon_video_called || id2 == R.id.iv_vidicon_video_calling) {
            if (!this.isLocalVideoMuted) {
                this.mRtcEngine.muteLocalVideoStream(true);
                this.isLocalVideoMuted = true;
            } else {
                this.mRtcEngine.muteLocalVideoStream(false);
                this.isLocalVideoMuted = false;
            }
            if (this.isOngoingCall) {
                this.updateViewWithCameraStatus();
            } else if (this.isInComingCall) {
                if (this.isLocalVideoMuted) {
                    String userHeadImage = EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser());
                    EaseCallImageUtil.setViewGaussianBlur(this.mBinding.rootLayout, userHeadImage);
                    this.mBinding.oppositeSurfaceLayout.setVisibility(8);
                } else {
                    this.mBinding.oppositeSurfaceLayout.setVisibility(0);
                }
            } else {
                if (this.isLocalVideoMuted) {
                    String userHeadImage = EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser());
                    EaseCallImageUtil.setViewGaussianBlur(this.mBinding.rootLayout, userHeadImage);
                    this.mBinding.oppositeSurfaceLayout.setVisibility(8);
                } else {
                    this.mBinding.oppositeSurfaceLayout.setVisibility(0);
                }
                this.mBinding.ivVidiconVideoCalled.setImageResource(!this.isLocalVideoMuted ? R.drawable.call_video_on : R.drawable.call_video_off);
            }
            this.mBinding.ivVidiconVideoCalling.setImageResource(!this.isLocalVideoMuted ? R.drawable.call_video_on : R.drawable.call_video_off);
        } else if (id2 == R.id.iv_call_redial) {
            this.makeCallStatus();
            EaseCallAudioControl.getInstance().playRing();
            if (this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
                this.mBinding.oppositeSurfaceLayout.setVisibility(0);
            }
            this.joinChannel();
        } else if (id2 == R.id.iv_call_close) {
            this.resetState();
        }
    }

    private void setSpeakerMode(final boolean isSpeakerOn) {
        this.isSpeakerOn = isSpeakerOn;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (isSpeakerOn) {
                    ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.ivSpeaker.setImageResource(R.drawable.em_icon_speaker_on);
                    EaseCallAudioControl.getInstance().openSpeakerOn();
                } else {
                    ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.ivSpeaker.setImageResource(R.drawable.em_icon_speaker_normal);
                    EaseCallAudioControl.getInstance().closeSpeakerOn();
                }
            }
        });
    }

    private void updateViewWithCameraStatus() {
        if (this.isLocalVideoMuted && this.isRemoteVideoMuted) {
            this.mBinding.btnSwitchCamera.setVisibility(8);
            this.mBinding.cslMuteSmallview.setVisibility(8);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.oppositeSurfaceLayout.setVisibility(8);
            String userHeadImage = EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser());
            EaseCallImageUtil.setViewGaussianBlur(this.mBinding.rootLayout, userHeadImage);
            this.mBinding.llVoiceCallingHead.setVisibility(0);
            this.mBinding.tvCallStateVoice.setText((CharSequence)"");
            EaseCallImageUtil.setImage((Context)this, (ImageView)this.mBinding.ivAvatarVoice, this.headUrl);
        } else if (this.isLocalVideoMuted && !this.isRemoteVideoMuted) {
            this.mBinding.btnSwitchCamera.setVisibility(8);
            this.mBinding.rootLayout.setBackground(null);
            this.mBinding.cslMuteSmallview.setVisibility(0);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.updateOppositeSurfaceLayoutUid(this.remoteUId);
            EaseCallImageUtil.setImage((Context)this, (ImageView)this.mBinding.ivMuteSmall, EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser()));
        } else if (!this.isLocalVideoMuted && this.isRemoteVideoMuted) {
            this.mBinding.btnSwitchCamera.setVisibility(0);
            this.mBinding.rootLayout.setBackground(null);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
            this.mBinding.cslMuteSmallview.setVisibility(0);
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.updateOppositeSurfaceLayoutUid(0);
            this.idInLocalSurfaceLayout = -1;
            EaseCallImageUtil.setImage((Context)this, (ImageView)this.mBinding.ivMuteSmall, this.headUrl);
        } else {
            this.mBinding.btnSwitchCamera.setVisibility(0);
            this.mBinding.rootLayout.setBackground(null);
            this.mBinding.llVoiceCallingHead.setVisibility(8);
            this.mBinding.cslMuteSmallview.setVisibility(8);
            this.updateOppositeSurfaceLayoutUid(this.remoteUId);
            this.updateLocalSurfaceLayoutUid(0);
        }
        if (this.isFloatWindowShowing()) {
            EaseCallFloatWindow.getInstance().setRemoteVideoMuted(this.isRemoteVideoMuted);
            EaseCallFloatWindow.getInstance().update(!this.changeFlag, this.headUrl, 0, this.remoteUId, true);
        }
    }

    private void sendAgreeMessage() {
        EaseCallAnswerEvent event = new EaseCallAnswerEvent();
        event.result = EaseCallMsgUtils.CALL_ANSWER_ACCEPT;
        event.callId = EaseCallKit.getInstance().getCallID();
        event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
        event.calleeDevId = EaseCallKit.deviceId;
        if (TextUtils.isEmpty((CharSequence)this.username)) {
            this.username = EaseCallKit.getInstance().getFromUserId();
        }
        if (TextUtils.isEmpty((CharSequence)this.channelName)) {
            this.channelName = EaseCallKit.getInstance().getChannelName();
        }
        this.sendCmdMsg(event, this.username);
    }

    private void sendRefuseMessage() {
        this.stopCount();
        EaseCallAnswerEvent event = new EaseCallAnswerEvent();
        event.result = EaseCallMsgUtils.CALL_ANSWER_REFUSE;
        event.callId = EaseCallKit.getInstance().getCallID();
        event.callerDevId = EaseCallKit.getInstance().getClallee_devId();
        event.calleeDevId = EaseCallKit.deviceId;
        this.sendCmdMsg(event, this.username);
    }

    private void changeSurface() {
        if (this.changeFlag) {
            this.updateLocalSurfaceLayoutUid(this.remoteUId);
            this.updateOppositeSurfaceLayoutUid(0);
            this.changeFlag = !this.changeFlag;
        } else {
            this.updateLocalSurfaceLayoutUid(0);
            this.updateOppositeSurfaceLayoutUid(this.remoteUId);
            this.changeFlag = !this.changeFlag;
        }
    }

    private synchronized void updateOppositeSurfaceLayoutUid(int uid) {
        this.mBinding.oppositeSurfaceLayout.setVisibility(0);
        if (this.idInOppositeSurfaceLayout != uid) {
            this.idInOppositeSurfaceLayout = uid;
            SurfaceView localview = RtcEngine.CreateRendererView((Context)this.getBaseContext());
            VideoCanvas mLocalVideo = new VideoCanvas((View)localview, 1, uid);
            if (uid == 0) {
                this.mRtcEngine.setupLocalVideo(mLocalVideo);
            } else {
                this.mRtcEngine.setupRemoteVideo(mLocalVideo);
            }
            if (this.mBinding.oppositeSurfaceLayout.getChildCount() >= 10) {
                this.mBinding.oppositeSurfaceLayout.removeAllViews();
            }
            this.mBinding.oppositeSurfaceLayout.addView((View)localview);
        }
    }

    private synchronized void updateLocalSurfaceLayoutUid(int uid) {
        this.mBinding.localSurfaceLayout.setVisibility(0);
        if (this.idInLocalSurfaceLayout != uid) {
            this.idInLocalSurfaceLayout = uid;
            TextureView remoteview = RtcEngine.CreateTextureView((Context)this.getBaseContext());
            EaseCallImageUtil.setBgRadius((View)remoteview, EaseCallKitUtils.dp2px((Context)this, 12));
            VideoCanvas mRemoteVideo = new VideoCanvas((View)remoteview, 1, uid);
            if (uid == 0) {
                this.mRtcEngine.setupLocalVideo(mRemoteVideo);
            } else {
                this.mRtcEngine.setupRemoteVideo(mRemoteVideo);
            }
            if (this.mBinding.localSurfaceLayout.getChildCount() >= 10) {
                this.mBinding.localSurfaceLayout.removeAllViews();
            }
            this.mBinding.localSurfaceLayout.addView((View)remoteview);
        }
    }

    private void leaveChannel() {
        if (this.mRtcEngine != null) {
            this.mRtcEngine.leaveChannel();
        }
    }

    void changeVideoVoiceState() {
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
            this.mBinding.ivAvatar.setVisibility(8);
            this.mBinding.localSurfaceLayout.setVisibility(0);
            this.mBinding.oppositeSurfaceLayout.setVisibility(0);
            this.makeOngoingStatus();
        } else {
            this.mBinding.localSurfaceLayout.setVisibility(8);
            this.mBinding.oppositeSurfaceLayout.setVisibility(8);
            EaseCallImageUtil.setViewGaussianBlur(this.rootView, EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser()));
            if (EaseCallKit.getInstance().getCallState() == EaseCallState.CALL_ANSWERED) {
                this.mBinding.ivAvatar.setVisibility(0);
                this.makeOngoingStatus();
            } else {
                this.mBinding.localSurfaceLayout.setVisibility(8);
                this.mBinding.oppositeSurfaceLayout.setVisibility(8);
                this.mBinding.tvCallStateVoice.setVisibility(0);
                EaseCallImageUtil.setViewGaussianBlur(this.rootView, EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser()));
                if (this.isInComingCall) {
                    this.mBinding.tvCallStateVoice.setText((CharSequence)this.getApplicationContext().getString(R.string.ease_call_voice_call));
                } else {
                    this.mBinding.tvCallStateVoice.setText((CharSequence)this.getApplicationContext().getString(R.string.ease_call_calling));
                }
                this.mBinding.llVideoCallingHead.setVisibility(8);
                this.mBinding.btnVideoTranse.setVisibility(8);
                this.mBinding.btnVideoTranseComming.setVisibility(8);
                this.mBinding.llVoiceCallingHead.setVisibility(0);
                this.mBinding.tvNickVoice.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.username));
            }
            this.loadHeadImage();
        }
    }

    protected void addLiveDataObserver() {
        EaseCallLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString(), EaseCallBaseEvent.class).observe((LifecycleOwner)this, event -> {
            if (event != null) {
                switch (event.callAction) {
                    case CALL_ALERT: {
                        EaseCallAlertEvent alertEvent = (EaseCallAlertEvent)event;
                        EaseCallConfirmRingEvent ringEvent = new EaseCallConfirmRingEvent();
                        if (TextUtils.equals((CharSequence)alertEvent.callId, (CharSequence)EaseCallKit.getInstance().getCallID()) && EaseCallKit.getInstance().getCallState() != EaseCallState.CALL_ANSWERED) {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.callId = alertEvent.callId;
                            ringEvent.valid = true;
                            this.sendCmdMsg(ringEvent, this.username);
                        } else {
                            ringEvent.calleeDevId = alertEvent.calleeDevId;
                            ringEvent.callId = alertEvent.callId;
                            ringEvent.valid = false;
                            this.sendCmdMsg(ringEvent, this.username);
                        }
                        this.mConfirmRing = true;
                        break;
                    }
                    case CALL_CANCEL: {
                        if (!TextUtils.equals((CharSequence)event.userId, (CharSequence)this.username) && !TextUtils.equals((CharSequence)event.userId, (CharSequence)ChatClient.getInstance().getCurrentUser())) break;
                        if (!this.isInComingCall) {
                            this.timehandler.stopTime();
                        }
                        this.exitChannel();
                        if (this.listener == null) break;
                        this.listener.onEndCallWithReason(this.callType, this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteCancel, 0L);
                        break;
                    }
                    case CALL_ANSWER: {
                        EaseCallAnswerEvent answerEvent = (EaseCallAnswerEvent)event;
                        EaseCallConfirmCallEvent callEvent = new EaseCallConfirmCallEvent();
                        boolean transVoice = answerEvent.transVoice;
                        callEvent.calleeDevId = answerEvent.calleeDevId;
                        callEvent.callerDevId = answerEvent.callerDevId;
                        callEvent.result = answerEvent.result;
                        callEvent.callId = answerEvent.callId;
                        if (TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_BUSY)) {
                            if (!this.mConfirmRing) {
                                this.timehandler.stopTime();
                                this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        EaseCallSingleBaseActivity.this.exitChannel();
                                        if (EaseCallSingleBaseActivity.this.listener != null) {
                                            EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonBusy, 0L);
                                        }
                                    }
                                });
                                break;
                            }
                            this.timehandler.stopTime();
                            this.sendCmdMsg(callEvent, this.username);
                            break;
                        }
                        if (TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                            EaseCallKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                            this.timehandler.stopTime();
                            this.sendCmdMsg(callEvent, this.username);
                            if (!transVoice) break;
                            this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    EaseCallSingleBaseActivity.this.callType = EaseCallType.SINGLE_VOICE_CALL;
                                    EaseCallKit.getInstance().setCallType(EaseCallType.SINGLE_VOICE_CALL);
                                    EaseCallFloatWindow.getInstance(EaseCallSingleBaseActivity.this.getApplicationContext()).setCallType(EaseCallSingleBaseActivity.this.callType);
                                    EaseCallSingleBaseActivity.this.changeVideoVoiceState();
                                }
                            });
                            break;
                        }
                        if (!TextUtils.equals((CharSequence)answerEvent.result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) break;
                        this.timehandler.stopTime();
                        this.sendCmdMsg(callEvent, this.username);
                        break;
                    }
                    case CALL_INVITE: {
                        EaseCallInviteEventEase inviteEvent = (EaseCallInviteEventEase)event;
                        if (inviteEvent.type != EaseCallType.SINGLE_VOICE_CALL) break;
                        this.callType = EaseCallType.SINGLE_VOICE_CALL;
                        EaseCallKit.getInstance().setCallType(EaseCallType.SINGLE_VOICE_CALL);
                        EaseCallFloatWindow.getInstance(this.getApplicationContext()).setCallType(this.callType);
                        if (this.mRtcEngine != null) {
                            this.mRtcEngine.disableVideo();
                        }
                        this.changeVideoVoiceState();
                        break;
                    }
                    case CALL_CONFIRM_RING: {
                        break;
                    }
                    case CALL_CONFIRM_CALLEE: {
                        EaseCallConfirmCallEvent confirmEvent = (EaseCallConfirmCallEvent)event;
                        String deviceId = confirmEvent.calleeDevId;
                        String result = confirmEvent.result;
                        this.timehandler.stopTime();
                        if (TextUtils.equals((CharSequence)deviceId, (CharSequence)EaseCallKit.deviceId)) {
                            if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                                EaseCallKit.getInstance().setCallState(EaseCallState.CALL_ANSWERED);
                                this.joinChannel();
                                this.makeOngoingStatus();
                                break;
                            }
                            if (!TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) break;
                            this.exitChannel();
                            break;
                        }
                        this.exitChannel();
                    }
                }
            }
        });
        EaseCallLiveDataBus.get().with("updateUserInfo", EaseCallUserInfo.class).observe((LifecycleOwner)this, userInfo -> {
            if (userInfo != null && TextUtils.equals((CharSequence)userInfo.getUserId(), (CharSequence)this.username)) {
                EaseCallKit.getInstance().getCallKitConfig().setUserInfo(this.username, (EaseCallUserInfo)userInfo);
                this.updateUserInfo();
            }
        });
    }

    private void sendInviteeMsg(String username, EaseCallType callType) {
        this.notifyUserToUpdateUserInfo(username);
        this.mConfirmRing = false;
        ChatMessage message = callType == EaseCallType.SINGLE_VIDEO_CALL ? ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invite_you_for_video_call), (String)username) : ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invite_you_for_audio_call), (String)username);
        this.setMessageAttr(message, username, callType, EaseCallAction.CALL_INVITE);
        ChatClient.getInstance().chatManager().sendMessage(message);
    }

    private void setMessageAttr(ChatMessage message, String username, EaseCallType callType, EaseCallAction callInvite) {
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, callInvite.state);
        message.setAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, this.channelName);
        message.setAttribute(EaseCallMsgUtils.CALL_TYPE, callType.code);
        message.setAttribute(EaseCallMsgUtils.CALL_DEVICE_ID, EaseCallKit.deviceId);
        JSONObject object = EaseCallKit.getInstance().getInviteExt();
        if (object != null) {
            message.setAttribute(EaseCallMsgUtils.CALL_INVITE_EXT, object);
        } else {
            try {
                JSONObject obj = new JSONObject();
                message.setAttribute(EaseCallMsgUtils.CALL_INVITE_EXT, obj);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        JSONObject extObject = new JSONObject();
        try {
            String info;
            EaseCallType type = EaseCallKit.getInstance().getCallType();
            if (type == EaseCallType.SINGLE_VOICE_CALL) {
                info = this.getApplication().getString(R.string.ease_call_alert_request_voice, new Object[]{ChatClient.getInstance().getCurrentUser()});
                extObject.putOpt("em_push_title", (Object)info);
                extObject.putOpt("em_push_content", (Object)info);
            } else {
                info = this.getApplication().getString(R.string.ease_call_alert_request_video, new Object[]{ChatClient.getInstance().getCurrentUser()});
                extObject.putOpt("em_push_title", (Object)info);
                extObject.putOpt("em_push_content", (Object)info);
            }
            extObject.putOpt("isRtcCall", (Object)true);
            extObject.putOpt("callType", (Object)type.code);
            extObject.putOpt("em_push_type", (Object)"voip");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        message.setAttribute("em_apns_ext", extObject);
        try {
            JSONObject pushExtObject = new JSONObject();
            pushExtObject.putOpt("type", (Object)"call");
            JSONObject customObject = new JSONObject();
            customObject.putOpt("callId", (Object)EaseCallKit.getInstance().getCallID());
            pushExtObject.putOpt("custom", (Object)customObject);
            message.setAttribute("em_push_ext", pushExtObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EaseCallKit.getInstance().setCallID(EaseCallKitUtils.getRandomString(10));
        message.setAttribute(EaseCallMsgUtils.CLL_ID, EaseCallKit.getInstance().getCallID());
        message.setAttribute(EaseCallMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        message.setAttribute(EaseCallMsgUtils.CALL_COST_TIME, this.mBinding.chronometer.getText().toString());
        message.setMessageStatusCallback(new CallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                if (EaseCallSingleBaseActivity.this.listener != null) {
                    EaseCallSingleBaseActivity.this.listener.onInViteCallMessageSent();
                }
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                if (EaseCallSingleBaseActivity.this.listener != null) {
                    EaseCallSingleBaseActivity.this.listener.onCallError(EaseCallError.IM_ERROR, code, error);
                    EaseCallSingleBaseActivity.this.listener.onInViteCallMessageSent();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
    }

    private void sendCmdMsg(final EaseCallBaseEvent event, String username) {
        EaseCallKit.getInstance().sendCmdMsg(event, username, new CallBack(){

            public void onSuccess() {
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            boolean cancel = ((EaseCallCallCancelEvent)event).cancel;
                            if (cancel) {
                                EaseCallSingleBaseActivity.this.resetState();
                                if (EaseCallSingleBaseActivity.this.listener != null) {
                                    EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonCancel, 0L);
                                }
                            } else {
                                EaseCallSingleBaseActivity.this.showRedialView();
                                if (EaseCallSingleBaseActivity.this.listener != null) {
                                    EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                                }
                            }
                        }
                    });
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE) {
                    if (!TextUtils.equals((CharSequence)((EaseCallConfirmCallEvent)event).result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                        String result = ((EaseCallConfirmCallEvent)event).result;
                        if (TextUtils.equals((CharSequence)result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_REFUSE)) {
                            EaseCallSingleBaseActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (EaseCallSingleBaseActivity.this.listener != null) {
                                        EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRefuse, 0L);
                                    }
                                }
                            });
                            EaseCallSingleBaseActivity.this.showRedialView();
                        } else {
                            EaseCallSingleBaseActivity.this.resetState();
                        }
                    }
                } else if (event.callAction == EaseCallAction.CALL_ANSWER) {
                    EaseCallSingleBaseActivity.this.timehandler.startTime();
                }
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                if (EaseCallSingleBaseActivity.this.listener != null) {
                    EaseCallSingleBaseActivity.this.listener.onCallError(EaseCallError.IM_ERROR, code, error);
                }
                if (event.callAction == EaseCallAction.CALL_CANCEL) {
                    EaseCallSingleBaseActivity.this.resetState();
                } else if (event.callAction == EaseCallAction.CALL_CONFIRM_CALLEE && !TextUtils.equals((CharSequence)((EaseCallConfirmCallEvent)event).result, (CharSequence)EaseCallMsgUtils.CALL_ANSWER_ACCEPT)) {
                    EaseCallSingleBaseActivity.this.resetState();
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
    }

    private void showRedialView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EaseCallSingleBaseActivity.this.leaveChannel();
                EaseCallAudioControl.getInstance().stopPlayRing();
                EaseCallSingleBaseActivity.this.isOngoingCall = false;
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.btnCallFloat.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.btnSwitchCamera.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.cslMuteSmallview.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.localSurfaceLayout.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.oppositeSurfaceLayout.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.llVoiceCallingControl.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.llVoiceCallingHead.setVisibility(8);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.llVideoCallingOutAndOngoingControl.setVisibility(8);
                EaseCallImageUtil.setImage((Context)EaseCallSingleBaseActivity.this, (ImageView)((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.ivAvatar, EaseCallSingleBaseActivity.this.headUrl);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.groupUseInfo.setVisibility(0);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.llVideoCloseControl.setVisibility(0);
                String userHeadImage = EaseCallKitUtils.getUserHeadImage(ChatClient.getInstance().getCurrentUser());
                EaseCallImageUtil.setViewGaussianBlur(((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.rootLayout, userHeadImage);
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.tvCallState.setText((CharSequence)EaseCallSingleBaseActivity.this.getString(R.string.ease_call_no_answer));
                if (EaseCallSingleBaseActivity.this.isFloatWindowShowing()) {
                    EaseCallFloatWindow.getInstance(EaseCallSingleBaseActivity.this.getApplicationContext()).dismiss();
                }
                EaseCallSingleBaseActivity.this.insertCancelMessageToLocal();
                EaseCallKit.getInstance().setCallState(EaseCallState.CALL_IDLE);
                EaseCallKit.getInstance().setCallID(null);
            }
        });
    }

    public long getChronometerSeconds(EaseCallChronometer cmt) {
        if (cmt == null) {
            EMLog.e((String)TAG, (String)"MyChronometer is null, can not get the cost seconds!");
            return 0L;
        }
        return cmt.getCostSeconds();
    }

    private void loadHeadImage() {
        if (EaseCallKit.getInstance().getCallType() == EaseCallType.SINGLE_VIDEO_CALL) {
            EaseCallImageUtil.setImage((Context)this, (ImageView)this.mBinding.ivAvatar, this.headUrl);
        } else {
            EaseCallImageUtil.setImage((Context)this, (ImageView)this.mBinding.ivAvatarVoice, this.headUrl);
        }
    }

    private void setUserJoinChannelInfo(String userName, int uid) {
        if (TextUtils.isEmpty((CharSequence)userName)) {
            if (this.listener != null) {
                this.listener.onRemoteUserJoinChannel(this.channelName, userName, uid, new EaseCallGetUserAccountCallback(){

                    @Override
                    public void onUserAccount(EaseUserAccount userAccount) {
                        EaseCallSingleBaseActivity.this.processOnUserAccount(userAccount);
                    }

                    @Override
                    public void onSetUserAccountError(int error, String errorMsg) {
                        EMLog.e((String)TAG, (String)("onRemoteUserJoinChannel error:" + error + "  errorMsg:" + errorMsg));
                    }
                });
            }
        } else {
            EaseUserAccount userAccount = new EaseUserAccount(uid, userName);
            this.processOnUserAccount(userAccount);
        }
    }

    private void processOnUserAccount(EaseUserAccount userAccount) {
        if (userAccount != null) {
            this.inChannelAccounts.put(userAccount.getUid(), userAccount);
            this.notifyUserToUpdateUserInfo(userAccount.getUserName());
        }
        this.updateUserInfo();
    }

    private void notifyUserToUpdateUserInfo(String username) {
        if (this.listener != null && !TextUtils.isEmpty((CharSequence)username)) {
            this.listener.onUserInfoUpdate(username);
        }
    }

    private void updateUserInfo() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EaseCallSingleBaseActivity.this.headUrl = EaseCallKitUtils.getUserHeadImage(EaseCallSingleBaseActivity.this.username);
                EaseCallSingleBaseActivity.this.loadHeadImage();
                ((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.tvNickVoice.setText((CharSequence)EaseCallKitUtils.getUserNickName(EaseCallSingleBaseActivity.this.username));
            }
        });
    }

    private void resetState() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EaseCallAudioControl.getInstance().stopPlayRing();
                EaseCallSingleBaseActivity.this.isOngoingCall = false;
                EaseCallSingleBaseActivity.this.releaseHandler();
                EaseCallKit.getInstance().setCallState(EaseCallState.CALL_IDLE);
                EaseCallKit.getInstance().setCallID(null);
                EaseCallKit.getInstance().releaseCall();
                RtcEngine.destroy();
                EaseCallSingleBaseActivity.this.finish();
            }
        });
    }

    void exitChannel() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EaseCallSingleBaseActivity.this.leaveChannel();
                EMLog.i((String)TAG, (String)("exit channel channelName: " + EaseCallSingleBaseActivity.this.channelName));
                if (EaseCallSingleBaseActivity.this.isFloatWindowShowing()) {
                    EaseCallFloatWindow.getInstance(EaseCallSingleBaseActivity.this.getApplicationContext()).dismiss();
                } else {
                    EaseCallFloatWindow.getInstance().resetCurrentInstance();
                }
                EaseCallSingleBaseActivity.this.insertCancelMessageToLocal();
                EaseCallSingleBaseActivity.this.resetState();
            }
        });
    }

    private void insertCancelMessageToLocal() {
        ChatMessage message = ChatMessage.createTxtSendMessage((String)this.getApplicationContext().getString(R.string.ease_call_invited_to_make_multi_party_call), (String)this.username);
        message.setAttribute(EaseCallMsgUtils.CALL_ACTION, EaseCallAction.CALL_CANCEL.state);
        message.setAttribute(EaseCallMsgUtils.CALL_CHANNELNAME, this.channelName);
        message.setAttribute(EaseCallMsgUtils.CALL_TYPE, this.callType.code);
        message.setAttribute(EaseCallMsgUtils.CALL_MSG_TYPE, EaseCallMsgUtils.CALL_MSG_INFO);
        message.setAttribute(EaseCallMsgUtils.CALL_COST_TIME, this.dateFormat.format(this.getChronometerSeconds(this.mBinding.chronometer) * 1000L));
        Conversation conversation = ChatClient.getInstance().chatManager().getConversation(this.username);
        if (conversation != null) {
            conversation.insertMessage(message);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.checkFloatIntent(intent);
    }

    private void checkFloatIntent(Intent intent) {
        if (this.isFloatWindowShowing()) {
            EaseCallFloatWindow.SingleCallInfo callInfo = EaseCallFloatWindow.getInstance().getSingleCallInfo();
            if (callInfo != null) {
                this.remoteUId = callInfo.remoteUid;
                this.changeFlag = callInfo.changeFlag;
                this.isCameraFront = callInfo.isCameraFront;
                this.idInLocalSurfaceLayout = -1;
                this.idInOppositeSurfaceLayout = -1;
                if (EaseCallKit.getInstance().getCallState() == EaseCallState.CALL_ANSWERED) {
                    if (this.changeFlag && this.remoteUId != 0) {
                        this.updateOppositeSurfaceLayoutUid(this.remoteUId);
                        this.updateLocalSurfaceLayoutUid(0);
                    } else {
                        this.updateOppositeSurfaceLayoutUid(0);
                        this.updateLocalSurfaceLayoutUid(this.remoteUId);
                    }
                } else if (!this.isInComingCall) {
                    this.updateOppositeSurfaceLayoutUid(0);
                }
                this.changeCameraDirection(this.isCameraFront);
            }
            long totalCostSeconds = EaseCallFloatWindow.getInstance().getTotalCostSeconds();
            this.mBinding.chronometer.setBase(SystemClock.elapsedRealtime() - totalCostSeconds * 1000L);
            this.mBinding.chronometer.start();
        }
        EaseCallFloatWindow.getInstance().dismiss();
    }

    @Override
    public void doShowFloatWindow() {
        super.doShowFloatWindow();
        if (this.mBinding.chronometer != null) {
            EaseCallFloatWindow.getInstance().setCostSeconds(this.mBinding.chronometer.getCostSeconds());
        }
        EaseCallFloatWindow.getInstance().setRtcEngine(this.getApplicationContext(), this.mRtcEngine);
        EaseCallFloatWindow.getInstance().show();
        boolean surface = true;
        if (this.isInComingCall && EaseCallKit.getInstance().getCallState() != EaseCallState.CALL_ANSWERED) {
            surface = false;
        }
        EaseCallFloatWindow.getInstance().update(!this.changeFlag, this.headUrl, 0, this.remoteUId, surface);
        EaseCallFloatWindow.getInstance().setCameraDirection(this.isCameraFront, this.changeFlag);
        this.moveTaskToBack(false);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        EMLog.i((String)TAG, (String)("onActivityResult: " + requestCode + ", result code: " + resultCode));
        if (requestCode == 1002 && Build.VERSION.SDK_INT >= 23) {
            this.requestOverlayPermission = false;
            if (Settings.canDrawOverlays((Context)this)) {
                this.doShowFloatWindow();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.ease_call_alert_window_permission_denied), (int)0).show();
            }
            return;
        }
    }

    private void startCount() {
        if (this.mBinding.chronometer != null) {
            this.mBinding.chronometer.setBase(SystemClock.elapsedRealtime());
            this.mBinding.chronometer.start();
        }
    }

    private void stopCount() {
        if (this.mBinding.chronometer != null) {
            this.mBinding.chronometer.stop();
        }
    }

    protected void releaseHandler() {
        if (this.handler != null) {
            this.handler.sendEmptyMessage(301);
        }
        if (this.inComingCallHandler != null) {
            this.inComingCallHandler.removeCallbacksAndMessages(null);
            this.inComingCallHandler = null;
        }
        if (this.timehandler != null) {
            this.timehandler.stopTime();
        }
    }

    protected void onDestroy() {
        EMLog.d((String)TAG, (String)"onDestroy");
        super.onDestroy();
        this.releaseHandler();
        if (this.inChannelAccounts != null) {
            this.inChannelAccounts.clear();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.onBackPressed();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onBackPressed() {
        this.exitChannelDisplay();
    }

    public void exitChannelDisplay() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        final AlertDialog dialog = builder.create();
        View dialogView = View.inflate((Context)this, (int)R.layout.ease_call_activity_exit_channel, null);
        dialog.setView(dialogView);
        dialog.requestWindowFeature(1);
        WindowManager.LayoutParams wmlp = dialog.getWindow().getAttributes();
        wmlp.gravity = 17;
        dialog.show();
        Button btn_ok = (Button)dialogView.findViewById(R.id.btn_ok);
        Button btn_cancel = (Button)dialogView.findViewById(R.id.btn_cancel);
        btn_ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                EMLog.e((String)TAG, (String)"exitChannelDisplay  exit channel:");
                EaseCallSingleBaseActivity.this.stopCount();
                if (EaseCallSingleBaseActivity.this.remoteUId == 0) {
                    EaseCallCallCancelEvent cancelEvent = new EaseCallCallCancelEvent();
                    cancelEvent.callId = EaseCallKit.getInstance().getCallID();
                    EaseCallSingleBaseActivity.this.sendCmdMsg(cancelEvent, EaseCallSingleBaseActivity.this.username);
                } else {
                    EaseCallSingleBaseActivity.this.exitChannel();
                    if (EaseCallSingleBaseActivity.this.listener != null) {
                        long time = EaseCallSingleBaseActivity.this.getChronometerSeconds(((EaseCallSingleBaseActivity)EaseCallSingleBaseActivity.this).mBinding.chronometer);
                        EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonHangup, time * 1000L);
                    }
                }
            }
        });
        btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.dismiss();
                EMLog.e((String)TAG, (String)"exitChannelDisplay not exit channel");
            }
        });
    }

    private class TimeHandler
    extends Handler {
        private final int MSG_TIMER = 0;
        private int timePassed = 0;
        private String passedTime;

        public void startTime() {
            this.timePassed = 0;
            this.sendEmptyMessageDelayed(0, 1000L);
        }

        public String getPassedTime() {
            this.passedTime = EaseCallSingleBaseActivity.this.dateFormat.format(this.timePassed * 1000);
            return this.passedTime;
        }

        public void stopTime() {
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                Log.e((String)"TAG", (String)("TimeHandler timePassed: " + this.timePassed));
                String time = EaseCallSingleBaseActivity.this.dateFormat.format(this.timePassed * 1000);
                EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
                long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() * 1000L : 30000L;
                if ((long)(this.timePassed * 1000) == intervalTime) {
                    EaseCallSingleBaseActivity.this.timehandler.stopTime();
                    if (EaseCallSingleBaseActivity.this.isInComingCall) {
                        EaseCallSingleBaseActivity.this.showRedialView();
                        if (EaseCallSingleBaseActivity.this.listener != null) {
                            EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonRemoteNoResponse, 0L);
                        }
                    } else {
                        EaseCallCallCancelEvent cancelEvent = new EaseCallCallCancelEvent();
                        cancelEvent.cancel = false;
                        cancelEvent.remoteTimeout = true;
                        cancelEvent.callId = EaseCallKit.getInstance().getCallID();
                        EaseCallSingleBaseActivity.this.sendCmdMsg(cancelEvent, EaseCallSingleBaseActivity.this.username);
                    }
                }
                this.sendEmptyMessageDelayed(0, 1000L);
                return;
            }
            super.handleMessage(msg);
        }
    }

    private class InComingCallHandler
    extends Handler {
        private int timePassed = 0;
        private final int MSG_TIMER = 1;

        private InComingCallHandler() {
        }

        public void handleMessage(@NonNull Message msg) {
            if (msg.what == 1) {
                ++this.timePassed;
                Log.e((String)"TAG", (String)("incomming call timePassed: " + this.timePassed));
                EaseCallKitConfig callKitConfig = EaseCallKit.getInstance().getCallKitConfig();
                long intervalTime = callKitConfig != null ? callKitConfig.getCallTimeOut() : 30000L;
                if ((long)(this.timePassed * 1000) == intervalTime) {
                    this.stopTime();
                    EaseCallSingleBaseActivity.this.exitChannel();
                    if (EaseCallSingleBaseActivity.this.listener != null) {
                        EaseCallSingleBaseActivity.this.listener.onEndCallWithReason(EaseCallSingleBaseActivity.this.callType, EaseCallSingleBaseActivity.this.channelName, EaseCallEndReason.EaseCallEndReasonNoResponse, 0L);
                    }
                } else {
                    this.sendEmptyMessageDelayed(1, 1000L);
                }
            }
        }

        public void startTime() {
            this.timePassed = 0;
            this.removeMessages(1);
            this.sendEmptyMessageDelayed(1, 1000L);
        }

        public void stopTime() {
            this.removeMessages(1);
        }
    }
}

