/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.utils;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.util.Log;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.util.EMLog;
import java.io.IOException;

public class EaseCallAudioControl {
    private String TAG = this.getClass().getSimpleName();
    private static volatile EaseCallAudioControl mInstance;
    private Context mContext;
    private MediaPlayer mediaPlayer;
    private String ringFile;
    protected AudioManager audioManager;
    protected Ringtone ringtone;
    private boolean isPlaying;

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        this.audioManager = (AudioManager)this.mContext.getSystemService("audio");
        Uri ringUri = RingtoneManager.getDefaultUri((int)1);
        this.audioManager.setMode(1);
        if (ringUri != null) {
            this.ringtone = RingtoneManager.getRingtone((Context)this.mContext, (Uri)ringUri);
        }
        this.ringFile = EaseCallKitUtils.getRingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseCallAudioControl getInstance() {
        if (mInstance != null) return mInstance;
        Class<EaseCallAudioControl> clazz = EaseCallAudioControl.class;
        synchronized (EaseCallAudioControl.class) {
            if (mInstance != null) return mInstance;
            mInstance = new EaseCallAudioControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private EaseCallAudioControl() {
    }

    public void playRing() {
        if (!this.isPlaying && this.audioManager.getRingerMode() == 2) {
            this.doRing();
            EMLog.e((String)this.TAG, (String)"playRing start");
        }
    }

    private void doRing() {
        this.isPlaying = true;
        if (this.ringFile != null) {
            this.mediaPlayer = new MediaPlayer();
            try {
                this.mediaPlayer.setDataSource(this.ringFile);
                if (!this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.prepare();
                    this.mediaPlayer.start();
                    Log.e((String)this.TAG, (String)"playRing play file");
                }
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        } else {
            EMLog.d((String)this.TAG, (String)"playRing start play");
            if (this.ringtone != null) {
                this.ringtone.play();
                Log.e((String)this.TAG, (String)"playRing play ringtone");
            }
            EMLog.d((String)this.TAG, (String)"playRing start play end");
        }
    }

    public void stopPlayRing() {
        this.isPlaying = false;
        if (this.ringFile != null) {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer = null;
            }
        } else if (this.ringtone != null) {
            this.ringtone.stop();
        }
    }

    public void openSpeakerOn() {
        try {
            if (!this.audioManager.isSpeakerphoneOn()) {
                this.audioManager.setSpeakerphoneOn(true);
            }
            this.audioManager.setMode(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeSpeakerOn() {
        try {
            if (this.audioManager != null) {
                if (this.audioManager.isSpeakerphoneOn()) {
                    this.audioManager.setSpeakerphoneOn(false);
                }
                this.audioManager.setMode(3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

