/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Outline;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.request.transition.Transition;
import io.agora.chat.callkit.utils.EaseCallGlideBlurTransformation;

public class EaseCallImageUtil {
    private static final int BITMAP_SCALE = 5;
    private static EaseCallImageUtil sInstance;

    private EaseCallImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseCallImageUtil instance() {
        if (sInstance != null) return sInstance;
        Class<EaseCallImageUtil> clazz = EaseCallImageUtil.class;
        synchronized (EaseCallImageUtil.class) {
            if (sInstance != null) return sInstance;
            sInstance = new EaseCallImageUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Bitmap blurBitmap(Context context, Bitmap image, float blurRadius, int outWidth, int outHeight) {
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)(outWidth / 5), (int)(outHeight / 5), (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        if (Build.VERSION.SDK_INT >= 17) {
            blurScript.setRadius(blurRadius);
        }
        blurScript.setInput(tmpIn);
        blurScript.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        return outputBitmap;
    }

    public static void setImage(Context context, ImageView imageView, String path) {
        if (imageView != null) {
            try {
                int resourceId = Integer.parseInt(path);
                imageView.setImageResource(resourceId);
            }
            catch (NumberFormatException e) {
                Glide.with((Context)context).load(path).into(imageView);
            }
        }
    }

    @TargetApi(value=21)
    public static void setBgRadius(View view, final int bgRadius) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)bgRadius);
                }
            });
            view.setElevation(10.0f);
            view.setClipToOutline(true);
        }
    }

    public static <T extends View> void setViewGaussianBlur(T view, String path) {
        if (view != null) {
            try {
                int resourceId = Integer.parseInt(path);
                Glide.with(view).load(Integer.valueOf(resourceId)).apply((BaseRequestOptions)RequestOptions.bitmapTransform((Transformation)new EaseCallGlideBlurTransformation(view.getContext()))).into((Target)new ViewTarget<T, Drawable>(view){

                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        Drawable current = resource.getCurrent();
                        this.view.setBackground(current);
                    }
                });
            }
            catch (NumberFormatException e) {
                Glide.with(view).load(path).apply((BaseRequestOptions)RequestOptions.bitmapTransform((Transformation)new EaseCallGlideBlurTransformation(view.getContext()))).into((Target)new ViewTarget<T, Drawable>(view){

                    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                        Drawable current = resource.getCurrent();
                        this.view.setBackground(current);
                    }
                });
            }
        }
    }
}

