/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.utils;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Properties;

public class EaseCallRomUtils {
    public static final String ROM_MIUI = "MIUI";
    public static final String ROM_EMUI = "EMUI";
    public static final String ROM_VIVO = "VIVO";
    public static final String ROM_OPPO = "OPPO";
    public static final String ROM_FLYME = "FLYME";
    public static final String ROM_SMARTISAN = "SMARTISAN";
    public static final String ROM_QIKU = "QIKU";
    public static final String ROM_LETV = "LETV";
    public static final String ROM_LENOVO = "LENOVO";
    public static final String ROM_NUBIA = "NUBIA";
    public static final String ROM_ZTE = "ZTE";
    public static final String ROM_COOLPAD = "COOLPAD";
    public static final String ROM_UNKNOWN = "UNKNOWN";
    private static final String SYSTEM_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String SYSTEM_VERSION_EMUI = "ro.build.version.emui";
    private static final String SYSTEM_VERSION_VIVO = "ro.vivo.os.version";
    private static final String SYSTEM_VERSION_OPPO = "ro.build.version.opporom";
    private static final String SYSTEM_VERSION_FLYME = "ro.build.display.id";
    private static final String SYSTEM_VERSION_SMARTISAN = "ro.smartisan.version";
    private static final String SYSTEM_VERSION_LETV = "ro.letv.eui";
    private static final String SYSTEM_VERSION_LENOVO = "ro.lenovo.lvp.version";
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";

    public static int getLightStatusBarAvailableRomType() {
        if (EaseCallRomUtils.isMiUIV7OrAbove()) {
            return 3;
        }
        if (EaseCallRomUtils.isMiUIV6OrAbove()) {
            return 1;
        }
        if (EaseCallRomUtils.isFlymeV4OrAbove()) {
            return 2;
        }
        if (EaseCallRomUtils.isAndroidMOrAbove()) {
            return 3;
        }
        return 4;
    }

    private static boolean isFlymeV4OrAbove() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            String[] displayIdArray;
            for (String temp : displayIdArray = displayId.split(" ")) {
                if (!temp.matches("^[4-9]\\.(\\d+\\.)+\\S*")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndroidMOrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMiUIV6OrAbove() {
        FileInputStream stream = null;
        try {
            Properties properties = new Properties();
            stream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(stream);
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                boolean bl = code >= 4;
                return bl;
            }
            boolean code = false;
            return code;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isMiUIV7OrAbove() {
        FileInputStream stream = null;
        try {
            Properties properties = new Properties();
            stream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            properties.load(stream);
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                boolean bl = code >= 5;
                return bl;
            }
            boolean code = false;
            return code;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getSystemProperty(String propName) {
        return "";
    }

    public static String getRomName() {
        if (EaseCallRomUtils.isMiuiRom()) {
            return ROM_MIUI;
        }
        if (EaseCallRomUtils.isHuaweiRom()) {
            return ROM_EMUI;
        }
        if (EaseCallRomUtils.isVivoRom()) {
            return ROM_VIVO;
        }
        if (EaseCallRomUtils.isOppoRom()) {
            return ROM_OPPO;
        }
        if (EaseCallRomUtils.isMeizuRom()) {
            return ROM_FLYME;
        }
        if (EaseCallRomUtils.isSmartisanRom()) {
            return ROM_SMARTISAN;
        }
        if (EaseCallRomUtils.is360Rom()) {
            return ROM_QIKU;
        }
        if (EaseCallRomUtils.isLetvRom()) {
            return ROM_LETV;
        }
        if (EaseCallRomUtils.isLenovoRom()) {
            return ROM_LENOVO;
        }
        if (EaseCallRomUtils.isZTERom()) {
            return ROM_ZTE;
        }
        if (EaseCallRomUtils.isCoolPadRom()) {
            return ROM_COOLPAD;
        }
        return ROM_UNKNOWN;
    }

    public static String getDeviceManufacture() {
        if (EaseCallRomUtils.isMiuiRom()) {
            return "\u5c0f\u7c73";
        }
        if (EaseCallRomUtils.isHuaweiRom()) {
            return "\u534e\u4e3a";
        }
        if (EaseCallRomUtils.isVivoRom()) {
            return ROM_VIVO;
        }
        if (EaseCallRomUtils.isOppoRom()) {
            return ROM_OPPO;
        }
        if (EaseCallRomUtils.isMeizuRom()) {
            return "\u9b45\u65cf";
        }
        if (EaseCallRomUtils.isSmartisanRom()) {
            return "\u9524\u5b50";
        }
        if (EaseCallRomUtils.is360Rom()) {
            return "\u5947\u9177";
        }
        if (EaseCallRomUtils.isLetvRom()) {
            return "\u4e50\u89c6";
        }
        if (EaseCallRomUtils.isLenovoRom()) {
            return "\u8054\u60f3";
        }
        if (EaseCallRomUtils.isZTERom()) {
            return "\u4e2d\u5174";
        }
        if (EaseCallRomUtils.isCoolPadRom()) {
            return "\u9177\u6d3e";
        }
        return Build.MANUFACTURER;
    }

    public static boolean isMiuiRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_MIUI));
    }

    public static boolean isHuaweiRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_EMUI));
    }

    public static boolean isVivoRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_VIVO));
    }

    public static boolean isOppoRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_OPPO));
    }

    public static boolean isMeizuRom() {
        String meizuFlymeOSFlag = EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_FLYME);
        return !TextUtils.isEmpty((CharSequence)meizuFlymeOSFlag) && meizuFlymeOSFlag.toUpperCase().contains(ROM_FLYME);
    }

    public static boolean isSmartisanRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_SMARTISAN));
    }

    public static boolean is360Rom() {
        String manufacturer = Build.MANUFACTURER;
        return !TextUtils.isEmpty((CharSequence)manufacturer) && manufacturer.toUpperCase().contains(ROM_QIKU);
    }

    public static boolean isLetvRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_LETV));
    }

    public static boolean isLenovoRom() {
        return !TextUtils.isEmpty((CharSequence)EaseCallRomUtils.getSystemProperty(SYSTEM_VERSION_LENOVO));
    }

    public static boolean isCoolPadRom() {
        String model = Build.MODEL;
        String fingerPrint = Build.FINGERPRINT;
        return !TextUtils.isEmpty((CharSequence)model) && model.toLowerCase().contains(ROM_COOLPAD) || !TextUtils.isEmpty((CharSequence)fingerPrint) && fingerPrint.toLowerCase().contains(ROM_COOLPAD);
    }

    public static boolean isZTERom() {
        String manufacturer = Build.MANUFACTURER;
        String fingerPrint = Build.FINGERPRINT;
        return !TextUtils.isEmpty((CharSequence)manufacturer) && (fingerPrint.toLowerCase().contains(ROM_NUBIA) || fingerPrint.toLowerCase().contains(ROM_ZTE)) || !TextUtils.isEmpty((CharSequence)fingerPrint) && (fingerPrint.toLowerCase().contains(ROM_NUBIA) || fingerPrint.toLowerCase().contains(ROM_ZTE));
    }

    public static boolean isDomesticSpecialRom() {
        return EaseCallRomUtils.isMiuiRom() || EaseCallRomUtils.isHuaweiRom() || EaseCallRomUtils.isMeizuRom() || EaseCallRomUtils.is360Rom() || EaseCallRomUtils.isOppoRom() || EaseCallRomUtils.isVivoRom() || EaseCallRomUtils.isLetvRom() || EaseCallRomUtils.isZTERom() || EaseCallRomUtils.isLenovoRom() || EaseCallRomUtils.isCoolPadRom();
    }

    class AvailableRomType {
        public static final int MIUI = 1;
        public static final int FLYME = 2;
        public static final int ANDROID_NATIVE = 3;
        public static final int NA = 4;

        AvailableRomType() {
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RomName {
    }
}

