/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.utils.EaseCallImageUtil;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.widget.EaseCallImageView;

public class EaseCallCommingCallView
extends FrameLayout {
    private static final String TAG = EaseCallCommingCallView.class.getSimpleName();
    private ImageButton mBtnReject;
    private ImageButton mBtnPickup;
    private TextView mInviterName;
    private TextView mCallState;
    private OnActionListener mOnActionListener;
    private EaseCallImageView avatar_view;
    private ImageView ivVidicon;
    private Bitmap headBitMap;
    private String headUrl;
    private RelativeLayout mSurfaceLayout;
    private ImageButton mSwitchCamera;

    public EaseCallCommingCallView(@NonNull Context context) {
        this(context, null);
    }

    public EaseCallCommingCallView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseCallCommingCallView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ease_call_activity_comming_call, (ViewGroup)this);
        this.mBtnReject = (ImageButton)this.findViewById(R.id.btn_refuse_video_called);
        this.mBtnPickup = (ImageButton)this.findViewById(R.id.btn_answer_video_called);
        this.mInviterName = (TextView)this.findViewById(R.id.tv_nick);
        this.mCallState = (TextView)this.findViewById(R.id.tv_call_state);
        this.mSwitchCamera = (ImageButton)this.findViewById(R.id.btn_switch_camera);
        this.avatar_view = (EaseCallImageView)this.findViewById(R.id.iv_avatar);
        this.ivVidicon = (ImageView)this.findViewById(R.id.iv_vidicon_video_called);
        this.mSurfaceLayout = (RelativeLayout)this.findViewById(R.id.opposite_surface_layout);
        this.mBtnReject.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCallCommingCallView.this.mOnActionListener != null) {
                    EaseCallCommingCallView.this.mOnActionListener.onRejectClick(v);
                }
            }
        });
        this.mBtnPickup.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCallCommingCallView.this.mOnActionListener != null) {
                    EaseCallCommingCallView.this.mOnActionListener.onPickupClick(v);
                }
            }
        });
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCallCommingCallView.this.mOnActionListener != null) {
                    EaseCallCommingCallView.this.mOnActionListener.onSwitchCamerClick(v);
                }
            }
        });
        this.ivVidicon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseCallCommingCallView.this.mOnActionListener != null) {
                    EaseCallCommingCallView.this.mOnActionListener.onMuteVideoClick(v);
                }
            }
        });
    }

    public void setInviteInfo(String username, String groupId, EaseCallType callType) {
        if (callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            this.mCallState.setText((CharSequence)this.getContext().getString(R.string.ease_call_video_call));
            this.mSwitchCamera.setVisibility(0);
        } else if (callType == EaseCallType.CONFERENCE_VOICE_CALL) {
            this.mCallState.setText((CharSequence)this.getContext().getString(R.string.ease_call_voice_call));
            this.mSwitchCamera.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)groupId)) {
            this.mInviterName.setText((CharSequence)groupId);
        }
        this.headUrl = EaseCallKitUtils.getUserHeadImage(username);
        this.loadHeadImage();
    }

    private void loadHeadImage() {
        this.post(new Runnable(){

            @Override
            public void run() {
                EaseCallImageUtil.setImage(EaseCallCommingCallView.this.getContext(), (ImageView)EaseCallCommingCallView.this.avatar_view, EaseCallCommingCallView.this.headUrl);
            }
        });
    }

    public void setVideoView(View view) {
        this.mSurfaceLayout.removeAllViews();
        this.mSurfaceLayout.addView(view);
    }

    public void removeVideoView(View view) {
        this.mSurfaceLayout.removeAllViews();
    }

    public void setOnActionListener(OnActionListener listener) {
        this.mOnActionListener = listener;
    }

    public static interface OnActionListener {
        public void onRejectClick(View var1);

        public void onPickupClick(View var1);

        public void onMuteVideoClick(View var1);

        public void onSwitchCamerClick(View var1);
    }
}

