/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import io.agora.chat.callkit.R;
import io.agora.chat.callkit.bean.EaseUserAccount;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.utils.EaseCallImageUtil;
import io.agora.chat.callkit.utils.EaseCallKitUtils;
import io.agora.chat.callkit.widget.EaseCallImageView;

public class EaseCallMemberView
extends RelativeLayout {
    private Context context;
    private RelativeLayout surfaceViewLayout;
    private EaseCallImageView avatarView;
    private ImageView audioOffInVideo;
    private ImageView audioOffInVoice;
    private ImageView talkingView;
    private TextView nameView;
    private SurfaceView surfaceView;
    private ValueAnimator animator;
    private EaseUserAccount userInfo;
    private boolean isShowVideo = true;
    private boolean isAudioOff = false;
    private boolean isDesktop = false;
    private boolean isFullScreenMode = false;
    private String streamId;
    private Bitmap headBitMap;
    private String headUrl;
    private EaseCallMemberView memberView;
    private LinearLayout loading_dialog;
    private boolean speakActivated;
    private boolean isCameraFront;
    private ImageView ivVidicon;
    private EaseCallType callType;

    public EaseCallMemberView(Context context) {
        this(context, null);
    }

    public EaseCallMemberView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseCallMemberView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ease_call_avtivity_call_member, (ViewGroup)this);
        this.init();
    }

    private void init() {
        this.surfaceViewLayout = (RelativeLayout)this.findViewById(R.id.item_surface_layout);
        this.avatarView = (EaseCallImageView)this.findViewById(R.id.img_call_avatar);
        this.audioOffInVideo = (ImageView)this.findViewById(R.id.mic_mute_in_video);
        this.audioOffInVoice = (ImageView)this.findViewById(R.id.mic_mute_in_voice);
        this.talkingView = (ImageView)this.findViewById(R.id.icon_talking);
        this.nameView = (TextView)this.findViewById(R.id.text_name);
        this.loading_dialog = (LinearLayout)this.findViewById(R.id.member_loading);
        this.ivVidicon = (ImageView)this.findViewById(R.id.iv_vidicon);
    }

    public void setLoading(Boolean loading) {
        if (loading.booleanValue()) {
            this.loading_dialog.setVisibility(0);
        } else {
            this.loading_dialog.setVisibility(8);
        }
    }

    public void addSurfaceView(SurfaceView surfaceView) {
        this.surfaceViewLayout.removeAllViews();
        this.surfaceViewLayout.addView((View)surfaceView);
        this.surfaceView = surfaceView;
    }

    public void setUserInfo(EaseUserAccount info) {
        this.userInfo = info;
        this.updateUserInfo();
    }

    public void updateUserInfo() {
        if (this.userInfo != null) {
            this.nameView.setVisibility(0);
            this.nameView.setText((CharSequence)EaseCallKitUtils.getUserNickName(this.userInfo.getUserName()));
            this.headUrl = EaseCallKitUtils.getUserHeadImage(this.userInfo.getUserName());
            if (this.headUrl != null) {
                this.loadHeadImage();
            } else {
                this.avatarView.setImageResource(R.drawable.call_memberview_background);
            }
        }
    }

    public EaseUserAccount getUserInfo() {
        return this.userInfo;
    }

    public String getUserAccount() {
        if (this.userInfo != null) {
            return this.userInfo.getUserName();
        }
        return null;
    }

    public int getUserId() {
        if (this.userInfo != null) {
            return this.userInfo.getUid();
        }
        return 0;
    }

    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    public void setAudioOff(boolean state) {
        if (!state) {
            this.setVoiceOnlineImageState(false);
        }
        this.isAudioOff = state;
        if (this.isFullScreenMode) {
            return;
        }
        if (this.isAudioOff) {
            if (this.callType == EaseCallType.CONFERENCE_VOICE_CALL) {
                this.audioOffInVoice.setVisibility(0);
                this.audioOffInVideo.setVisibility(8);
                this.audioOffInVoice.setImageResource(R.drawable.ease_call_mic_off);
            } else {
                this.audioOffInVoice.setVisibility(8);
                this.audioOffInVideo.setVisibility(0);
                this.audioOffInVideo.setImageResource(R.drawable.ease_call_mic_off_small);
            }
        } else if (this.callType == EaseCallType.CONFERENCE_VOICE_CALL) {
            this.audioOffInVoice.setVisibility(8);
            this.audioOffInVideo.setVisibility(8);
        } else {
            this.audioOffInVoice.setVisibility(8);
            this.audioOffInVideo.setVisibility(8);
        }
    }

    public boolean getAudioOff() {
        return this.isAudioOff;
    }

    public void setSpeak(boolean speak, int volume) {
        if (speak && volume > 3) {
            this.setVoiceOnlineImageState(true);
        } else {
            this.setVoiceOnlineImageState(false);
        }
    }

    public boolean isAudioOff() {
        return this.isAudioOff;
    }

    public void showVideo(boolean show) {
        this.isShowVideo = show;
        if (!this.isShowVideo) {
            this.avatarView.setVisibility(8);
            this.surfaceViewLayout.setVisibility(0);
            this.ivVidicon.setVisibility(8);
        } else {
            this.avatarView.setVisibility(0);
            this.surfaceViewLayout.setVisibility(8);
            this.ivVidicon.setVisibility(0);
        }
    }

    public void setNameVisiable(int visiable) {
        this.nameView.setVisibility(visiable);
    }

    public void setVidiconVisiable(int visiable) {
        this.ivVidicon.setVisibility(visiable);
    }

    public boolean isShowVideo() {
        return this.isShowVideo;
    }

    public void setDesktop(boolean desktop) {
        this.isDesktop = desktop;
        if (this.isDesktop) {
            this.avatarView.setVisibility(8);
        }
    }

    public void setUsername(String username) {
        this.headUrl = EaseCallKitUtils.getUserHeadImage(username);
        if (this.headUrl != null) {
            this.avatarView.setImageResource(R.drawable.call_memberview_background);
        } else {
            this.loadHeadImage();
        }
        this.nameView.setText((CharSequence)EaseCallKitUtils.getUserNickName(username));
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setFullScreen(boolean fullScreen) {
        this.isFullScreenMode = fullScreen;
        if (fullScreen) {
            this.talkingView.setVisibility(8);
            this.nameView.setVisibility(8);
            this.audioOffInVideo.setVisibility(8);
        } else {
            this.nameView.setVisibility(0);
            if (this.isAudioOff) {
                this.audioOffInVideo.setVisibility(0);
            }
        }
    }

    public boolean isFullScreen() {
        return this.isFullScreenMode;
    }

    private void loadHeadImage() {
        EaseCallImageUtil.setImage(this.getContext(), (ImageView)this.avatarView, this.headUrl);
    }

    public void setSpeakActivated(boolean activated) {
        this.speakActivated = activated;
    }

    public boolean isSpeakActivated() {
        return this.speakActivated;
    }

    public void setCameraDirectionFront(boolean isFront) {
        this.isCameraFront = isFront;
    }

    public boolean isCameraDirectionFront() {
        return this.isCameraFront;
    }

    public void setVoiceOnlineImageState(boolean show) {
        if (show) {
            this.avatarView.setBorderWidth(this.dp2px(3));
            this.avatarView.setBorderColor(-16711936);
        } else {
            this.avatarView.setBorderWidth(0);
            this.avatarView.setBorderColor(0);
        }
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
        if (callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            this.setVoiceOnlineImageState(false);
            ConstraintSet constraintSet = new ConstraintSet();
            constraintSet.clone((ConstraintLayout)this.nameView.getParent());
            constraintSet.connect(this.nameView.getId(), 1, 0, 1, this.dp2px(10));
            constraintSet.applyTo((ConstraintLayout)this.nameView.getParent());
        } else {
            this.ivVidicon.setVisibility(8);
            this.setVoiceOnlineImageState(false);
            ConstraintSet constraintSet = new ConstraintSet();
            constraintSet.clone((ConstraintLayout)this.nameView.getParent());
            constraintSet.connect(this.nameView.getId(), 1, 0, 1);
            constraintSet.connect(this.nameView.getId(), 2, 0, 2);
            constraintSet.connect(this.nameView.getId(), 3, 0, 3);
            constraintSet.applyTo((ConstraintLayout)this.nameView.getParent());
        }
    }
}

