/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.callkit.widget;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import io.agora.chat.callkit.general.EaseCallType;
import io.agora.chat.callkit.widget.EaseCallMemberView;
import io.agora.util.EMLog;

public class EaseCallMemberViewGroup
extends ViewGroup
implements View.OnClickListener {
    private static final String TAG = EaseCallMemberViewGroup.class.getSimpleName();
    private OnItemClickListener onItemClickListener;
    private OnScreenModeChangeListener onScreenModeChangeListener;
    private int mWidth = 0;
    private int mHeight = 0;
    private int pageIndex = 0;
    private int pageCount = 1;
    private View fullScreenView;
    private int itemWidth;
    private int itemHeight;
    private int maxSizeOnePage = 1;
    int touchSlop;
    private int itemCountOneLine = 2;
    private int itemCountOneRow = 2;
    private EaseCallType callType = EaseCallType.CONFERENCE_VIDEO_CALL;

    public EaseCallMemberViewGroup(Context context) {
        this(context, null);
    }

    public EaseCallMemberViewGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseCallMemberViewGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Point p = new Point();
        wm.getDefaultDisplay().getSize(p);
        this.mWidth = p.x;
        this.mHeight = p.y;
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureHeiht;
        int heightMeasure = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int totalHeight = 0;
        int count = this.getChildCount();
        int right = 0;
        this.pageCount = (this.getChildCount() - 1) / this.maxSizeOnePage + 1;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (8 == child.getVisibility()) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            this.itemHeight = child.getMeasuredHeight();
            int p = i / this.maxSizeOnePage;
            right = Math.max(right, p * this.itemWidth * this.itemCountOneLine + this.itemWidth + this.getPaddingLeft() + this.getPaddingRight() + i % this.maxSizeOnePage / this.itemCountOneRow * this.itemWidth);
        }
        int n = measureHeiht = heightMode != 0x40000000 ? totalHeight + this.getPaddingTop() + this.getPaddingBottom() : heightMeasure;
        if (this.isFullScreenMode()) {
            this.setMeasuredDimension(this.mWidth, measureHeiht);
        } else {
            this.setMeasuredDimension(Math.max(right, this.mWidth), measureHeiht);
        }
        this.itemHeight = this.callType == EaseCallType.CONFERENCE_VIDEO_CALL ? this.getMeasuredHeight() / this.itemCountOneRow : this.itemWidth + this.dp2px(30);
        if (!this.isFullScreenMode()) {
            this.resetAllViews();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int baseLeft = 0;
        int baseTop = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int p = i / this.maxSizeOnePage;
            int l = 0;
            int t = 0;
            int r = 0;
            int b = 0;
            if (child.getVisibility() == 8) continue;
            if (this.callType == EaseCallType.CONFERENCE_VOICE_CALL) {
                if (count == 1) {
                    baseLeft = this.itemWidth;
                    baseTop = this.itemHeight + this.itemHeight / 2;
                } else if (count == 2) {
                    baseLeft = this.itemWidth / 2;
                    baseTop = this.itemHeight + this.itemHeight / 2;
                } else if (count <= 6) {
                    baseLeft = 0;
                    baseTop = this.itemHeight;
                } else {
                    baseLeft = 0;
                    baseTop = this.itemHeight / 2;
                }
            }
            if (this.isFullScreenMode()) {
                l = 0;
                t = 0;
                r = this.mWidth;
                b = this.mHeight;
            } else if (p == 0) {
                l = baseLeft + this.getPaddingLeft() + i % this.itemCountOneLine * this.itemWidth;
                t = baseTop + i % this.maxSizeOnePage / this.itemCountOneLine * this.itemHeight + this.getPaddingTop();
                r = baseLeft + child.getMeasuredWidth() + this.getPaddingLeft() + i % this.itemCountOneLine * this.itemWidth;
                b = baseTop + i % this.maxSizeOnePage / this.itemCountOneLine * this.itemHeight + child.getMeasuredHeight() + this.getPaddingTop();
            } else {
                l = baseLeft + p * this.itemWidth * this.itemCountOneLine + this.getPaddingLeft() + i % this.maxSizeOnePage / this.itemCountOneRow * this.itemWidth;
                t = baseTop + i % this.maxSizeOnePage % this.itemCountOneRow * this.itemHeight + this.getPaddingTop();
                r = baseLeft + p * this.itemWidth * this.itemCountOneLine + child.getMeasuredWidth() + this.getPaddingLeft() + i % this.maxSizeOnePage / this.itemCountOneRow * this.itemWidth;
                b = baseTop + i % this.maxSizeOnePage % this.itemCountOneRow * this.itemHeight + child.getMeasuredHeight() + this.getPaddingTop();
            }
            if (this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
                child.setOnClickListener((View.OnClickListener)this);
            }
            Log.d((String)TAG, (String)("l=" + l + ",t=" + t + ",r=" + r + ",b=" + b + ",itemWidth=" + this.itemWidth));
            child.layout(l, t, r, b);
        }
    }

    public void setRowAndLine(int row, int line) {
        this.itemCountOneRow = row;
        this.itemCountOneLine = line;
        this.maxSizeOnePage = this.itemCountOneLine * this.itemCountOneRow;
        this.itemWidth = this.mWidth / this.itemCountOneLine;
        this.requestLayout();
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((EaseCallMemberView)this.getChildAt(i)).setCallType(callType);
        }
        if (callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
            this.setRowAndLine(2, 2);
        } else {
            this.setRowAndLine(3, 3);
        }
    }

    public void addView(View child) {
        ViewParent parent = child.getParent();
        if (parent != null) {
            ((ViewGroup)parent).removeView(child);
        }
        super.addView(child);
        if (this.isFullScreenMode()) {
            EMLog.i((String)TAG, (String)("addView, isFullScreenMode: " + this.isFullScreenMode()));
            return;
        }
        if (child instanceof EaseCallMemberView) {
            ((EaseCallMemberView)child).setCallType(this.callType);
        }
        this.setViewParams(child, this.itemWidth, this.itemHeight);
    }

    private void setViewParams(View target, int widthBorder, int heightBorder) {
        ViewGroup.LayoutParams params = target.getLayoutParams();
        params.width = widthBorder;
        params.height = heightBorder;
        target.setLayoutParams(params);
    }

    private void handleItemClickAction(View v, int index) {
        if (this.isFullScreenMode()) {
            this.fullScreenView = null;
            if (this.onScreenModeChangeListener != null) {
                this.onScreenModeChangeListener.onScreenModeChange(this.isFullScreenMode(), this.fullScreenView);
            }
        } else if (v instanceof EaseCallMemberView && !((EaseCallMemberView)v).isShowVideo()) {
            this.fullScreen(v);
        }
        if (this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(v, index);
        }
    }

    private void fullScreen(View view) {
        this.fullScreenView = view;
        if (this.onScreenModeChangeListener != null) {
            this.onScreenModeChangeListener.onScreenModeChange(this.isFullScreenMode(), this.fullScreenView);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (view == child) {
                lp.width = this.mWidth;
                lp.height = this.mHeight;
            } else {
                lp.width = 0;
                lp.height = 0;
            }
            child.setLayoutParams(lp);
        }
        if (view instanceof EaseCallMemberView) {
            ((EaseCallMemberView)view).setFullScreen(this.isFullScreenMode());
        }
    }

    private void resetAllViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (this.getChildCount() == 3 && i == 2 && this.callType == EaseCallType.CONFERENCE_VIDEO_CALL) {
                this.setViewParams(child, this.getMeasuredWidth(), this.itemHeight);
            } else {
                this.setViewParams(child, this.itemWidth, this.itemHeight);
            }
            if (!(child instanceof EaseCallMemberView)) continue;
            ((EaseCallMemberView)child).setFullScreen(this.isFullScreenMode());
        }
    }

    public void onClick(View v) {
        this.handleItemClickAction(v, this.indexOfChild(v));
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        return new ViewGroup.MarginLayoutParams(lp);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int currentIndex() {
        return this.pageIndex;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public void setOnScreenModeChangeListener(OnScreenModeChangeListener listener) {
        this.onScreenModeChangeListener = listener;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenView != null;
    }

    public View getFullScreenView() {
        return this.fullScreenView;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public static interface OnScreenModeChangeListener {
        public void onScreenModeChange(boolean var1, @Nullable View var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

