/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;

import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.util.EMLog;

/**
 * \~english
 * The service that SDK keeps the app active.
 */
@SuppressLint("Registered")
public class ChatService extends Service {

	private final static String TAG = "chatservice";

	public class LocalBinder extends Binder {
		ChatService getService() {
			return ChatService.this;
		}
	}

	public void onCreate() {
		super.onCreate();
		EMLog.i(TAG, "chat service created");
	}


	public int onStartCommand(Intent _intent, int flags, int startId) {
		if(PushHelper.getInstance().getPushType() == PushType.FCM){
			EMLog.d(TAG, "start not sticky!");
			return Service.START_NOT_STICKY;
		} else {
			EMLog.d(TAG, "start sticky!");
			return Service.START_STICKY;
		}
	}

	@Override
	public void onDestroy() {
		EMLog.d(TAG, "onDestroy");

		if(PushHelper.getInstance().getPushType() == PushType.NORMAL
				&& ChatClient.getInstance().isLoggedInBefore()){ // Keep this service alive.
			new Thread(new Runnable() {

				@Override
				public void run() {
					try {
						Intent intent = new Intent(ChatService.this, ChatService.class);
						startService(intent);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}).start();
		}
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		EMLog.d(TAG, "onBind");
		return mBinder;
	}

	@Override
	public boolean onUnbind(Intent intent) {
		return true;
	}

	// This is the object that receives interactions from clients. See
	// RemoteService for a more complete example.
	private final IBinder mBinder = new LocalBinder();

}
