package io.agora.chat;

import io.agora.chat.adapter.EMAThreadInfo;

public class ChatThreadEvent extends EMBase<EMAThreadInfo>{
    private ChatThread chatThread;

    public ChatThreadEvent(EMAThreadInfo event) {
        emaObject = event;
        chatThread = new ChatThread(event);
    }

    /**
     * \~english
     * Gets the message thread event type.
     *
     * @return The message thread event type. See {@link TYPE}.
     */
    public TYPE getType() {
        return emaObject.getType();
    }

    /**
     * \~english
     * Gets the user ID of the operator of the message thread event.
     *
     * @return The user ID of the event operator.
     */
    public String getFrom() {
        return emaObject.getFrom();
    }

    /**
     * \~english
     * Gets the message thread object.
     * 
     * @return The message thread object.
     */
    public ChatThread getChatThread() {
        return chatThread;
    }

    public enum TYPE {
        /**
         * \~english
         * The unknown type of message thread event.
         */
        UNKNOWN,
        /**
         * \~english
         * The message thread is created.
         */
        CREATE,
        /**
         * \~english
         * The message thread is updated.
         */
        UPDATE,
        /**
         * \~english
         * The message thread is destroyed.
         */
        DELETE,
        /**
         * \~english
         * One or more messages in the message thread are updated.
         */
        UPDATE_MSG
    }
}
