/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMACmdMessageBody;

import java.util.Map;

/**
 * \~english
 * The command message body.
 *
 * ```java
 *     CmdMessageBody body = new CmdMessageBody("delete", null);
 * ```
 *
 */
public class CmdMessageBody extends MessageBody implements Parcelable {
	
    /**
     * \~english
     * Creates a command message.
     *
     * @param action The command action content.
     */
    public CmdMessageBody(String action) {
    	emaObject = new EMACmdMessageBody(action);
    }
    
    CmdMessageBody(EMACmdMessageBody body) {
    	this.emaObject = body;
    }
    
    /**
     * \~english
     * Gets the command action content.
     *
     * @return The command action content.
     */
    public String action() {
    	return ((EMACmdMessageBody)emaObject).action();
    }

    /**
     * \~english
     * Checks whether this cmd message is only delivered to online users.
     * @return - `true`: Only delivers to online users.
     * - `false`: Delivers to all users. 
     */
    public boolean isDeliverOnlineOnly() {
        return ((EMACmdMessageBody)emaObject).isDeliverOnlineOnly();
    }

    /**
     * \~english
     * Sets whether the current cmd msg is only delivered to online users. 
     *
     * @param onlineOnly    Whether to deliver to online users only. 
     *                      - (Default)`false`: The message is delivered to all users. 
     *                      - `true`: The message is delivered to the online users only, so the offline users won't receive the message when they log in later.
     */
    public void deliverOnlineOnly(boolean onlineOnly) {
        ((EMACmdMessageBody)emaObject).deliverOnlineOnly(onlineOnly);
    }

    /**
     * \~english
     * Gets and displays the content of the CMD message.
     * @return   The content of the action of the CMD message.
     */
    public String toString() {
        return "cmd:\"" + ((EMACmdMessageBody)emaObject).action() + "\"";
    }

	@Override
	public int describeContents() {
		return 0;
	}

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACmdMessageBody)emaObject).action());
    }
    
    public static final Parcelable.Creator<CmdMessageBody> CREATOR
            = new Parcelable.Creator<CmdMessageBody>() {
        public CmdMessageBody createFromParcel(Parcel in) {
            return new CmdMessageBody(in);
        }

        public CmdMessageBody[] newArray(int size) {
            return new CmdMessageBody[size];
        }
    };

    private CmdMessageBody(Parcel in) {
    	emaObject = new EMACmdMessageBody(in.readString());
    }
}
