/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import java.util.List;

class EMResult<TList> {
    private TList data;
    
    /*
     * return TList value
     */
    public TList getData(){
    	return data;
    }
    
    public void setData(TList data){
    	this.data = data;
    }
}

/**
 * \~english
 * This is a generic class with cursors and paging to get results.
 * 
 * Returns an instance with the list and the cursor.
 * 
 * For example:
 * ```java
 *     CursorResult<GroupInfo> result = ChatClient.getInstance().groupManager().getPublicGroupsFromServer(pageSize, cursor);
 * 	   List<GroupInfo> groupList = result.getData();
 * 	   String cursor = result.getCursor();
 * ```
 */
public class CursorResult<T> extends EMResult<List<T>>{
	private String cursor = "";
	
	void setCursor(String cursor){
		this.cursor = cursor;
	}

	/**
	 * \~english
	 * Gets the cursor.
	 * @return	The cursor.
	 */
	public String getCursor(){
		return cursor;
	}
}
