/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

import java.io.Serializable;

/**
 * \~english
 * The basic group information, which is used when getting the public group list.
 * @see GroupManager#getPublicGroupsFromServer(int, String)
 */
public class GroupInfo implements Serializable{

	private static final long serialVersionUID = -2004486389398310700L;
	private String groupId;
	private String groupName;
	
	/**
	 * \~english
	 * The constructor of GroupInfo.

	 * @param groupId	The group ID.
	 * @param groupName	The group name.
	 */
	public GroupInfo(String groupId, String groupName) {
		this.groupId = groupId;
		this.groupName = groupName;
	}

	/**
	 * \~english
	 * Gets the group ID.
	 * @return  The group ID.
	 */
	public String getGroupId() {
		return groupId;
	}

	/**
	 * \~english
	 * Sets the group ID.
	 * @param groupId  The group ID.
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	/**
	 * \~english
	 * Gets the group name.
	 * @return  The group name.
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * \~english
	 * Sets the group name.
	 * @param groupName  The group name.
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	
	@Override
	public String toString() {
		return groupName;
	}
}
