package io.agora.chat;

/**
 * \~english
 * Group property options to be configured during group creation.
 */
public class GroupOptions {

    /**
     * \~english
     * The maximum number of members in a group.
     */
    public int maxUsers = 200;

    /**
     * \~english
     * The group style. See {@link io.agora.chat.GroupManager.GroupStyle}.
     */
    public GroupManager.GroupStyle style = GroupManager.GroupStyle.GroupStylePrivateOnlyOwnerInvite;

    /**
     * \~english
     * This option defines whether to ask for content when inviting a user to join a group.
     * Whether automatically acceting the invitation to join a group depends on two settings: inviteNeedConfirm, an option during group creation,
     * and {@link ChatOptions#setAutoAcceptGroupInvitation(boolean)} which determines whether to automatically accept an invitation to join the group.
     * There are two cases:
     * (1) If inviteNeedConfirm is set to 'false', adds the invitee directly to the group on the server side 
     * regardless of the setting of {@link ChatOptions#setAutoAcceptGroupInvitation(boolean)}.
     * 
     * (2) If inviteNeedConfirm is set to 'true', the user automatically joins a group or decides whether to join, depending on the setting of {@link ChatOptions#setAutoAcceptGroupInvitation(boolean)}.
     * {@link ChatOptions#setAutoAcceptGroupInvitation(boolean)} is an SDK-level operation. If it is set to true,
     * SDK calls the API for agreeing to join the group to automatically accept the joining invitation.
     * If inviteNeedConfirm is set to false, SDK does not automatically accept its invitation,
     * but the user decides to accept or reject the invitation.
     */
    public boolean inviteNeedConfirm = false;

    /**
     * \~english
     * Group detail extensions which can be in the JSON format to contain more group information.
     */
    public String extField;
}