/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMALocationMessageBody;

/**
 * \~english
 * The location message body.
 * 
 * ```java
 * LocationMessageBody body = new LocationMessageBody(“location”, 30.010378, 104.358878, "建筑物名称");
 * ```
 */
public class LocationMessageBody extends MessageBody implements Parcelable {
    /**
     * \~english
     * Creates a location message body.
     * @param address  The address.
     * @param latitude  The latitude.
     * @param longitude  The longitude.
     * @param buildingName The building name.
     */
    public LocationMessageBody(String address, double latitude, double longitude, String buildingName) {
    	emaObject = new EMALocationMessageBody(latitude, longitude, address, buildingName);
    }

    public LocationMessageBody(String address, double latitude, double longitude) {
        emaObject = new EMALocationMessageBody(latitude, longitude, address, "");
    }
    
    public LocationMessageBody(EMALocationMessageBody body) {
    	emaObject = body;
	}
    /**
     * \~english
     * Gets the address.
     */
    public String getAddress() {
        return ((EMALocationMessageBody)emaObject).address();
    }
    
    /**
     * \~english
     * Gets the latitude.
     */
    public double getLatitude() {
        return ((EMALocationMessageBody)emaObject).latitude();
    }
    
    /**
     * \~english
     * Gets the longitude.
     */
    public double getLongitude() {
        return ((EMALocationMessageBody)emaObject).longitude();
    }

    /**
     * \~english
     * Gets the building name.
     */
    public String getBuildingName(){
        return ((EMALocationMessageBody)emaObject).buildingName();
    }
    
    public String toString() {
        return "location:" + ((EMALocationMessageBody)emaObject).address() + ",lat:" + ((EMALocationMessageBody)emaObject).latitude() + ""
            + ",lng:" + ((EMALocationMessageBody)emaObject).longitude() + ",build:" + ((EMALocationMessageBody)emaObject).buildingName();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMALocationMessageBody)emaObject).address());
        dest.writeDouble(((EMALocationMessageBody)emaObject).latitude());
        dest.writeDouble(((EMALocationMessageBody)emaObject).longitude());
        dest.writeString(((EMALocationMessageBody)emaObject).buildingName());
    }
    
    public static final Parcelable.Creator<LocationMessageBody> CREATOR
            = new Parcelable.Creator<LocationMessageBody>() {
        public LocationMessageBody createFromParcel(Parcel in) {
            return new LocationMessageBody(in);
        }

        public LocationMessageBody[] newArray(int size) {
            return new LocationMessageBody[size];
        }
    };

    private LocationMessageBody(Parcel in) {
    	emaObject = new EMALocationMessageBody(0.0, 0.0, "", "");
    	String address = in.readString();
    	double latitude = in.readDouble();
    	double longitude = in.readDouble();
    	String buildName = in.readString();
    	((EMALocationMessageBody)emaObject).setAddress(address);
    	((EMALocationMessageBody)emaObject).setLatitude(latitude);
    	((EMALocationMessageBody)emaObject).setLongitude(longitude);
        ((EMALocationMessageBody)emaObject).setBuildingName(buildName);
    }
}
