/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material is strictly forbidden unless prior written permission is obtained from EaseMob Technologies.
 */
package io.agora.chat;

import android.os.Parcelable;

import io.agora.chat.adapter.message.EMAMessageBody;

/**
 * \~english
 * The message body base class.
 */
public abstract class MessageBody extends EMBase<EMAMessageBody> implements Parcelable {

    //public MimeType mimeType;
    /*
    public enum MimeType {
        TEXT_PLAIN, IMAGE, VIDEO, LOCATION, VOICE
    }*/

    /**
     * \~english
     * Gets the UNIX timestamp of the last message modification, in milliseconds.
     * 
     * @return The UNIX timestamp of the last message modification.
     */
    public long operationTime() {
        if (emaObject != null) {
            return emaObject.operationTime();
        }
        return 0;
    }

    /**
     * \~english
     * Gets the user ID of the operator that modified the message last time.
     * 
     * @return The user ID of the operator that modified the message last time.
     */
    public String operatorId() {
        if (emaObject != null) {
            return emaObject.operatorId();
        }
        return "";
    }

    /**
     * \~english
     * Gets the number of times a message is modified.
     * 
     * A message can be modified at most five times.
     * 
     * @return The number of times a message is modified.
     */
    public int operationCount() {
        if (emaObject != null) {
            return emaObject.operationCount();
        }
        return 0;
    }
}