package io.agora.chat;


import io.agora.chat.adapter.EMAMessageReaction;

import java.util.List;

/**
 * \~english
 * The message Reaction instance class, which has the following attributes:
 *
 *   Reaction: The message Reaction.
 *   UserCount: The count of users that added the Reaction.
 *   UserList: The list of users that added the Reaction.
 *   isAddedBySelf: Whether the current user added this Reaction.
 */
public class MessageReaction extends EMBase<EMAMessageReaction> {

    public MessageReaction(EMAMessageReaction messageReaction) {
        emaObject = messageReaction;
    }

    /**
     * \~english
     * Gets the Reaction.
     * @return The Reaction.
     */
    public String getReaction() {
        return emaObject.reaction();
    }

    /**
     * \~english
     * Gets the count of users that added this Reaction.
     * @return The count of users that added the Reaction.
     */
    public int getUserCount() {
        return emaObject.count();
    }

    /**
     * \~english
     * Gets the list of users that added this Reaction.
     *
     * **Note**
     * {@link #getReactionDetail(ChatManager)} can return the entire list of users that added this Reaction with pagination, whereas other methods such as {@link #getMessageReaction(ChatMessage)}, {@link #getReactionList(ChatManager)}, and {@link onReactionChanged(MessageListener)} can only return the first three users.
     * @return  The list of users that added this Reaction.
     */
    public List<String> getUserList() {
        return emaObject.userList();
    }

    /**
     * \~english
     * Gets whether the current user has added the Reaction.
     *
     * @return  Whether the current user has added the Reaction.
     *  - `true`: Yes.
     *  - `false`: No.
     */
    public boolean isAddedBySelf() {
        return emaObject.state();
    }
}