package io.agora.chat;

import io.agora.chat.adapter.EMAMucShareFile;

/**
 * \~english
 * The shared file info class.
 * 
 * For example, you can use the following method to get information about the group shared file through {@link GroupManager#fetchGroupSharedFileList(String, int, int)}:


 * ```java
 *     List<MucSharedFile> sharedFiles = ChatClient.getInstance().groupManager().fetchGroupSharedFileList(groupId, pageNum, pageSize);
 * ```
 */
public class MucSharedFile extends EMBase<EMAMucShareFile>{
    public MucSharedFile(){
        emaObject = new EMAMucShareFile();
    }

    public MucSharedFile(EMAMucShareFile shareFile){
        emaObject = new EMAMucShareFile(shareFile);
    }

    /**
     * \~english
     * Gets the shared file ID.
     * @return  The shared file ID.
     */
    public String getFileId() {
        return emaObject.getFileId();
    }

    /**
     * \~english
     * Gets the shared file name.
     * @return  The shared file name.
     */
    public String getFileName() {
        return emaObject.getFileName();
    }

    /**
     * \~english
     * Gets the username who uploads the shared file.
     * @return  The username who uploads the shared file.
     */
    public String getFileOwner() {
        return emaObject.getFileOwner();
    }

    /**
     * \~english
     * Gets the update Unix timestamp of the shared file, in ms.
     * @return  The update Unix timestamp of the shared file, in ms.
     */
    public long getFileUpdateTime() {
        return emaObject.getUpdateTime();
    }

    /**
     * \~english
     * Gets the data length of the shared file, in bytes.
     * @return  The data length of the shared file, in bytes.
     */
    public long getFileSize() {
        return emaObject.getFileSize();
    }
}
