/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMATextMessageBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * \~english
 * The text message body.
 * 
 * ```java
 *     TextMessageBody body = new TextMessageBody("hello hyphenate chat sdk!");
 * ```
 */
public class TextMessageBody extends MessageBody implements Parcelable {

    /**
     * \~english
     * Creates a text message body.
     *
     * @param msg The text content.
     */
    public TextMessageBody(String msg) {
        emaObject = new EMATextMessageBody(msg);
    }

    TextMessageBody(EMATextMessageBody body) {
        emaObject = body;
    }

    /**
     * \~english
     * Gets the text message body.
     *
     * @return  The text content.
     */
    public String getMessage() {
        return ((EMATextMessageBody) emaObject).text();
    }

    /**
     * \~english
     * Sets the text message body's content.
     * @Note: you can only modify the local data.
     *
     * @param message The text content.
     */
    public void setMessage(String message) {
        ((EMATextMessageBody) emaObject).setText(message);
    }

    public String toString() {
        return "txt:\"" + ((EMATextMessageBody) emaObject).text() + "\"";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMATextMessageBody) emaObject).text());
    }

    public static final Parcelable.Creator<TextMessageBody> CREATOR
            = new Parcelable.Creator<TextMessageBody>() {
        public TextMessageBody createFromParcel(Parcel in) {
            return new TextMessageBody(in);
        }

        public TextMessageBody[] newArray(int size) {
            return new TextMessageBody[size];
        }
    };

    private TextMessageBody(Parcel in) {
        emaObject = new EMATextMessageBody(in.readString());
    }

    /**
     * \~english
     * Translation structure
     *
     */
    public static class TranslationInfo{
        public String languageCode; /** \~chinese 译文语种  \~english The languages */
        public String translationText; /** \~chinese 译文文本  \~english The translation text */

        public TranslationInfo(String languageCode, String translationText){
            this.languageCode = languageCode;
            this.translationText = translationText;
        }
    }


    /**
     * \~english
     * Set the target language for translation
     * @param languageList Language code list
     *
     */
    public void setTargetLanguages(List<String> languageList){
        ((EMATextMessageBody)emaObject).setTargetLanguages(languageList);
    }

    /**
     * \~english
     * Get the target language for translation
     * @return Language code list
     *
     */
    public List<String> getTargetLanguages(){
        return ((EMATextMessageBody)emaObject).getTargetLanguages();
    }

    /**
     * \~english
     * Get the translation list
     *
     * @return Translation information list
     */
    public List<TranslationInfo> getTranslations(){
        Map<String, String> result = ((EMATextMessageBody)emaObject).getTranslations();
        List<TranslationInfo> translations = new ArrayList<>();
        for(String key : result.keySet()){
            translations.add(new TranslationInfo(key, result.get(key)));
        }
        return translations;
    }

}
